/*
	CMameWindow.h
	The BeMame Team
*/

#ifndef CMAMEWINDOW_H
#define CMAMEWINDOW_H

#include <DirectWindow.h>
#include "CMameDisplay.h"

class CMameWindow : public BWindow, public CMameDisplay {
public:
					CMameWindow(
						status_t		*outRet,
						BRect			inFrame,
						int				inColorDepth);
	virtual			~CMameWindow();
						
	virtual	void	ShutDown();

	virtual void	SetPenAtIdx(
						int32			inIdx,
						uint8			inRed,
						uint8			inGreen,
						uint8			inBlue);
	virtual void	SetPalette();
	virtual void	Update8BitDirect(
						uint8				*inSource,
						int32				inLineNumber,
						int32				inScreenWidth,
						int32				inVisibleWidth,
						bool				inDouble);
	virtual void	Update8BitDirectWScan(
						uint8				*inSource,
						int32				inLineNumber,
						int32				inScreenWidth,
						int32				inVisibleWidth);
    
private:
	void			InitPalette();
	bool			QuitRequested();

    BRect		mRequestedSize;

	rgb_color	mPalette[256];
	uint8		mPenIndex[256];
};


#endif
