//___ my_sel.h ________________________________________________________________
//
#ifndef MY_SEL_H
#define MY_SEL_H

#include <InterfaceKit.h>
#include <SupportKit.h>

#ifdef __cplusplus
extern "C" {
#endif
	#include "driver.h"
	#include "audit.h"
	void decompose_rom_sample_path(char *rompath, char *samplepath);
#ifdef __cplusplus
}
#endif

class CSelWin;
class CInfoView;

enum {
	MSG_RUN_GAME		= 'RunG',
	MSG_SEL_LIST		= 'SelL',
	MSG_SEL_CHANGED		= 'SelC',
	MSG_LIST_INIT		= 'lstI'/*,
	MSG_SEL_GAME		= 'SelG'*/
};

enum h_justify {
	eJustify_Center = 0,
	eJustify_Right,
	eJustify_Left
};

class CConfItem
{
	public:
	virtual void	AddToMsg(BMessage* Msg) = 0;
};


class CConfItem_Menu : public BMenuField, public CConfItem
{
	public:
					CConfItem_Menu(const char* TheName, const char* TheLabel, const char* Items);
	virtual void	AddToMsg(BMessage* Msg);
	private:
};


class CConfItem_Bool : public BCheckBox, public CConfItem
{
	public:
					CConfItem_Bool(const char* TheName, const char* TheLabel, const char* Arg, bool State);
	virtual void	AddToMsg(BMessage* Msg);
	private:
	BString			mMsgString;
};


class CConfView : public BBox, public CConfItem
{
public:
						CConfView(BView* TheParent, const char* TheName, uint32 ResizeMode);
	virtual void		AddToMsg(BMessage* Msg);
	void				AddToBox(BBox* Box, float* Y, BView* View);
	void				SetJoysticks(void);
	void				UpdateConfigItems(
							const GameDriver		*inDriver);
	void				SaveConfigItems();
	
private:
	const GameDriver	*mCurDriver;
	CConfItem_Bool*		mCnf_Window;
	CConfItem_Bool*		mCnf_Double;
	CConfItem_Bool*		mCnf_NoRotate;
	CConfItem_Bool*		mCnf_Scanlines;
	CConfItem_Menu*		mCnf_Depth;
	CConfItem_Menu*		mCnf_Rot;
	CConfItem_Menu*		mCnf_Flip;
	CConfItem_Menu*		mCnf_Frameskip;
	CConfItem_Bool*		mCnf_UseFm;
	CConfItem_Menu*		mCnf_SamRate;
	CConfItem_Menu*		mCnf_SamBits;
	CConfItem_Bool*		mCnf_UseMouse;
	CConfItem_Menu*		mCnf_Joy[4];
};


class CGame : public BListItem
{
public:
						CGame(
							int32			inIndex);

	static void			Init(
							CSelWin			*inWindow);
	static int32		Cnt(int8 Index);
	virtual void		DrawItem(BView* View, BRect ItemRect, bool DrawEverything);
	virtual void		Update(BView* View, const BFont* Font);
	void				Audit();
	int16				DriverIdx(void) const;
	const GameDriver*	Driver(void) const;
	const char*			Name(void) const;
	const char*			Archive(void) const;
	int8				Alph(void) const;

	enum {
		MAXLIST = 27
	};
	
private:
	int32				mStatus;
	int16				mIndex;
	int8				mAlph;

	static int32		sCnt[MAXLIST];
	static BFont		sFont;
	static BFont		sFontItalic;
	static float		sBaseLine;
	static float		sHeight;
};


class CGameList : public BListView
{
public:
						CGameList(BRect Rect);
	virtual void		SelectionChanged(void);
	virtual void		MakeEmpty(void);
	CGame*				SelectedGame(void);
	
private:
	CGame*				mSelGame;
};


class CSelWin : public BWindow
{
public:
						CSelWin(void);
						~CSelWin();
						
	virtual bool		QuitRequested(void);
	virtual void		MessageReceived(BMessage *Msg);
	BList *				GameList()		{ return &mGames; }
	
private:
	static int32		AuditEntry(
							void		*inObj);
	void				AuditGames();
	void				AddMenuBar(BView* Parent);
	void				AddTabGames(void);
	bool				FillGamesList(int32 Idx);
	
	// Data
	BMenuBar*			mMenuBar;
	BTabView*			mTabView;
	// Tab: Games
	BView*				mTabGames;
	CGameList*			mGameList;
	CInfoView*			mInfoView;
	BRadioButton*		mGameSel[CGame::MAXLIST];
	BButton*			mButRun;
//	BList				mGameSub[CGame::MAXLIST];
	BList				mGames;
	CConfView*			mConf;
};

class CInfoView : public BView {
public:
								CInfoView(
									BRect			inFrame);
								
	virtual void				Draw(
									BRect			inUpdateRect);
	void						SetDriver(
									int32			inDriverIdx);
private:
	void						DrawMameVersion();
	void						DrawDriverInfo();
	void						DrawStringJustified(
									const char		*inStr,
									BRect			inRect,
									rgb_color		inColor,
									h_justify		inJustify = eJustify_Center);
	
	int32		mDriverIdx;
	float		mFontHeight;
	float		mFontOffs;
};

#endif
