// CAbout.cpp

#include <BeHeaders>

#include "CAbout.h"

#define kAbout_Width	320
#define kAbout_Height	224

#define kBeMAMEVersStr	"v0.29b0"

void
CAbout::DoAbout()
{
	BScreen	theScreen(B_MAIN_SCREEN_ID);
	BRect	theFrame = theScreen.Frame();
	uint32	scrH, scrW;
	
	scrH = (theFrame.bottom-theFrame.top)+1;
	scrW = (theFrame.right-theFrame.left)+1;
	
	new CAbout(BRect(scrW/2 - kAbout_Width/2,
					scrH/2 - kAbout_Height/2,
					scrW/2 + kAbout_Width/2,
					scrH/2 + kAbout_Height/2));
}

CAbout::CAbout(
	BRect	inRect) :
		BWindow(inRect, "About", B_MODAL_WINDOW,
			B_NOT_RESIZABLE | B_NOT_CLOSABLE | B_NOT_ZOOMABLE | B_NOT_MINIMIZABLE)
{
	inRect.OffsetTo(B_ORIGIN);
	
	AddChild(new CAboutView(inRect));
	Show();
}

CAboutView::CAboutView(
	BRect		inFrame) : BView(inFrame, "About", B_FOLLOW_ALL_SIDES, B_WILL_DRAW)
{
	status_t		theStatus = B_NO_ERROR;
	app_info		theInfo;
		
	if ((theStatus = be_app->GetAppInfo(&theInfo)) == B_NO_ERROR) {
		BFile		appFile;
		BResources	appRez;
		uint16		height, width;
		
		appFile.SetTo(&theInfo.ref, B_READ_ONLY);
		appRez.SetTo(&appFile);
		
		appRez.ReadResource('bitm', 128, &height, 0, 2);
		appRez.ReadResource('bitm', 128, &width, 2, 2);
		mBitMap = new BBitmap(BRect(0,0,width-1,height-1), B_COLOR_8_BIT);
		appRez.ReadResource('bitm', 128, mBitMap->Bits(), 4, height * width);
	}	
}

CAboutView::~CAboutView()
{
	delete mBitMap;
}

#define kTextStart	144

void
CAboutView::Draw(
	BRect	inRect)
{
#pragma unused (inRect)
	float	strW;
	float	dispW;
	
	DrawBitmap(mBitMap, BPoint(8,8));
	
	SetFontSize(18.0);
	SetHighColor(0,0,0);
	dispW = kAbout_Width - kTextStart;
	strW = StringWidth("A port of M.A.M.E");
	DrawString("A port of M.A.M.E", BPoint(kTextStart + dispW/2 - strW/2, 40));
	strW = StringWidth("to the BeOS");
	DrawString("to the ", BPoint(kTextStart + dispW/2 - strW/2, 64));
	SetHighColor(0,0,255);
	DrawString("B");
	SetHighColor(255,0,0);
	DrawString("e");
	SetHighColor(0,0,0);
	DrawString("OS");
	
	SetFontSize(10.0);
	strW = StringWidth(kBeMAMEVersStr);
	DrawString(kBeMAMEVersStr, BPoint(kTextStart + dispW/2 - strW/2, 136));
	strW = StringWidth("by Casey Fleser");
	DrawString("by Casey Fleser", BPoint(kTextStart + dispW/2 - strW/2, 152));
	strW = StringWidth("cfleser@kagi.com");
	DrawString("cfleser@kagi.com", BPoint(kTextStart + dispW/2 - strW/2, 168));
	strW = StringWidth("http://www.glw.com/casey/");
	DrawString("http://www.glw.com/casey/", BPoint(kTextStart + dispW/2 - strW/2, 184));
}

void
CAboutView::MouseDown(
	BPoint		inWhere)
{
#pragma unused (inWhere)
	Window()->PostMessage(B_QUIT_REQUESTED);
}

