// CMAMEScreen.h

#pragma once

#include "CMAMEDisplay.h"

class CIOThread;
class CPalette;
class CFullView;

class CMAMEScreen : public BWindowScreen, public CMAMEDisplay {
public:
						CMAMEScreen(
							int32		space,
							char			*name,
							status_t		*error);
						~CMAMEScreen();

	virtual void			Quit();
	virtual void			ScreenConnected(
							bool			active);
	virtual void			ScreenChanged(
							BRect		screen_size,
							color_space	depth);
	virtual void			MessageReceived(
							BMessage		 *inMessage);

	virtual void			Init();
	virtual void			Exit();
	virtual void			InitPalette();
	virtual void			SetPen(
							int16		inPen,
							uchar		inRed,
							uchar		inGreen,
							uchar		inBlue);
	virtual void			GetPen(
							int16		inPen,
							uchar		*outRed,
							uchar		*outGreen,
							uchar		*outBlue);
	virtual void			Resize(
							int16		inWidth,
							int16		inHeight);
	virtual void			CopyBits(
							void			*inSrc,
							int16		inHeight,
							int16		inWidth);
	virtual void			PollMouse();
	virtual void			ReadMouse(
							int16		*outX,
							int16		*outY);
	
private:
	CIOThread			*mIO;
	CPalette			*mPalette;
	BView			*mView;
	int16			mDeltaX;
	int16			mDeltaY;
	int16			mBytesRow;
	int16			mHeight;
	int16			mWidth;
	uchar			*mBase;
	bool				mInitComplete;
};
