#ifndef OSDEPEND_H
#define OSDEPEND_H


struct osd_bitmap
{
	int width,height;	/* width and hegiht of the bitmap */
	void *_private;	/* don't touch! - reserved for osdepend use */
#ifdef __BEOS__		// cwf 102197
	unsigned char *line[1];	/* pointers to the start of each line */
#else
	unsigned char *line[0];	/* pointers to the start of each line */
#endif
};

#define OSD_KEY_ESC		0x01
#define OSD_KEY_F1			0x02
#define OSD_KEY_F2			0x03
#define OSD_KEY_F3			0x04
#define OSD_KEY_F4			0x05
#define OSD_KEY_F5			0x06
#define OSD_KEY_F6			0x07
#define OSD_KEY_F7			0x08
#define OSD_KEY_F8			0x09
#define OSD_KEY_F9			0x0a
#define OSD_KEY_F10		0x0b
#define OSD_KEY_F11		0x0c
#define OSD_KEY_F12		0x0d
#define OSD_KEY_F13		0x0e
#define OSD_KEY_F14		0x0f
#define OSD_KEY_SCRLOCK		0x0f
#define OSD_KEY_F15		0x10
#define OSD_KEY_TILDE		0x11
#define OSD_KEY_1			0x12
#define OSD_KEY_2			0x13
#define OSD_KEY_3			0x14
#define OSD_KEY_4			0x15
#define OSD_KEY_5			0x16
#define OSD_KEY_6			0x17
#define OSD_KEY_7			0x18
#define OSD_KEY_8			0x19
#define OSD_KEY_9			0x1a
#define OSD_KEY_0			0x1b
#define OSD_KEY_MINUS		0x1c
#define OSD_KEY_EQUALS		0x1d
#define OSD_KEY_BACKSPACE	0x1e
#define OSD_KEY_INSERT		0x1f
#define OSD_KEY_HOME		0x20
#define OSD_KEY_PGUP		0x21
#define OSD_KEY_NUMLOCK		0x22
#define OSD_KEY_DIV_PAD		0x23
#define OSD_KEY_MUL_PAD		0x24
#define OSD_KEY_ASTERISK	0x24
#define OSD_KEY_MINUS_PAD	0x25
#define OSD_KEY_TAB		0x26
#define OSD_KEY_Q			0x27
#define OSD_KEY_W			0x28
#define OSD_KEY_E			0x29
#define OSD_KEY_R			0x2a
#define OSD_KEY_T			0x2b
#define OSD_KEY_Y			0x2c
#define OSD_KEY_U			0x2d
#define OSD_KEY_I			0x2e
#define OSD_KEY_O			0x2f
#define OSD_KEY_P			0x30
#define OSD_KEY_OPENBRACE	0x31
#define OSD_KEY_CLOSEBRACE	0x32
#define OSD_KEY_BSLASH		0x33
#define OSD_KEY_DEL		0x34
#define OSD_KEY_END		0x35
#define OSD_KEY_PGDN		0x36
#define OSD_KEY_7_PAD		0x37
#define OSD_KEY_8_PAD		0x38
#define OSD_KEY_9_PAD		0x39
#define OSD_KEY_PLUS_PAD	0x3a
#define OSD_KEY_CAPSLOCK	0x3b
#define OSD_KEY_A			0x3c
#define OSD_KEY_S			0x3d
#define OSD_KEY_D			0x3e
#define OSD_KEY_F			0x3f
#define OSD_KEY_G			0x40
#define OSD_KEY_H			0x41
#define OSD_KEY_J			0x42
#define OSD_KEY_K			0x43
#define OSD_KEY_L			0x44
#define OSD_KEY_COLON		0x45
#define OSD_KEY_QUOTE		0x46
#define OSD_KEY_ENTER		0x47
#define OSD_KEY_4_PAD		0x48
#define OSD_KEY_5_PAD		0x49
#define OSD_KEY_6_PAD		0x4a
#define OSD_KEY_LSHIFT		0x4b
#define OSD_KEY_Z			0x4c
#define OSD_KEY_X			0x4d
#define OSD_KEY_C			0x4e
#define OSD_KEY_V			0x4f
#define OSD_KEY_B			0x50
#define OSD_KEY_N			0x51
#define OSD_KEY_M			0x52
#define OSD_KEY_COMMA 		0x53
#define OSD_KEY_STOP	 	0x54
#define OSD_KEY_SLASH 		0x55
#define OSD_KEY_RSHIFT		0x56
#define OSD_KEY_UP			0x57
#define OSD_KEY_1_PAD		0x58
#define OSD_KEY_2_PAD		0x59
#define OSD_KEY_3_PAD		0x5a
//#define OSD_KEY_ENTER		0x5b		already defined
#define OSD_KEY_LCONTROL	0x5c
#define OSD_KEY_ALT		0x5d
#define OSD_KEY_SPACE		0x5e
#define OSD_KEY_ALTGR       0x5f
#define OSD_KEY_RCONTROL	0x60
#define OSD_KEY_LEFT		0x61
#define OSD_KEY_DOWN		0x62
#define OSD_KEY_RIGHT		0x63
#define OSD_KEY_0_PAD		0x64
#define OSD_KEY_STOP_PAD	0x65
#define OSD_KEY_OPTION		0x66
#define OSD_KEY_COMMAND		0x66
#define OSD_MAX_KEY		0x66

#define OSD_JOY_LEFT	1
#define OSD_JOY_RIGHT	2
#define OSD_JOY_UP	3
#define OSD_JOY_DOWN	4
#define OSD_JOY_FIRE1	5
#define OSD_JOY_FIRE2	6
#define OSD_JOY_FIRE3	7
#define OSD_JOY_FIRE4	8
#define OSD_JOY_FIRE5	9
#define OSD_JOY_FIRE6	10
#define OSD_JOY_FIRE7	11
#define OSD_JOY_FIRE8	12
#define OSD_JOY_FIRE9	13
#define OSD_JOY_FIRE10	14
#define OSD_JOY_FIRE	15	/* any of the first joystick fire buttons */
#define OSD_JOY2_LEFT	16
#define OSD_JOY2_RIGHT	17
#define OSD_JOY2_UP	18
#define OSD_JOY2_DOWN	19
#define OSD_JOY2_FIRE1	20
#define OSD_JOY2_FIRE2	21
#define OSD_JOY2_FIRE3	22
#define OSD_JOY2_FIRE4	23
#define OSD_JOY2_FIRE5	24
#define OSD_JOY2_FIRE6	25
#define OSD_JOY2_FIRE7	26
#define OSD_JOY2_FIRE8	27
#define OSD_JOY2_FIRE9	28
#define OSD_JOY2_FIRE10	29
#define OSD_JOY2_FIRE	30	/* any of the second joystick fire buttons */
#define OSD_MAX_JOY     30

#define X_AXIS          1
#define Y_AXIS          2
#define NO_TRAK         1000000


extern int play_sound;
extern int video_sync;

#ifdef __cplusplus
extern "C" {
#endif

int osd_init(int argc,char **argv);
void osd_exit(void);
struct osd_bitmap *osd_create_bitmap(int width,int height);
void osd_clearbitmap(struct osd_bitmap *bitmap);
void osd_free_bitmap(struct osd_bitmap *bitmap);
/* Create a display screen, or window, large enough to accomodate a bitmap */
/* of the given dimensions. Attributes are the ones defined in driver.h. */
/* palette is an array of 'totalcolors' R,G,B triplets. The function returns */
/* in *pens the pen values corresponding to the requested colors. */
/* Return a osd_bitmap pointer or 0 in case of error. */
struct osd_bitmap *osd_create_display(int width,int height,int totalcolors,
		const unsigned char *palette,unsigned char *pens,int attributes);
void osd_close_display(void);
void osd_modify_pen(int pen,unsigned char red, unsigned char green, unsigned char blue);
void osd_get_pen(int pen,unsigned char *red, unsigned char *green, unsigned char *blue);
void osd_mark_dirty(int x1, int y1, int x2, int y2, int ui);	/* ASG 971011 */
void osd_update_display(void);
void osd_update_audio(void);
void osd_play_sample(int channel,unsigned char *data,int len,int freq,int volume,int loop);
void osd_play_streamed_sample(int channel,unsigned char *data,int len,int freq,int volume);
void osd_adjust_sample(int channel,int freq,int volume);
void osd_stop_sample(int channel);
void osd_restart_sample(int channel);
int osd_get_sample_status(int channel);
void osd_ym2203_write(int n, int r, int v);
void osd_ym2203_update(void);
void osd_set_mastervolume(int volume);
int osd_key_pressed(int keycode);
int osd_read_key(void);
int osd_read_keyrepeat(void);
const char *osd_joy_name(int joycode);
const char *osd_key_name(int keycode);
void osd_poll_joystick(void);
int osd_joy_pressed(int joycode);

int osd_trak_read(int axis);

int osd_update_vectors(int *x_res, int *y_res, int step);
void osd_draw_to(int x, int y, int col);


/* file handling routines */
#define OSD_FILETYPE_ROM 1
#define OSD_FILETYPE_SAMPLE 2
#define OSD_FILETYPE_HIGHSCORE 3
#define OSD_FILETYPE_CONFIG 4

/* gamename holds the driver name, filename is only used for ROMs and samples. */
/* if 'write' is not 0, the file is opened for write. Otherwise it is opened */
/* for read. */
void *osd_fopen (const char *gamename,const char *filename,int filetype,int write);
int osd_fread (void *file,void *buffer,int length);
int osd_fwrite (void *file,const void *buffer,int length);
int osd_fseek (void *file,int offset,int whence);
void osd_fclose (void *file);

/* control keyboard leds or other indicators */
void osd_led_w(int led,int on);

char *create_cheat_path();

#ifdef __cplusplus
}
#endif

#endif
