/***************************************************************************

to do:
-Verify the Dip switches functions
-Better sound emulation
-Speed!!!
 -The Z80 spends most of its time reading the timer, we should trap that.


Time Pilot 84 Memory Map (preliminary)

The schematics are available on the net.

There is 3 CPU for this game.
 Two 68A09E for the game.
 A Z80A for the sound

As I understand it, the second 6809 is for displaying
 the sprites. If we do not emulate him, all work well, except
 that the player cannot die.
 Address 57ff must read 0 to pass the RAM test if the second CPU
 is not emulated.


---- Master 6809 ------

Write
 2000-27ff MAFR Watch dog ?
 2800      COL0 a register that index the colors Proms
 3000      reset IRQ
 3001      OUT2  Coin Counter 2
 3002      OUT1  Coin Counter 1
 3003      MUT
 3004      HREV
 3005      VREV
 3006      -
 3007      GMED
 3800      SON   Sound on
 3A00      SDA   Sound data
 3C00      SHF0 SHF1 J2 J3 J4 J5 J6 J7  background Y position
 3E00      L0 - L7                      background X position

Read:
 2800      in0  Buttons 1
 2820      in1  Buttons 2
 2840      in2  Buttons 3
 2860      in3  Dip switches 1
 3000      in4  Dip switches 2
 3800      in5  Dip switches 3 (not used)

Read/Write
 4000-47ff Char ram, 2 pages
 4800-4fff Background character ram, 2 pages
 5000-57ff Ram (Common for the Master and Slave 6809)  0x5000-0x517f sprites data
 6000-ffff Rom (only from $8000 to $ffff is used in this game)


------ Slave 6809 --------
 0000-1fff SAFR Watch dog ?
 2000      seem to be the beam position (if always 0, no player collision is detected)
 4000      enable or reset IRQ
 6000-7fff DRA ?
 8000-87ff Ram (Common for the Master and Slave 6809)
 E000-ffff Rom


------ Sound CPU (Z80) -----
There is 3 or 4 76489AN chips driven by the Z80

0000-1fff Rom program (A6)
2000-3fff Rom Program (A4) (not used or missing?)
4000-43ff Ram
6000-7fff Sound data in
8000-9fff Timer
A000-Bfff
C000      ? Store Data that will go to one of the 76489AN
C001      Sound 1
C002      Sound 2 (optional)
C003      Sound 3
C004      Sound 4

***************************************************************************/

#include "driver.h"
#include "vidhrdw/generic.h"
#include "sndhrdw/generic.h"


/* In Machine */
extern int tp84_beam_r(int offset);
extern int tp84_interrupt(void);
void tp84_catchloop_w(int offset,int data); /* JB 970829 */
int tp84_catchloop_r(int offset); /* JB 970829 */
void tp84_init_machine(void); /* JB 970829 */

/* In Vidhrdw */
extern unsigned char *tp84_sharedram;
int tp84_sharedram_r(int offset);
void tp84_sharedram_w(int offset,int data);

extern unsigned char *tp84_videoram2;
extern unsigned char *tp84_colorram2;
extern unsigned char *tp84_scrollx;
extern unsigned char *tp84_scrolly;
void tp84_videoram2_w(int offset,int data);
void tp84_colorram2_w(int offset,int data);
void tp84_col0_w(int offset,int data);
void tp84_vh_convert_color_prom(unsigned char *palette, unsigned char *colortable,const unsigned char *color_prom);
int tp84_vh_start(void);
void tp84_vh_stop(void);
void tp84_vh_screenrefresh(struct osd_bitmap *bitmap);

int tp84_sh_timer_r(int offset);
int tp84_sh_interrupt(void);
void tp84_sound1_w(int offset,int data);
void tp84_sound2_w(int offset,int data);
void tp84_sound3_w(int offset,int data);
int tp84_sh_start(void);
void tp84_sh_stop(void);
void tp84_sh_update(void);



/* CPU 1 read addresses */
static struct MemoryReadAddress readmem[] =
{
	{ 0x2800, 0x2800, input_port_0_r },
	{ 0x2820, 0x2820, input_port_1_r },
	{ 0x2840, 0x2840, input_port_2_r },
	{ 0x2860, 0x2860, input_port_3_r },
	{ 0x3000, 0x3000, input_port_4_r },
	{ 0x4000, 0x4fff, MRA_RAM },
	{ 0x523a, 0x523a, tp84_catchloop_r }, /* JB 970829 */
	{ 0x5000, 0x57ff, tp84_sharedram_r },
	{ 0x8000, 0xffff, MRA_ROM },
	{ -1 }	/* end of table */
};

/* CPU 1 write addresses */
static struct MemoryWriteAddress writemem[] =
{
	{ 0x2000, 0x2000, MWA_RAM }, /*Watch dog?*/
	{ 0x2800, 0x2800, tp84_col0_w },
	{ 0x3000, 0x3000, MWA_RAM },
	{ 0x3a00, 0x3a00, sound_command_w },
	{ 0x3c00, 0x3c00, MWA_RAM, &tp84_scrollx }, /* Y scroll */
	{ 0x3e00, 0x3e00, MWA_RAM, &tp84_scrolly }, /* X scroll */
	{ 0x4000, 0x43ff, videoram_w, &videoram , &videoram_size},
	{ 0x4400, 0x47ff, tp84_videoram2_w, &tp84_videoram2 },
	{ 0x4800, 0x4bff, colorram_w, &colorram },
	{ 0x4c00, 0x4fff, tp84_colorram2_w, &tp84_colorram2 },
	{ 0x5000, 0x57ff, tp84_sharedram_w, &tp84_sharedram },   /* 0x5000-0x517f sprites definitions*/
	{ 0x8000, 0xffff, MWA_ROM },
	{ -1 }	/* end of table */
};


/* CPU 2 read addresses */
static struct MemoryReadAddress readmem_cpu2[] =
{
	{ 0x0000, 0x0000, MRA_RAM },
	{ 0x2000, 0x2000, tp84_beam_r }, /* beam position */
	{ 0x6000, 0x7fff, MRA_RAM },
	{ 0x8000, 0x87ff, tp84_sharedram_r },  /* shared RAM with the main CPU */
	{ 0xe000, 0xffff, MRA_ROM },
	{ -1 }	/* end of table */
};

/* CPU 2 write addresses */
static struct MemoryWriteAddress writemem_cpu2[] =
{
	{ 0x0000, 0x0000, MWA_RAM }, /* Watch dog ?*/
	{ 0x4000, 0x4000, tp84_catchloop_w }, /* IRQ enable */ /* JB 970829 */
	{ 0x6000, 0x7fff, MWA_RAM },
	{ 0x8000, 0x87ff, tp84_sharedram_w },    /* shared RAM with the main CPU */
	{ 0xe000, 0xffff, MWA_ROM },              /* ROM code */

	{ -1 }	/* end of table */
};


static struct MemoryReadAddress sound_readmem[] =
{
	{ 0x0000, 0x1fff, MRA_ROM },
	{ 0x4000, 0x43ff, MRA_RAM },
	{ 0x6000, 0x6000, sound_command_r },
	{ 0x8000, 0x8000, tp84_sh_timer_r },
	{ -1 }	/* end of table */
};

static struct MemoryWriteAddress sound_writemem[] =
{
	{ 0x0000, 0x1fff, MWA_ROM },
	{ 0x4000, 0x43ff, MWA_RAM },
	{ 0xc000, 0xc000, MWA_NOP },
	{ 0xc001, 0xc001, tp84_sound1_w },
	{ 0xc003, 0xc003, tp84_sound1_w },
	{ 0xc004, 0xc004, tp84_sound1_w },
	{ -1 }	/* end of table */
};



static struct InputPort TP84_input_ports[] =
{
	{	/* Insert Coin */
		0xFF,	/* default_value */
		{ OSD_KEY_3, 0, 0, OSD_KEY_1, OSD_KEY_2, 0, 0, 0 },
		{ 0, 0, 0, 0, 0, 0, 0, 0 }	/* not affected by joystick */
	},
	{	/* Player 1 joystick */
		0xFF,	/* default_value */
		{ OSD_KEY_LEFT, OSD_KEY_RIGHT, OSD_KEY_UP, OSD_KEY_DOWN, OSD_KEY_LCONTROL, OSD_KEY_ALT, 0, 0},
		{ OSD_JOY_LEFT, OSD_JOY_RIGHT, OSD_JOY_UP, OSD_JOY_DOWN, OSD_JOY_FIRE2, OSD_JOY_FIRE1, 0, 0}
	},
	{	/* Second player joystick */
		0xFF,	/* default_value */
		{ 0, 0, 0, 0, 0, 0, 0, 0 },
		{ 0, 0, 0, 0, 0, 0, 0, 0 }	/* not affected by joystick */
	},
	{	/* Dip 1 Self test and pricing */
		0xff,	/* default_value */
		{ 0, 0, 0, 0, 0, 0, 0, 0 },
		{ 0, 0, 0, 0, 0, 0, 0, 0 }	/* not affected by joystick */
	},
	{	/* Dip 2 */
		0xD5,	/* default_value */
		{ 0, 0, 0, 0, 0, 0, 0, 0 },
		{ 0, 0, 0, 0, 0, 0, 0, 0 }	/* not affected by joystick */
	},
	{ -1 }	/* end of table */
};


static struct KEYSet keys[] =
{
				{ 1, 2, "MOVE UP" },
				{ 1, 3, "MOVE DOWN" },
				{ 1, 0, "MOVE LEFT"  },
				{ 1, 1, "MOVE RIGHT" },
				{ 1, 4, "FIRE" },
				{ 1, 5, "MISSILE" },
				{ -1 }
};


/* This needs a lot of work... */
static struct DSW TP84_dsw[] =
{
	{ 4, 0x03, "LIVES", {"7", "5", "3", "2" } },

	{ 4, 0x18, "BONUS AT", { "40000 80000", "30000 70000",\
													 "20000 60000", "10000 50000" } },
/*Not sure*/
	{ 4, 0x60, "DIFFICULTY", { "HARD", "MEDIUM", "NORMAL", "EASY" }, 1 },

	{ -1 }
};

static struct TrakPort trak_ports[] =
{
        { -1 }
};



static struct GfxLayout charlayout =
{
	8,8,	/* 8*8 characters */
	1024,	/* 1024 characters */
	2,	/* 2 bits per pixel */
	{ 4, 0 },	/* the two bitplanes for 4 pixels are packed into one byte */
	{  0, 1, 2, 3, 8*8+0, 8*8+1, 8*8+2, 8*8+3 },	/* bits are packed in groups of four */
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8 },
	16*8	/* every char takes 16 bytes */
};
static struct GfxLayout spritelayout =
{
	16,16,	/* 16*16 sprites */
	256,	/* 256 sprites */
	4,	/* 4 bits per pixel */
	{ 256*64*8+4, 256*64*8+0, 4 ,0 },
	{ 0, 1, 2, 3, 8*8+0, 8*8+1, 8*8+2, 8*8+3,
			16*8+0, 16*8+1, 16*8+2, 16*8+3, 24*8+0, 24*8+1, 24*8+2, 24*8+3 },
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8,
			32*8, 33*8, 34*8, 35*8, 36*8, 37*8, 38*8, 39*8 },
	64*8	/* every sprite takes 64 bytes */
};

static struct GfxDecodeInfo gfxdecodeinfo[] =
{
	{ 1, 0x0000, &charlayout,        0, 64*8 },
	{ 1, 0x4000, &spritelayout, 64*4*8, 16*8 },
	{ -1 } /* end of array */
};



static unsigned char color_prom[] =
{
	/* 2c - palette red component */
	0x00,0x02,0x04,0x06,0x08,0x0A,0x01,0x0F,0x0B,0x05,0x03,0x05,0x07,0x09,0x0B,0x0D,
	0x00,0x02,0x03,0x06,0x0A,0x0C,0x01,0x0F,0x0B,0x05,0x03,0x05,0x07,0x0A,0x0C,0x0D,
	0x00,0x01,0x03,0x05,0x0B,0x0D,0x01,0x0F,0x0B,0x05,0x02,0x04,0x06,0x09,0x0E,0x0D,
	0x00,0x01,0x03,0x05,0x0C,0x0E,0x01,0x0F,0x0B,0x05,0x02,0x04,0x06,0x09,0x0E,0x0D,
	0x00,0x01,0x0A,0x05,0x07,0x0A,0x01,0x0F,0x0B,0x05,0x02,0x0A,0x05,0x07,0x0A,0x0D,
	0x00,0x01,0x0B,0x04,0x06,0x0A,0x01,0x0F,0x0B,0x05,0x02,0x0B,0x04,0x06,0x0A,0x0D,
	0x00,0x02,0x04,0x06,0x08,0x0A,0x01,0x0F,0x0B,0x05,0x03,0x05,0x06,0x08,0x0A,0x0D,
	0x00,0x02,0x04,0x06,0x08,0x0A,0x01,0x0F,0x0B,0x05,0x03,0x05,0x06,0x08,0x0A,0x0D,
	0x00,0x0B,0x09,0x06,0x04,0x04,0x02,0x01,0x09,0x03,0x09,0x06,0x05,0x03,0x0F,0x0D,
	0x00,0x0C,0x0A,0x06,0x04,0x04,0x02,0x01,0x0A,0x03,0x0A,0x06,0x05,0x03,0x0F,0x0D,
	0x00,0x0B,0x0A,0x06,0x04,0x04,0x02,0x01,0x00,0x00,0x0A,0x06,0x05,0x03,0x0F,0x0D,
	0x00,0x09,0x08,0x05,0x03,0x03,0x02,0x01,0x00,0x00,0x09,0x05,0x04,0x03,0x0F,0x0D,
	0x00,0x0C,0x00,0x00,0x07,0x01,0x02,0x06,0x05,0x04,0x06,0x03,0x02,0x02,0x0F,0x0D,
	0x00,0x0F,0x0F,0x00,0x07,0x01,0x01,0x06,0x05,0x04,0x05,0x02,0x02,0x05,0x0F,0x0D,
	0x00,0x0D,0x0B,0x0A,0x0F,0x0A,0x01,0x09,0x09,0x0A,0x0E,0x0C,0x07,0x00,0x00,0x0C,
	0x00,0x0D,0x00,0x00,0x00,0x00,0x00,0x09,0x00,0x0B,0x00,0x01,0x03,0x05,0x07,0x00,
	/* 2d - palette green component */
	0x00,0x04,0x06,0x08,0x0A,0x0C,0x01,0x07,0x03,0x01,0x03,0x05,0x08,0x0A,0x0E,0x0D,
	0x00,0x03,0x05,0x07,0x09,0x0A,0x01,0x07,0x03,0x01,0x03,0x05,0x08,0x0A,0x0C,0x0D,
	0x00,0x02,0x04,0x07,0x09,0x0A,0x01,0x07,0x03,0x01,0x03,0x05,0x07,0x09,0x0A,0x0D,
	0x00,0x02,0x04,0x07,0x08,0x09,0x01,0x07,0x03,0x01,0x03,0x05,0x07,0x08,0x08,0x0D,
	0x00,0x03,0x0A,0x07,0x09,0x0C,0x01,0x07,0x03,0x01,0x02,0x0B,0x06,0x08,0x0D,0x0D,
	0x00,0x02,0x06,0x06,0x08,0x0C,0x01,0x07,0x03,0x01,0x02,0x0C,0x05,0x07,0x0D,0x0D,
	0x00,0x04,0x06,0x08,0x0A,0x0C,0x01,0x07,0x03,0x01,0x03,0x05,0x07,0x09,0x0D,0x0D,
	0x00,0x04,0x06,0x08,0x0A,0x0C,0x01,0x07,0x03,0x01,0x03,0x05,0x07,0x09,0x0D,0x0D,
	0x00,0x09,0x07,0x05,0x03,0x00,0x00,0x00,0x09,0x03,0x09,0x06,0x05,0x03,0x07,0x0D,
	0x00,0x07,0x06,0x04,0x02,0x00,0x00,0x00,0x07,0x01,0x07,0x05,0x03,0x01,0x07,0x0D,
	0x00,0x05,0x04,0x02,0x01,0x01,0x01,0x01,0x0B,0x0B,0x06,0x04,0x02,0x01,0x07,0x0D,
	0x00,0x06,0x04,0x02,0x01,0x01,0x00,0x01,0x0B,0x0B,0x04,0x03,0x02,0x01,0x07,0x0D,
	0x00,0x00,0x00,0x0B,0x0F,0x00,0x00,0x03,0x03,0x03,0x03,0x02,0x01,0x00,0x07,0x0D,
	0x00,0x00,0x0F,0x0C,0x0F,0x00,0x00,0x04,0x04,0x04,0x02,0x01,0x00,0x00,0x07,0x0D,
	0x00,0x0D,0x0B,0x0A,0x0E,0x0A,0x00,0x00,0x00,0x00,0x05,0x0C,0x0E,0x0D,0x09,0x00,
	0x00,0x0D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,
	/* 1e - palette blue component */
	0x00,0x06,0x08,0x0A,0x0C,0x0E,0x01,0x03,0x02,0x01,0x02,0x03,0x04,0x05,0x06,0x0D,
	0x00,0x05,0x07,0x09,0x0A,0x0C,0x01,0x03,0x02,0x01,0x02,0x03,0x04,0x05,0x06,0x0D,
	0x00,0x05,0x06,0x09,0x0A,0x0C,0x01,0x03,0x02,0x01,0x01,0x02,0x04,0x05,0x06,0x0D,
	0x00,0x05,0x06,0x09,0x09,0x0B,0x01,0x03,0x02,0x01,0x01,0x02,0x04,0x04,0x04,0x0D,
	0x00,0x05,0x0D,0x09,0x0B,0x0E,0x01,0x03,0x02,0x01,0x01,0x09,0x03,0x04,0x06,0x0D,
	0x00,0x04,0x0B,0x08,0x0A,0x0E,0x01,0x03,0x02,0x01,0x01,0x0A,0x02,0x03,0x06,0x0D,
	0x00,0x06,0x08,0x0A,0x0C,0x0E,0x01,0x03,0x02,0x01,0x02,0x03,0x04,0x05,0x06,0x0D,
	0x00,0x06,0x08,0x0A,0x0C,0x0E,0x01,0x03,0x02,0x01,0x02,0x03,0x04,0x05,0x06,0x0D,
	0x00,0x00,0x00,0x00,0x00,0x0A,0x07,0x05,0x09,0x03,0x09,0x06,0x05,0x03,0x00,0x0D,
	0x00,0x00,0x00,0x00,0x00,0x09,0x05,0x03,0x05,0x01,0x05,0x04,0x03,0x01,0x00,0x0D,
	0x00,0x00,0x02,0x02,0x01,0x05,0x04,0x03,0x07,0x07,0x06,0x03,0x03,0x02,0x00,0x0D,
	0x00,0x00,0x03,0x04,0x04,0x05,0x04,0x03,0x07,0x07,0x07,0x04,0x03,0x02,0x00,0x0D,
	0x00,0x0F,0x00,0x07,0x0F,0x05,0x04,0x06,0x06,0x06,0x08,0x05,0x04,0x03,0x00,0x0D,
	0x00,0x0F,0x06,0x08,0x0F,0x04,0x03,0x06,0x06,0x06,0x07,0x04,0x03,0x04,0x00,0x0D,
	0x00,0x0D,0x0B,0x0A,0x03,0x03,0x05,0x0D,0x0D,0x00,0x00,0x00,0x00,0x08,0x0D,0x0A,
	0x00,0x0D,0x00,0x00,0x00,0x00,0x00,0x0D,0x00,0x00,0x00,0x04,0x06,0x08,0x0B,0x00,
	/* 1f - character lookup table */
	0x00,0x02,0x03,0x04,0x01,0x02,0x03,0x04,0x05,0x06,0x03,0x04,0x0A,0x0B,0x0D,0x00,
	0x0A,0x0B,0x0D,0x0C,0x00,0x0B,0x0D,0x0C,0x0D,0x0B,0x0D,0x09,0x0A,0x0B,0x0D,0x0E,
	0x0A,0x0C,0x03,0x04,0x0A,0x0B,0x0D,0x08,0x00,0x0B,0x0D,0x09,0x0A,0x0B,0x0C,0x0E,
	0x0A,0x0B,0x0D,0x00,0x0A,0x0B,0x0B,0x0B,0x05,0x06,0x07,0x00,0x0F,0x00,0x00,0x0E,
	0x09,0x05,0x0B,0x06,0x04,0x06,0x00,0x09,0x09,0x01,0x0B,0x06,0x09,0x05,0x02,0x06,
	0x09,0x01,0x02,0x06,0x02,0x09,0x00,0x06,0x09,0x03,0x02,0x06,0x09,0x03,0x00,0x06,
	0x09,0x03,0x00,0x02,0x09,0x05,0x00,0x06,0x0B,0x09,0x00,0x06,0x0C,0x00,0x00,0x0F,
	0x0D,0x04,0x00,0x01,0x0E,0x00,0x00,0x08,0x07,0x00,0x00,0x0A,0x01,0x06,0x00,0x09,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x0E,
	0x00,0x0B,0x0C,0x00,0x0A,0x0B,0x0C,0x00,0x05,0x06,0x0C,0x00,0x0A,0x0B,0x0D,0x00,
	0x0A,0x0B,0x0D,0x0C,0x00,0x0B,0x0D,0x0C,0x02,0x0B,0x0D,0x04,0x0A,0x0B,0x0D,0x0E,
	0x0A,0x0C,0x0C,0x00,0x0A,0x0B,0x0D,0x03,0x00,0x0B,0x0D,0x03,0x0A,0x0B,0x0C,0x0E,
	0x0A,0x0B,0x0D,0x01,0x0A,0x09,0x08,0x07,0x05,0x06,0x00,0x00,0x0F,0x00,0x00,0x0E,
	/* 16c - sprite lookup table */
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x00,0x00,0x01,0x02,0x03,0x04,0x06,0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,
	0x00,0x00,0x00,0x01,0x02,0x03,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00,0x0E,0x0F,
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x09,0x09,0x06,0x00,0x00,0x0E,0x0F,0x00,0x00,
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x08,0x08,0x09,0x0E,0x0F,0x00,0x00,0x00,0x00,
	0x00,0x06,0x09,0x09,0x06,0x0F,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x08,
	0x00,0x09,0x06,0x06,0x00,0x08,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x00,
	0x00,0x08,0x06,0x06,0x05,0x00,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x00,
	0x00,0x07,0x09,0x09,0x00,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x00,
	0x00,0x07,0x08,0x08,0x00,0x00,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x05,
	0x00,0x08,0x07,0x07,0x00,0x00,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0A,
	0x00,0x09,0x07,0x07,0x00,0x00,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x07,
	0x00,0x06,0x08,0x08,0x00,0x00,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x03,
	0x00,0x00,0x00,0x00,0x02,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};



static struct MachineDriver machine_driver =
{
	/* basic machine hardware  */
	{
		{
			CPU_M6809,
			1500000,			/* ? Mhz 1.1 seem too slow */
			0,					/* memory region */
			readmem,			/* MemoryReadAddress */
			writemem,			/* MemoryWriteAddress */
			0,					/* IOReadPort */
			0,					/* IOWritePort */
			interrupt,			/* interrupt routine */
			1					/* interrupts per frame */
		},
		{
			CPU_M6809,
			1100000,			/* ? Mhz */
			2,	/* memory region #2 */
			readmem_cpu2,
			writemem_cpu2,
			0,
			0,
			tp84_interrupt,1	/* JB 970829 */ /*256*/
		},
		{
			CPU_Z80 | CPU_AUDIO_CPU,
			3072000,	/* 3.072 Mhz ? */
			3,	/* memory region #3 */
			sound_readmem,sound_writemem,0,0,
			tp84_sh_interrupt,1
		}
	},
	60,							/* frames per second */
	100,	/* 100 CPU slices per frame - an high value to ensure proper */
			/* synchronization of the CPUs */
	tp84_init_machine,		/* init machine routine */ /* JB 970829 */

	/* video hardware */
	32*8, 32*8, { 0*8, 32*8-1, 2*8, 30*8-1 },
	gfxdecodeinfo,				/* GfxDecodeInfo * */
	256,4096, /* see tp84_vh_convert_color_prom for explanation */
	tp84_vh_convert_color_prom,							/* convert color prom routine */

	VIDEO_TYPE_RASTER,
	0,							/* vh_init routine */
	tp84_vh_start,			/* vh_start routine */
	tp84_vh_stop,			/* vh_stop routine */
	tp84_vh_screenrefresh,	/* vh_update routine */

	/* sound hardware */
	0,
	0,
	tp84_sh_start,
	tp84_sh_stop,
	tp84_sh_update
};


ROM_START( tp84_rom )
	ROM_REGION(0x10000)	/* 64k for code */
	ROM_LOAD( "tp84_7j.bin",  0x8000, 0x2000, 0xA31F399F )
	ROM_LOAD( "tp84_8j.bin",  0xa000, 0x2000, 0x26F277A6 )
	ROM_LOAD( "tp84_9j.bin",  0xc000, 0x2000, 0x32B33813 )
	ROM_LOAD( "tp84_10j.bin", 0xe000, 0x2000, 0x0EE9E39B )

	ROM_REGION(0xc000)	/* Temporary */
/*Chars*/
	ROM_LOAD( "tp84_2j.bin", 0x0000, 0x2000, 0x2e1d4fc1 )
	ROM_LOAD( "tp84_1j.bin", 0x2000, 0x2000, 0xa03b6e83 )

/*Sprites*/
	ROM_LOAD( "tp84_12a.bin", 0x4000, 0x2000, 0xbce053e6 )
	ROM_LOAD( "tp84_13a.bin", 0x6000, 0x2000, 0x6041402f )
	ROM_LOAD( "tp84_14a.bin", 0x8000, 0x2000, 0x766266d0 )
	ROM_LOAD( "tp84_15a.bin", 0xa000, 0x2000, 0x5e4e6bfc )

/* Second CPU */
	ROM_REGION(0x10000)	/* 64k for the second CPU */
	ROM_LOAD( "tp84_10d.bin", 0xe000, 0x2000, 0x971bf3f1 )

/* Sound CPU */
	ROM_REGION(0x10000)	/* 64k for code of sound cpu Z80 */
	ROM_LOAD( "tp84s_6a.bin", 0x0000, 0x2000, 0xe2664270 )
ROM_END



static int hiload(void)
{
	unsigned char *RAM = Machine->memory_region[0];
	void *f;

	/* Wait for hiscore table initialization to be done. */
	if (memcmp(&RAM[0x57a0], "\x00\x02\x00\x47\x53\x58", 6) != 0)
		return 0;

	if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_HIGHSCORE,0)) != 0)
	{
		/* Load and set hiscore table. */
		osd_fread(f,&RAM[0x57a0],5*6);
		RAM[0x5737] = RAM[0x57a1];
		RAM[0x5738] = RAM[0x57a2];
		osd_fclose(f);
	}

	return 1;
}



static void hisave(void)
{
	unsigned char *RAM = Machine->memory_region[0];
	void *f;

	if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_HIGHSCORE,1)) != 0)
	{
		/* Write hiscore table. */
		osd_fwrite(f,&RAM[0x57a0],5*6);
		osd_fclose(f);
	}
}



struct GameDriver tp84_driver =
{
	"Time Pilot 84",
	"tp84",
	"Marc Lafontaine (MAME driver)\nJuan Carlos Lorente (high score)",
	&machine_driver,		/* MachineDriver * */

	tp84_rom,			/* RomModule * */
	0, 0,					/* ROM decrypt routines */
	0,						/* samplenames */

	TP84_input_ports,	/* InputPort  */
	0,
	trak_ports,                     /* TrackBall  */
	TP84_dsw,		/* DSW        */
	keys,                   /* KEY def    */

	color_prom,						/* color prom */
	0, 	          /* palette */
	0, 	          /* color table */
	ORIENTATION_ROTATE_90,

	hiload, hisave
};

