#include "CtrlView.h"
//------------------------------------------------------------------------------
TCtrlView::TCtrlView(BRect xFrame) : BView(xFrame,"CtrlView"
		,B_FOLLOW_LEFT | B_FOLLOW_TOP_BOTTOM,B_WILL_DRAW)
{
	BStringView	*xStrViewEnbloc;

	mxButtonGoStop = new BButton(BRect(CtrlCmpLeft,CmpMargin,CtrlCmpRight
			,CmpMargin+ButtonHeight),"ButtonGoStop",gxLLMsg->mxButtonGo.String()
			,new BMessage(MENUGOSTOP_CLICKED),B_FOLLOW_LEFT | B_FOLLOW_TOP
			,B_WILL_DRAW | B_NAVIGABLE);
	AddChild(mxButtonGoStop);
	mxButtonStep = new BButton(BRect(CtrlCmpLeft
			,mxButtonGoStop->Frame().bottom+CmpMargin,CtrlCmpRight
			,mxButtonGoStop->Frame().bottom+CmpMargin+ButtonHeight)
			,"ButtonStep",gxLLMsg->mxButtonStep.String(),new BMessage(MENUSTEP_CLICKED)
			,B_FOLLOW_LEFT | B_FOLLOW_TOP,B_WILL_DRAW | B_NAVIGABLE);
	AddChild(mxButtonStep);
	mxButtonEnbloc = new BButton(BRect(CtrlCmpLeft
			,mxButtonStep->Frame().bottom+CmpMargin,CtrlCmpRight
			,mxButtonStep->Frame().bottom+CmpMargin+ButtonHeight)
			,"ButtonEnbloc",gxLLMsg->mxButtonEnbloc.String(),new BMessage(MENUENBLOC_CLICKED)
			,B_FOLLOW_LEFT | B_FOLLOW_TOP,B_WILL_DRAW | B_NAVIGABLE);
	AddChild(mxButtonEnbloc);
	mxTxtCtrlEnbloc = new BTextControl(BRect(CtrlCmpLeft
			,mxButtonEnbloc->Frame().bottom+CmpMargin,CtrlCmpRight*0.6
			,0/*mxButtonEnbloc->Frame().bottom+CmpMargin+ButtonHeight*/)
			,"TxtCtrlEnbloc",NULL,gxLLMsg->mxEditEnbloc.String(),NULL);
	mxTxtCtrlEnbloc->SetAlignment(B_ALIGN_RIGHT,B_ALIGN_RIGHT);
	AddChild(mxTxtCtrlEnbloc);
	xStrViewEnbloc = new BStringView(BRect(CtrlCmpRight*0.6
			,mxTxtCtrlEnbloc->Frame().top,CtrlCmpRight
			,mxTxtCtrlEnbloc->Frame().bottom),"StrViewEnbloc",gxLLMsg->mxLabelEnbloc.String());
	AddChild(xStrViewEnbloc);
	miOptimumHeight = (int)mxTxtCtrlEnbloc->Frame().bottom+CmpMargin;
}
//------------------------------------------------------------------------------
void	TCtrlView::AllAttached()
{
	mxFieldView = Parent()->FindView("FieldView");
	mxButtonGoStop->SetTarget(mxFieldView);
	mxButtonStep->SetTarget(mxFieldView);
	mxButtonEnbloc->SetTarget(mxFieldView);
	mxButtonGoStop->MakeFocus();
}
//------------------------------------------------------------------------------
void TCtrlView::AttachedToWindow()
{
}
//------------------------------------------------------------------------------
void	TCtrlView::ChangeViewColRqtd()
{
	int		i = 0;
	BView	*xView;
	
	SetViewColor(gxCustomSet->mxCtrlViewColor);
	Invalidate();
	while ( (xView = ChildAt(i)) != NULL ) {
		xView->SetViewColor(gxCustomSet->mxCtrlViewColor);
		xView->Invalidate();
		i++;
	}
}
//------------------------------------------------------------------------------
void TCtrlView::DisableCtrl()
{
	mxButtonGoStop->SetLabel(gxLLMsg->mxButtonStop.String());
	mxButtonStep->SetEnabled(false);
	mxButtonEnbloc->SetEnabled(false);
	mxTxtCtrlEnbloc->SetEnabled(false);
}
//------------------------------------------------------------------------------
void TCtrlView::DisableCtrlRqtd()
{
	DisableCtrl();
}
//------------------------------------------------------------------------------
void TCtrlView::Draw(BRect xRect)
{
//	MovePenTo(10,100);
//	DrawString("TCtrlView : Abcdefg Hijklmn Opqrstu Vwxyz");
}
//------------------------------------------------------------------------------
void TCtrlView::EnableCtrl()
{
	mxButtonGoStop->SetLabel(gxLLMsg->mxButtonGo.String());
	mxButtonStep->SetEnabled(true);
	mxButtonEnbloc->SetEnabled(true);
	mxTxtCtrlEnbloc->SetEnabled(true);
}
//------------------------------------------------------------------------------
void TCtrlView::EnableCtrlRqtd()
{
	EnableCtrl();
}
//------------------------------------------------------------------------------
int	TCtrlView::EnblocNum()
{
	return StrToInt(mxTxtCtrlEnbloc->Text(),EnblocMaxFig);
}
//------------------------------------------------------------------------------
void	TCtrlView::MessageReceived(BMessage *xMsg)
{
	switch ( xMsg->what ) {
	case CHANGEVIEWCOL_RQTD:
		ChangeViewColRqtd();
		break;
	case DISABLECTRL_RQTD:
		DisableCtrlRqtd();
		break;
	case ENABLECTRL_RQTD:
		EnableCtrlRqtd();
		break;
	default:
		BView::MessageReceived(xMsg);
	}
}
//------------------------------------------------------------------------------
int		TCtrlView::OptimumHeight()
{
	return miOptimumHeight;
}
//------------------------------------------------------------------------------
/*
	BAlert	*xAlert;
	xAlert = new BAlert("title","Ctrl:ButtonGoClickd End"
			,"OK",NULL,NULL,B_WIDTH_AS_USUAL,B_OFFSET_SPACING
			,B_WARNING_ALERT); 
	xAlert->Go();
*/
