#!/bin/sh
#
# This shell script extracts the doom1.wad file from the doom19s.zip
# archive.
#
BASEDIR=`dirname $0`
cd $BASEDIR
DOOM19SZIP=doom19s.zip

if [ -e $DOOM19SZIP ]
then
	cp $DOOM19SZIP /tmp
	(
		j=`basename $DOOM19SZIP`
		/bin/alert --info "Installing from $BASEDIR/$DOOM19SZIP" "OK"
		cd /tmp
		mkdir doom
		cd doom
		unzip -o ../$j >/dev/null 2>&1
		if [ -e *.DAT ]
		then
			k=`ls *.DAT | sed "s/.DAT//g"`
			cat $k.[0-9]* > DOOM.ZIP
		else
			echo "Couldn't find a .DAT file in the archive."
			exit;
		fi
	)
	unzip -nL /tmp/doom/DOOM.ZIP doom1.wad readme.txt >/dev/null 2>&1
	rm -Rf /tmp/doom

	alert --idea "Would you like a link to this game created under 'Games' in your Be Menu?" No Yes >/dev/null 2>&1
	result=$?
	menuname="Doom 1.92"
	if [ $result -eq 1 ]
	then
		mkdir /boot/home/config/be/Games >/dev/null 2>&1
		rm -f "/boot/home/config/be/Games/$menuname"
		ln -s $PWD/Doom "/boot/home/config/be/Games/$menuname"
	fi

	alert --info "Installed successfully.  You may now delete $DOOM19SZIP and RUN_ME_FIRST.sh if you like." Thanks >/dev/null 2>&1
else
	/bin/alert --stop "Couldn't find the file $DOOM19SZIP.  Make sure its in this folder." "OK"
	exit;
fi
