/*********************************************************************
HyperTTT - Tic tac toe in higher dimensions
Copyright (c) 1998 Brian Nenninger

This program is free software; you can redistribute it and/or modify it under 
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with 
this program; if not, write to the Free Software Foundation, Inc., 675 Mass 
Ave., Cambridge, MA 02139, USA.

You may contact me at bwn@kreative.net
************************************************************************/

#include "InterfaceKit.h"
#include "BeTTTApp.h"
#include "4dBoard.h"
#include "BeTTTGame.h"
#include "BeTTTWindow.h"
#include "BeTTTView.h"
// for srand()
#include "stdlib.h"


// global vars
extern int N, D;


main()
{	
	BeTTTApp *myApplication;
  srand(time(NULL));
  
	myApplication = new BeTTTApp();
	myApplication->Run();
	
	delete(myApplication);
	return(0);
}

BeTTTApp::BeTTTApp()
		  		  : BApplication('4TTT')
{
	BeTTTWindow		*aWindow;
	BeTTTView		*aView;
	BRect			aRect;


	// set up a rectangle and instantiate a new window
	aRect.Set(80, 100, 405, 425);
	aWindow = new BeTTTWindow(aRect);
	
		// set up a rectangle and instantiate a new view
	// view rect should be same size as window rect but with left top at (0, 0)
	aRect.OffsetTo(B_ORIGIN);
	aRect.top += 20;
	aView = new BeTTTView(aRect, "Game View");
	
	// add view to window
	aWindow->AddChild(aView);

  // create and assign the game object	
	m_game = new BeTTTGame(this, aWindow, aView, 4, 4);
    aWindow->SetGame(m_game);
    //aWindow->SetApp(this);
	aView->SetGame(m_game);
	
	// make window visible
	aWindow->Show();
	aWindow->ShowScoreWindow();
	
	aWindow->Activate();

  aWindow->PostMessage(new BMessage(kNewGameMsg));	
}
