/*********************************************************************
HyperTTT - Tic tac toe in higher dimensions
Copyright (c) 1998 Brian Nenninger

This program is free software; you can redistribute it and/or modify it under 
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with 
this program; if not, write to the Free Software Foundation, Inc., 675 Mass 
Ave., Cambridge, MA 02139, USA.

You may contact me at bwn@kreative.net
************************************************************************/

#ifndef BeTTT_VIEW_H
#define BeTTT_VIEW_H

#ifndef _VIEW_H
#include <View.h>
#endif


#define kLeftGap 10
#define kTopGap  10
#define kTie -1 // passed as winner number when there is a tie

#define kSolidStyle 0
#define kXOStyle 1

class BeTTTApp;
class BeTTTGame;
class Vector;
class ThreatLine;

class BeTTTView : public BView {

protected:
  BeTTTGame *m_game;
  

	BRect ComputeCellRect(Vector &v);
	bool UpdateScale();
	void CountCells();
	void EndGame(int);
	void CheckForTie();
	void DoMove(Vector &v);
	void ToggleFlash();

	int m_hScale, m_vScale, m_hCells, m_vCells;
	int m_lastHScale, m_lastVScale;
	
	int m_flashing;
	int m_flashOn;
	int m_flashCount;
	int m_winnerNum;
	
	int m_cellStyle;

public:
	BeTTTView(BRect frame, char *name); 
  virtual	void	Draw(BRect);
  virtual void FrameResized(float, float);
	void DrawCell(Vector &v, int val);
	void SetStyle(int);
	int GetStyle();
  void NDChanged();  
    
  void SetGame(BeTTTGame *);
  
  virtual void MouseDown(BPoint);
};

void DrawPiece(BRect, BView *, int, int);

#endif
