/*********************************************************************
HyperTTT - Tic tac toe in higher dimensions
Copyright (c) 1998 Brian Nenninger

This program is free software; you can redistribute it and/or modify it under 
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with 
this program; if not, write to the Free Software Foundation, Inc., 675 Mass 
Ave., Cambridge, MA 02139, USA.

You may contact me at bwn@kreative.net
************************************************************************/

#ifndef BeTTT_WINDOW_H
#define BeTTT_WINDOW_H

#include <Window.h>
#include "4dBoard.h"
#include "BeTTTView.h"

class BeTTTGame;

class BeScoreView;
class BeAboutView;

#define kNewGameMsg 1
#define kQuitMsg    2

#define kP1BaseMsg     100
#define kP1HumanMsg    kP1BaseMsg+HUMAN
#define kP1AttackMsg   kP1BaseMsg+ATTACK
#define kP1BalancedMsg kP1BaseMsg+BALANCED
#define kP1DefendMsg   kP1BaseMsg+DEFEND
#define kP2BaseMsg     200
#define kP2HumanMsg    kP2BaseMsg+HUMAN
#define kP2AttackMsg   kP2BaseMsg+ATTACK
#define kP2BalancedMsg kP2BaseMsg+BALANCED
#define kP2DefendMsg   kP2BaseMsg+DEFEND

#define kSolidCellMsg  1000
#define kXOCellMsg     1001

#define kFastplayMsg   1101
#define kShowScoreMsg  1102
#define kResetScoreMsg 1103
#define kShowAboutMsg  1104

#define kSizeBaseMsg 1200
#define kDimBaseMsg  1300

class BeTTTWindow : public BWindow {
protected:

	virtual void MessageReceived(BMessage *); 
	void DoNewGame();

  int m_InGame;
  thread_id m_GameThread;
  
  BeTTTGame *m_game;
  //BeTTTApp  *m_app;
  
  BMenuItem *m_fastplayItem;
  
  int m_scoreWindOpen, m_aboutWindOpen;
  BWindow *m_scoreWindow, *m_aboutWindow;
  BeScoreView *m_scoreView;
  BeAboutView *m_aboutView;

public:
	BeTTTWindow(BRect frame);
	virtual	bool	QuitRequested();
	
	
	void SetGame(BeTTTGame *);
	
	void ShowScoreWindow();
	void ScoreWindowClosed();
	void ShowAboutWindow();
	void AboutWindowClosed();
	
	void UpdateScore();
	
	void DChanged(int, int, int);
};

#endif
