/*
	
	MorpionView.cpp
	
	Copyright © 1998 Fumihiko Shibata, All Rights Reserved.
	
*/

#include "Morpion.h"
#include "MorpionView.h"

#include <Be.h>
#include <stdlib.h>

extern		MorpionAppl	myApplication;

void DeBug(const char *message);
void DeBug(const char *message)
{
	BAlert *alert = new BAlert("DebugMessage", message, "OK");
	alert->Go();
}

MorpionView::MorpionView(BRect rect, const char *name)
			: BView(rect, name, B_FOLLOW_ALL, B_WILL_DRAW)
{
	dr[0] = -1; dr[1] = -1; dr[2] = 0;  dr[3] = 1;
	dr[4] = 1;  dr[5] = 1;  dr[6] = 0;  dr[7] = -1;
	dc[0] = 0;  dc[1] = 1;  dc[2] = 1;  dc[3] = 1;
	dc[4] = 0;  dc[5] = -1; dc[6] = -1; dc[7] = -1;

	Create();
}

MorpionView::~MorpionView()
{
}

void MorpionView::AttachedToWindow()
{
}

void MorpionView::Draw(BRect rect)
{
	DrawBoard();
}

void MorpionView::MouseDown(BPoint point)
{
	DoMove(point);
};

void MorpionView::Create()
{
	int	r, c, i, size;

	finished = FALSE;
	score = 0;
	for (r = 1; r <= max_row; r++)
		for (c = 1; c <= max_col; c++) {
			vertex[r][c] = FALSE;
			edges[r][c] = 0;
			}
	size = 3 * cross - 2;
	r = (max_row - size) / 2 + 1;
	c = (max_col - size) / 2 + 1;
	for (i = 0; i < cross; i++) {
		vertex[r][c + cross - 1 + i] = TRUE;
		vertex[r + size - 1][c + cross - 1 + i] = TRUE;
		vertex[r + cross - 1 + i][c] = TRUE;
		vertex[r + cross - 1 + i][c + size - 1] = TRUE;
		vertex[r + cross - 1][c + i] = TRUE;
		vertex[r + 2 * cross - 2][c + i] = TRUE;
		vertex[r + cross - 1][c + size - 1 - i] = TRUE;
		vertex[r + 2 * cross - 2][c + size - 1 - i] = TRUE;
		vertex[r + i][c + cross - 1] = TRUE;
		vertex[r + i][c + 2 * cross - 2] = TRUE;
		vertex[r + size - 1 - i][c + cross - 1] = TRUE;
		vertex[r + size - 1 - i][c + 2 * cross - 2] = TRUE;
		}
	Resize();
	DrawBoard();
}

void MorpionView::Resize()
{
	diff = boardSize / max_row;
}


void MorpionView::DrawBoard()
{
	int	r, c;
	
	this->SetDrawingMode(B_OP_COPY);
	this->SetHighColor(80, 200, 50, 0);
	this->FillRect(BRect(0, 0, boardSize, boardSize));
	for (r = 1; r <= max_row; r++)
		for (c = 1; c <= max_col; c++)
			DrawVertex(r, c);
	ShowMoves();
}

bool MorpionView::InRange(int r, int c)
{
	return (0 < r) && (r <= max_row) && (0 < c) && (c < max_col);
}

bool MorpionView::PointToCell(BPoint pt, int *r, int *c)
{
	*c = int((pt.x + diff / 2) / diff);
	*r = int((pt.y + diff / 2) / diff);
	return InRange(*r, *c);
}

void MorpionView::CellToPoint(int r, int c, BPoint *pt)
{
	pt->x = c * diff;
	pt->y = r * diff;
}

void MorpionView::DrawVertex(int r, int c)
{
	const int d = 2;
	int		i;
	BPoint	mid, current;
	
	this->SetHighColor(20, 120, 200, 0);	
	
	CellToPoint(r, c, &mid);
	this->MovePenTo(mid);
	current = mid;
	if (!vertex[r][c])
		this->StrokeLine(current);
	else {
		this->MovePenTo(current + BPoint(-d, -d));
		this->StrokeLine(current + BPoint(d, d));
		this->MovePenTo(current + BPoint(-d, d));
		this->StrokeLine(current + BPoint(d, -d));
		this->MovePenTo(current + BPoint(0, -d));
		this->StrokeLine(current + BPoint(0, d));
		this->MovePenTo(current + BPoint(-d, 0));
		this->StrokeLine(current + BPoint(d, 0));
		}
	for (i = 0; i < 8; i++) {
		if (edges[r][c] & (1 << i)) {
			this->MovePenTo(mid);
			this->StrokeLine(mid + BPoint(diff * dc[i], diff * dr[i]));
			}
		}
}

bool MorpionView::ValidLine(int r, int c, int d)
{
bool	good;
int		i, cnt;

	good = InRange(r, c);
	cnt = 0;
	i = 0;
	
	while (good && (i <= (len - 2))) {
		if (vertex[r][c]) cnt++;
		if (edges[r][c] & (1 << d))
			good = false;
		r += dr[d];
		c += dc[d];
		good = good && InRange(r, c);
		i++;
		}
	if (good)
		if (vertex[r][c]) cnt++;
	return (good && (cnt >= 4));
}

bool MorpionView::RandomChance(int n)
{
	if (n <= 1) return (true);
	else return (((random() & 0x7FFF) % n) == 0);
}

void MorpionView::TestDirection(int r, int c, int i, int *cnt, BPoint start)
{
	if ((vertex[r][c] || vertex[r + dr[i]][c + dc[i]]) && ValidLine(r, c, i)) {
		if (show) DLine(start, i);
		*cnt += 1;
		if (RandomChance(*cnt)) {
			mover = r;
			movec = c;
			moved = i;
			}
		}
}

void MorpionView::ShowMoves()
{
	BPoint	start;
	int		r, c, i, cnt;
	char	title[255];

	this->SetHighColor(220, 200, 40, 0);
	cnt = 0;
	for (r = 1; r <= max_row; r++)
		for (c = 1; c <= max_col; c++) {
			CellToPoint(r, c, &start);
			for (i = 0; i < 8; i++)
				TestDirection(r, c, i, &cnt, start);
			if ((r >= len) && (c <= (max_col - len + 1))) TestDirection(r, c, 1, &cnt, start);
			if (c <= (max_col - len + 1)) TestDirection(r, c, 2, &cnt, start);
			if ((r <= (max_row - len + 1)) && (c <= (max_col - len + 1))) TestDirection(r, c, 3, &cnt, start);
			if (r <= (max_row - len + 1)) TestDirection(r, c, 4, &cnt, start);
			}
	moves = cnt;
	finished = (moves == 0);
	if (show)
		sprintf(title, "Morpion:  Score= %d  Moves= %d", score, moves);
	else
		sprintf(title, "Morpion:  Score= %d", score);
	if (finished) {
		sprintf(title, "Finished:  (Score= %d  Moves= %d)", score, moves);
		beep();
		}
	myApplication.aWindow->SetTitle(title);
}

void MorpionView::ToggleShowMoves()
{
	show = !show;
	if (show) ShowMoves();
	else DrawBoard();
}

void MorpionView::AutoPlay()
{
	BPoint	location;
	uint32	button;

	this->GetMouse(&location, &button);
	while ((moves > 0) && !button) {
		DoLine(mover, movec, moved);
		this->GetMouse(&location, &button);
		}
}

void MorpionView::DLine(BPoint start, int dir)
{
	if (dir != -1) {
		this->MovePenTo(start);
		this->StrokeLine(start + BPoint(diff * (len - 1) * dc[dir], diff * (len - 1) * dr[dir]));
		}
}

void MorpionView::DoLine(int r, int c, int d)
{
	if (ValidLine(r, c, d)) {
		for (int i = 0; i < len - 1; i++) {
			vertex[r][c] = true;
			edges[r][c] |= (1 << d);
			edges[r + dr[d]][c + dc[d]] |= (1 << ((d +4) & 7));
			DrawVertex(r, c);
			r += dr[d];
			c += dc[d];
			}
		vertex[r][c] = true;
		DrawVertex(r, c);
		score++;
		if (show)
			DrawBoard();
		else
			ShowMoves();
		}
}

void MorpionView::DoMove(BPoint pt)
{
	BPoint	start, fin;
	bool	goods[8];
	int		r, c, d, i, cnt, mini, oldmini;
	float	dist, mindist;
	BPoint	location;
	uint32	button;

	if (PointToCell(pt, &r, &c)) {
		cnt = 0;
		for (i = 0; i < 8; i++) {
			goods[i] = ValidLine(r, c, i);
			if (goods[i]) cnt ++;
			}
		CellToPoint(r, c, &start);

		this->SetDrawingMode(B_OP_INVERT);
		this->SetHighColor(100, 100, 100, 0);

		oldmini = -1;
		this->GetMouse(&location, &button);
		while (button) {
			pt = location;
			mini = -1;
			mindist = 32767;
			fin = start - pt;
			dist = fin.x * fin.x + fin.y * fin.y;
			if (dist < (len * len * diff * diff * 3 / 2)) {
				for (i = 0; i < 8; i++) {
					if (goods[i]) {
						fin.x = pt.x - (start.x + dc[i] * diff * len * (3 - (i % 2)) / 3);
						fin.y = pt.y - (start.y + dr[i] * diff * len * (3 - (i % 2)) / 3);
						dist = fin.x * fin.x + fin.y * fin.y;
						if (dist < mindist) {
							mindist = dist;
							mini = i;
							}
						}
					}
				}
			if (oldmini != mini) {
					DLine(start, oldmini);
					DLine(start, mini);
					oldmini = mini;
					}
			this->GetMouse(&location, &button);
			}
		this->SetDrawingMode(B_OP_COPY);
		DLine(start, oldmini);

		if (oldmini != -1) {
			d = oldmini;
			while (true) {
				DoLine(r, c, d);
				r = mover;
				c = movec;
				d = moved;
				if (!automatic || (moves != 1)) break;
				}
			}
		}
}
