/*****************************************************************************

	Projet	: Droids

	Fichier	:	bCApplication.cpp
	Partie	: Loader

	Auteur	: RM
	Date		: 140297
	Format	: tabs==2

*****************************************************************************/

#include "machine.h"
#include "gCApplication.h"

#include "gCVideo.h"
#include "gCThread.h"
#include "gCMoteur.h"
#include "gCApplication.h"

#include "externs.h"

#include "Path.h"

//#define _INCLUDE_LICENSE

//---------------------------------------------------------------------------

CVideo				*gVideo					= NULL;
CThread				*gThreadMoteur	= NULL;
CMoteur				*gMoteur				= NULL;

//---------------------------------------------------------------------------


//***************************************************************************
CApplication::CApplication(void)
						 :BApplication("application/x-ralf-nerdkill")
#define inherited BApplication
//***************************************************************************
{
} // end of constructor for CApplication


//***************************************************************************
CApplication::~CApplication(void)
//***************************************************************************
{
	printf("CApplication::~CApplication -- destructor\n");
	// On demande a tout ce qui n'est pas NULL de se liberer
	if (gThreadMoteur)	delete gThreadMoteur;		// First, kill all tasks
	if (gMoteur)				delete gMoteur;					// Then close moteur
	if (gVideo)					delete gVideo;					// Then close video class
} // end of destructor for CApplication


//---------------------------------------------------------------------------


//***************************************************************************
void CApplication::AboutRequested(void)
//***************************************************************************
{
	BAlert *box;

	box = new BAlert(	"Nerdkill - About box",
										"\"Nerdkill\" for BeOS R3"
										"\n" B_UTF8_COPYRIGHT " R'alf"
										"\n\ndev release : 1.0.1 - January 1999"
										"\nFirst released at Paris'GeekFest 97"
										"\n\nContact : raphael.moll@capway.com"
										"\nand http://www.multimania.com/~ralf/beos"
										"\nGFX by \"Pulco\" and \"SpH\""
#ifndef _INCLUDE_LICENSE
										"\n\nThanks to UAE by Christian Bauer, "
										"\nAmiga's Nerdkill by Adam Girvin"
#else
										"\n\n"
										#include "license.h"
#endif
										,
										"    OK    ", NULL, NULL,
										B_WIDTH_FROM_WIDEST, B_INFO_ALERT);
	if (box)
	{
		box->Go();
		//delete box;
	}


} // end of AboutRequested for CApplication


//***************************************************************************
void CApplication::ReadyToRun(void)
//***************************************************************************
{
	printf("CApplication::ReadyToRun\n");

	//be_app->PostMessage(B_QUIT_REQUESTED);

	//AboutRequested();

} // end of ReadyToRun for CApplication


//***************************************************************************
BOOL CApplication::QuitRequested(void)
//***************************************************************************
{
	printf("CApplication::QuitRequested\n");

	printf("CApplication::QuitRequested -- arret moteur\n");
	if (gMoteur) gMoteur->arreter();
	printf("CApplication::QuitRequested -- attend fin thread\n");
	if (gThreadMoteur) gThreadMoteur->waitForEnd();
	printf("CApplication::QuitRequested -- apres fin thread\n");

	return BApplication::QuitRequested();	// accepte de mourrir

} // end of QuitRequested for CApplication


//***************************************************************************
void CApplication::MessageReceived(BMessage *msg)
//***************************************************************************
{
	switch(msg->what)
	{
		case K_GRAF_SPH:
			if (gVideo) gVideo->setSpriteMode(0);
			if (gMoteur) gMoteur->redrawArme();
			if (mGrafSph) mGrafSph->SetMarked(true);
			if (mGrafPulco) mGrafPulco->SetMarked(false);
			break;
		case K_GRAF_PULCO:
			if (gVideo) gVideo->setSpriteMode(1);
			if (gMoteur) gMoteur->redrawArme();
			if (mGrafPulco) mGrafPulco->SetMarked(true);
			if (mGrafSph) mGrafSph->SetMarked(false);
			break;
		case K_CALL_END:
			callEndAddOn(msg->FindInt32("nerd"),msg->FindInt32("shoot"));
			break;
		default:
			inherited::MessageReceived(msg);
	}
} // end of MessageReceived for CApplication



//***************************************************************************
void CApplication::callEndAddOn(long nerds, long shoots)
//***************************************************************************
{
#ifndef B_BEOS_VERSION_4
	try
	{
		BFile fichier;
		BEntry dummy;
		if (mDirAddOn.FindEntry("nerdkill_end", &dummy) < B_NO_ERROR) throw(0);
		//if (fichier.SetTo(&dummy, B_READ_ONLY) < B_NO_ERROR) return FALSE;
		//if (mDirAddOn.GetFile("nerdkill_end", &fichier) < B_NO_ERROR) throw(0);
		
		//image_id iid = load_add_on(&fichier);
		BPath path(&mDirAddOn,"nerdkill_end");
		printf("path for add on : %s\n", path.Path());
		
		image_id iid = load_add_on(path.Path());
		if (iid < B_NO_ERROR) throw(iid);
		
		// define function call prototype
		long (*end_func)(long n, long s);
		
		long err = get_image_symbol(iid, "nerdkill_end_game", B_SYMBOL_TYPE_TEXT, (void **)&end_func);
		if (err < B_NO_ERROR) throw(err);
		if (!end_func) throw(B_ERROR);

		//long retval = 
		(*end_func)(nerds, shoots);

		unload_add_on(iid);
	}
	catch(...)
#endif
	{
/*		BAlert *box = new BAlert("Nerdkill End",
														 "End ! All nerds blasted !"
														 "\n\nBTW, there is no \"nerdkill_end\" add-on"
														 "\nin the \"nerkill_addon\" directory !",
														 "   OK   ");
		if(box) box->Go();
*/
		if(1)
		{
			char s[512];
			BAlert *box;
			sprintf(s,
							"All nerds have been exterminated !"
							"\n\nGreat !"
							"\nBeside that, it tooks you only %ld shoots"
							"\nto kick these damned %ld nerds."
							"\n\nHey, Joe, you're a true geek !",
							shoots,
							nerds);
		
			box = new BAlert("Nerdkill End", s, "   OK   ");
			if (box) box->Go();
		}
	}
} // end of callEndAddOn for CApplication

//---------------------------------------------------------------------------


//***************************************************************************
BOOL CApplication::init(void)
//***************************************************************************
{
app_info info;
BEntry fichier,dummy;
BDirectory parent;
status_t result;

	//be_app->GetAppInfo(&info);
	//result=fichier.SetRef(info.ref);
	//if (!result) result=fichier.GetParent(&parent);
	//if (!result) result=parent.GetDirectory("nerdkill_addon", &mDirAddOn);
	//if (result) return FALSE;

	be_app->GetAppInfo(&info);
	result=fichier.SetTo(&info.ref);
	if (!result) result=fichier.GetParent(&parent);
	if (!result) result=parent.FindEntry("nerdkill_addon", &dummy);
	if (!result) result=mDirAddOn.SetTo(&dummy);
	if (result) return FALSE;

	mMainMenu = new BMenu("Nerdkill");
	if (!mMainMenu) return false;

	BMenuItem *item = new BMenuItem("About Nerdkill" B_UTF8_ELLIPSIS, new BMessage(B_ABOUT_REQUESTED));
	item->SetTarget(this);
	mMainMenu->AddItem(item);
	mMainMenu->AddSeparatorItem();
	mGrafSph = new BMenuItem("Grafx by SpH", new BMessage(K_GRAF_SPH), 'S');
	mGrafSph->SetMarked(true);
	mGrafSph->SetTarget(this);
	mGrafPulco = NULL;
	//mGrafPulco = new BMenuItem("Grafx by Pulco", new BMessage(K_GRAF_PULCO), 'P');
	//mGrafPulco->SetMarked(false);
	//mGrafPulco->SetTarget(this);
	mMainMenu->AddItem(mGrafSph);
	//mMainMenu->AddItem(mGrafPulco);
	mMainMenu->AddSeparatorItem();
	item =  new BMenuItem("Full Screen", new BMessage('GamK'));
	item->SetEnabled(false);
	mMainMenu->AddItem(item);
	item = new BMenuItem("Windowed Screen", new BMessage('WinK'));
	item->SetEnabled(false);
	item->SetMarked(true);
	mMainMenu->AddItem(item);
	mMainMenu->AddSeparatorItem();
	item = new BMenuItem("Quit Nerdkill", new BMessage(B_QUIT_REQUESTED), 'Q');
	item->SetTarget(this);
	mMainMenu->AddItem(item);
	//SetMainMenu(mMainMenu);

	printf("CApplication::init\n");
	gMoteur				= new CMoteur;
	gVideo				= new CVideo;
	gThreadMoteur	= new CThread;
	if(	 gVideo				== NULL
		|| gThreadMoteur== NULL
		|| gMoteur			== NULL)
		return FALSE;

	// Une fois qu'on est sur d'avoir les instances, on leur demande
	// d'essayer de faire les allocations dont elles ont besoin.
	if(!gVideo->init())				return FALSE;
	if(!gMoteur->init())			return FALSE;
	if(!gThreadMoteur->init())return FALSE;

	// HOOK RM TEST
	gThreadMoteur->launch(CMoteur::threadEntryPoint, THREAD_PRI_NORMAL);

	return TRUE;
} // end of init for CApplication


//***************************************************************************
void CApplication::run(void)
//***************************************************************************
{
	printf("CApplication::run\n");
	Run();
} // end of run for CApplication


//---------------------------------------------------------------------------

// eoc
