/*****************************************************************************

	Projet	: Droids

	Fichier	:	bCViewEcran.h
	Partie	: Video

	Auteur	: RM
	Date		: 110297
	Format	: tabs==2

*****************************************************************************/

#ifndef _H_BCVIEWECRAN_
#define _H_BCVIEWECRAN_


#include "machine.h"
#include "gCVideo.h"

//---------------------------------------------------------------------------


//*****************************
class CViewEcran : public BView
//*****************************
{
public:
	CViewEcran(bool main, BRect viewFrame, BRect blitFrame, char *titre);
	virtual ~CViewEcran(void);

	BOOL init(void);

	virtual void	MessageReceived(BMessage *msg);
	virtual	void	FrameResized(float new_width, float new_height);
	virtual void	AttachedToWindow(void);
	virtual	void	Draw(BRect updateRect);
	virtual	void	MouseDown(BPoint where);
	virtual	void	KeyDown(const char *bytes, int32 numBytes);
	virtual	void	MouseMoved(	BPoint where, uint32 code, const BMessage *a_message);
/*
	virtual	void			WindowActivated(bool state);
*/

	BOOL getVideoBase(UBYTE * &address, ULONG &length, ULONG &brp);

	void redraw(void) { Draw(mEcranBounds); }

	void setScroll(ULONG x, ULONG y);

	//void blitSpriteNoMask(ULONG x, ULONG y, SbSprite *sp);
	//void blitSpriteMask(ULONG x, ULONG y, SbSprite *sp);

//-----
protected:

	bool		mMain;
	BRect		mBounds;
	BRect		mEcranBounds;
	BBitmap *mEcran;
	double	mScrollX, mScrollY;

}; // end of class defs for CViewEcran


//---------------------------------------------------------------------------

#endif // of _H_BCVIEWECRAN_

// eoh
