/********************
*	gCInterface.cpp	*
*********************
*	Cross-Platform	*
********************/

#include "machine.h"

#include "gCVideo.h"
#include "gCThread.h"
#include "gCInterface.h"


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

extern CInterface *gInterface;
extern CVideo *gVideo;
extern CThread *gThread;

/************************************************************************/
/*************************  CIRect  *************************************/
/************************************************************************/

CIRect *CIRect::curFocus=NULL;

void CIRect::getFocus(void)
//*************************
{
	curFocus->looseFocus();
	curFocus=this;
}

void CIRect::looseFocus(void)
//***************************
{
	curFocus=NULL;
}

BOOL CIRect::isUnderCursor(ULONG x,ULONG y)
//*****************************************
{
	if(flag&RECTF_DISABLED)return FALSE;
	if(x<this->x)return FALSE;
	if(y<this->y)return FALSE;
	if(x>=(this->x+this->w))return FALSE;
	if(y>=(this->y+this->h))return FALSE;
	return TRUE;
}

/************************************************************************/
/*************************  CIButton  ***********************************/
/************************************************************************/

BOOL CIButton::init(ULONG x,ULONG y,ULONG w,ULONG h,ULONG id,ULONG flag,
/*********************/ ULONG status,ULONG spriteID,CHAR key)
//**********************************************************************
{
	this->x=x;
	this->y=y;
	this->w=w;
	this->h=h;
	this->id=id;
	this->flag=flag;
	this->status=status;
	this->spriteID=spriteID;
	this->key=key;
	return TRUE;
}

void CIButton::redraw(void)
//*************************
{
ULONG spriteOffset;
    if(flag&RECTF_DISABLED)spriteOffset=2;
    else if(flag&BUTF_DOWN)spriteOffset=1;
    else spriteOffset=0;
    gVideo->drawButton(x,y,spriteID+spriteOffset);
}

/************************************************************************/
/**************************  CIList  ************************************/
/************************************************************************/

BOOL CIList::init(ULONG x,ULONG y,ULONG w,ULONG h,ULONG id,
/****************/ ULONG flag,ULONG status)
//*****************************************
{
	this->x=x;
	this->y=y;
	this->w=w;
	this->h=h;
	this->id=id;
	this->flag=flag;
	this->status=status;
	firstItem=0;
	nbItem=0;
	nbLines=20;
	curItem=0;
	memset(data,0,sizeof(data));
	return TRUE;
}

void CIList::redraw(void)
//***********************
{
	return;
}

/************************************************************************/
/*************************  CInterface  *********************************/
/************************************************************************/

CInterface::CInterface()
//**********************
{
	nbButton=0;
	nbList=0;
	lastCommon=0;
	firstBut=0;
	lastBut=0;
	firstList=0;
	lastList=0;
	button=NULL;
	list=NULL;
}

CInterface::~CInterface()
//***********************
{
	if(button)delete [] button;
	if(list)delete [] list;
}

BOOL CInterface::init(void)
//************************
{
	button=new CIButton[MAX_NB_BUTTON];
	list=new CIList[MAX_NB_LIST];
	if(button==NULL || list==NULL)return FALSE;

	createLayout();

	return TRUE;
}

void CInterface::setPannel(ULONG id)
//**********************************
{
	return;
}

void CInterface::redraw(void)
//***************************
{
ULONG i;
	for(i=0;i<nbList;i++)list[i].redraw();
	for(i=0;i<nbButton;i++)button[i].redraw();
	return;
}

void CInterface::createLayout(void)
//*********************************
{
	nbButton=0;
	nbList=0;
	addButton(0,0,99,31,GID_PROGRAM,0,
		BUTF_CHECK|BUTF_NOTDOWN|BUTF_NOTUP,POSI_MENU_Program,'1');
	addButton(99,0,80,31,GID_PLAYER,0,
		BUTF_CHECK|BUTF_NOTDOWN|BUTF_NOTUP,POSI_MENU_Player,'2');
	addButton(179,0,78,31,GID_GAME,0,
		BUTF_CHECK|BUTF_NOTDOWN|BUTF_NOTUP,POSI_MENU_Game,'3');
	addButton(257,0,112,31,GID_NETWORK,RECTF_DISABLED,
		BUTF_CHECK|BUTF_NOTDOWN|BUTF_NOTUP,POSI_MENU_Network,'4');
	return;
}

void CInterface::addButton(ULONG x,ULONG y,ULONG w,ULONG h,ULONG id,
/***************/ ULONG flag,ULONG status,ULONG spriteID,CHAR key)
//*****************************************************************
{
	button[nbButton++].init(x,y,w,h,id,flag,status,spriteID,key);
	return;
}

void CInterface::addList(ULONG x,ULONG y,ULONG w,ULONG h,ULONG id,
/***************/ ULONG flag,ULONG status)
//****************************************
{
	list[nbList++].init(x,y,w,h,id,flag,status);
	return;
}

/* eof */