#include "FieldView.h"
//------------------------------------------------------------------------------
TFieldView::TFieldView(BRect xFrame) : BView(xFrame,"FieldView"
		,B_FOLLOW_ALL,B_WILL_DRAW | B_FRAME_EVENTS)
{
	srand((unsigned int)(clock()));
	SetViewColor(0,0,0,0);
	miGeneNo = 0;
	miMapPage = 0;
	CreateMapArray();
}
//------------------------------------------------------------------------------
TFieldView::~TFieldView()
{
	entry_ref	xRef;
	BEntry		xEntry;
	BPath		xPath;
	
	DestroyMapArray();
	mxOpenPanel->GetPanelDirectory(&xRef);
	xEntry.SetTo(&xRef);
	xEntry.GetPath(&xPath);
	strcpy(gxExitState->mszOPanelPath,xPath.Path());
	mxSavePanel->GetPanelDirectory(&xRef);
	xEntry.SetTo(&xRef);
	xEntry.GetPath(&xPath);
	strcpy(gxExitState->mszSPanelPath,xPath.Path());
	delete mxSavePanel;
	delete mxOpenPanel;
}
//------------------------------------------------------------------------------
void	TFieldView::AllAttached()
{
	mxCtrlView = (TCtrlView *)Parent()->Parent()->FindView("CtrlView");
}
//------------------------------------------------------------------------------
void TFieldView::AttachedToWindow()
{
	mxVBar = ScrollBar(B_VERTICAL);
	mxHBar = ScrollBar(B_HORIZONTAL);
	SetScrlBar();
	mxOpenPanel = new BFilePanel(B_OPEN_PANEL,new BMessenger(this),NULL,0,false
			,NULL,NULL,true);
	mxOpenPanel->SetPanelDirectory(gxExitState->mszOPanelPath);
	mxOpenPanel->SetButtonLabel(B_DEFAULT_BUTTON,gxLLMsg->mxButtonOpen.String());
	mxOpenPanel->SetButtonLabel(B_CANCEL_BUTTON,gxLLMsg->mxButtonCancel.String());
	mxOpenPanel->Window()->SetTitle(gxLLMsg->mxOPanelTitle.String());
	mxSavePanel = new BFilePanel(B_SAVE_PANEL,new BMessenger(this),NULL,0,false
			,NULL,NULL,true);
	mxSavePanel->SetPanelDirectory(gxExitState->mszSPanelPath);
	mxSavePanel->SetButtonLabel(B_DEFAULT_BUTTON,gxLLMsg->mxButtonSave.String());
	mxSavePanel->SetButtonLabel(B_CANCEL_BUTTON,gxLLMsg->mxButtonCancel.String());
	mxSavePanel->Window()->SetTitle(gxLLMsg->mxSPanelTitle.String());
}
//------------------------------------------------------------------------------
bool TFieldView::CreateMapArray()
{
	int		i,j,k;
	
	mcMap = new uchar** [2];
	for ( i = 0 ; i < 2 ; i++ ) {
		mcMap[i] = new uchar* [gxCustomSet->miXBlocks];
		for ( j = 0 ; j < gxCustomSet->miXBlocks ; j++ ) {
			mcMap[i][j] = new uchar [gxCustomSet->miYBlocks];
			for ( k = 0 ; k < gxCustomSet->miYBlocks ; k++ ) {
				mcMap[i][j][k] = 0;
			}
		}
	}
#ifdef DEBUGz
	mcMap[0][0][0] = mcMap[0][1][0] = mcMap[0][2][0] = mcMap[0][3][0] = mcMap[0][4][0] = 1;
	mcMap[0][15][7] = mcMap[0][14][8] = mcMap[0][15][8] = mcMap[0][16][8] = mcMap[0][15][9] = 1;
	mcMap[0][10][1] = mcMap[0][11][1] = mcMap[0][12][1] = 1;
#endif
	return true;
}
//------------------------------------------------------------------------------
void	TFieldView::CreateMapArrayRqtd()
{
	CreateMapArray();
}
//------------------------------------------------------------------------------
void TFieldView::DestroyMapArray()
{
	int	i,j;
	
	for ( i = 0 ; i < 2 ; i++ ) {
		for ( j = 0 ; j < gxCustomSet->miXBlocks ; j++ ) {
			delete[] mcMap[i][j];
		}
		delete[] mcMap[i];
	}
	delete[] mcMap;
}
//------------------------------------------------------------------------------
void	TFieldView::DestroyMapArrayRqtd()
{
	DestroyMapArray();
}
//------------------------------------------------------------------------------
void TFieldView::Draw(BRect xRect)
{
	DrawMap();
}
//------------------------------------------------------------------------------
void TFieldView::DrawMap()
{
	int		iXMin,iXMax;
	int		iYMin,iYMax;
	int		i,j;
	BRect	xRect;
	
	SetHighColor(gxCustomSet->mxLifeColor);
	SetLowColor(gxCustomSet->mxEmptyColor);
	SetDrawingMode(B_OP_COPY);
	iXMin = (int)mxHBar->Value()/gxCustomSet->miXBlockSize;
	iXMax = iXMin+(int)Frame().Width()/gxCustomSet->miXBlockSize+2;
	if ( iXMax > gxCustomSet->miXBlocks )
		iXMax = gxCustomSet->miXBlocks;
	iYMin = (int)mxVBar->Value()/gxCustomSet->miYBlockSize;
	iYMax = iYMin+(int)Frame().Height()/gxCustomSet->miYBlockSize+2;
	if ( iYMax > gxCustomSet->miYBlocks )
		iYMax = gxCustomSet->miYBlocks;
	for ( i = iXMin ; i < iXMax ; i++ ) {
		for ( j = iYMin ; j < iYMax ; j++ ) {
			xRect.Set(i*gxCustomSet->miXBlockSize,j*gxCustomSet->miYBlockSize
					,(i+1)*gxCustomSet->miXBlockSize,(j+1)*gxCustomSet->miYBlockSize);
			if ( mcMap[miMapPage][i][j] )
				FillRect(xRect);
			else
				FillRect(xRect,B_SOLID_LOW);
		}
	}
#if 0
	StrokeLine(BPoint(gxCustomSet->miXBlocks*gxCustomSet->miXBlockSize,0)
			,BPoint(gxCustomSet->miXBlocks*gxCustomSet->miXBlockSize
			,gxCustomSet->miYBlocks*gxCustomSet->miYBlockSize)
			,B_MIXED_COLORS);
	StrokeLine(BPoint(0,gxCustomSet->miYBlocks*gxCustomSet->miYBlockSize)
			,B_MIXED_COLORS);
	BAlert	*xAlert;
	xAlert = new BAlert("title",szArray
			,"OK",NULL,NULL,B_WIDTH_AS_USUAL,B_OFFSET_SPACING
			,B_WARNING_ALERT); 
	xAlert->Go();
#endif
}
//------------------------------------------------------------------------------
void	TFieldView::FieldDataFromClip()
{
//	char		*cData;
	const char	*cTmp;
	int			iWidth;
	int			a,b;
	int			i,j;
	BMessage	*xClipData;
	
	ShineField();
	if ( be_clipboard->Lock() ) {
		xClipData = be_clipboard->Data();
		if ( xClipData->FindString(BLFData,&cTmp) != B_OK )
			return;
		ShineField();
		iWidth = instr(cTmp,"\n")-1;
		if ( iWidth == 0 )
			iWidth = strlen(cTmp);
		a = (int)gxAppPrivacy->mxSelectedField.top+(signed int)strlen(cTmp)/(iWidth+1);
		b = (int)gxAppPrivacy->mxSelectedField.left+iWidth;
		for ( i = (int)gxAppPrivacy->mxSelectedField.top ; i < a ; i++ ) {
			for ( j = (int)gxAppPrivacy->mxSelectedField.left ; j < b ; j++ ) {
				mcMap[miMapPage][j%gxCustomSet->miXBlocks][i%gxCustomSet->miYBlocks]
						= cTmp[int((i-gxAppPrivacy->mxSelectedField.top)*(iWidth+1)
						+(j-gxAppPrivacy->mxSelectedField.left))]-'0';
			}
		}
		be_clipboard->Unlock();
		DrawMap();
	}
#if 0
	char		*cData;
	const char	*cTmp;
	int			iWidth;
	int			i,j;
	BMessage	*xClipData;
	
	ShineField();
	if ( be_clipboard->Lock() ) {
		xClipData = be_clipboard->Data();
		if ( xClipData->FindString(BLFData,&cTmp) != B_OK )
			return;
		ShineField();
		cData = new char [strlen(cTmp)+1];
		strcpy(cData,cTmp);
		be_clipboard->Unlock();
		iWidth = instr(cData,"\n")-1;
		if ( iWidth == 0 )
			iWidth = strlen(cData);
		for ( i = (int)gxAppPrivacy->mxSelectedField.top
				; i < (int)gxAppPrivacy->mxSelectedField.top+(signed int)strlen(cData)/(iWidth+1) ; i++ ) {
			for ( j = (int)gxAppPrivacy->mxSelectedField.left ; j < (int)gxAppPrivacy->mxSelectedField.left+iWidth ; j++ ) {
				mcMap[miMapPage][j%gxCustomSet->miXBlocks][i%gxCustomSet->miYBlocks]
						= cData[int((i-gxAppPrivacy->mxSelectedField.top)*(iWidth+1)
						+(j-gxAppPrivacy->mxSelectedField.left))]-'0';
			}
		}
		delete cData;
		DrawMap();
	}
#endif
}
//------------------------------------------------------------------------------
void	TFieldView::FieldDataToClip(bool bDelData)
{
	char		*cData;
	int			i,j;
	BMessage	*xClipData;
	
	ShineField();
	cData = new char [(gxAppPrivacy->mxSelectedField.right-gxAppPrivacy->mxSelectedField.left+2)
			*(gxAppPrivacy->mxSelectedField.bottom-gxAppPrivacy->mxSelectedField.top+1)+1];
	for ( i = (int)gxAppPrivacy->mxSelectedField.top ; i <= (int)gxAppPrivacy->mxSelectedField.bottom ; i++ ) {
		for ( j = (int)gxAppPrivacy->mxSelectedField.left ; j <= (int)gxAppPrivacy->mxSelectedField.right ; j++ ) {
			cData[int((i-gxAppPrivacy->mxSelectedField.top)
					*(gxAppPrivacy->mxSelectedField.right-gxAppPrivacy->mxSelectedField.left+2)
					+(j-gxAppPrivacy->mxSelectedField.left))] = mcMap[miMapPage][j][i]+'0';
			if ( bDelData )
				mcMap[miMapPage][j][i] = 0;
		}
		cData[int((i-gxAppPrivacy->mxSelectedField.top)
				*(gxAppPrivacy->mxSelectedField.right-gxAppPrivacy->mxSelectedField.left+2)
				+(gxAppPrivacy->mxSelectedField.right-gxAppPrivacy->mxSelectedField.left+1))] = '\n';
	}
	cData[int((gxAppPrivacy->mxSelectedField.right-gxAppPrivacy->mxSelectedField.left+2)
			*(gxAppPrivacy->mxSelectedField.bottom-gxAppPrivacy->mxSelectedField.top+1))] = '\0';
	if ( be_clipboard->Lock() ) {
		be_clipboard->Clear();
		xClipData = be_clipboard->Data();
		xClipData->AddString(BLFData,cData);
		be_clipboard->Commit();
		be_clipboard->Unlock();
	}
	delete cData;
	DrawMap();
}
//------------------------------------------------------------------------------
void	TFieldView::FrameResized(float fWidth,float fHeight)
{
	SetScrlBar();
}
//------------------------------------------------------------------------------
void	TFieldView::LoadBLMD1(TSHIFile &xFile)
{
	char		szTmp[(int)pow(10,MapBlockMaxFig)+FReadMarginLen];
	int			i,j;

	DestroyMapArray();
	xFile.ReadLine(szTmp,MapBlockMaxFig+FReadMarginLen);
	gxCustomSet->miXBlocks = atoi(szTmp);
	xFile.ReadLine(szTmp,MapBlockMaxFig+FReadMarginLen);
	gxCustomSet->miYBlocks = atoi(szTmp);
	CreateMapArray();
	for ( i = 0 ; i < gxCustomSet->miYBlocks ; i++ ) {
		xFile.ReadLine(szTmp,gxCustomSet->miXBlocks+FReadMarginLen);
		for ( j = 0 ; j < gxCustomSet->miXBlocks ; j++ ) {
			mcMap[miMapPage][j][i] = szTmp[j]-'0';
		}
	}
}
//------------------------------------------------------------------------------
void	TFieldView::LoadLife(TSHIFile &xFile)
{
	char		cPhase = ' ';
	char		szTrush[LifeFmtMaxLen+1];
	char		szTmp[LifeFmtMaxLen+1];
	int			iX,iY;		//ＢeなＬife座標に変換した後の座標
	int			i;
//	istrstream	xIn(szTmp,LifeFmtMaxLen);
	istrstream	*xIn;
	
	DestroyMapArray();
	CreateMapArray();
	while ( !xFile.Eof() ) {
		xFile.ReadLine(szTmp,LifeFmtMaxLen+1);
		if ( szTmp[0] == '#' ) {
			cPhase = szTmp[1];
			switch ( cPhase ) {
			case 'C':	//コメント
			case 'D':
				break;
			case 'P':	//生命体配置
				xIn = new istrstream(szTmp,LifeFmtMaxLen);
				*xIn >> szTrush >> iX >> iY;
				delete xIn;
				LoadLifeCvtCdn(iX,iY);
				break;
			}
			continue;
		}
		switch ( cPhase ) {
		case 'P':	//生命体配置
			for ( i = 0 ; i < (signed int)strlen(szTmp) ; i++ ) {
				mcMap[miMapPage][(iX+i)%gxCustomSet->miXBlocks][iY] = (szTmp[i] == '*');
			}
			iY = (iY+1)%gxCustomSet->miYBlocks;
			break;
		default:	//Life 1.03用生命体配置
			xIn = new istrstream(szTmp,LifeFmtMaxLen);
			*xIn >> iX >> iY;
			delete xIn;
			LoadLifeCvtCdn(iX,iY);
			mcMap[miMapPage][iX][iY] = 1;
		}
	}
}
//------------------------------------------------------------------------------
void	TFieldView::LoadLifeCvtCdn(int &iX,int &iY)
{
	iX += gxCustomSet->miXBlocks/2;
	if ( iX < 0 )
		iX += ((-iX-1)/gxCustomSet->miXBlocks+1)*gxCustomSet->miXBlocks;
	iX = iX%gxCustomSet->miXBlocks;
	iY += gxCustomSet->miYBlocks/2;
	if ( iY < 0 )
		iY += ((-iY-1)/gxCustomSet->miYBlocks+1)*gxCustomSet->miYBlocks;
	iY = iY%gxCustomSet->miYBlocks;
}
//------------------------------------------------------------------------------
void	TFieldView::ManageLife()
{
	int		iPrevXBlock = -1,iPrevYBlock = -1;
	int		iXBlock,iYBlock;
	uint32	iButtons;
	BPoint	xPoint;
	
	GetMouse(&xPoint,&iButtons);
	while ( iButtons & B_PRIMARY_MOUSE_BUTTON ) {
		iXBlock = int(xPoint.x)/gxCustomSet->miXBlockSize;
		iYBlock = int(xPoint.y)/gxCustomSet->miYBlockSize;
		if ( (iXBlock != iPrevXBlock || iYBlock != iPrevYBlock) && iXBlock >= 0
				&& iXBlock < gxCustomSet->miXBlocks && iYBlock >= 0 && iYBlock < gxCustomSet->miYBlocks ) {
			mcMap[miMapPage][iXBlock][iYBlock] ^= 1;
			DrawMap();
			iPrevXBlock = iXBlock;
			iPrevYBlock = iYBlock;
		}
		snooze(20*1000);
		GetMouse(&xPoint,&iButtons);
	}
}
//------------------------------------------------------------------------------
void	TFieldView::MenuCopyClicked()
{
	FieldDataToClip(false);
}
//------------------------------------------------------------------------------
void	TFieldView::MenuCutClicked()
{
	FieldDataToClip(true);
}
//------------------------------------------------------------------------------
void	TFieldView::MenuEnblocClicked()
{
	int			iEnblocNum;
	
	iEnblocNum = mxCtrlView->EnblocNum();
	if ( iEnblocNum <= 0 )	return;
//	Window()->PostMessage(DISABLECTRL_RQTD,mxCtrlView,this);
	StartGeneShift(iEnblocNum);
}
//------------------------------------------------------------------------------
void	TFieldView::MenuGoStopClicked()
{
	if ( gxAppPrivacy->mbGoing ) {
		StopGeneShift();
	}
	else {
		StartGeneShift(0);
	}		
}
//------------------------------------------------------------------------------
void	TFieldView::MenuNewClicked()
{
	char	szTmp[256];
	BAlert	*xAlert;
	
	strcpy(szTmp,AlertCaption());
	strcat(szTmp,gxLLMsg->mxNewConfirm.String());
	xAlert = new BAlert("Title",szTmp,gxLLMsg->mxButtonNo.String(),gxLLMsg->mxButtonYes.String()
			,NULL,B_WIDTH_AS_USUAL,B_OFFSET_SPACING,B_WARNING_ALERT);
	if ( xAlert->Go() == 0 )	return;
	DestroyMapArray();
	CreateMapArray();
	gxAppPrivacy->mbNewFile = true;
	DrawMap();
}
//------------------------------------------------------------------------------
void	TFieldView::MenuOpenClicked()
{
	mxOpenPanel->Show();
}
//------------------------------------------------------------------------------
void	TFieldView::MenuPasteClicked()
{
	FieldDataFromClip();
}
//------------------------------------------------------------------------------
void	TFieldView::MenuRandomClicked()
{
	int		iX,iY;
	int		i;
	
	for ( i = 0 ; i < gxCustomSet->miXBlocks*gxCustomSet->miYBlocks/5 ; i++ ) {
		iX = random()%gxCustomSet->miXBlocks;
		iY = random()%gxCustomSet->miYBlocks;
		mcMap[miMapPage][iX][iY] = 1;
	}
	DrawMap();
}
//------------------------------------------------------------------------------
void	TFieldView::MenuSaveClicked()
{
	char	szTmp[B_FILE_NAME_LENGTH+256];
	BAlert	*xAlert;
	BPath	xPath;
	
	if ( gxAppPrivacy->mbNewFile ) {
		mxSavePanel->Show();
	}
	else {
		strcpy(szTmp,AlertCaption());
		strcat(szTmp,gxLLMsg->mxOWConfirm.String());
		strcat(szTmp,"\n");
		gxAppPrivacy->mxCurrentEnt.GetPath(&xPath);
		strcat(szTmp,xPath.Path());
		xAlert = new BAlert("Title",szTmp,gxLLMsg->mxButtonNo.String(),gxLLMsg->mxButtonYes.String()
				,NULL,B_WIDTH_AS_USUAL,B_OFFSET_SPACING,B_WARNING_ALERT);
		if ( xAlert->Go() == 1 )
			SaveData(&gxAppPrivacy->mxCurrentEnt);
	}
}
//------------------------------------------------------------------------------
void	TFieldView::MenuSaveAsClicked()
{
	mxSavePanel->Show();
}
//------------------------------------------------------------------------------
void	TFieldView::MenuSelAllClicked()
{
	SetDrawingMode(B_OP_INVERT);
	gxAppPrivacy->mxSelectedField.left = 0;
	gxAppPrivacy->mxSelectedField.top = 0;
	gxAppPrivacy->mxSelectedField.right = gxCustomSet->miXBlocks-1;
	gxAppPrivacy->mxSelectedField.bottom = gxCustomSet->miYBlocks-1;
	StrokeRect(BRect(gxAppPrivacy->mxSelectedField.left*gxCustomSet->miXBlockSize
			,gxAppPrivacy->mxSelectedField.top*gxCustomSet->miYBlockSize
			,(gxAppPrivacy->mxSelectedField.right+1)*gxCustomSet->miXBlockSize
			,(gxAppPrivacy->mxSelectedField.bottom+1)*gxCustomSet->miYBlockSize));
}
//------------------------------------------------------------------------------
void	TFieldView::MenuStepClicked()
{
	BMessage	*xMsg;
	
	xMsg = new BMessage(DISABLECTRL_RQTD);
	be_app->DispatchMessage(xMsg,mxCtrlView);
	delete xMsg;
	StartGeneShift(1);
}
//------------------------------------------------------------------------------
void TFieldView::MessageReceived(BMessage *xMsg)
{
	entry_ref	xRef;
	
	switch ( xMsg->what ) {
	case B_REFS_RECEIVED:
		RefsReceived(xMsg);
		break;
	case B_SAVE_REQUESTED:
		SaveRequested(xMsg);
		break;
	case B_SIMPLE_DATA:
		if ( xMsg->FindRef("refs",&xRef) == B_OK )
			RefsReceived(xMsg);
		else
			BView::MessageReceived(xMsg);
		break;
	case CREATEMAPARRAY_RQTD:
		CreateMapArrayRqtd();
		break;
	case DESTROYMAPARRAY_RQTD:
		DestroyMapArrayRqtd();
		break;
	case B_COPY:
		MenuCopyClicked();
		break;
	case B_CUT:
		MenuCutClicked();
		break;
	case MENUENBLOC_CLICKED:
		MenuEnblocClicked();
		break;
	case MENUGOSTOP_CLICKED:
		MenuGoStopClicked();
		break;
	case MENUNEW_CLICKED:
		MenuNewClicked();
		break;
	case MENUOPEN_CLICKED:
		MenuOpenClicked();
		break;
	case B_PASTE:
		MenuPasteClicked();
		break;
	case MENURANDOM_CLICKED:
		MenuRandomClicked();
		break;
	case MENUSAVE_CLICKED:
		MenuSaveClicked();
		break;
	case MENUSAVEAS_CLICKED:
		MenuSaveAsClicked();
		break;
	case B_SELECT_ALL:
		MenuSelAllClicked();
		break;
	case MENUSTEP_CLICKED:
		MenuStepClicked();
		break;
	case REDRAWMAP_RQTD:
		RedrawMapRqtd();
		break;
	default:
		BView::MessageReceived(xMsg);
	}
}
//------------------------------------------------------------------------------
void	TFieldView::MouseDown(BPoint xPoint)
{
	uint32	iButtons;
	
	if ( gxAppPrivacy->mbGoing )	return;
	GetMouse(&xPoint,&iButtons);
	switch ( iButtons ) {
	case B_PRIMARY_MOUSE_BUTTON:
		ManageLife();
		break;
	case B_SECONDARY_MOUSE_BUTTON:
		SelectField();
		break;
	}
}
//------------------------------------------------------------------------------
void	TFieldView::NextGeneration()
{
	int		iLife;
	int		iNextMapPage;
	int		i,j,k,m;

//	LockLooper();	//DB
	iNextMapPage = miMapPage^1;
	for ( i = 0 ; i < gxCustomSet->miXBlocks ; i++ ) {
		for ( j = 0 ; j < gxCustomSet->miYBlocks ; j++ ) {
			iLife = 0;
			for ( k = i-1 ; k <= i+1 ; k++ ) {
				for ( m = j-1 ; m <= j+1 ; m++ ) {
					if ( k == i && m == j )	continue;
					if ( mcMap[miMapPage][(k+gxCustomSet->miXBlocks)%gxCustomSet->miXBlocks][(m+gxCustomSet->miYBlocks)%gxCustomSet->miYBlocks] )
						iLife += 1;
				}
			}
			switch ( iLife ) {
			case 2:
				mcMap[iNextMapPage][i][j] = mcMap[miMapPage][i][j];
				break;
			case 3:
				mcMap[iNextMapPage][i][j] = 1;
				break;
			default:
				mcMap[iNextMapPage][i][j] = 0;
			}
		}
	}
	miMapPage = iNextMapPage;
	miGeneNo++;
	if ( miGeneNo == miGeneLimit ) {
		StopGeneShift();
	}
//	UnlockLooper();	//DB
}
//------------------------------------------------------------------------------
void	TFieldView::OpenData(BEntry *xEntry)
{
	char		szTmp[strlen(FDFHeader)+FReadMarginLen];
	BPath		xPath;
	BString		xMsg;
	TSHIFile	xFile;

	xEntry->GetPath(&xPath);
	if ( xFile.SetTo(xEntry,B_READ_ONLY) != B_NO_ERROR ) {
		xMsg << gxLLMsg->mxNotOpenErr << "\n" << xPath.Path();
		AlertErr(xMsg);
		return;
	}
	xFile.ReadLine(szTmp,strlen(FDFHeader)+FReadMarginLen);
	if ( strcmp(szTmp,FDFHeader) == 0 ) {
		LoadBLMD1(xFile);
	}
	else if ( instr(szTmp,"#Life") > 0 ) {
		LoadLife(xFile);
	}
	else {
		xMsg << gxLLMsg->mxDiffeFmtErr << "\n" << xPath.Path();
		AlertErr(xMsg);
		return;
	}
	gxAppPrivacy->mbNewFile = false;
	gxAppPrivacy->mxCurrentEnt = *xEntry;
	RedrawMap();
}
//------------------------------------------------------------------------------
void	TFieldView::Pulse()
{
	NextGeneration();
	DrawMap();
}
//------------------------------------------------------------------------------
void	TFieldView::RedrawMap()
{
	Invalidate();
	DrawMap();
	SetScrlBar();
}
//------------------------------------------------------------------------------
void	TFieldView::RedrawMapRqtd()
{
	RedrawMap();
}
//------------------------------------------------------------------------------
void	TFieldView::RefsReceived(BMessage *xMsg)
{
//	char		szNPFName[B_FILE_NAME_LENGTH+4];
	entry_ref	xRef;
	BEntry		xEntry;
	
	if ( xMsg->FindRef("refs",&xRef) != B_OK )
		return;
#if 0
	if ( instr(xRef.name,FDFExt) != strlen(xRef.name)-strlen(FDFExt)+1 ) {
		strcpy(szNPFName,xRef.name);
		strcat(szNPFName,FDFExt);
		xRef.set_name(szNPFName);
	}
#endif
	StopGeneShift();
	if ( xEntry.SetTo(&xRef) == B_OK )
		OpenData(&xEntry);
}
//------------------------------------------------------------------------------
void	TFieldView::SaveData(BEntry *xEntry)
{
//	char		szFName[B_FILE_NAME_LENGTH];
//	char		szFormat[256];
	char		szMapData[(int)pow(10,MapBlockMaxFig)+FReadMarginLen];
	char		szTmp[B_FILE_NAME_LENGTH+100];
	int			i,j;
//	off_t		xSize;
//	BAlert		*xAlert;
	BPath		xPath;
	BString		xMsg;
	TSHIFile	xFile;

	xEntry->GetPath(&xPath);
	if ( xFile.SetTo(xEntry,B_WRITE_ONLY|B_CREATE_FILE) != B_NO_ERROR ) {
		xMsg << gxLLMsg->mxNotSaveErr << "\n" << xPath.Path();
		AlertErr(xMsg);
		return;
	}
	xFile.WriteLine(FDFHeader);
	sprintf(szTmp,"%d",gxCustomSet->miXBlocks);
	xFile.WriteLine(szTmp);
	sprintf(szTmp,"%d",gxCustomSet->miYBlocks);
	xFile.WriteLine(szTmp);
	for ( i = 0 ; i < gxCustomSet->miYBlocks ; i++ ) {
		for ( j = 0 ; j < gxCustomSet->miXBlocks ; j++ ) {
			szMapData[j] = mcMap[miMapPage][j][i]+'0';
		}
		szMapData[gxCustomSet->miXBlocks] = '\0';
		xFile.WriteLine(szMapData);
	}
	gxAppPrivacy->mbNewFile = false;
	gxAppPrivacy->mxCurrentEnt = *xEntry;
}
//------------------------------------------------------------------------------
void	TFieldView::SaveRequested(BMessage *xMsg)
{
	char		szNPFName[B_FILE_NAME_LENGTH+4];
	const char	*cTmp;
	entry_ref	xDirRef;
	BDirectory	xDir;
	BEntry		xEntry;
	
	xMsg->FindRef("directory",&xDirRef);
	xMsg->FindString("name",&cTmp);
	strcpy(szNPFName,cTmp);
	if ( instr(szNPFName,FDFExt) != strlen(szNPFName)-strlen(FDFExt)+1 ) {
		strcat(szNPFName,FDFExt);
	}
	xDir.SetTo(&xDirRef);
 	if ( xEntry.SetTo(&xDir,szNPFName) == B_OK ) {
		SaveData(&xEntry);
	}
#ifdef DEBUGz
	else {
		xAlert = new BAlert("title","Err"
				,"OK",NULL,NULL,B_WIDTH_AS_USUAL,B_OFFSET_SPACING
				,B_WARNING_ALERT); 
		xAlert->Go();
	}
#endif
}
//------------------------------------------------------------------------------
void	TFieldView::SelectField()
{
	float	fPrevX,fPrevY;
//	int		iXBlock,iYBlock;
	uint32	iButtons;
	BPoint	xPoint;
	
	DrawMap();
	SetDrawingMode(B_OP_INVERT);
	GetMouse(&xPoint,&iButtons);
	gxAppPrivacy->mxSelectedField.left = int(xPoint.x)/gxCustomSet->miXBlockSize;
	gxAppPrivacy->mxSelectedField.top = int(xPoint.y)/gxCustomSet->miYBlockSize;
	fPrevX = gxAppPrivacy->mxSelectedField.left*gxCustomSet->miXBlockSize;
	fPrevY = gxAppPrivacy->mxSelectedField.top*gxCustomSet->miYBlockSize;
//	StrokeRect(BRect(gxAppPrivacy->mxSelectedField.left*gxCustomSet->miXBlockSize
//			,gxAppPrivacy->mxSelectedField.top*gxCustomSet->miYBlockSize,fPrevX,fPrevY));
	while ( iButtons & B_SECONDARY_MOUSE_BUTTON ) {
		StrokeRect(BRect(gxAppPrivacy->mxSelectedField.left*gxCustomSet->miXBlockSize
				,gxAppPrivacy->mxSelectedField.top*gxCustomSet->miYBlockSize,fPrevX,fPrevY));
		StrokeRect(BRect(gxAppPrivacy->mxSelectedField.left*gxCustomSet->miXBlockSize
				,gxAppPrivacy->mxSelectedField.top*gxCustomSet->miYBlockSize,xPoint.x,xPoint.y));
		fPrevX = xPoint.x;
		fPrevY = xPoint.y;
		snooze(20*1000);
		GetMouse(&xPoint,&iButtons);
	}
	StrokeRect(BRect(gxAppPrivacy->mxSelectedField.left*gxCustomSet->miXBlockSize
			,gxAppPrivacy->mxSelectedField.top*gxCustomSet->miYBlockSize,fPrevX,fPrevY));
	gxAppPrivacy->mxSelectedField.right = int(xPoint.x)/gxCustomSet->miXBlockSize;
	gxAppPrivacy->mxSelectedField.bottom = int(xPoint.y)/gxCustomSet->miYBlockSize;
	if ( gxAppPrivacy->mxSelectedField.left > gxAppPrivacy->mxSelectedField.right )
		Swap(gxAppPrivacy->mxSelectedField.left,gxAppPrivacy->mxSelectedField.right);
	if ( gxAppPrivacy->mxSelectedField.top > gxAppPrivacy->mxSelectedField.bottom )
		Swap(gxAppPrivacy->mxSelectedField.top,gxAppPrivacy->mxSelectedField.bottom);
	if ( gxAppPrivacy->mxSelectedField.left < 0 )
		gxAppPrivacy->mxSelectedField.left = 0;
	if ( gxAppPrivacy->mxSelectedField.right >= gxCustomSet->miXBlocks )
		gxAppPrivacy->mxSelectedField.right = gxCustomSet->miXBlocks-1;
	if ( gxAppPrivacy->mxSelectedField.top < 0 )
		gxAppPrivacy->mxSelectedField.top = 0;
	if ( gxAppPrivacy->mxSelectedField.bottom >= gxCustomSet->miYBlocks )
		gxAppPrivacy->mxSelectedField.bottom = gxCustomSet->miYBlocks-1;
	StrokeRect(BRect(gxAppPrivacy->mxSelectedField.left*gxCustomSet->miXBlockSize
			,gxAppPrivacy->mxSelectedField.top*gxCustomSet->miYBlockSize
			,(gxAppPrivacy->mxSelectedField.right+1)*gxCustomSet->miXBlockSize
			,(gxAppPrivacy->mxSelectedField.bottom+1)*gxCustomSet->miYBlockSize));
}
//------------------------------------------------------------------------------
void TFieldView::SetScrlBar()
{
	float		fHMax,fVMax;
	float		fViewHeight,fViewWidth;
	
	fViewWidth = Frame().Width();
	fViewHeight = Frame().Height();
	fHMax = gxCustomSet->miXBlocks*gxCustomSet->miXBlockSize - fViewWidth;
	if ( fHMax < 0 )
		fHMax = 0;
	fVMax = gxCustomSet->miYBlocks*gxCustomSet->miYBlockSize - fViewHeight;
	if ( fVMax < 0 )
		fVMax = 0;
	mxHBar->SetRange(0,fHMax);
	mxHBar->SetProportion(fViewWidth/(gxCustomSet->miXBlocks*gxCustomSet->miXBlockSize));
	mxVBar->SetRange(0,fVMax);
	mxVBar->SetProportion(fViewHeight/(gxCustomSet->miYBlocks*gxCustomSet->miYBlockSize));
}
//------------------------------------------------------------------------------
void	TFieldView::ShineField()
{
	int		i;
	BRect	xRect;
	
	SetDrawingMode(B_OP_INVERT);
	xRect.Set(gxAppPrivacy->mxSelectedField.left*gxCustomSet->miXBlockSize
			,gxAppPrivacy->mxSelectedField.top*gxCustomSet->miYBlockSize
			,(gxAppPrivacy->mxSelectedField.right+1)*gxCustomSet->miXBlockSize
			,(gxAppPrivacy->mxSelectedField.bottom+1)*gxCustomSet->miYBlockSize);
	for ( i = 0 ; i < 4 ; i++ ) {
		FillRect(xRect);
		Window()->UpdateIfNeeded();
		snooze(25*1000);
	}
}
//------------------------------------------------------------------------------
void TFieldView::StartGeneShift(int iGenes)
{
	BMessage	*xMsg;
	
	xMsg = new BMessage(DISABLECTRL_RQTD);
	be_app->DispatchMessage(xMsg,mxCtrlView);
	delete xMsg;
	gxAppPrivacy->mbGoing = true;
	if ( iGenes == 0 )
		miGeneLimit = 0;
	else
		miGeneLimit = miGeneNo+iGenes;
	Window()->SetPulseRate(gxCustomSet->miInterval*1000);
	SetFlags(Flags()|B_PULSE_NEEDED);
	NextGeneration();
	DrawMap();
}
//------------------------------------------------------------------------------
void TFieldView::StopGeneShift()
{
	BMessage	*xMsg;
	
	gxAppPrivacy->mbGoing = false;
	SetFlags(Flags()&~B_PULSE_NEEDED);
	xMsg = new BMessage(ENABLECTRL_RQTD);
	be_app->DispatchMessage(xMsg,mxCtrlView);
	delete xMsg;
	xMsg = new BMessage(CHANGEMBARSTATE_RQTD);
	be_app->DispatchMessage(xMsg,Window());
	delete xMsg;
}
//------------------------------------------------------------------------------
void	TFieldView::TargetedByScrollView(BScrollView *xScrlView)
{
}
//------------------------------------------------------------------------------
/*
	BAlert	*xAlert;
	xAlert = new BAlert("Title","Field : "
			,"OK",NULL,NULL,B_WIDTH_AS_USUAL,B_OFFSET_SPACING
			,B_WARNING_ALERT); 
	xAlert->Go();
*/
