//Name:		NumberAndBlockViews.cpp
//Author:	Brian Tietz
//Copyright 1999
//Conventions:
//	Global constants (declared with const) and #defines - begin with "c_" followed by lowercase
//		words separated by underscores.
//		(E.G., #define c_my_constant 5).
//		(E.G., const int c_my_constant = 5;).
//	Global variables - begin with "g_" followed by lowercase words separated by underscores.
//		(E.G., int g_my_global;).
//	New data types (classes, structs, typedefs, etc.) - begin with an uppercase letter followed by
//		lowercase words separated by uppercase letters.  Enumerated constants contain a prefix
//		associating them with a particular enumerated set.
//		(E.G., typedef int MyTypedef;).
//		(E.G., enum MyEnumConst {c_mec_one, c_mec_two};)
//	Private member variables - begin with "m_" followed by lowercase words separated by underscores.
//		(E.G., int m_my_member;).
//	Public or friend-accessible member variables - all lowercase words separated by underscores.
//		(E.G., int public_member;).
//	Argument and local variables - begin with a lowercase letter followed by
//		lowercase words separated by underscores.  If the name is already taken by a public member
//		variable, prefix with a_ or l_
//		(E.G., int my_local; int a_my_arg, int l_my_local).
//	Functions (member or global) - begin with an uppercase letter followed by lowercase words
//		separated by uppercase letters.
//		(E.G., void MyFunction(void);).
//License:
//  Obviously, the idea for Tetris isn't mine, so I hold no copyright on the idea.  I do, however,
//  reserve all rights with regard to the source code for this BeOS version of Tetris.  The executable,
//  is freely distributable.  The source code is likewise freely distributable, provided that the
//  license and copyright are retained in these source code files and in the about box of the
//  executable.


//******************************************************************************************************
//**** System header files
//******************************************************************************************************
#include <stdio.h>
#include <Bitmap.h>


//******************************************************************************************************
//**** Project header files
//******************************************************************************************************
#include "NumberAndBlockViews.h"
#include "TetrisResources.h"
#include "Colors.h"


//******************************************************************************************************
//**** Constants
//******************************************************************************************************
#if defined(__POWERPC__)
	//PPC: Big endian
	const int c_rgb_black = 0x000000FF;		//Black, alpha=255
#elif defined(__INTEL__)
	//INTEL: Little endian
	const int c_rgb_black = 0xFF000000;		//Black, alpha=255
#endif


//******************************************************************************************************
//**** NumberView
//******************************************************************************************************
NumberView::NumberView(BRect frame, const BFont* font)
: DeepBevelView(frame,NULL,B_FOLLOW_LEFT|B_FOLLOW_TOP,B_WILL_DRAW)
{
	m_number = 0;
	SetFont(font);
	struct font_height font_ht;
	font->GetHeight(&font_ht);
	m_font_ascent = ceil(font_ht.ascent);
	SetViewColor(Black);
	SetLowColor(Black);
}


void NumberView::SetNumber(int32 number)
{
	m_number = number;
	Invalidate();
}


void NumberView::Draw(BRect update_rect)
{
	DeepBevelView::Draw(update_rect);
	char number_buffer[12];
	SetHighColor(White);
	sprintf(number_buffer,"%d",m_number);
	DrawString(number_buffer,BPoint(5,2+m_font_ascent));
}


//******************************************************************************************************
//**** NextBlockView
//******************************************************************************************************
NextBlockView::NextBlockView(BRect frame)
: DeepBevelView(frame,NULL,B_FOLLOW_LEFT|B_FOLLOW_TOP,B_WILL_DRAW)
{
	SetViewColor(Black);
	m_bitmap = new BBitmap(BRect(0,0,47,63),B_RGB32);
	m_bitmap_data = (uint32*)m_bitmap->Bits();
	for(int i=0; i<48*64; i++)
		m_bitmap_data[i] = c_rgb_black;
	float x = floor((frame.Width()-48)/2);
	float y = floor((frame.Height()-64)/2);
	m_bitmap_rect.Set(x,y,x+47,y+63);
}


NextBlockView::~NextBlockView()
{
	delete m_bitmap;
}


void NextBlockView::SetType(uint8 type)
{
	for(int i=0; i<48*64; i++)
		m_bitmap_data[i] = c_rgb_black;
	if(type < 1)
		return;
	int x_min=3;
	int y_min=3;
	int x_max=0;
	int y_max=0;
	int x,y;
	for(x=0; x<4; x++)
		for(y=0; y<4; y++)
			if(g_blocks[type-1].data[0][x][y])
			{
				if(x_min > x)
					x_min = x;
				if(x_max < x)
					x_max = x;
				if(y_min > y)
					y_min = y;
				if(y_max < y)
					y_max = y;
			}
	int x_offset = (48-(x_max-x_min+1)*16)/2;
	int y_offset = (64-(y_max-y_min+1)*16)/2;
	for(y=y_min; y<=y_max; y++)
		for(int y2=0; y2<16; y2++)
			for(x=x_min; x<=x_max; x++)
				if(g_blocks[type-1].data[0][x][y])
					for(int x2=0; x2<16; x2++)
						m_bitmap_data[y_offset*48 + (y-y_min)*48*16 + y2*48 +
							x_offset + (x-x_min)*16 + x2] = g_blocks[type-1].bitmap_data[x2][y2];
	Invalidate();
}


void NextBlockView::Draw(BRect update_rect)
{
	DeepBevelView::Draw(update_rect);
	if(update_rect.Intersects(m_bitmap_rect))
		DrawBitmap(m_bitmap,m_bitmap_rect.LeftTop());
}

