//Name:		TetrisPrefs.cpp
//Author:	Brian Tietz
//Copyright 1999
//Conventions:
//	Global constants (declared with const) and #defines - begin with "c_" followed by lowercase
//		words separated by underscores.
//		(E.G., #define c_my_constant 5).
//		(E.G., const int c_my_constant = 5;).
//	Global variables - begin with "g_" followed by lowercase words separated by underscores.
//		(E.G., int g_my_global;).
//	New data types (classes, structs, typedefs, etc.) - begin with an uppercase letter followed by
//		lowercase words separated by uppercase letters.  Enumerated constants contain a prefix
//		associating them with a particular enumerated set.
//		(E.G., typedef int MyTypedef;).
//		(E.G., enum MyEnumConst {c_mec_one, c_mec_two};)
//	Private member variables - begin with "m_" followed by lowercase words separated by underscores.
//		(E.G., int m_my_member;).
//	Public or friend-accessible member variables - all lowercase words separated by underscores.
//		(E.G., int public_member;).
//	Argument and local variables - begin with a lowercase letter followed by
//		lowercase words separated by underscores.  If the name is already taken by a public member
//		variable, prefix with a_ or l_
//		(E.G., int my_local; int a_my_arg, int l_my_local).
//	Functions (member or global) - begin with an uppercase letter followed by lowercase words
//		separated by uppercase letters.
//		(E.G., void MyFunction(void);).
//License:
//  Obviously, the idea for Tetris isn't mine, so I hold no copyright on the idea.  I do, however,
//  reserve all rights with regard to the source code for this BeOS version of Tetris.  The executable,
//  is freely distributable.  The source code is likewise freely distributable, provided that the
//  license and copyright are retained in these source code files and in the about box of the
//  executable.


//******************************************************************************************************
//**** System header files
//******************************************************************************************************
#include <Alert.h>


//******************************************************************************************************
//**** Project header files
//******************************************************************************************************
#include "TetrisPrefs.h"
#include "TetrisResources.h"
#include "Tetris.h"

//Libprefs
#define P_IMPEXP
#include "Preferences.h"


//******************************************************************************************************
//**** TetrisPrefs
//******************************************************************************************************
TetrisPrefs::TetrisPrefs()
{
	m_libprefs_prefs = new Preferences(&c_tetris_sig[12]),
	m_libprefs_prefs_set = new PreferenceSet(*m_libprefs_prefs,"TetrisSettings",true);
	m_init_ok = (!m_libprefs_prefs->InitCheck()) && (!m_libprefs_prefs_set->InitCheck());

	const void* void_data;
	ssize_t data_size;
	uint32 data_type;
	#define READSETTING(label,B_type,target,cpp_type) \
		if(m_libprefs_prefs_set->GetData(label,void_data,data_size,data_type) == B_NO_ERROR) \
			if(data_type == B_type) target = *((cpp_type*)void_data);

	m_window_position.Set(100,100,670,510);
	READSETTING("WindowPosition",B_RECT_TYPE,m_window_position,BRect);
}


TetrisPrefs::~TetrisPrefs()
{
	bool ok = true;

	#define WRITESETTING(label,B_type,target,cpp_type) \
		if(m_libprefs_prefs_set->SetData(label,&target,sizeof(cpp_type),B_type) != B_NO_ERROR) \
			ok = false;

	WRITESETTING("WindowPosition",B_RECT_TYPE,m_window_position,BRect);

	if(m_libprefs_prefs_set->Save() != B_NO_ERROR)
		ok = false;

	if(!ok)
	{
		BAlert *alert = new BAlert(NULL,g_save_prefs_fail_string,g_quit_string,NULL,
			NULL,B_WIDTH_FROM_WIDEST,B_OFFSET_SPACING,B_STOP_ALERT);
		alert->Go();
	}

 	delete m_libprefs_prefs_set;
	delete m_libprefs_prefs;
}
