
#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <Entry.h>
#include <MediaDefs.h>
#include <Sound.h>
#include <SoundPlayer.h>

#include "BD4Sound.h"

#define BDSOUND_HACK_NUM 25
int bdsound_hack_valid=0;
BSound **bdsound_hack_sample;
BSoundPlayer *bdsound_hack_player[BDSOUND_HACK_NUM];

static struct {
  int playtimes;
  double volume;
  char *name;
} config[BDSOUND_HACK_NUM];

extern "C" {char *getbasepath(int);}

int bdsound_hack_init() {
  static int init=0;
  char s[BUFSIZ];
  int i;
  FILE *fp=NULL;

  if(init)return(0);
  init=1;
  cout << "Initialising sound." << endl;


  if((bdsound_hack_sample = new (BSound *)[BDSOUND_HACK_NUM])==NULL) {
    return(0);
  }

  for(i=0;i<BDSOUND_HACK_NUM;i++) {
    bdsound_hack_player[i] = NULL;
    bdsound_hack_sample[i] = NULL;
    config[i].playtimes=1;
    config[i].volume=1.0;
    config[i].name = NULL;
  }

  sprintf(s,"%s/data/samples/config",getbasepath(0));
  if((fp=fopen(s,"r"))!=NULL) {
    int index,play;
    double volume;
    char filename[BUFSIZ];
    fprintf(stdout,"Reading configuration file data/samples/config...\n");
    while(fscanf(fp,"%d %d %lf %s",&index,&play,&volume,filename)==4) {
      if(index>=0 && index<BDSOUND_HACK_NUM && play<100 &&
         volume>=0.0 && volume<=10.0) {
        config[index].playtimes=play;
        config[index].volume=volume;
        config[index].name=strdup(filename);
        strcpy(config[index].name,filename);
      }
    }
    fclose(fp);
  }

  for(i=0;i<BDSOUND_HACK_NUM;i++) {
    entry_ref ref;
    char s[BUFSIZ];
    if(config[i].name)sprintf(s,"data/samples/%s",config[i].name);
    else sprintf(s,"data/samples/%d",i);
    BEntry entry(s, true);

    // make sure there is a sound there
    if (entry.InitCheck() == B_OK) {
      // get the reference id
    //cerr << "ok1." << endl;
      if (entry.GetRef(&ref) == B_OK) {
    //cerr << "Sample " << i << " (" << s << ") loading." << endl;
        bdsound_hack_sample[i] = new BSound(&ref);
      } else {
    //cerr << "FAILED."  << i << endl;
      }
    } else {
    //cerr << "entry check FAILED."  << i << endl;
    }
  }

  fprintf(stdout,"Loading samples...\n");
  for(i=0;i<BDSOUND_HACK_NUM;i++) {
    if (bdsound_hack_sample[i]) {
      if(bdsound_hack_sample[i]->InitCheck() == B_OK) {
        bdsound_hack_player[i] = new BSoundPlayer(&(bdsound_hack_sample[i]->Format()), "BD4 Hack");
        bdsound_hack_player[i]->Start();
        //bdsound_hack_player[i]->SetVolume(0.3);
        //fprintf(stdout,"  %d %s, ",i,(config[i].name)?config[i].name:"");
      } else {
        fprintf(stdout,"FAILED to load %d. %s\n",i,(config[i].name)?config[i].name:"");
        while(bdsound_hack_sample[i]->RefCount()>0) {
          bdsound_hack_sample[i]->ReleaseRef();
        }
        bdsound_hack_sample[i]=NULL;
      }
    } else {
        fprintf(stdout,"FAILED to load %d. %s\n",i,(config[i].name)?config[i].name:"");
    }
  }
  bdsound_hack_valid=1;
  return 1;
}

int bdsound_hack_play(int index,double volume) {
  //cerr << "Trying: " << index << "  at volume: " << volume << endl;
  if(!bdsound_hack_sample[index])return(0);
  if(!bdsound_hack_valid)return(0);
  if(index>BDSOUND_HACK_NUM || index<0)return(0);
  if(volume<0.0)return(0);

  //cerr << "Playing sound." << endl;

  bdsound_hack_player[index]->SetVolume(config[index].volume*volume);
  for(int i=0;i<config[index].playtimes;i++)
    (void)bdsound_hack_player[index]->StartPlaying(bdsound_hack_sample[index]);
  //cerr << bdsound_hack_player[index]->StartPlaying(bdsound_hack_sample[index]);
  //cerr << endl;
  return(1);
}

int bdsound_hack_playpersistent(int index,double volume,int hackid) {
  static int foo[6] = {0,0,0,0,0,0};
  //cerr << "Trying: " << index << "  at volume: " << volume << endl;
  if(!bdsound_hack_sample[index])return(0);
  if(!bdsound_hack_valid)return(0);
  if(index>BDSOUND_HACK_NUM || index<0)return(0);

  //cerr << "Playing sound." << endl;

  bdsound_hack_player[index]->SetVolume(config[index].volume*volume);

  /* If it's finished restart it */
  if(foo[hackid]>0 && !(bdsound_hack_player[index]->IsPlaying(foo[hackid]))) {
    foo[hackid]=0;
  }
  
  if(foo[hackid]==0) {
    foo[hackid]=bdsound_hack_player[index]->StartPlaying(bdsound_hack_sample[index]);
   }

  return(1);
}

void bdsound_hack_mute() {
  for(int i=0;i<BDSOUND_HACK_NUM;i++)if(bdsound_hack_player[i]) {
    bdsound_hack_player[i]->SetVolume(0.0);
  }
}

int bdsound_hack_quit() {
  if(!bdsound_hack_valid)return(-1);
  cerr << "Quitting sound." << endl;

  for(int i=0;i<BDSOUND_HACK_NUM;i++) {
    if(bdsound_hack_player[i]) {
      bdsound_hack_player[i]->Stop();
      delete bdsound_hack_player[i];
    }
    if(bdsound_hack_sample[i]) {
      while(bdsound_hack_sample[i]->RefCount()>0) {
        bdsound_hack_sample[i]->ReleaseRef();
      }
    }
    //delete bdsound_hack_sample[i];
  }
  delete [] bdsound_hack_sample;
  bdsound_hack_valid=0;
  return(0);
  
}
