	section .text

SRC_ADDR	EQU 16
SRC_WIDTH	EQU	20
SRC_HEIGHT	EQU 24
SRC_SKIP	EQU 28
DST_ADDR	EQU 32
DST_SKIP	EQU 36

	global stretchby2_mmx
stretchby2_mmx:
		; eax - unbenutzt
		; ebx - Dest_Width + Dest_Skip
		; ecx - Source_Width / 4 (counter)
		; edx - Source_Height (counter)
		; esi - SRC_ADDR
		; edi - DST_ADDR
		
		push		edi						; Put EDI on Stack
		push		esi						; Put ESI on Stack
		push		ebx						; Put EBX on Stack

		mov			esi,[esp+SRC_ADDR]		; Source Address
		mov			edx,[esp+SRC_HEIGHT]	; Source Height
		mov			edi,[esp+DST_ADDR]		; Destination Address

		mov			ebx,[esp+SRC_WIDTH]		; Source Width to EBX
		add			ebx,ebx					; Double Source Width -> Dest. Width
        add			ebx,[esp+DST_SKIP]		; Add Destination Skip

		; Double line in horizontal and vertical direction

.L2:  
		mov			ecx,[esp+SRC_WIDTH]		; Source Width
		shr			ecx,4					; Source Width / 16

.L1:
        movq		mm0,[esi]				; Get 8 pixels into mm0
        movq		mm2,[esi+8]
        mov			eax,[edi]
        movq		mm1,mm0
		punpcklbw	mm0,mm0					; 0xAABBCCDDEEFFGGHH -> 0xEEEEFFFFGGGGHHHH
        add			esi,byte 16				; Next Position in Source
        punpckhbw	mm1,mm1					; 0xAABBCCDDEEFFGGHH -> 0xAAAABBBBCCCCDDDD
		movq		mm3,mm2
		punpcklbw	mm2,mm2					; 0xAABBCCDDEEFFGGHH -> 0xEEEEFFFFGGGGHHHH
		punpckhbw	mm3,mm3					; 0xAABBCCDDEEFFGGHH -> 0xAAAABBBBCCCCDDDD
		movq		[edi],mm0				; Put 8 pixels
		movq		[edi+8],mm1
		movq		[edi+16],mm2				; Put 8 pixels
		movq		[edi+24],mm3
		movq		[edi+ebx],mm0			; Put 8 pixels into next line
		movq		[edi+ebx+8],mm1
		movq		[edi+ebx+16],mm2			; Put 8 pixels into next line
		movq		[edi+ebx+24],mm3
		add			edi,byte 32				; Next Destination Position

		dec			ecx						; Decrease Counter
		jnz			.L1						; Repeat

		add			edi,ebx					; Add Destination_Skip + Destination_Width
		add			edi,[esp+DST_SKIP]		; Add Destination-Skip

		add			esi,[esp+SRC_SKIP]		; Add Source-Skip

		dec			edx						; Subtract Height Counter
		jnz			.L2						; Repeat

		emms

		pop			ebx
		pop			esi						; Get old EBX/ESI/EDI from stack
		pop			edi
		ret
