/******************************************************************************/
/* APChannel header file.                                                     */
/******************************************************************************/
/* This is part of the APlayer Programming Package (APPP).                    */
/* Copyright (C) 1998-1999 by The APlayer-Team.                               */
/* All rights reserved.                                                       */
/*                                                                            */
/* This source, or parts thereof, may only be used in APlayer related         */
/* software. If you want to use it elsewhere, please contact the author for a */
/* permission.                                                                */
/******************************************************************************/


#ifndef __APChannel_h
#define __APChannel_h

// APlayer headers
#include "APlayerClasses_Import.h"


/******************************************************************************/
/* Useful constants                                                           */
/******************************************************************************/
enum AP_LoopType {APLOOP_Normal, APLOOP_PingPong};

// Panning values
#define APPAN_LEFT			0
#define APPAN_CENTER		128
#define APPAN_RIGHT			255
#define APPAN_SURROUND		512


/******************************************************************************/
/* APChannel class                                                            */
/******************************************************************************/
#if __p_os == __p_beos && __POWERPC__
#pragma export on
#endif

class _IMPEXP_APLIB APChannel
{
public:
	APChannel(void);
	virtual ~APChannel(void);

	void SetBuffer(const void *adr, uint32 length);
	void PlaySample(const void *adr, uint32 startOffset, uint32 length, uint8 bit = 8);
	void SetLoop(uint32 startOffset, uint32 length, AP_LoopType type = APLOOP_Normal);
	void SetLoop(const void *adr, uint32 startOffset, uint32 length, AP_LoopType type = APLOOP_Normal);
	void SetVolume(uint16 vol);
	void SetPanning(uint16 pan);
	void SetFrequency(uint32 freq);
	void SetAmigaPeriod(uint32 period);

	bool IsActive(void);
	void Mute(void);

protected:
	uint32	flags;
	const void *sampAddress;	// Start address of the sample
	uint32	sampStart;			// Start offset in the sample in samples, not bytes
	uint32	sampLength;			// Length of the sample in samples, not bytes
	uint32	loopStart;			// Loop offset in the sample in samples, not bytes
	uint32	loopLength;			// Loop length in samples, not bytes
	uint32	frequency;			// The frequency to play with
	uint16	volume;				// The volume (0-256)
	uint16	panning;			// The panning (0 = left; 128 = middle; 255 = right, 512 = Surround)
};

#if __p_os == __p_beos && __POWERPC__
#pragma export off
#endif

#endif
