/******************************************************************************/
/* APlayer add-on import/export functions.                                    */
/******************************************************************************/
/* This is part of the APlayer Programming Package (APPP).                    */
/* Copyright (C) 1998-1999 by The APlayer-Team.                               */
/* All rights reserved.                                                       */
/*                                                                            */
/* This source, or parts thereof, may only be used in APlayer related         */
/* software. If you want to use it elsewhere, please contact the author for a */
/* permission.                                                                */
/******************************************************************************/


#ifndef __APLAYER_ADDON_h
#define __APLAYER_ADDON_h

// APlayer headers
#include "APlayer.h"


#ifdef _BUILDING_APLAYER_CONVERTER_
#ifndef _BUILDING_APLAYER_ADDON_
#define _BUILDING_APLAYER_ADDON_
#endif
#endif

#ifdef __INTEL__

// Intel
#ifdef _BUILDING_APLAYER_ADDON_
#define _IMPEXP_APADDON		__declspec(dllexport)
#else
#define _IMPEXP_APADDON		__declspec(dllimport)
#endif

#else

// PPC
#ifdef _BUILDING_APLAYER_ADDON_
#define _IMPEXP_APADDON
#else
#define _IMPEXP_APADDON
#endif
#endif


/******************************************************************************/
/* Add-On functions                                                           */
/******************************************************************************/
#ifdef __POWERPC__
#pragma export on
#endif
extern "C"
{
#ifdef _BUILDING_APLAYER_CONVERTER_

_IMPEXP_APADDON	void Load(APGlobalData *global);
_IMPEXP_APADDON	void Unload(APGlobalData *global);
_IMPEXP_APADDON	APAddOnConverter *GetInstance(APGlobalData *global);

#else

_IMPEXP_APADDON	void Load(APGlobalData *global);
_IMPEXP_APADDON	void Unload(APGlobalData *global);
_IMPEXP_APADDON	APAddOn *GetInstance(APGlobalData *global);

#endif
}
#ifdef __POWERPC__
#pragma export off
#endif

#endif
