/******************************************************************************/
/* MIWindow header file.                                                      */
/******************************************************************************/
/* This is part of the APlayer Programming Package (APPP).                    */
/* Copyright (C) 1998-1999 by The APlayer-Team.                               */
/* All rights reserved.                                                       */
/*                                                                            */
/* This source, or parts thereof, may only be used in APlayer related         */
/* software. If you want to use it elsewhere, please contact the author for a */
/* permission.                                                                */
/******************************************************************************/


#ifndef __MIWindow_h
#define __MIWindow_h

// PolyKit headers
#include "POS.h"
#include "PString.h"
#include "PSynchronize.h"

// APlayer headers
#include "APlayer.h"

// Needed headers
#include "MIListView.h"


/******************************************************************************/
/* MIWindow class                                                             */
/******************************************************************************/
class MIWindow : public BWindow
{
public:
	MIWindow(BRect frame, const PString title, APGlobalData *global, uint32 strID);
	virtual ~MIWindow(void);

	void RefreshWindow(void);
	void UpdateWindow(uint32 line, ap_infoType type, PString newString);

	bool QuitRequested(void);
	void WindowActivated(bool active);

	PMutex *winLock;
	bool onScreen;
	bool shutDown;

protected:
	BPoint CalcMinSize(void);

	void AddItems(void);

	APGlobalData *globalData;
	uint32 strings;

	BView *topView;
	CLVContainerView *containerView;
	MIListView *columnListView;

	float fontHeight;

	bool wasOnScreen;
};

#endif
