/******************************************************************************/
/* ModTracker Player Stub Interface.                                          */
/******************************************************************************/
/* This is part of the APlayer Programming Package (APPP).                    */
/* Copyright (C) 1998-1999 by The APlayer-Team.                               */
/* All rights reserved.                                                       */
/*                                                                            */
/* This source, or parts thereof, may only be used in APlayer related         */
/* software. If you want to use it elsewhere, please contact the author for a */
/* permission.                                                                */
/******************************************************************************/


#define _BUILDING_APLAYER_ADDON_

// APlayer headers
#include "AddOn_Import.h"

// Player headers
#include "ModTracker.h"
#include "ModIcons.h"


/******************************************************************************/
/* Add-On function: Load() is called when the add-on is loaded into the       */
/*      memory.                                                               */
/*                                                                            */
/* Input:  "global" is a pointer to the global data class.                    */
/******************************************************************************/
void Load(APGlobalData *global)
{
	// Install the mime type + icon
	global->InstallModType("audio/x-mod", "mod", "ProTracker and various module formats with 4 or more channels", "MOD Sound Module", modSmallIcon, modLargeIcon);
	global->InstallModType("audio/x-mtm", "mtm", "2-32 channels MultiTracker module format", "MultiTracker module", mtmSmallIcon, mtmLargeIcon);
}



/******************************************************************************/
/* Add-On function: Unload() is called just before the add-on is freed from   */
/*      the memory.                                                           */
/*                                                                            */
/* Input:  "global" is a pointer to the global data class.                    */
/******************************************************************************/
void Unload(APGlobalData *global)
{
}



/******************************************************************************/
/* Add-On function: GetInstance() will allocate a new add-on instance and     */
/*      return the pointer to it.                                             */
/*                                                                            */
/* Input:  "global" is a pointer to the global data class.                    */
/*                                                                            */
/* Output: A new add-on instance allocated with new.                          */
/******************************************************************************/
APAddOn *GetInstance(APGlobalData *global)
{
	return (new ModTracker(global));
}
