unit main;

interface

uses
  SysUtils, Forms, Dialogs, StdCtrls, ComCtrls, Controls, Classes;

type
  Tfrm_main = class(TForm)
    btn_search: TButton;
    ed_filename: TEdit;
    lbl_file: TLabel;
    lbl_status: TLabel;
    btn_patch: TButton;
    dlg_open: TOpenDialog;
    rdb_intel: TRadioButton;
    rdb_amd: TRadioButton;
    pb_main: TProgressBar;
    chk_extended: TCheckBox;
    procedure btn_searchClick(Sender: TObject);
    procedure btn_patchClick(Sender: TObject);
    function bufftostr(inbuff: array of byte): string;
    function getstring(intel: boolean): string;
    function simplepatch: boolean;
    function extendedpatch: boolean;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  blocksize = 1024;

var
  frm_main: Tfrm_main;
  origstring: string = 'GenuineIntel';
  newstring: string = 'AuthenticAMD';
  search1: string = ', disabling all nonboot CPUs' + #10 + #0;
  search2: string = 'Started only %ld CPUs';
  search3: string = #0 + 'starting cpu %d' + #10;
  exitloop: boolean;

implementation

{$R *.dfm}

procedure Tfrm_main.btn_searchClick(Sender: TObject);
begin
if dlg_open.Execute then ed_filename.Text := dlg_open.FileName;
end;

procedure Tfrm_main.btn_patchClick(Sender: TObject);
begin
if btn_patch.Caption = 'Patch!' then begin
  btn_patch.Caption := 'Stop';
  if chk_extended.Checked then extendedpatch
  else simplepatch;
  btn_patch.Caption := 'Patch!';
end
else begin
  btn_patch.Caption := 'Patch!';
  exitloop := true;
end;
end;

function tfrm_main.bufftostr(inbuff: array of byte): string;
var
  i: integer;
begin
result := '';
setlength(result, length(inbuff));
for i := 0 to high(inbuff) do result[i + 1] := chr(inbuff[i]);
end;

function tfrm_main.getstring(intel: boolean): string;
begin
if intel then result := newstring
else result := origstring;
end;

function tfrm_main.simplepatch: boolean;
var
  stream: tfilestream;
  testbuff: array[0..11] of byte;
begin
try
  result := false;
  if fileexists(ed_filename.Text) then begin
    try
      stream := tfilestream.Create(ed_filename.Text, fmopenreadwrite)
    except
      lbl_status.Caption := 'Cannot open file, probably write protected';
      exit;
    end;
  end
  else begin
    lbl_status.Caption := 'File not found';
    exit;
  end;
  if stream.Size < 371672351 then begin
    lbl_status.Caption := 'Not a valid image file';
    stream.Free;
    exit;
  end;

  stream.Seek(371672339, sofrombeginning);
  stream.Read(testbuff, 12);

  if bufftostr(testbuff) = getstring(rdb_intel.Checked) then begin
    stream.Seek(371672339, sofrombeginning);
    try
      if rdb_intel.Checked then stream.Write(pchar(origstring)^, 12)
      else stream.Write(pchar(newstring)^, 12);
    except
      lbl_status.Caption := 'Cannot write to file';
      stream.Free;
      exit;
    end;
  end
  else begin
    lbl_status.Caption := 'Original string not found. Try extended patch';
    chk_extended.Checked := true;
    stream.Free;
    exit;
  end;

  lbl_status.Caption := 'Patch successful';
  stream.Free;
  result := true;
except
  lbl_status.Caption := 'An error occured';
  result := false;
end;
end;

function tfrm_main.extendedpatch: boolean;
var
  stream: tfilestream;
  i, j, k: integer;
  searchstring: string;
  buffer: array[0..blocksize - 1] of byte;
  testbuff: array[0..11] of byte;
  success: boolean;
  count: integer;
  testpos, oldpos: int64;
begin
try
  result := true;
  searchstring := search2 + search1;
  if rdb_intel.Checked then searchstring := searchstring + newstring
  else searchstring := searchstring + origstring;
  searchstring := searchstring + search3;

  if fileexists(ed_filename.Text) then begin
    try
      stream := tfilestream.Create(ed_filename.Text, fmopenreadwrite)
    except
      lbl_status.Caption := 'Cannot open file, probably write protected';
      exit;
    end;
  end
  else begin
    lbl_status.Caption := 'File not found';
    exit;
  end;

  j := 0;
  k := 1;
  count := 0;
  exitloop := false;
  success := false;
  pb_main.Position := 0;
  try
    pb_main.Max := stream.Size div blocksize;
  except
    pb_main.Max := maxint;
  end;

  lbl_status.Caption := 'Searching...';

  repeat
    stream.Read(buffer, blocksize);
    for i := 0 to blocksize - 1 do begin
      if chr(buffer[i]) <> searchstring[k] then k := 1
      else inc(k);
      if k = 81 then begin
        try
          k := 1;
          testpos := (j * blocksize) + i - 28;
          oldpos := stream.Position;
          stream.Seek(testpos, sofrombeginning);
          stream.Read(testbuff, 12);
          if bufftostr(testbuff) = getstring(rdb_intel.Checked) then begin
            stream.Seek(testpos, sofrombeginning);
            if rdb_intel.Checked then stream.Write(pchar(origstring)^, 12)
            else stream.Write(pchar(newstring)^, 12);
            inc(count);
            lbl_status.Caption := 'Found ' + inttostr(count) + ' instances';
            success := true;
          end;
          stream.Seek(oldpos, sofrombeginning);
        except
          lbl_status.Caption := 'Cannot write to file';
          stream.Free;
          exit;
        end;
      end;
    end;
    inc(j);
    pb_main.Position := j;
    application.ProcessMessages;
  until ((j * blocksize) >= stream.Size) or exitloop;

  if success then begin
    lbl_status.Caption := 'Patched ' + inttostr(count) + ' instances';
    result := true;
  end
  else lbl_status.Caption := 'Original string not found';
  stream.Free;
except
  lbl_status.Caption := 'An error occured';
  result := false;
end;
end;

end.
