//functions of EditCompoundWindow soi0.1

#include "windowGuts.h"
#include "editCompoundWindow.h"
#include "getFromList.h"
#include "showSomeThings.h"
#include "getSomeThings.h"
#include "fileHeaders.h"
#include "titleWindow.h"
#include "designButtons.h"

void EditCompoundWindow::SaveRequested(const char * fileName) 
{

SaveCompounds(fileName);
}//end


EditCompoundWindow::EditCompoundWindow(BRect area, const char *title) : BWindow(area, title, B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE), getEButton(NULL), showEButton(NULL), getCButton(NULL), showCButton(NULL) 
{

bb = new BottomButtons;
if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DFLT_COMPOUND]->SetEnabled(false);
		editUniverseWindow->buttons[DSN_COMPOUND]->SetEnabled(false);
		editUniverseWindow->buttons[LOAD_COMPOUND]->SetEnabled(false);
		editUniverseWindow->Unlock();
	}
	scg = new SmallConstantsGadgets();
	if (!scg) err = CREATEDNOTADDED;
}
else err = CREATEDNOTADDED;
editCompoundWindow = this;
if (!compoundCurrent) if (dataListGlobal[COMPOUND_TYPE]->list->CountItems()) compoundCurrent = (Compound *)((DataNode *)dataListGlobal[COMPOUND_TYPE]->list->ItemAt(0))->data;
}//end


EditCompoundWindow::~EditCompoundWindow() 
{

if (getEButton) 
{
	getEButton->RemoveSelf();
	delete getEButton;
}
if (showEButton) 
{
	showEButton->RemoveSelf();
	delete showEButton;
}
if (getCButton) 
{
	getCButton->RemoveSelf();
	delete getCButton;
}
if (showCButton) 
{
	showCButton->RemoveSelf();
	delete showCButton;
}
if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DFLT_COMPOUND]->SetEnabled(true);
		editUniverseWindow->buttons[DSN_COMPOUND]->SetEnabled(true);
		editUniverseWindow->buttons[LOAD_COMPOUND]->SetEnabled(true);
		editUniverseWindow->Unlock();
	}
	delete bb;
}
if (scg) delete scg;
editCompoundWindow = NULL;
}//end


void EditCompoundWindow::AddCompound(void) 
{

Compound * c = new Compound(compound, scg->nameStrGadget->Text(), dataListGlobal[COMPOUND_TYPE]);
if (c) 
{
	if (err != CREATED) 
	{
		delete c;
		return;
	}
}
else err = NO_COMPOUND;
}//end


void EditCompoundWindow::MessageReceived(BMessage *message) 
{

bool validate = true;
if (!strcmp(scg->nameStrGadget->Text(), "")) validate = false;

switch (message->what) 
{
	case SOI_NAME:
	case SOI_VOLUME:
	case SOI_VPER:
	
	break;
	case SOI_BLREMOVE:
		dataListGlobal[COMPOUND_TYPE]->Remove();
		Quit();
	break;
	case SOI_BLLIST:
		GetFromList((void *)editCompoundWindow, dataListGlobal[COMPOUND_TYPE], scg->nameStrGadget->Text());
	break;
	case SOI_BLLISTGOT:
		if (validate) ValidateCompound();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateCompound();
			compoundCurrent = compoundNewCurrent;
			compound->Copy(compoundCurrent);
			if (compoundCurrent->eList->list->CountItems()) showEButton->SetEnabled(true);
			else showEButton->SetEnabled(false);
			if (compoundCurrent->cList->list->CountItems()) showCButton->SetEnabled(true);
			else showCButton->SetEnabled(false);
			scg->nameStrGadget->SetText(compoundCurrent->name);
			thisDNPtr = dataListGlobal[COMPOUND_TYPE]->NextPrevItems((void *)compoundCurrent, &nextDNPtr, &prevDNPtr, bb);
			if (!bb->gnu) 
			{
				BRect gnuRect(154,bottom, 189,34);
				bb->gnu = new BButton(gnuRect, "", newStr, new BMessage(SOI_BLGNU));
				if (!bb->gnu) 
				{
					warning(failMemory);
					return;
				}
				AddChild(bb->gnu);
				bb->gnu->SetTarget(this);
				bb->add->SetLabel(removeStr);
				bb->add->SetMessage(new BMessage(SOI_BLREMOVE));
			}
		}
	break;
	case SOI_BLPREV:
		Compound * prevCompound = (Compound *)((DataNode *)prevDNPtr)->data;
		if (validate) ValidateCompound();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateCompound();
			compoundCurrent = prevCompound;
			compound->Copy(compoundCurrent);
			if (compound->eList->list->CountItems()) showEButton->SetEnabled(true);
			else showEButton->SetEnabled(false);
			if (compound->cList->list->CountItems()) showCButton->SetEnabled(true);
			else showCButton->SetEnabled(false);
			scg->nameStrGadget->SetText(compoundCurrent->name);
			thisDNPtr = dataListGlobal[COMPOUND_TYPE]->NextPrevItems((void *)compoundCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	case SOI_BLDONE:
		if (!validate) 
		{
			Quit();
		}
		if (!strcmp(removeStr, bb->add->Label())) 
		{
			ValidateCompound();
			if (err == NO_ERR) 
			{
				UpdateCompound();
			}
		}
		if (err == NO_ERR) 
		{
			Quit();
		}
	break;
	case SOI_BLGNU:
		if (validate) ValidateCompound();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateCompound();
			compoundCurrent = NULL;
			RemoveChild(bb->gnu);
			delete bb->gnu;
			bb->gnu = NULL;
			bb->add->SetLabel(addStr);
			bb->add->SetMessage(new BMessage(SOI_BLADD));
			scg->nameStrGadget->SetText("");
			scg->nameStrGadget->MakeFocus();
			showEButton->SetEnabled(false);
			showCButton->SetEnabled(false);
		}
	break;
	case SOI_BLADD:
		if (validate) ValidateCompound();
		else {
			err = NO_NAME;
			warning(everythingNamed);
		}//for add don't update
		if (err == NO_ERR) 
		{
			AddCompound();
			if (err) 
			{
				if (err != CREATEDNOTADDED) 
				{
					Quit();
				}
			}
			else {
				if (editUniverseWindow) 
				{
					editUniverseWindow->Lock();
					editUniverseWindow->buttons[DSN_COMPOUND]->SetLabel(editThe[COMPOUND_TYPE]);
					editUniverseWindow->bb->save->SetEnabled(true);
					editUniverseWindow->Unlock();
				}
				scg->nameStrGadget->SetText("");
				scg->nameStrGadget->MakeFocus();
				getCButton->SetEnabled(true);
				bb->save->SetEnabled(true);
				showEButton->SetEnabled(false);
				showCButton->SetEnabled(false);
				if (openingWindow) 
				{
					openingWindow->Lock();
					openingWindow->universeButton->SetLabel(editThe[UNIVERSE_TYPE]);
					openingWindow->createUniverseButton->SetEnabled(true);
					openingWindow->realUniverseButton->SetEnabled(true);
					openingWindow->Unlock();
				}
			}
		}
	break;
	case SOI_BLSAVE:
		if (validate) ValidateCompound();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateCompound();
			//RunSavePanel("compounds", saveThe[COMPOUND_TYPE], saveStr, cancelStr);
		}
	break;
	case SOI_BLPIC:
	
	break;
	case SOI_LOADCOMPOUNDFROMPANEL:
		LoadCompounds("compounds");//debug
		Quit();
	break;
	case SOI_BLLOAD:
		BMessage * bm = new BMessage(SOI_LOADCOMPOUNDFROMPANEL);
		if (bm) break;//debug break;//debug be_app->RunFilePanel(loadThe[COMPOUND_TYPE], loadStr, cancelStr, false, bm);
		else warning(failMemory);
	break;
	case SOI_BLNEXT:
		Compound * nextCompound = (Compound *)((DataNode *)nextDNPtr)->data;
		if (validate) ValidateCompound();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateCompound();
			compoundCurrent = nextCompound;
			compound->Copy(compoundCurrent);
			if (compound->eList->list->CountItems()) showEButton->SetEnabled(true);
			else showEButton->SetEnabled(false);
			if (compound->cList->list->CountItems()) showCButton->SetEnabled(true);
			else showCButton->SetEnabled(false);
			scg->nameStrGadget->SetText(compoundCurrent->name);
			thisDNPtr = dataListGlobal[COMPOUND_TYPE]->NextPrevItems((void *)compoundCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	case SOI_COMPOUNDGETELIST:
		GetSomeThings(compound->eList->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], COMPOUND_TYPE);
	break;
	case SOI_COMPOUNDGETCLIST:
		GetSomeThings(compound->cList->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], COMPOUND_TYPE);
	break;
	case SOI_COMPOUNDSHOWELIST:
		ShowSomeThings((const void *)&compound, sizeof(compound), compoundCurrent->name, COMPOUND_TYPE, compound->eList, scg->nameStrGadget->Text(), editCompoundWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_COMPOUNDSHOWCLIST:
		ShowSomeThings((const void *)&compound, sizeof(compound), compoundCurrent->name, COMPOUND_TYPE, compound->cList, scg->nameStrGadget->Text(), editCompoundWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	default:
		BWindow::MessageReceived(message);
	break;
}
}

bool EditCompoundWindow::QuitRequested(void) 
{

if (strcmp(scg->nameStrGadget->Text(), "")) 
{
	ValidateCompound();
	if (err == NO_ERR) 
	{
		UpdateCompound();
		if (err == NO_ERR) 
		{
			Quit();
			return(BWindow::QuitRequested());
		}
		else return false;
	}
	else return false;
}
Quit();
return(BWindow::QuitRequested());
}//end


void EditCompoundWindow::ValidateCompound(void) 
{

UniqueName(dataListGlobal[COMPOUND_TYPE], scg->nameStrGadget->Text());
if (NO_UNIQUE == err) 
{
	warning(failNameUnique[COMPOUND_TYPE]);
	return;
}
uint32 v, vp;

v = s2uint32(scg->vIntGadget->Text());
if (S2UIERR == err) 
{
	warning(SCGVolumeErr);
	return;
}
vp = s2uint32(scg->vperIntGadget->Text());
if (S2UIERR == err) 
{
	warning(SCGVolumePerErr);
	return;
}
compound->volume = v;
compound->vper = vp;
}//end


void EditCompoundWindow::UpdateCompound(void) 
{

err = NO_ERR;
compound->mass = 0;
UIntPtrNode * node;
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)compound->eList->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	compound->mass += ((Element * )(node->data))->mass;
	compound->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)compound->cList->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	compound->mass += ((Compound * )(node->data))->mass;
	compound->mass *= node->number;
}
if (compoundCurrent) compoundCurrent->Copy(compound);
}//end


void EditCompoundWindow::SaveCompounds(const char * fileName) 
{

//BVolume volu;
//char nme[B_OS_NAME_LENGTH];
//int32 cnt = 0;
//bool doit = true;
//bool fileOpened = true;
////debug volu = volume_at(cnt);
//BFile * theFile = new BFile;
//
//if (!theFile) 
//{
//	warning(failMemory);
//	return;
//}
//while (doit) 
//{
//	if (volu.Error() != B_NO_ERROR) break;
//	volu.GetName(nme);
//	if (!strcmp(nme, "flopp")) 
//	{
//		BDirectory rootDir;
//		volu.GetRootDirectory(&rootDir);
//		rootDir.Create(fileName, theFile);
//		theFile->Open(B_EXCLUSIVE);
//		if (theFile->Error() != B_NO_ERROR) 
//		{
//			fileOpened = false;
//			warning(badFileNoOpen);
//		}
//	}
//	volu = volume_at(++cnt);
//	if (volu.Error() != B_NO_ERROR) 
//	{
//		doit = false;
//	}
//}
//if (fileOpened) 
//{
//	Compound * saveme;
//	int32 num = dataListGlobal[COMPOUND_TYPE]->list->CountItems();
//	if (num) 
//	{
//		if (!PutFileHeaderPre(theFile)) 
//		{
//			warning(noSave);
//			theFile->Close();
//			delete theFile;
//			return;
//		}
//		if (!PutFileHeader(COMPOUND_TYPE, num, theFile)) 
//		{
//			warning(noSave);
//			theFile->Close();
//			delete theFile;
//			return;
//		}
//		Element * saveElement;
//		num = dataListGlobal[ELEMENT_TYPE]->list->CountItems();
//		if (!PutFileHeader(ELEMENT_TYPE, num, theFile)) 
//		{
//			warning(noSave);
//			theFile->Close();
//			delete theFile;
//			return;
//		}	
//		DataNode * node;
//		if (num) 
//		{
//			#pragma warn_possunwant off
//			for (int32 i = 0; node = (DataNode *)dataListGlobal[ELEMENT_TYPE]->list->ItemAt(i); i++) 
//			{
//			#pragma warn_possunwant reset
//				saveElement = (Element *)node->data;
//				if (!(saveElement->Save(theFile))) 
//				{
//					warning(noSave);
//					theFile->Close();
//					delete theFile;
//					return;
//				}
//			}
//		}
//		else warning(nothingToSave[ELEMENT_TYPE]);
//		#pragma warn_possunwant off
//		for (int32 i = 0; node = (DataNode *)dataListGlobal[COMPOUND_TYPE]->list->ItemAt(i); i++) 
//		{
//		#pragma warn_possunwant reset
//			saveme = (Compound *)node->data;
//			if (!(saveme->Save(theFile))) 
//			{
//				warning(nothingToSave[COMPOUND_TYPE]);
//				theFile->Close();
//				delete theFile;
//				return;
//			}
//		}
//	}
//	else warning(nothingToSave[COMPOUND_TYPE]);
//	theFile->Close();
//}
//delete theFile;
}//end


void EditCompoundWindow::LoadCompounds(const char * fileName) 
{

//BVolume volu;
//char nme[B_OS_NAME_LENGTH];
//int32 cnt = 0;
//bool doit = true;
////debug volu = volume_at(cnt);
//BFile * theFile = new BFile;
//int32 numCompounds, numElements;
//
//if (!theFile) 
//{
//	warning(failMemory);
//	return;
//}
//while (doit) 
//{
//	if (volu.Error() != B_NO_ERROR) break;
//	volu.GetName(nme);
//	if (!strcmp(nme, "flopp")) 
//	{
//		BDirectory rootDir;
//		volu.GetRootDirectory(&rootDir);
//		rootDir.GetFile(fileName, theFile);
//	}
//	volu = volume_at(++cnt);
//	if (volu.Error() != B_NO_ERROR) 
//	{
//		doit = false;
//	}
//}
//theFile->Open(B_READ_ONLY);
//if (theFile->Error() != B_NO_ERROR) 
//{
//	warning(badFileNoOpen);
//	delete theFile;
//	return;
//}
//MergeList * eMergeList = new MergeList(ELEMENT_TYPE);
//if (!eMergeList) 
//{
//	warning(failDataList);
//	delete theFile;
//	return;
//}
//if (!StripFileHeaderPre(theFile)) 
//{
//	delete eMergeList;
//	warning(noLoad);
//	delete theFile;
//	return;
//}
//if (!StripFileHeader(COMPOUND_TYPE, theFile, &numCompounds)) 
//{
//	delete eMergeList;
//	warning(noLoad);
//	delete theFile;
//	return;
//}
//if (!StripFileHeader(ELEMENT_TYPE, theFile, &numElements)) 
//{
//	delete eMergeList;
//	warning(noLoad);
//	delete theFile;
//	return;
//}
//Element e;
//for (int32 i = 0; i < numElements; i++) 
//{
//	if (e.Load(theFile)) 
//	{
//		Element * newElement = new Element(&e, eMergeList);
//		if (!newElement) 
//		{
//			warning(failCreate[ELEMENT_TYPE]);
//			i = numElements;
//		}
//		else if (err != CREATED) i = numElements;
//	}
//	else i = numElements;
//}
//dataListGlobal[ELEMENT_TYPE]->Merge(eMergeList);
//MergeList * cMergeList = new MergeList(COMPOUND_TYPE);
//if (!cMergeList) 
//{
//	theFile->Close();
//	delete eMergeList;
//	delete theFile;
//	warning(failMergeList);
//	return;
//}
//Compound c;
//for (int32 i = 0; i < numCompounds; i++) 
//{
//	if (c.Load(theFile)) 
//	{
//		Compound * newCompound = new Compound(&c, cMergeList);
//		if (!newCompound) 
//		{
//			warning(failCreate[COMPOUND_TYPE]);
//			i = numCompounds;
//		}
//		else if (err != CREATED) i = numCompounds;
//	}
//	else i = numCompounds;
//}
//dataListGlobal[COMPOUND_TYPE]->Merge(cMergeList);
//theFile->Close();
//delete theFile;
//
//int32 numMerged = cMergeList->list->CountItems();
//for (int32 i = 0; i < numMerged; i++) 
//{
//	MergeNode * mergeNode = (MergeNode *)cMergeList->list->ItemAt(i);
//	if (mergeNode->howMerged != MERGEDCUT) 
//	{
//		Compound * compound = (Compound *)mergeNode->ItemMerged(dataListGlobal[COMPOUND_TYPE]);
//		int32 listNum = compound->eList->list->CountItems();
//		for (int32 j = 0; j < listNum; j++) 
//		{
//			MPtrNode * mPtrNode = (MPtrNode *)compound->eList->list->ItemAt(j);
//			UIntPtrNode * uIntPtrNode = new UIntPtrNode(mPtrNode->FindData(dataListGlobal[ELEMENT_TYPE], eMergeList), mPtrNode->number);
//			if (!uIntPtrNode) 
//			{
//				delete eMergeList;
//				delete cMergeList;
//				warning(failUIntPtrNode);
//				return;
//			}
//			compound->eList->list->RemoveItem(j);
//			compound->eList->list->AddItem(uIntPtrNode, j);
//			delete mPtrNode;
//		}
//		listNum = compound->cList->list->CountItems();
//		for (int32 j = 0; j < listNum; j++) 
//		{
//			MPtrNode * mPtrNode = (MPtrNode *)compound->cList->list->ItemAt(j);
//			UIntPtrNode * uIntPtrNode = new UIntPtrNode(mPtrNode->FindData(dataListGlobal[COMPOUND_TYPE], cMergeList), mPtrNode->number);
//			if (!uIntPtrNode) 
//			{
//				delete cMergeList;
//				delete eMergeList;
//				warning(failUIntPtrNode);
//				return;
//			}
//			compound->cList->list->RemoveItem(j);
//			compound->cList->list->AddItem(uIntPtrNode, j);
//			delete mPtrNode;
//		}
//	}
//	
//}
//delete eMergeList;
//delete cMergeList;
}//end
