//functions of EditPlanetShieldWindow soi0.1

#include "windowGuts.h"
#include "editPlanetShieldWindow.h"
#include "def.h"
#include "s2f.h"
#include "showSomeThings.h"
#include "getSomeThings.h"
#include "getFromList.h"
#include "saveLoadUniverse.h"
#include "titleWindow.h"
#include "designButtons.h"

void EditPlanetShieldWindow::SaveRequested(const char * fileName) 
{

SavePlanetShields(fileName);
}//end


EditPlanetShieldWindow::EditPlanetShieldWindow(BRect area, const char *title) : BWindow(area, title, B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE) 
{

err = NO_ERR;
orderButton = NULL;
kindButton = NULL;
defaultStrengthGadget = NULL;
bb = new BottomButtons;
if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_PLANETSHIELD]->SetEnabled(false);
		editUniverseWindow->Unlock();
	}
	db = new DoableButtons();
	if (db) 
	{
		maint = new DoableButtons();
		if (maint) 
		{
			scg = new SmallConstantsGadgets();
			if (scg) 
			{
				bld = new DoableButtons();
				if (!bld) err = CREATEDNOTADDED;
			}
			else err = CREATEDNOTADDED;
		}
		else err = CREATEDNOTADDED;
	}
	else err = CREATEDNOTADDED;
}
else err = CREATEDNOTADDED;
editPlanetShieldWindow = this;
if (!planetShieldCurrent) if (dataListGlobal[PLANETSHIELD_TYPE]->list->CountItems()) planetShieldCurrent = (PlanetShield *)((DataNode *)dataListGlobal[PLANETSHIELD_TYPE]->list->ItemAt(0))->data;
}//end


EditPlanetShieldWindow::~EditPlanetShieldWindow() 
{

if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_PLANETSHIELD]->SetEnabled(true);
		editUniverseWindow->Unlock();
	}
	delete bb;
}
if (defaultStrengthGadget) 
{
	defaultStrengthGadget->RemoveSelf();
	delete defaultStrengthGadget;
}
if (bld) delete bld;
if (db) delete db;
if (maint) delete maint;
if (scg) delete scg;
if (orderButton) 
{
	orderButton->RemoveSelf();
	delete orderButton;
}
if (kindButton) 
{
	kindButton->RemoveSelf();
	delete kindButton;
}
editPlanetShieldWindow = NULL;
}//end


void EditPlanetShieldWindow::AddPlanetShield(void) 
{

PlanetShield * item = new PlanetShield(planetShield, scg->nameStrGadget->Text(), dataListGlobal[PLANETSHIELD_TYPE]);
if (item) 
{
	if (err != CREATED) 
	{
		delete item;
		return;
	}
}
else err = NO_PLANETSHIELD;
}//end


void EditPlanetShieldWindow::MessageReceived(BMessage *message) 
{

bool validate = true;
int32 planetShieldSize = sizeof planetShieldCurrent;
if (!strcmp(scg->nameStrGadget->Text(), "")) validate = false;

switch (message->what) 
{
	case SOI_NAME:
	case SOI_VOLUME:
	case SOI_VPER:
	
	break;
	case SOI_MAINTAINABLEBUTTONLABEL:
		if (maint->showing) 
		{
			maint->label->SetLabel(selectMaintValue);
			maint->showing = false;
		}
		else {
			maint->label->SetLabel(showMaintValue);
			maint->showing = true;
		}
		maint->ResetMsg(message->what);
	break;
	case SOI_BUILDABLEBUTTONLABEL:
		if (bld->showing) 
		{
			bld->label->SetLabel(selectProdValue);
			bld->showing = false;
		}
		else {
			bld->label->SetLabel(showProdValue);
			bld->showing = true;
		}
		bld->ResetMsg(message->what);
	break;
	case SOI_DOABLEBUTTONLABEL:
		if (db->showing) 
		{
			db->label->SetLabel(selectConsumeValue);
			db->showing = false;
		}
		else {
			db->label->SetLabel(showConsumeValue);
			db->showing = true;
		}
		db->ResetMsg(message->what);
	break;
	case SOI_GETPOSSORDERS:
	
	break;
	case SOI_BUILDABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(planetShield->buildable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(planetShield->buildable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONELEMENTS:
		GetSomeThings(planetShield->buildable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONCOMPOUNDS:
		GetSomeThings(planetShield->buildable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONMINES:
		GetSomeThings(planetShield->buildable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONFACTORYS:
		GetSomeThings(planetShield->buildable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONENGINES:
		GetSomeThings(planetShield->buildable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSHIPS:
		GetSomeThings(planetShield->buildable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSSHIELDS:
		GetSomeThings(planetShield->buildable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSHIPWEAPONS:
		GetSomeThings(planetShield->buildable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPLANETSHIELDS:
		GetSomeThings(planetShield->buildable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPLANETWEAPONS:
		GetSomeThings(planetShield->buildable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(planetShield->doable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(planetShield->doable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONELEMENTS:
		GetSomeThings(planetShield->doable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONCOMPOUNDS:
		GetSomeThings(planetShield->doable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONMINES:
		GetSomeThings(planetShield->doable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONFACTORYS:
		GetSomeThings(planetShield->doable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONENGINES:
		GetSomeThings(planetShield->doable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONSHIPS:
		GetSomeThings(planetShield->doable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONSSHIELDS:
		GetSomeThings(planetShield->doable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONSHIPWEAPONS:
		GetSomeThings(planetShield->doable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONPLANETSHIELDS:
		GetSomeThings(planetShield->doable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONPLANETWEAPONS:
		GetSomeThings(planetShield->doable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(planetShield->maintainable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(planetShield->maintainable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONELEMENTS:
		GetSomeThings(planetShield->maintainable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONCOMPOUNDS:
		GetSomeThings(planetShield->maintainable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONMINES:
		GetSomeThings(planetShield->maintainable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONFACTORYS:
		GetSomeThings(planetShield->maintainable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONENGINES:
		GetSomeThings(planetShield->maintainable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSHIPS:
		GetSomeThings(planetShield->maintainable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSSHIELDS:
		GetSomeThings(planetShield->maintainable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSHIPWEAPONS:
		GetSomeThings(planetShield->maintainable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPLANETSHIELDS:
		GetSomeThings(planetShield->maintainable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPLANETWEAPONS:
		GetSomeThings(planetShield->maintainable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], PLANETSHIELD_TYPE);
	break;
	case SOI_SHOWBUILDPRIMALELEMENTS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->buildable->elementPrimal, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWBUILDPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->buildable->compoundPrimal, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWBUILDELEMENTS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->buildable->elementManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWBUILDCOMPOUNDS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->buildable->compoundManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWBUILDMINES:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->buildable->mineManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWBUILDFACTORYS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->buildable->factoryManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWBUILDENGINES:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->buildable->engineManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWBUILDSHIPS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->buildable->shipManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWBUILDSSHIELDS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->buildable->shipShieldManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWBUILDSHIPWEAPONS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->buildable->shipWeaponManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWBUILDPLANETSHIELDS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->buildable->planetShieldManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWBUILDPLANETWEAPONS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->buildable->planetWeaponManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_SHOWDOPRIMALELEMENTS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->doable->elementPrimal, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWDOPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->doable->compoundPrimal, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWDOELEMENTS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->doable->elementManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWDOCOMPOUNDS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->doable->compoundManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWDOMINES:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->doable->mineManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWDOFACTORYS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->doable->factoryManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWDOENGINES:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->doable->engineManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWDOSHIPS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->doable->shipManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWDOSSHIELDS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->doable->shipShieldManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWDOSHIPWEAPONS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->doable->shipWeaponManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWDOPLANETSHIELDS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->doable->planetShieldManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWDOPLANETWEAPONS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->doable->planetWeaponManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_SHOWMAINTPRIMALELEMENTS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->maintainable->elementPrimal, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWMAINTPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->maintainable->compoundPrimal, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWMAINTELEMENTS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->maintainable->elementManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWMAINTCOMPOUNDS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->maintainable->compoundManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWMAINTMINES:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->maintainable->mineManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWMAINTFACTORYS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->maintainable->factoryManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWMAINTENGINES:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->maintainable->engineManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWMAINTSHIPS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->maintainable->shipManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWMAINTSSHIELDS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->maintainable->shipShieldManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWMAINTSHIPWEAPONS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->maintainable->shipWeaponManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWMAINTPLANETSHIELDS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->maintainable->planetShieldManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWMAINTPLANETWEAPONS:
		ShowSomeThings((const void *)&planetShield, planetShieldSize, planetShieldCurrent->name, PLANETSHIELD_TYPE, planetShield->maintainable->planetWeaponManufactured, scg->nameStrGadget->Text(), editPlanetShieldWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_BLREMOVE:
		dataListGlobal[PLANETSHIELD_TYPE]->Remove();
		Quit();
	break;
	case SOI_BLLIST:
		GetFromList((void *)editPlanetShieldWindow, dataListGlobal[PLANETSHIELD_TYPE], scg->nameStrGadget->Text());
	break;
	case SOI_BLLISTGOT:
		if (validate) ValidatePlanetShield();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdatePlanetShield();
			planetShieldCurrent = planetShieldNewCurrent;
			planetShield->Copy(planetShieldCurrent);
			scg->nameStrGadget->SetText(planetShieldCurrent->name);
			thisDNPtr = dataListGlobal[PLANETSHIELD_TYPE]->NextPrevItems((void *)planetShieldCurrent, &nextDNPtr, &prevDNPtr, bb);
			if (!bb->gnu) 
			{
				BRect gnuRect(154,bottom, 189,34);
				bb->gnu = new BButton(gnuRect, "", newStr, new BMessage(SOI_BLGNU));
				AddChild(bb->gnu);
				bb->gnu->SetTarget(this);
				bb->add->SetLabel(removeStr);
				bb->add->SetMessage(new BMessage(SOI_BLREMOVE));
			}
		}
	break;
	case SOI_BLPREV:
		PlanetShield * prevPlanetShield = (PlanetShield *)((DataNode *)prevDNPtr)->data;
		if (validate) ValidatePlanetShield();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdatePlanetShield();
			planetShieldCurrent = prevPlanetShield;
			planetShield->Copy(planetShieldCurrent);
			scg->nameStrGadget->SetText(planetShieldCurrent->name);
			thisDNPtr = dataListGlobal[PLANETSHIELD_TYPE]->NextPrevItems((void *)planetShieldCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	case SOI_BLDONE:
		if (!validate) 
		{
			Quit();
		}
		if (!strcmp(removeStr, bb->add->Label())) 
		{
			ValidatePlanetShield();
			if (err == NO_ERR) 
			{
				UpdatePlanetShield();
			}
		}
		if (err == NO_ERR) 
		{
			Quit();
		}
	break;
	case SOI_BLGNU:
		if (validate) ValidatePlanetShield();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdatePlanetShield();
			planetShieldCurrent = NULL;
			RemoveChild(bb->gnu);
			delete bb->gnu;
			bb->gnu = NULL;
			bb->add->SetLabel(addStr);
			bb->add->SetMessage(new BMessage(SOI_BLADD));
			scg->nameStrGadget->SetText("");
			scg->nameStrGadget->MakeFocus();
		}
	break;
	case SOI_BLADD:
		if (validate) ValidatePlanetShield();
		else {
			err = NO_NAME;
			warning(everythingNamed);
		}//for add don't update
		if (err == NO_ERR) 
		{
			AddPlanetShield();
			if (err) 
			{
				if (err != CREATEDNOTADDED) 
				{
					Quit();
				}
			}
			else {
				if (editUniverseWindow) 
				{
					editUniverseWindow->Lock();
					editUniverseWindow->buttons[DSN_PLANETSHIELD]->SetLabel(editThe[PLANETSHIELD_TYPE]);
					editUniverseWindow->bb->save->SetEnabled(true);
					editUniverseWindow->Unlock();
				}
				scg->nameStrGadget->SetText("");
				scg->nameStrGadget->MakeFocus();
				bb->save->SetEnabled(true);
				if (openingWindow) 
				{
					openingWindow->Lock();
					openingWindow->universeButton->SetLabel(editThe[UNIVERSE_TYPE]);
					openingWindow->createUniverseButton->SetEnabled(true);
					openingWindow->realUniverseButton->SetEnabled(true);
					openingWindow->Unlock();
				}
				planetShield->maintainable->EmptyList();
				planetShield->buildable->EmptyList();
				planetShield->doable->EmptyList();
			}
		}
	break;
	case SOI_BLSAVE:
		if (validate) ValidatePlanetShield();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdatePlanetShield();
			//RunSavePanel("universe", saveThe[UNIVERSE_TYPE], saveStr, cancelStr);
		}
	break;
	case SOI_BLPIC:
	
	break;
	case SOI_LOADUNIVERSEFROMPANEL:
		LoadPlanetShields("universe");//debug
		Quit();
	break;
	case SOI_BLLOAD:
		BMessage * bm = new BMessage(SOI_LOADUNIVERSEFROMPANEL);
		if (bm) break;//debug break;//debug be_app->RunFilePanel(loadThe[UNIVERSE_TYPE], loadStr, cancelStr, false, bm);
		else warning(failMemory);
	break;
	case SOI_BLNEXT:
		PlanetShield * nextPlanetShield = (PlanetShield *)((DataNode *)nextDNPtr)->data;
		if (validate) ValidatePlanetShield();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdatePlanetShield();
			planetShieldCurrent = nextPlanetShield;
			planetShield->Copy(planetShieldCurrent);
			scg->nameStrGadget->SetText(planetShieldCurrent->name);
			thisDNPtr = dataListGlobal[PLANETSHIELD_TYPE]->NextPrevItems((void *)planetShieldCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	default:
		BWindow::MessageReceived(message);
	break;
}
}//end

bool EditPlanetShieldWindow::QuitRequested(void) 
{

if (strcmp(scg->nameStrGadget->Text(), "")) 
{
	if (planetShieldCurrent) 
	{
		ValidatePlanetShield();
		if (err == NO_ERR) 
		{
			UpdatePlanetShield();
			if (err == NO_ERR) 
			{
				Quit();
				return(BWindow::QuitRequested());
			}
			else return false;
		}
		else return false;
	}
}
Quit();
return(BWindow::QuitRequested());
}//end


void EditPlanetShieldWindow::ValidatePlanetShield(void) 
{

UniqueName(dataListGlobal[PLANETSHIELD_TYPE], scg->nameStrGadget->Text());
if (NO_UNIQUE == err) 
{
	warning(failNameUnique[PLANETSHIELD_TYPE]);
	return;
}
uint32 v, vp;

v = s2uint32(scg->vIntGadget->Text());
if (S2UIERR == err) 
{
	warning(SCGVolumeErr);
	return;
}
vp = s2uint32(scg->vperIntGadget->Text());
if (S2UIERR == err) 
{
	warning(SCGVolumePerErr);
	return;
}
planetShield->volume = v;
planetShield->vper = vp;
}//end


void EditPlanetShieldWindow::UpdatePlanetShield(void) 
{

err = NO_ERR;
planetShield->mass = 0;
UIntPtrNode * node;
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetShield->buildable->elementPrimal->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetShield->mass += ((Element *)(node->data))->mass;
	planetShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetShield->buildable->compoundPrimal->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetShield->mass += ((Compound *)(node->data))->mass;
	planetShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetShield->buildable->elementManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetShield->mass += ((Element *)(node->data))->mass;
	planetShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetShield->buildable->compoundManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetShield->mass += ((Compound *)(node->data))->mass;
	planetShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetShield->buildable->planetShieldManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetShield->mass += ((PlanetShield *)(node->data))->mass;
	planetShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetShield->buildable->factoryManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetShield->mass += ((Factory *)(node->data))->mass;
	planetShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetShield->buildable->engineManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetShield->mass += ((Engine *)(node->data))->mass;
	planetShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetShield->buildable->shipManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetShield->mass += ((Ship *)(node->data))->mass;
	planetShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetShield->buildable->shipShieldManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetShield->mass += ((ShipShield *)(node->data))->mass;
	planetShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetShield->buildable->shipWeaponManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetShield->mass += ((ShipWeapon *)(node->data))->mass;
	planetShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetShield->buildable->planetShieldManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetShield->mass += ((PlanetShield *)(node->data))->mass;
	planetShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetShield->buildable->planetWeaponManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetShield->mass += ((PlanetWeapon *)(node->data))->mass;
	planetShield->mass *= node->number;
}
if (planetShieldCurrent) planetShieldCurrent->Copy(planetShield);
}//end


void EditPlanetShieldWindow::SavePlanetShields(const char * fileName) 
{

SaveUniverse(fileName);
}//end


void EditPlanetShieldWindow::LoadPlanetShields(const char * fileName) 
{

LoadUniverse(fileName);
}//end
