//functions of EditUniversalConstantsWindow soi0.1

#include <memory>
#include <string>
#include "windowGuts.h"
#include "warning.h"
#include "error.h"
#include "s2uint32.h"
#include "things.h"
#include "dataNode.h"
#include "intGadget.h"
#include "dataList.h"
#include "bottomLine.h"
#include "myButton.h"
#include "bottomButtons.h"
#include "stringGadget.h"
#include "unique.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "constants.h"
#include "universalConstants.h"
#include "hasIntReqWindow.h"
#include "listViewWindow.h"
#include "hasListViewWindow.h"
#include "editUniversalConstantsWindow.h"
#include "designButtons.h"
#include "editUniverseWindow.h"
#include "fileHeaders.h"
#include "universe.h"
#include "preferences.h"
#include "myPreferences.h"
#include "myApp.h"
#include "getFromList.h"
#include "unique.h"
#include "error.h"
#include "titleWindow.h"
#include "verify.h"

EditUniversalConstantsWindow	::	EditUniversalConstantsWindow(	BRect paramBound,
																	const char * ccpparamWindowTitle,
																	const char * ccpparamScrollViewName,
																	const char * ccpparamNamePrefFrame)
								: 
									WindowGuts(	paramBound, 
												ccpparamWindowTitle, 
												ccpparamScrollViewName,
												ccpparamNamePrefFrame),
									savePanel(NULL), 
									saveMessenger(NULL), 
									loadPanel(NULL), 
									loadMessenger(NULL), 
									mpListViewWindow(NULL),
									enteredMinWidthGadget(NULL),
									enteredMaxWidthGadget(NULL),
									enteredMinHeightGadget(NULL),
									enteredMaxHeightGadget(NULL),
									enteredMinDepthGadget(NULL),
									enteredMaxDepthGadget(NULL),
									enteredMinSofLGadget(NULL),
									enteredMaxSofLGadget(NULL),
									enteredMinPropFuelUseGadget(NULL),
									enteredMaxPropFuelUseGadget(NULL),
									enteredMinPropAccelGadget(NULL),
									enteredMaxPropAccelGadget(NULL),
									enteredMinFTLFuelUseGadget(NULL),
									enteredMaxFTLFuelUseGadget(NULL),
									enteredMinFTLAccelGadget(NULL),
									enteredMaxFTLAccelGadget(NULL),
									enteredMinInstFuelUseGadget(NULL),
									enteredMaxInstFuelUseGadget(NULL),
									enteredMinElectronMassGadget(NULL),
									enteredMaxElectronMassGadget(NULL),
									enteredMinNeutronMassGadget(NULL),
									enteredMaxNeutronMassGadget(NULL),
									enteredMinProtonMassGadget(NULL),
									enteredMaxProtonMassGadget(NULL),
									enteredMinNumGalaxyGadget(NULL),
									enteredMaxNumGalaxyGadget(NULL),
									pBottomButtons(new BottomButtons)
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning(gccpFailCreateSemaphore);
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		BWindow bw(	BRect(0, 0, 32, 32), 
					gccpNoShowWindow, 
					B_DOCUMENT_WINDOW, 
					/*B_WILL_ACCEPT_FIRST_CLICK*/0);
		LayoutMatrix *	pNameLayoutMatrix = new LayoutMatrix(&bw, BESTSIZE, 1, 1);//rows,columns
		AddToLayoutMatrixList(pNameLayoutMatrix);
/////////////////////////////////////////////////////////////////////////////////////////////
		BView bv(BRect(0, 0, 32, 32), gccpNoShowView, B_FOLLOW_NONE, B_WILL_DRAW);
		bw.AddChild(&bv);
		bv.SetFont(myPrefs->GetPreferredFont());
		float stringEntryPixWidth = bv.StringWidth(gccpNameUCStrGadgetLable);
		char * prelimName;
		if (universalConstantsCurrent) 
		{
			prelimName = universalConstantsCurrent->name;
		}
		else 
		{
			prelimName = NULL;
		}
		BMessage * pNameStrGadgetMsg = new BMessage(NAMEUCMSG);
		nameStrGadget = new StringGadget(	BRect(0, 0, 32, 32), 
											"stringGadgetName", 
											gccpNameUCStrGadgetLable, 
											prelimName, 
											pNameStrGadgetMsg, 
											B_FOLLOW_NONE, 
											B_WILL_DRAW | B_NAVIGABLE,
											stringEntryPixWidth);
		nameStrGadget->SetFont(myPrefs->GetPreferredFont());
		nameStrGadget->bmMakeFocus = true;
		pNameLayoutMatrix->AddToChildren(nameStrGadget);
		auto_ptr<LayoutMatrixItem> apNameLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																				(void *)nameStrGadget, 
																				pNameLayoutMatrix->itemsList,
																				KIND_STRINGGADG));
																				
/////////////////////////////////////////////
		LayoutMatrix *	pMinLayoutMatrix = new LayoutMatrix(&bw, SAMESIZE, 13, 1);//rows,columns
		AddToLayoutMatrixList(pMinLayoutMatrix);
////////////////
		char intGadgetBuf[16];
		//debug must check for current and if then set min's and max's to those values
		//if !current use general as ir has all defaults built in
		float ftemp;
		float maxStrWidth = bv.StringWidth(SofLStr);
		ftemp = bv.StringWidth(PropFuelUseStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(PropAccelStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(FTLFuelUseStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(FTLAccelStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(InstFuelUseStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(ElectronMassStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(ProtonMassStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(NeutronMassStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(NumGalaxyStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(WidthStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(HeightStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(DepthStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(maxStr);//re-use this for all the Max:s
		bv.RemoveSelf();
		UniversalConstants * uc;
		if (!universalConstantsCurrent) 
		{
			uc = universalConstants;
		}
		else
		{
			uc = universalConstantsCurrent;
		}
		sprintf(intGadgetBuf, "%u", uc->enteredMinWidth);
		BMessage * pMinWidthMsg = new BMessage(MINWIDTH);
		enteredMinWidthGadget = new IntGadget(	BRect(10, 100, 300, 110), 
												"MinWidth", 
												WidthStr, 
												intGadgetBuf, 
												pMinWidthMsg,  
												B_FOLLOW_NONE, 
												B_WILL_DRAW | B_NAVIGABLE,
												maxStrWidth);
		pMinLayoutMatrix->AddToChildren((void *)enteredMinWidthGadget);
		enteredMinWidthGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMinWidthIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMinWidthGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
//////////////////////////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMinHeight);
		BMessage * pMinHeightMsg = new BMessage(MINHEIGHT);
		enteredMinHeightGadget = new IntGadget(	BRect(10, 100, 300, 110), 
														"MinHeight", 
														HeightStr, 
														intGadgetBuf, 
														pMinHeightMsg,  
														B_FOLLOW_NONE, 
														B_WILL_DRAW | B_NAVIGABLE,
														maxStrWidth);
		pMinLayoutMatrix->AddToChildren((void *)enteredMinHeightGadget);
		enteredMinHeightGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMinHeightIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMinHeightGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
//////////////////////////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMinDepth);
		BMessage * pMinDepthMsg = new BMessage(MINDEPTH);
		enteredMinDepthGadget = new IntGadget(	BRect(10, 100, 300, 110), 
												"MinDepth", 
												DepthStr, 
												intGadgetBuf, 
												pMinDepthMsg,  
												B_FOLLOW_NONE, 
												B_WILL_DRAW | B_NAVIGABLE,
												maxStrWidth);
		pMinLayoutMatrix->AddToChildren((void *)enteredMinDepthGadget);
		enteredMinDepthGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMinDepthIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMinDepthGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
//////////////////////////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMinSofL);
		BMessage * pMinSofLMsg = new BMessage(MINSOFL);
		enteredMinSofLGadget = new IntGadget(	BRect(10, 100, 300, 110), 
												"MinSofL", 
												SofLStr, 
												intGadgetBuf, 
												pMinSofLMsg,  
												B_FOLLOW_NONE, 
												B_WILL_DRAW | B_NAVIGABLE,
												maxStrWidth);
		pMinLayoutMatrix->AddToChildren((void *)enteredMinSofLGadget);
		enteredMinSofLGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMinSofLIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMinSofLGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMinPropFuelUse);
		BMessage * pMinPropFuelUseMsg = new BMessage(MINPROPFUELUSE);
		enteredMinPropFuelUseGadget = new IntGadget(	BRect(10, 100, 300, 110), 
														"MinPropFuelUse", 
														PropFuelUseStr, 
														intGadgetBuf, 
														pMinPropFuelUseMsg,  
														B_FOLLOW_NONE, 
														B_WILL_DRAW | B_NAVIGABLE,
														maxStrWidth);
		pMinLayoutMatrix->AddToChildren((void *)enteredMinPropFuelUseGadget);
		enteredMinPropFuelUseGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMinPropFuelUseIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMinPropFuelUseGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMinPropAccel);
		BMessage * pMinPropAccelMsg = new BMessage(MINPROPACCEL);
		enteredMinPropAccelGadget = new IntGadget(	BRect(10, 100, 300, 110), 
														"MinPropAccel", 
														PropAccelStr, 
														intGadgetBuf, 
														pMinPropAccelMsg,  
														B_FOLLOW_NONE, 
														B_WILL_DRAW | B_NAVIGABLE,
														maxStrWidth);
		pMinLayoutMatrix->AddToChildren((void *)enteredMinPropAccelGadget);
		enteredMinPropAccelGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMinPropAccelIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMinPropAccelGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMinFTLFuelUse);
		BMessage * pMinFTLFuelUseMsg = new BMessage(MINFTLFUELUSE);
		enteredMinFTLFuelUseGadget = new IntGadget(	BRect(10, 100, 300, 110), 
														"MinFTLFuelUse", 
														FTLFuelUseStr, 
														intGadgetBuf, 
														pMinFTLFuelUseMsg,  
														B_FOLLOW_NONE, 
														B_WILL_DRAW | B_NAVIGABLE,
														maxStrWidth);
		pMinLayoutMatrix->AddToChildren((void *)enteredMinFTLFuelUseGadget);
		enteredMinFTLFuelUseGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMinFTLFuelUseIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMinFTLFuelUseGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMinFTLAccel);
		BMessage * pMinFTLAccelMsg = new BMessage(MINFTLACCEL);
		enteredMinFTLAccelGadget = new IntGadget(	BRect(10, 100, 300, 110), 
													"MinFTLAccel", 
													FTLAccelStr, 
													intGadgetBuf, 
													pMinFTLAccelMsg,  
													B_FOLLOW_NONE, 
													B_WILL_DRAW | B_NAVIGABLE,
													maxStrWidth);
		pMinLayoutMatrix->AddToChildren((void *)enteredMinFTLAccelGadget);
		enteredMinFTLAccelGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMinFTLAccelIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMinFTLAccelGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMinInstFuelUse);
		BMessage * pMinInstFuelUseMsg = new BMessage(MININSTFUELUSE);
		enteredMinInstFuelUseGadget = new IntGadget(	BRect(10, 100, 300, 110), 
														"MinInstFuelUse", 
														InstFuelUseStr, 
														intGadgetBuf, 
														pMinInstFuelUseMsg,  
														B_FOLLOW_NONE, 
														B_WILL_DRAW | B_NAVIGABLE,
														maxStrWidth);
		pMinLayoutMatrix->AddToChildren((void *)enteredMinInstFuelUseGadget);
		enteredMinInstFuelUseGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMinInstFuelUseIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMinInstFuelUseGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
/////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMinElectronMass);
		BMessage * pMinElectronMassMsg = new BMessage(MINELECTRONMASS);
		enteredMinElectronMassGadget = new IntGadget(	BRect(10, 100, 300, 110), 
														"MinElectronMass", 
														ElectronMassStr, 
														intGadgetBuf, 
														pMinElectronMassMsg,  
														B_FOLLOW_NONE, 
														B_WILL_DRAW | B_NAVIGABLE,
														maxStrWidth);
		pMinLayoutMatrix->AddToChildren((void *)enteredMinElectronMassGadget);
		enteredMinElectronMassGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMinElectronMassIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMinElectronMassGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
//////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMinNeutronMass);
		BMessage * pMinNeutronMassMsg = new BMessage(MINNEUTRONMASS);
		enteredMinNeutronMassGadget = new IntGadget(	BRect(10, 100, 300, 110), 
														"MinNeutronMass", 
														NeutronMassStr, 
														intGadgetBuf, 
														pMinNeutronMassMsg,  
														B_FOLLOW_NONE, 
														B_WILL_DRAW | B_NAVIGABLE,
														maxStrWidth);
		pMinLayoutMatrix->AddToChildren((void *)enteredMinNeutronMassGadget);
		enteredMinNeutronMassGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMinNeutronMassIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMinNeutronMassGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
/////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMinProtonMass);
		BMessage * pMinProtonMassMsg = new BMessage(MINPROTONMASS);
		enteredMinProtonMassGadget = new IntGadget(	BRect(10, 100, 300, 110), 
													"MinProtonMass", 
													ProtonMassStr, 
													intGadgetBuf, 
													pMinProtonMassMsg,  
													B_FOLLOW_NONE, 
													B_WILL_DRAW | B_NAVIGABLE,
													maxStrWidth);
		pMinLayoutMatrix->AddToChildren((void *)enteredMinProtonMassGadget);
		enteredMinProtonMassGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMinProtonMassIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMinProtonMassGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMinNumGalaxy);
		BMessage * pMinNumGalaxyMsg = new BMessage(MINNUMGALAXY);
		enteredMinNumGalaxyGadget = new IntGadget(	BRect(10, 100, 300, 110), 
													"MinNumGalaxy", 
													NumGalaxyStr, 
													intGadgetBuf, 
													pMinNumGalaxyMsg,  
													B_FOLLOW_NONE, 
													B_WILL_DRAW | B_NAVIGABLE,
													maxStrWidth);
		pMinLayoutMatrix->AddToChildren((void *)enteredMinNumGalaxyGadget);
		enteredMinNumGalaxyGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMinNumGalaxyIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMinNumGalaxyGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
/////////////////////////////////////////////////////////////////
		LayoutMatrix *	pMaxLayoutMatrix = new LayoutMatrix(&bw, SAMESIZE, 13, 1);//rows,columns
		AddToLayoutMatrixList(pMaxLayoutMatrix);
////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMaxWidth);
		BMessage * pMaxWidthMsg = new BMessage(MAXWIDTH);
		enteredMaxWidthGadget = new IntGadget(	BRect(10, 100, 300, 110), 
												"MaxWidth", 
												maxStr, 
												intGadgetBuf, 
												pMaxWidthMsg,  
												B_FOLLOW_NONE, 
												B_WILL_DRAW | B_NAVIGABLE,
												ftemp);
		pMaxLayoutMatrix->AddToChildren((void *)enteredMaxWidthGadget);
		enteredMaxWidthGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMaxWidthIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMaxWidthGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
//////////////////////////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMaxHeight);
		BMessage * pMaxHeightMsg = new BMessage(MAXHEIGHT);
		enteredMaxHeightGadget = new IntGadget(	BRect(10, 100, 300, 110), 
												"MaxHeight", 
												maxStr, 
												intGadgetBuf, 
												pMaxHeightMsg,  
												B_FOLLOW_NONE, 
												B_WILL_DRAW | B_NAVIGABLE,
												ftemp);
		pMaxLayoutMatrix->AddToChildren((void *)enteredMaxHeightGadget);
		enteredMaxHeightGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMaxHeightIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMaxHeightGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
//////////////////////////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMaxDepth);
		BMessage * pMaxDepthMsg = new BMessage(MAXDEPTH);
		enteredMaxDepthGadget = new IntGadget(	BRect(10, 100, 300, 110), 
												"MaxDepth", 
												maxStr, 
												intGadgetBuf, 
												pMaxDepthMsg,  
												B_FOLLOW_NONE, 
												B_WILL_DRAW | B_NAVIGABLE,
												ftemp);
		pMaxLayoutMatrix->AddToChildren((void *)enteredMaxDepthGadget);
		enteredMaxDepthGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMaxDepthIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMaxDepthGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
//////////////////////////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMaxSofL);
		BMessage * pMaxSofLMsg = new BMessage(MAXSOFL);
		enteredMaxSofLGadget = new IntGadget(	BRect(10, 100, 300, 110), 
												"MaxSofL", 
												maxStr, 
												intGadgetBuf, 
												pMaxSofLMsg,  
												B_FOLLOW_NONE, 
												B_WILL_DRAW | B_NAVIGABLE,
												ftemp);
		pMaxLayoutMatrix->AddToChildren((void *)enteredMaxSofLGadget);
		enteredMaxSofLGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMaxSofLIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMaxSofLGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMaxPropFuelUse);
		BMessage * pMaxPropFuelUseMsg = new BMessage(MAXPROPFUELUSE);
		enteredMaxPropFuelUseGadget = new IntGadget(	BRect(10, 100, 300, 110), 
														"MaxPropFuelUse", 
														maxStr, 
														intGadgetBuf, 
														pMaxPropFuelUseMsg,  
														B_FOLLOW_NONE, 
														B_WILL_DRAW | B_NAVIGABLE,
														ftemp);
		pMaxLayoutMatrix->AddToChildren((void *)enteredMaxPropFuelUseGadget);
		enteredMaxPropFuelUseGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMaxPropFuelUseIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMaxPropFuelUseGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMaxPropAccel);
		BMessage * pMaxPropAccelMsg = new BMessage(MAXPROPACCEL);
		enteredMaxPropAccelGadget = new IntGadget(	BRect(10, 100, 300, 110), 
													"MaxPropAccel", 
													maxStr, 
													intGadgetBuf, 
													pMaxPropAccelMsg,  
													B_FOLLOW_NONE, 
													B_WILL_DRAW | B_NAVIGABLE,
													ftemp);
		pMaxLayoutMatrix->AddToChildren((void *)enteredMaxPropAccelGadget);
		enteredMaxPropAccelGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMaxPropAccelIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMaxPropAccelGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMaxFTLFuelUse);
		BMessage * pMaxFTLFuelUseMsg = new BMessage(MAXFTLFUELUSE);
		enteredMaxFTLFuelUseGadget = new IntGadget(	BRect(10, 100, 300, 110), 
													"MaxFTLFuelUse", 
													maxStr, 
													intGadgetBuf, 
													pMaxFTLFuelUseMsg,  
													B_FOLLOW_NONE, 
													B_WILL_DRAW | B_NAVIGABLE,
													ftemp);
		pMaxLayoutMatrix->AddToChildren((void *)enteredMaxFTLFuelUseGadget);
		enteredMaxFTLFuelUseGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMaxFTLFuelUseIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMaxFTLFuelUseGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMaxFTLAccel);
		BMessage * pMaxFTLAccelMsg = new BMessage(MAXFTLACCEL);
		enteredMaxFTLAccelGadget = new IntGadget(	BRect(10, 100, 300, 110), 
													"MaxFTLAccel", 
													maxStr, 
													intGadgetBuf, 
													pMaxFTLAccelMsg,  
													B_FOLLOW_NONE, 
													B_WILL_DRAW | B_NAVIGABLE,
													ftemp);
		pMaxLayoutMatrix->AddToChildren((void *)enteredMaxFTLAccelGadget);
		enteredMaxFTLAccelGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMaxFTLAccelIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMaxFTLAccelGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMaxInstFuelUse);
		BMessage * pMaxInstFuelUseMsg = new BMessage(MAXINSTFUELUSE);
		enteredMaxInstFuelUseGadget = new IntGadget(	BRect(10, 100, 300, 110), 
														"MaxInstFuelUse", 
														maxStr, 
														intGadgetBuf, 
														pMaxInstFuelUseMsg,  
														B_FOLLOW_NONE, 
														B_WILL_DRAW | B_NAVIGABLE,
														ftemp);
		pMaxLayoutMatrix->AddToChildren((void *)enteredMaxInstFuelUseGadget);
		enteredMaxInstFuelUseGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMaxInstFuelUseIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMaxInstFuelUseGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
/////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMaxElectronMass);
		BMessage * pMaxElectronMassMsg = new BMessage(MAXELECTRONMASS);
		enteredMaxElectronMassGadget = new IntGadget(	BRect(10, 100, 300, 110), 
														"MaxElectronMass", 
														maxStr, 
														intGadgetBuf, 
														pMaxElectronMassMsg,  
														B_FOLLOW_NONE, 
														B_WILL_DRAW | B_NAVIGABLE,
														ftemp);
		pMaxLayoutMatrix->AddToChildren((void *)enteredMaxElectronMassGadget);
		enteredMaxElectronMassGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMaxElectronMassIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMaxElectronMassGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
//////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMaxNeutronMass);
		BMessage * pMaxNeutronMassMsg = new BMessage(MAXNEUTRONMASS);
		enteredMaxNeutronMassGadget = new IntGadget(	BRect(10, 100, 300, 110), 
														"MaxNeutronMass", 
														maxStr, 
														intGadgetBuf, 
														pMaxNeutronMassMsg,  
														B_FOLLOW_NONE, 
														B_WILL_DRAW | B_NAVIGABLE,
														ftemp);
		pMaxLayoutMatrix->AddToChildren((void *)enteredMaxNeutronMassGadget);
		enteredMaxNeutronMassGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMaxNeutronMassIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMaxNeutronMassGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
/////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMaxProtonMass);
		BMessage * pMaxProtonMassMsg = new BMessage(MAXPROTONMASS);
		enteredMaxProtonMassGadget = new IntGadget(	BRect(10, 100, 300, 110), 
													"MaxProtonMass", 
													maxStr, 
													intGadgetBuf, 
													pMaxProtonMassMsg,  
													B_FOLLOW_NONE, 
													B_WILL_DRAW | B_NAVIGABLE,
													ftemp);
		pMaxLayoutMatrix->AddToChildren((void *)enteredMaxProtonMassGadget);
		enteredMaxProtonMassGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMaxProtonMassIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMaxProtonMassGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		sprintf(intGadgetBuf, "%u", uc->enteredMaxNumGalaxy);
		BMessage * pMaxNumGalaxyMsg = new BMessage(MAXNUMGALAXY);
		enteredMaxNumGalaxyGadget = new IntGadget(	BRect(10, 100, 300, 110), 
													"MaxNumGalaxy", 
													maxStr, 
													intGadgetBuf, 
													pMaxNumGalaxyMsg,  
													B_FOLLOW_NONE, 
													B_WILL_DRAW | B_NAVIGABLE,
													ftemp);
		pMaxLayoutMatrix->AddToChildren((void *)enteredMaxNumGalaxyGadget);
		enteredMaxNumGalaxyGadget->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apMaxNumGalaxyIntGadgetLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)enteredMaxNumGalaxyGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////
		uint32 picKind = UNIVERSALCONSTANTSPICKIND;
		#include "bottomLine.source"
		//debug must check next&prev
		thisDNPtr = dataListGlobal[UNIVERSALCONSTANTS_TYPE]->NextPrevItems(	(void *)universalConstantsCurrent, 
																			&nextDNPtr, 
																			&prevDNPtr, 
																			pBottomButtons);
		if (!prevDNPtr)
		{
			pBottomButtons->prev->SetEnabled(false);
		}
		if (!nextDNPtr)
		{
			pBottomButtons->next->SetEnabled(false);
		}
		if (!prevDNPtr && !nextDNPtr)
		{
			pBottomButtons->list->SetEnabled(false);
		}
		if (!dataListGlobal[UNIVERSALCONSTANTS_TYPE]->list->CountItems()) 
		{
			pBottomButtons->remove->SetEnabled(false);
		}
/////////////////////////////////
		release_sem(calc_sem);
		pNameLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, MATRIXVERTICALOFFSET, calc_sem);
		pMinLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, pNameLayoutMatrix->bottom, calc_sem);
		pMaxLayoutMatrix->Calc(pMinLayoutMatrix->right, pNameLayoutMatrix->bottom, calc_sem);
		pBottomLineLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, pMaxLayoutMatrix->bottom, calc_sem);
	}
	catch (...)
	{
		warning("gccpCaughtUniversalConstantsWindowCTOR");
		release_sem(calc_sem);
		throw;
	}
	try 
	{
		BMenuItem *	menuItem;
		BMenu * APPMenu = new BMenu(gccpAppMenuLable);
		BMessage * aboutMsg = new BMessage(ABOUT_UNIVERSALCONSTANTSWINDOW);
		menuItem = new BMenuItem(	gccpAboutMenuLable, 
									aboutMsg);
		APPMenu->AddItem(menuItem);
		BMessage * prefMsg = new BMessage(PREFSMSG);
		menuItem = new BMenuItem(	gccpPreferenceMenuLable, 
									prefMsg);
		APPMenu->AddItem(menuItem);
		BMessage * closeMsg = new BMessage(B_QUIT_REQUESTED);
		menuItem = new BMenuItem(	gccpCloseWindow, 
									closeMsg);
		APPMenu->AddItem(menuItem);
		BMessage * quitMsg = new BMessage(QUIT_APP);
		menuItem = new BMenuItem(	gccpQuitMenuLable, 
									quitMsg);
		APPMenu->AddItem(menuItem);
		pMenuBar->AddItem(APPMenu);
	}
	catch(...) 
	{
		throw;
	}
	if (myApp->pEditUniverseWindow) 
	{
		if (myApp->pEditUniverseWindow->LockLooper())
		{
			myApp->pEditUniverseWindow->buttons[NUM_DFLT_UNIVERSALCONSTANTS]->SetEnabled(false);
			myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->SetEnabled(false);
			myApp->pEditUniverseWindow->buttons[NUM_LOAD_UNIVERSALCONSTANTS]->SetEnabled(false);
			myApp->pEditUniverseWindow->UnlockLooper();
		}
	}
	if (!universalConstantsCurrent) 
	{
		if (dataListGlobal[UNIVERSALCONSTANTS_TYPE]->list->CountItems()) 
		{
			universalConstantsCurrent = (UniversalConstants *)((DataNode *)dataListGlobal[UNIVERSALCONSTANTS_TYPE]->list->ItemAt(0))->data;
		}
	}
}//end


EditUniversalConstantsWindow	::	~EditUniversalConstantsWindow() 
{
	if (savePanel)
	{
		delete savePanel;
	}
	if (saveMessenger)
	{
		delete saveMessenger;
	}
	if (loadPanel)
	{
		delete loadPanel;
	}
	if (loadMessenger)
	{
		delete loadMessenger;
	}
	if (enteredMinWidthGadget) 
	{
		enteredMinWidthGadget->RemoveSelf();
		delete enteredMinWidthGadget;
	}
	if (enteredMaxWidthGadget) 
	{
		enteredMaxWidthGadget->RemoveSelf();
		delete enteredMaxWidthGadget;
	}
	if (enteredMinHeightGadget) 
	{
		enteredMinHeightGadget->RemoveSelf();
		delete enteredMinHeightGadget;
	}
	if (enteredMaxHeightGadget) 
	{
		enteredMaxHeightGadget->RemoveSelf();
		delete enteredMaxHeightGadget;
	}
	if (enteredMinDepthGadget) 
	{
		enteredMinDepthGadget->RemoveSelf();
		delete enteredMinDepthGadget;
	}
	if (enteredMaxDepthGadget) 
	{
		enteredMaxDepthGadget->RemoveSelf();
		delete enteredMaxDepthGadget;
	}
	if (enteredMinSofLGadget) 
	{
		enteredMinSofLGadget->RemoveSelf();
		delete enteredMinSofLGadget;
	}
	if (enteredMaxSofLGadget) 
	{
		enteredMaxSofLGadget->RemoveSelf();
		delete enteredMaxSofLGadget;
	}
	if (enteredMinPropFuelUseGadget) 
	{
		enteredMinPropFuelUseGadget->RemoveSelf();
		delete enteredMinPropFuelUseGadget;
	}
	if (enteredMaxPropFuelUseGadget) 
	{
		enteredMaxPropFuelUseGadget->RemoveSelf();
		delete enteredMaxPropFuelUseGadget;
	}
	if (enteredMinPropAccelGadget) 
	{
		enteredMinPropAccelGadget->RemoveSelf();
		delete enteredMinPropAccelGadget;
	}
	if (enteredMaxPropAccelGadget) 
	{
		enteredMaxPropAccelGadget->RemoveSelf();
		delete enteredMaxPropAccelGadget;
	}
	if (enteredMinFTLFuelUseGadget) 
	{
		enteredMinFTLFuelUseGadget->RemoveSelf();
		delete enteredMinFTLFuelUseGadget;
	}
	if (enteredMaxFTLFuelUseGadget) 
	{
		enteredMaxFTLFuelUseGadget->RemoveSelf();
		delete enteredMaxFTLFuelUseGadget;
	}
	if (enteredMinFTLAccelGadget) 
	{
		enteredMinFTLAccelGadget->RemoveSelf();
		delete enteredMinFTLAccelGadget;
	}
	if (enteredMaxFTLAccelGadget) 
	{
		enteredMaxFTLAccelGadget->RemoveSelf();
		delete enteredMaxFTLAccelGadget;
	}
	if (enteredMinInstFuelUseGadget) 
	{
		enteredMinInstFuelUseGadget->RemoveSelf();
		delete enteredMinInstFuelUseGadget;
	}
	if (enteredMaxInstFuelUseGadget) 
	{
		enteredMaxInstFuelUseGadget->RemoveSelf();
		delete enteredMaxInstFuelUseGadget;
	}
	if (enteredMinElectronMassGadget) 
	{
		enteredMinElectronMassGadget->RemoveSelf();
		delete enteredMinElectronMassGadget;
	}
	if (enteredMaxElectronMassGadget) 
	{
		enteredMaxElectronMassGadget->RemoveSelf();
		delete enteredMaxElectronMassGadget;
	}
	if (enteredMinNeutronMassGadget) 
	{
		enteredMinNeutronMassGadget->RemoveSelf();
		delete enteredMinNeutronMassGadget;
	}
	if (enteredMaxNeutronMassGadget) 
	{
		enteredMaxNeutronMassGadget->RemoveSelf();
		delete enteredMaxNeutronMassGadget;
	}
	if (enteredMinProtonMassGadget) 
	{
		enteredMinProtonMassGadget->RemoveSelf();
		delete enteredMinProtonMassGadget;
	}
	if (enteredMaxProtonMassGadget) 
	{
		enteredMaxProtonMassGadget->RemoveSelf();
		delete enteredMaxProtonMassGadget;
	}
	if (enteredMinNumGalaxyGadget) 
	{
		enteredMinNumGalaxyGadget->RemoveSelf();
		delete enteredMinNumGalaxyGadget;
	}
	if (enteredMaxNumGalaxyGadget) 
	{
		enteredMaxNumGalaxyGadget->RemoveSelf();
		delete enteredMaxNumGalaxyGadget;
	}
	if (myApp->pEditUniverseWindow) 
	{
		if (myApp->pEditUniverseWindow->LockLooper())
		{
			myApp->pEditUniverseWindow->buttons[NUM_DFLT_UNIVERSALCONSTANTS]->SetEnabled(true);
			myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->SetEnabled(true);
			myApp->pEditUniverseWindow->buttons[NUM_LOAD_UNIVERSALCONSTANTS]->SetEnabled(true);
			myApp->pEditUniverseWindow->UnlockLooper();
		}
	}
	if (pBottomButtons)
	{
		delete pBottomButtons;
	}
	myApp->pEditUniversalConstantsWindow = NULL;
}

void 
EditUniversalConstantsWindow	::	MessageReceived(	BMessage *message) 
{
	bool validate = strcmp(nameStrGadget->Text(), "");
	BWindow * panelWindow;
	switch (message->what) 
	{
		case LOADFROMPANEL:	
		{
			entry_ref ref;
			int32 numUniversalConstants;
			if (message->FindRef("refs", &ref) >= B_OK) 
			{
				BFile file(&ref, B_READ_ONLY);
				status_t fileStatus;
				if ((fileStatus = file.InitCheck()) == B_NO_ERROR) 
				{
					if (!StripFileHeaderPre(&file)) 
					{
						warning(noLoad);
						return;
					}
					if (!StripFileHeader(	UNIVERSALCONSTANTS_TYPE, 
											&file, 
											&numUniversalConstants)) 
					{
						warning(noLoad);
						return;
					}
					if (!(universalConstants->Load(&file))) 
					{
						warning(noLoad);
					}
					else 
					{
						universalConstantsCurrent = universalConstants;
						nameStrGadget->SetText(universalConstantsCurrent->name);
						FillStrGadgets();
						thisDNPtr = dataListGlobal[UNIVERSALCONSTANTS_TYPE]->NextPrevItems(	(void *)universalConstantsCurrent, 
																							&nextDNPtr, 
																							&prevDNPtr, 
																							pBottomButtons);
					}
				}
				else warning("debug oops InitCheck");
			}
			else warning("debug oops findref");
		break;
		}
		case BLLOAD:
			if (!loadPanel) 
			{
				try 
				{
					loadMessenger = new BMessenger(this);
				}
				catch (...) 
				{
					warning(gccpFailMemory);
					loadMessenger = NULL;
					return;
				}
				try 
				{
					loadPanel = new BFilePanel(	B_OPEN_PANEL, 
												loadMessenger, 
												NULL, 
												B_FILE_NODE, 
												false, 
												new BMessage(LOADFROMPANEL), 
												NULL, 
												false, 
												true);
					
					panelWindow = loadPanel->Window();
					panelWindow->SetTitle(gccpOpenUC);
					loadPanel->Show();
				}
				catch (...) 
				{
					warning(gccpFailMemory);
					loadPanel = NULL;
					return;
				}
			}
			else loadPanel->Show();
		break;
		case SAVEFROMPANEL: 
		{
			if (validate)
			{
				if (ValidateUniversalConstants())
				{
					UpdateUniversalConstants();
					entry_ref ref;
					const char * fileName;
					if (message->FindRef("directory", &ref) >= B_OK) 
					{
						if (message->FindString("name", &fileName) >= B_OK) 
						{
							BFile file;
							BDirectory dir = BDirectory(&ref);
							//debug ask to overwrite???
							status_t result = file.SetTo(	&dir, 
															fileName, 
															B_WRITE_ONLY | B_CREATE_FILE | B_ERASE_FILE);
							if (result >= B_OK) 
							{
								if (!PutFileHeaderPre(&file)) 
								{
									return;
								}
								if (!PutFileHeader(UNIVERSALCONSTANTS_TYPE, 1, &file)) 
								{
									return;
								}
								if (!(universalConstants->Save(&file))) 
								{
									warning(nothingToSave[UNIVERSALCONSTANTS_TYPE]);
									return;
								}
								return;
							}
							else 
							{
								warning("debug oops file.setto");
							}
						}
						else 
						{
							warning("debug oops name");
						}
					}
					else 
					{
						warning("debug oops dir");
					}
				}
			}
			else
			{
				warning(gccpNeedNameToKeep);
			}
		break;
		}
		case BLSAVE:
			if (validate)
			{
				if (!savePanel) 
				{
					try 
					{
						saveMessenger = new BMessenger(this);
					}
					catch (...) 
					{
						warning(gccpFailMemory);
						saveMessenger = NULL;
						return;
					}
					try 
					{
						savePanel = new BFilePanel(	B_SAVE_PANEL, 
													saveMessenger, 
													NULL, 
													B_FILE_NODE, 
													false, 
													new BMessage(SAVEFROMPANEL), 
													NULL, 
													false, 
													true);
						savePanel->Show();
					}
					catch (...) 
					{
						warning(gccpFailMemory);
						savePanel = NULL;
						return;
					}
				}
				else 
				{
					savePanel->Show();
				}
			}
			else
			{
				warning(gccpNeedNameToKeep);
			}
		break;
		case MINWIDTH:
		case MINHEIGHT:
		case MINDEPTH:
		case MINSOFL:
		case MINPROPFUELUSE:
		case MINPROPACCEL:
		case MINFTLFUELUSE:
		case MINFTLACCEL:
		case MININSTFUELUSE:
		case MINELECTRONMASS:
		case MINNEUTRONMASS:
		case MINPROTONMASS:
		case MINNUMGALAXY:
		case MAXWIDTH:
		case MAXHEIGHT:
		case MAXDEPTH:
		case MAXSOFL:
		case MAXPROPFUELUSE:
		case MAXPROPACCEL:
		case MAXFTLFUELUSE:
		case MAXFTLACCEL:
		case MAXINSTFUELUSE:
		case MAXELECTRONMASS:
		case MAXNEUTRONMASS:
		case MAXPROTONMASS:
		case MAXNUMGALAXY:
			//debug no need to do anything really, but might want to validate??
		break;
		case PREFSMSG:
		{
			myPrefs->OpenPreferencesPanel();
		break;
		}
		case BLREMOVE:
			dataListGlobal[UNIVERSALCONSTANTS_TYPE]->Remove();
			Quit();
		break;
		case BLLIST:
			if (!mpListViewWindow)
			{
				try 
				{
					BRect holdRect;
					myPrefs->GetPreferredListViewWindowRect(&holdRect);
					mpListViewWindow = new ListViewWindow(	holdRect,
															lvWindowTitleStr[UNIVERSALCONSTANTS_TYPE],
															"ListViewView",
															"ListViewWindowFrame",
															NULL,
															dataListGlobal[UNIVERSALCONSTANTS_TYPE], 
															nameStrGadget->Text(),
															this,
															LISTVIEWSELECTONE);
					if (err == NO_ERR)
					{
						mpListViewWindow->Initialize();
						pBottomButtons->list->SetEnabled(false);
					}
				}
				catch (...) 
				{
					warning(gccpFailListViewWindow);
					myApp->PostMessage(B_QUIT_REQUESTED);
					throw;
				}
			}
			else 
			{
				warning(gccpOnlyOneListView);
			}
		break;
		case BLLISTGOT:
			if (LockLooper())
			{
				if (validate) 
				{
					if (UniqueName(dataListGlobal[UNIVERSALCONSTANTS_TYPE], nameStrGadget->Text()))
					{
						validate = false;
						if (ValidateUniversalConstants())
						{
							if (AddUniversalConstants()) 
							{
								validate = true;
							}
						}
					}
					else
					{
						if (strcmp(nameStrGadget->Text(), universalConstantsCurrent->name))
						{
							validate = false;
							if (ValidateUniversalConstants())
							{
								if (UpdateUniversalConstants()) 
								{
									validate = true;
								}
							}
						}
					}
				}
				else
				{
					validate = true;
				}
				if (validate)
				{
					universalConstantsCurrent = universalConstantsNewCurrent;
					nameStrGadget->SetText(universalConstantsCurrent->name);
					FillStrGadgets();
					thisDNPtr = dataListGlobal[UNIVERSALCONSTANTS_TYPE]->NextPrevItems(	(void *)universalConstantsCurrent, 
																						&nextDNPtr, 
																						&prevDNPtr, 
																						pBottomButtons);
				}
				if (mpListViewWindow)
				{
					mpListViewWindow->PostMessage(B_QUIT_REQUESTED);
				}
				pBottomButtons->list->SetEnabled(true);
				UnlockLooper();
			}
			else
			{
				warning(gccpFailLockLooper);
			}
		break;
		case BLPREVIOUS:
		{
			if (validate) 
			{
				if (UniqueName(dataListGlobal[UNIVERSALCONSTANTS_TYPE], nameStrGadget->Text()))
				{
					validate = false;
					if (ValidateUniversalConstants())
					{
						if (AddUniversalConstants()) 
						{
							validate = true;
						}
					}
				}
				else
				{
					if (strcmp(nameStrGadget->Text(), universalConstantsCurrent->name))
					{
						validate = false;
						if (ValidateUniversalConstants())
						{
							if (UpdateUniversalConstants()) 
							{
								validate = true;
							}
						}
					}
				}
			}
			else
			{
				validate = true;
			}
			if (validate)
			{
				UniversalConstants * prevUniversalConstants = (UniversalConstants *)((DataNode *)prevDNPtr)->data;
				universalConstantsCurrent = prevUniversalConstants;
				nameStrGadget->SetText(universalConstantsCurrent->name);
				thisDNPtr = dataListGlobal[UNIVERSALCONSTANTS_TYPE]->NextPrevItems(	(void *)universalConstantsCurrent, 
																					&nextDNPtr, 
																					&prevDNPtr, 
																					pBottomButtons);
				FillStrGadgets();
				if (myApp->pEditUniverseWindow->LockLooper())
				{
					string newLabel = editThe[UNIVERSALCONSTANTS_TYPE];
					newLabel += nameStrGadget->Text();
					myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->SetLabel(newLabel.c_str());
					myApp->pEditUniverseWindow->UnlockLooper();
				}
				if (dataListGlobal[UNIVERSALCONSTANTS_TYPE]->list->CountItems() > 1) 
				{
					pBottomButtons->list->SetEnabled(true);
				}
				else
				{
					pBottomButtons->list->SetEnabled(false);
				}
			}
		break;
		}
		case BLDONE:
			if (validate) 
			{
				if (UniqueName(dataListGlobal[UNIVERSALCONSTANTS_TYPE], nameStrGadget->Text()))
				{
					validate = false;
					if (ValidateUniversalConstants())
					{
						if (AddUniversalConstants()) 
						{
							validate = true;
						}
					}
				}
				else
				{
					if (strcmp(nameStrGadget->Text(), universalConstantsCurrent->name))
					{
						validate = false;
						warning(gccpWrongName);
						nameStrGadget->SetText(universalConstantsCurrent->name);
					}
					else
					{
						validate = false;
						if (ValidateUniversalConstants())
						{
							if (UpdateUniversalConstants())
							{
								validate = true;
							}
						}
					}
				}
				if (validate)
				{
					if (myApp->pEditUniverseWindow->LockLooper())
					{
						string newLabel = editThe[UNIVERSALCONSTANTS_TYPE];
						newLabel += nameStrGadget->Text();
						myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->SetLabel(newLabel.c_str());
						myApp->pEditUniverseWindow->pBottomButtons->save->SetEnabled(true);
						myApp->pEditUniverseWindow->UnlockLooper();
					}
					if (myApp->pTitleWindow->LockLooper())
					{
						myApp->pTitleWindow->pSaveButton->SetEnabled(true);
						myApp->pTitleWindow->pRealButton->SetEnabled(true);
						myApp->pTitleWindow->UnlockLooper();
					}
					Quit();
				}
			}
			else
			{
				Quit();
			}
		break;
		case BLNEW:
			if (validate) 
			{
				if (UniqueName(dataListGlobal[UNIVERSALCONSTANTS_TYPE], nameStrGadget->Text()))
				{
					if (ValidateUniversalConstants())
					{
						if (AddUniversalConstants()) 
						{
							if( myApp->pEditUniverseWindow->LockLooper())
							{
								string newLabel = editThe[UNIVERSALCONSTANTS_TYPE];
								newLabel += nameStrGadget->Text();
								myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->SetLabel(newLabel.c_str());
								myApp->pEditUniverseWindow->pBottomButtons->save->SetEnabled(true);
								myApp->pEditUniverseWindow->UnlockLooper();
							}
							if (myApp->pTitleWindow->LockLooper())
							{
								myApp->pTitleWindow->pSaveButton->SetEnabled(true);
								myApp->pTitleWindow->pRealButton->SetEnabled(true);
								myApp->pTitleWindow->UnlockLooper();
							}
							nameStrGadget->SetText("");
							nameStrGadget->MakeFocus();
							pBottomButtons->prev->SetEnabled(true);
							if (dataListGlobal[UNIVERSALCONSTANTS_TYPE]->list->CountItems() > 1) 
							{
								pBottomButtons->list->SetEnabled(true);
							}
							else
							{
								pBottomButtons->list->SetEnabled(false);
							}
						}
					}
				}
				else
				{
					if (UpdateUniversalConstants())
					{
						nameStrGadget->SetText("");
						nameStrGadget->MakeFocus();
						pBottomButtons->prev->SetEnabled(false);
						pBottomButtons->next->SetEnabled(false);
					}
				}
			}
		break;
		case BLADD:
			if (validate) 
			{
				if (UniqueName(dataListGlobal[UNIVERSALCONSTANTS_TYPE], nameStrGadget->Text()))
				{
					if (ValidateUniversalConstants())
					{
						if (AddUniversalConstants()) 
						{
							if (myApp->pEditUniverseWindow->LockLooper())
							{
								string newLabel = editThe[UNIVERSALCONSTANTS_TYPE];
								newLabel += nameStrGadget->Text();
								myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->SetLabel(newLabel.c_str());
								myApp->pEditUniverseWindow->pBottomButtons->save->SetEnabled(true);
								myApp->pEditUniverseWindow->UnlockLooper();
							}
							if (myApp->pTitleWindow->LockLooper())
							{
								myApp->pTitleWindow->pSaveButton->SetEnabled(true);
								myApp->pTitleWindow->pRealButton->SetEnabled(true);
								myApp->pTitleWindow->UnlockLooper();
							}
							nameStrGadget->SetText("");
							nameStrGadget->MakeFocus();
							pBottomButtons->prev->SetEnabled(false);
							pBottomButtons->gnu->SetEnabled(false);
							if (dataListGlobal[UNIVERSALCONSTANTS_TYPE]->list->CountItems() > 1) 
							{
								pBottomButtons->list->SetEnabled(true);
							}
							else
							{
								pBottomButtons->list->SetEnabled(false);
							}
						}
					}
				}
				else
				{
					warning(gccpFailNameUnique[UNIVERSALCONSTANTS_TYPE]);
				}
			}
			else 
			{
				warning(everythingNamed);
			}
		break;
		case BLPICTURE:
			warning("debug no pictures yet\n");
		break;
		case BLNEXT:
		{
			if (validate) 
			{
				if (UniqueName(dataListGlobal[UNIVERSALCONSTANTS_TYPE], nameStrGadget->Text()))
				{
					validate = false;
					if (ValidateUniversalConstants())
					{
						if (AddUniversalConstants()) 
						{
							validate = true;
						}
					}
				}
				else
				{
					if (strcmp(nameStrGadget->Text(), universalConstantsCurrent->name))
					{
						validate = false;
						if (ValidateUniversalConstants())
						{
							if (UpdateUniversalConstants()) 
							{
								validate = true;
							}
						}
					}
				}
			}
			else
			{
				validate = true;
			}
			if (validate)
			{
				UniversalConstants * nextUniversalConstants = (UniversalConstants *)((DataNode *)nextDNPtr)->data;
				universalConstantsCurrent = nextUniversalConstants;
				nameStrGadget->SetText(universalConstantsCurrent->name);
				thisDNPtr = dataListGlobal[UNIVERSALCONSTANTS_TYPE]->NextPrevItems(	(void *)universalConstantsCurrent, 
																					&nextDNPtr, 
																					&prevDNPtr, 
																					pBottomButtons);
				FillStrGadgets();
				if (myApp->pEditUniverseWindow->LockLooper())
				{
					string newLabel = editThe[UNIVERSALCONSTANTS_TYPE];
					newLabel += nameStrGadget->Text();
					myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->SetLabel(newLabel.c_str());
					myApp->pEditUniverseWindow->UnlockLooper();
				}
				if (dataListGlobal[UNIVERSALCONSTANTS_TYPE]->list->CountItems() > 1) 
				{
					pBottomButtons->list->SetEnabled(true);
				}
				else
				{
					pBottomButtons->list->SetEnabled(false);
				}
			}
		break;
		}
		case ABOUT_UNIVERSALCONSTANTSWINDOW:
		{
			string warn = gccpAboutUniversalConstantsWindowMsg1;
			warn += gccpAboutUniversalConstantsWindowMsg2;
			warn += gccpAboutUniversalConstantsWindowMsg3;
			warning(warn.c_str());
		break;
		}
		case QUIT_APP:
			if (Verify(gccpReallyQuitApp))
			{
				myApp->PostMessage(B_QUIT_REQUESTED);
			}
		break;
		default:
			BWindow::MessageReceived(message);
		break;
	}
}//end


bool 
EditUniversalConstantsWindow	::	AddUniversalConstants(	void) 
{
	UniversalConstants * uc;
	try
	{
		uc = new UniversalConstants(	universalConstants, 
										(char *)nameStrGadget->Text());
	}
	catch (...)
	{
		warning(gccpFailMemory);
		return false;
	}
	if (err != CREATED)
	{
		delete uc;
		return false;
	}
	return true;
}//end


bool 
EditUniversalConstantsWindow	::	QuitRequested(	void) 
{
	BRect frame = Frame();
	myApp->SetPreferredUniversalConstantsWindowRect(frame);
	if (strcmp(nameStrGadget->Text(), ""))
	{
		bool validate = false;
		if (UniqueName(dataListGlobal[UNIVERSALCONSTANTS_TYPE], nameStrGadget->Text()))
		{
			validate = false;
			if (ValidateUniversalConstants())
			{
				if (AddUniversalConstants()) 
				{
					validate = true;
				}
			}
		}
		else
		{
			if (strcmp(nameStrGadget->Text(), universalConstantsCurrent->name))
			{
				validate = false;
				warning(gccpWrongName);
				nameStrGadget->SetText(universalConstantsCurrent->name);
			}
			else
			{
				validate = false;
				if (ValidateUniversalConstants())
				{
					if (UpdateUniversalConstants())
					{
						validate = true;
					}
				}
			}
		}
		if (validate)
		{
			if (myApp->pEditUniverseWindow->LockLooper())
			{
				string newLabel = editThe[UNIVERSALCONSTANTS_TYPE];
				newLabel += nameStrGadget->Text();
				myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->SetLabel(newLabel.c_str());
				myApp->pEditUniverseWindow->pBottomButtons->save->SetEnabled(true);
				myApp->pEditUniverseWindow->UnlockLooper();
			}
			if (myApp->pTitleWindow->LockLooper())
			{
				myApp->pTitleWindow->pSaveButton->SetEnabled(true);
				myApp->pTitleWindow->pRealButton->SetEnabled(true);
				myApp->pTitleWindow->UnlockLooper();
			}
		}
	}
	return(BWindow::QuitRequested());
}


bool 
EditUniversalConstantsWindow	::	UpdateUniversalConstants(	void) 
{
	if (universalConstantsCurrent) 
	{
		if (!universalConstantsCurrent->Copy(universalConstants))
		{
			return false;
		}
		return true;
	}
	return false;
}//end


bool 
EditUniversalConstantsWindow	::	ValidateUniversalConstants(	void) 
{
	uint32	wMin, hMin, dMin, sMin, pMin, fMin, iMin, eMin, nMin, prMin, 
			wMax, hMax, dMax, sMax, pMax, fMax, iMax, eMax, nMax, prMax, 
			paMin, paMax, faMin, faMax, ngMin, ngMax;
	wMin = s2uint32(enteredMinWidthGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univWidtherr);
		return false;
	}
	hMin = s2uint32(enteredMinHeightGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univHeighterr);
		return false;
	}
	dMin = s2uint32(enteredMinDepthGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univDeptherr);
		return false;
	}
	sMin = s2uint32(enteredMinSofLGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univSerr);
		return false;
	}
	pMin = s2uint32(enteredMinPropFuelUseGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univPerr);
		return false;
	}
	fMin = s2uint32(enteredMinFTLFuelUseGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univFerr);
		return false;
	}
	iMin = s2uint32(enteredMinInstFuelUseGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univIerr);
		return false;
	}
	paMin = s2uint32(enteredMinPropAccelGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univPAerr);
		return false;
	}
	faMin = s2uint32(enteredMinFTLAccelGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univFAerr);
		return false;
	}
	eMin = s2uint32(enteredMinElectronMassGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univEerr);
		return false;
	}
	nMin = s2uint32(enteredMinNeutronMassGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univNerr);
		return false;
	}
	prMin = s2uint32(enteredMinProtonMassGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univPRerr);
		return false;
	}
	ngMin = s2uint32(enteredMinNumGalaxyGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univNGerr);
		return false;
	}
	wMax = s2uint32(enteredMaxWidthGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univWidtherr);
		return false;
	}
	hMax = s2uint32(enteredMaxHeightGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univHeighterr);
		return false;
	}
	dMax = s2uint32(enteredMaxDepthGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univDeptherr);
		return false;
	}
	sMax = s2uint32(enteredMaxSofLGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univSerr);
		return false;
	}
	pMax = s2uint32(enteredMaxPropFuelUseGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univPerr);
		return false;
	}
	fMax = s2uint32(enteredMaxFTLFuelUseGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univFerr);
		return false;
	}
	iMax = s2uint32(enteredMaxInstFuelUseGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univIerr);
		return false;
	}
	paMax = s2uint32(enteredMaxPropAccelGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univPAerr);
		return false;
	}
	faMax = s2uint32(enteredMaxFTLAccelGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univFAerr);
		return false;
	}
	eMax = s2uint32(enteredMaxElectronMassGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univEerr);
		return false;
	}
	nMax = s2uint32(enteredMaxNeutronMassGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univNerr);
		return false;
	}
	prMax = s2uint32(enteredMaxProtonMassGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univPRerr);
		return false;
	}
	ngMax = s2uint32(enteredMaxNumGalaxyGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univNGerr);
		return false;
	}
	universalConstants->enteredMinWidth = wMin;
	universalConstants->enteredMinHeight = hMin;
	universalConstants->enteredMinDepth = dMin;
	universalConstants->enteredMinSofL = sMin;
	universalConstants->enteredMinPropFuelUse = pMin;
	universalConstants->enteredMinFTLFuelUse = fMin;
	universalConstants->enteredMinInstFuelUse = iMin;
	universalConstants->enteredMinElectronMass = eMin;
	universalConstants->enteredMinNeutronMass = nMin;
	universalConstants->enteredMinProtonMass = prMin;
	universalConstants->enteredMinPropAccel = paMin;
	universalConstants->enteredMinFTLAccel = faMin;
	universalConstants->enteredMinNumGalaxy = ngMin;
	universalConstants->enteredMaxWidth = wMax;
	universalConstants->enteredMaxHeight = hMax;
	universalConstants->enteredMaxDepth = dMax;
	universalConstants->enteredMaxSofL = sMax;
	universalConstants->enteredMaxPropFuelUse = pMax;
	universalConstants->enteredMaxFTLFuelUse = fMax;
	universalConstants->enteredMaxInstFuelUse = iMax;
	universalConstants->enteredMaxElectronMass = eMax;
	universalConstants->enteredMaxNeutronMass = nMax;
	universalConstants->enteredMaxProtonMass = prMax;
	universalConstants->enteredMaxPropAccel = paMax;
	universalConstants->enteredMaxFTLAccel = faMax;
	universalConstants->enteredMaxNumGalaxy = ngMax;
	universe->enteredMinWidth = wMin;
	universe->enteredMinHeight = hMin;
	universe->enteredMinDepth = dMin;
	universe->enteredMinSofL = sMin;
	universe->enteredMinPropFuelUse = pMin;
	universe->enteredMinFTLFuelUse = fMin;
	universe->enteredMinInstFuelUse = iMin;
	universe->enteredMinElectronMass = eMin;
	universe->enteredMinNeutronMass = nMin;
	universe->enteredMinProtonMass = prMin;
	universe->enteredMinPropAccel = paMin;
	universe->enteredMinFTLAccel = faMin;
	universe->enteredMinNumGalaxy = ngMin;
	universe->enteredMaxWidth = wMax;
	universe->enteredMaxHeight = hMax;
	universe->enteredMaxDepth = dMax;
	universe->enteredMaxSofL = sMax;
	universe->enteredMaxPropFuelUse = pMax;
	universe->enteredMaxFTLFuelUse = fMax;
	universe->enteredMaxInstFuelUse = iMax;
	universe->enteredMaxElectronMass = eMax;
	universe->enteredMaxNeutronMass = nMax;
	universe->enteredMaxProtonMass = prMax;
	universe->enteredMaxPropAccel = paMax;
	universe->enteredMaxFTLAccel = faMax;
	universe->enteredMaxNumGalaxy = ngMax;
	if (universalConstants->name)
	{
		if (strcmp(universalConstants->name, nameStrGadget->Text())) 
		{
			if (universalConstants->name) 
			{
				free(universalConstants->name);
			}
			universalConstants->name = (char *)malloc(strlen(nameStrGadget->Text()) + 1);
			if (universalConstants->name) 
			{
				strcpy(universalConstants->name, nameStrGadget->Text());
			}
			else 
			{
				warning(gccpFailName);
				return false;
			}
		}
	}
	else
	{
		universalConstants->name = (char *)malloc(strlen(nameStrGadget->Text()) + 1);
		if (universalConstants->name) 
		{
			strcpy(universalConstants->name, nameStrGadget->Text());
		}
		else 
		{
			warning(gccpFailName);
			return false;
		}
	}
	return true;
}//end


void
EditUniversalConstantsWindow	::	FillStrGadgets(	void)
{
	char intGadgetBuf[16];
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMinWidth);
	enteredMinWidthGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMinHeight);
	enteredMinHeightGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMinDepth);
	enteredMinDepthGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMinSofL);
	enteredMinSofLGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMinPropFuelUse);
	enteredMinPropFuelUseGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMinPropAccel);
	enteredMinPropAccelGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMinFTLFuelUse);
	enteredMinFTLFuelUseGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMinFTLAccel);
	enteredMinFTLAccelGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMinInstFuelUse);
	enteredMinInstFuelUseGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMinElectronMass);
	enteredMinElectronMassGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMinNeutronMass);
	enteredMinNeutronMassGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMinProtonMass);
	enteredMinProtonMassGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMinNumGalaxy);
	enteredMinNumGalaxyGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMaxWidth);
	enteredMaxWidthGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMaxHeight);
	enteredMaxHeightGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMaxDepth);
	enteredMaxDepthGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMaxSofL);
	enteredMaxSofLGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMaxPropFuelUse);
	enteredMaxPropFuelUseGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMaxPropAccel);
	enteredMaxPropAccelGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMaxFTLFuelUse);
	enteredMaxFTLFuelUseGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMaxFTLAccel);
	enteredMaxFTLAccelGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMaxInstFuelUse);
	enteredMaxInstFuelUseGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMaxElectronMass);
	enteredMaxElectronMassGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMaxNeutronMass);
	enteredMaxNeutronMassGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMaxProtonMass);
	enteredMaxProtonMassGadget->SetText(intGadgetBuf);
	sprintf(intGadgetBuf, "%u", universalConstantsCurrent->enteredMaxNumGalaxy);
	enteredMaxNumGalaxyGadget->SetText(intGadgetBuf);
}//end