//editUniversalConstantsWindow.cpp

#include <memory>
#include <string>
#include "DmenuMsg.h"
#include "windowGuts.h"
#include "Xwarning.h"
#include "error.h"
#include "Xs2uint32.h"
#include "Xthings.h"
#include "dataNode.h"
#include "uInt32Gadget.h"
#include "dataList.h"
#include "bottomLine.h"
#include "myButton.h"
#include "bottomButtons.h"
#include "stringGadget.h"
#include "Xunique.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "XlayoutMatrixItem.h"
#include "layoutMatrixItem.h"
#include "DlayoutMatrix.h"
#include "layoutMatrix.h"
#include "constants.h"
#include "universalConstants.h"
#include "DlistViewWindow.h"
#include "listViewWindow.h"
#include "XeditUniversalConstantsWindow.h"
#include "editUniversalConstantsWindow.h"
#include "designButtons.h"
#include "editUniverseWindow.h"
#include "XfileHeaders.h"
#include "universe.h"
#include "preferences.h"
#include "myPreferences.h"
#include "myApp.h"
#include "getFromList.h"
#include "error.h"
#include "titleWindow.h"
#include "Xverify.h"
#include "truncateString.h"

EditUniversalConstantsWindow	::	EditUniversalConstantsWindow(	BRect paramBound,
																	const char * paramWindowTitle,
																	const char * paramScrollViewName,
																	const char * paramNamePrefFrame)
								: 
									WindowGuts(	paramBound, 
												paramWindowTitle, 
												paramScrollViewName,
												paramNamePrefFrame),
									savePanel(NULL), 
									saveMessenger(NULL), 
									loadPanel(NULL), 
									loadMessenger(NULL), 
									MinWidthGadget(NULL),
									MaxWidthGadget(NULL),
									MinHeightGadget(NULL),
									MaxHeightGadget(NULL),
									MinDepthGadget(NULL),
									MaxDepthGadget(NULL),
									MinSofLGadget(NULL),
									MaxSofLGadget(NULL),
									MinPropFuelUseGadget(NULL),
									MaxPropFuelUseGadget(NULL),
									MinPropAccelGadget(NULL),
									MaxPropAccelGadget(NULL),
									MinFTLFuelUseGadget(NULL),
									MaxFTLFuelUseGadget(NULL),
									MinFTLAccelGadget(NULL),
									MaxFTLAccelGadget(NULL),
									MinInstFuelUseGadget(NULL),
									MaxInstFuelUseGadget(NULL),
									MinElectronMassGadget(NULL),
									MaxElectronMassGadget(NULL),
									MinNeutronMassGadget(NULL),
									MaxNeutronMassGadget(NULL),
									MinProtonMassGadget(NULL),
									MaxProtonMassGadget(NULL),
									MinNumGalaxyGadget(NULL),
									MaxNumGalaxyGadget(NULL),
									pBottomButtons(new BottomButtons)
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning(FailCreateSemaphore);
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		LayoutMatrix *	pNameLayoutMatrix = new LayoutMatrix(BESTSIZE, 1, 1, this);//rows,columns
/////////////////////////////////////////////////////////////////////////////////////////////
		char * prelimName;
		if (universalConstantsCurrent) 
		{
			prelimName = universalConstantsCurrent->name;
		}
		else 
		{
			prelimName = NULL;
		}
		mpNameStrGadget = new StringGadget(	"stringGadgetName", 
											NameUCStrGadgetLable, 
											prelimName, 
											NAMEUCMSG, 
											B_FOLLOW_NONE, 
											B_WILL_DRAW | B_NAVIGABLE,
											0,
											pNameLayoutMatrix,
											true);
		auto_ptr<LayoutMatrixItem> apNameLayoutMatrixItem(new LayoutMatrixItem(	(void *)mpNameStrGadget, 
																				pNameLayoutMatrix->itemsList,
																				KIND_STRINGGADG));
																				
/////////////////////////////////////////////
		LayoutMatrix *	pMinLayoutMatrix = new LayoutMatrix(SAMESIZE, 13, 1, this);//rows,columns
////////////////
		float ftemp;
		BView bv(BRect(0, 0, 32, 32), NoShowView, B_FOLLOW_NONE, NULL);
		bv.SetFont(myPrefs->GetPreferredFont());
		float maxStrWidth = bv.StringWidth(SofLStr);
		ftemp = bv.StringWidth(PropFuelUseStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(PropAccelStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(FTLFuelUseStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(FTLAccelStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(InstFuelUseStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(ElectronMassStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(ProtonMassStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(NeutronMassStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(NumGalaxyStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(WidthStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(HeightStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(DepthStr);
		if (ftemp > maxStrWidth)
		{
			maxStrWidth = ftemp;
		}
		ftemp = bv.StringWidth(maxStr);//re-use this for all the Max:s
		UniversalConstants * uc;
		if (!universalConstantsCurrent) 
		{
			uc = universalConstants;
		}
		else
		{
			uc = universalConstantsCurrent;
		}
		MinWidthGadget = new UInt32Gadget(	uc->MinWidth,
											"MinWidth", 
											WidthStr,  
											MINWIDTH,  
											B_FOLLOW_NONE, 
											B_WILL_DRAW | B_NAVIGABLE,
											maxStrWidth,
											pMinLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMinWidthUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MinWidthGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
//////////////////////////////////////////////////////////////////////////////////////
		MinHeightGadget = new UInt32Gadget(	uc->MinHeight,
											"MinHeight", 
											HeightStr,  
											MINHEIGHT,  
											B_FOLLOW_NONE, 
											B_WILL_DRAW | B_NAVIGABLE,
											maxStrWidth,
											pMinLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMinHeightUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MinHeightGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
//////////////////////////////////////////////////////////////////////////////////////
		MinDepthGadget = new UInt32Gadget(	uc->MinDepth,
											"MinDepth", 
											DepthStr,  
											MINDEPTH,  
											B_FOLLOW_NONE, 
											B_WILL_DRAW | B_NAVIGABLE,
											maxStrWidth,
											pMinLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMinDepthUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MinDepthGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
//////////////////////////////////////////////////////////////////////////////////////
		MinSofLGadget = new UInt32Gadget(	uc->MinSofL,
											"MinSofL", 
											SofLStr,  
											MINSOFL,  
											B_FOLLOW_NONE, 
											B_WILL_DRAW | B_NAVIGABLE,
											maxStrWidth,
											pMinLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMinSofLUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MinSofLGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		MinPropFuelUseGadget = new UInt32Gadget(	uc->MinPropFuelUse,
													"MinPropFuelUse", 
													PropFuelUseStr, 
													MINPROPFUELUSE,  
													B_FOLLOW_NONE, 
													B_WILL_DRAW | B_NAVIGABLE,
													maxStrWidth,
													pMinLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMinPropFuelUseUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MinPropFuelUseGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		MinPropAccelGadget = new UInt32Gadget(	uc->MinPropAccel,
												"MinPropAccel", 
												PropAccelStr, 
												MINPROPACCEL,  
												B_FOLLOW_NONE, 
												B_WILL_DRAW | B_NAVIGABLE,
												maxStrWidth,
												pMinLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMinPropAccelUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MinPropAccelGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		MinFTLFuelUseGadget = new UInt32Gadget(	uc->MinFTLFuelUse,
												"MinFTLFuelUse", 
												FTLFuelUseStr, 
												MINFTLFUELUSE,  
												B_FOLLOW_NONE, 
												B_WILL_DRAW | B_NAVIGABLE,
												maxStrWidth,
												pMinLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMinFTLFuelUseUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MinFTLFuelUseGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		MinFTLAccelGadget = new UInt32Gadget(	uc->MinFTLAccel,
												"MinFTLAccel", 
												FTLAccelStr, 
												MINFTLACCEL,  
												B_FOLLOW_NONE, 
												B_WILL_DRAW | B_NAVIGABLE,
												maxStrWidth,
												pMinLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMinFTLAccelUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MinFTLAccelGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		MinInstFuelUseGadget = new UInt32Gadget(	uc->MinInstFuelUse,
													"MinInstFuelUse", 
													InstFuelUseStr, 
													MININSTFUELUSE,  
													B_FOLLOW_NONE, 
													B_WILL_DRAW | B_NAVIGABLE,
													maxStrWidth,
													pMinLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMinInstFuelUseUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MinInstFuelUseGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
/////////////////////////////////////////////////////////////////
		MinElectronMassGadget = new UInt32Gadget(	uc->MinElectronMass,
													"MinElectronMass", 
													ElectronMassStr, 
													MINELECTRONMASS,  
													B_FOLLOW_NONE, 
													B_WILL_DRAW | B_NAVIGABLE,
													maxStrWidth,
													pMinLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMinElectronMassUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MinElectronMassGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
//////////////////////////////////////////////////////////////////
		MinNeutronMassGadget = new UInt32Gadget(	uc->MinNeutronMass,
													"MinNeutronMass", 
													NeutronMassStr, 
													MINNEUTRONMASS,  
													B_FOLLOW_NONE, 
													B_WILL_DRAW | B_NAVIGABLE,
													maxStrWidth,
													pMinLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMinNeutronMassUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MinNeutronMassGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
/////////////////////////////////////////////////////////////////
		MinProtonMassGadget = new UInt32Gadget(	uc->MinProtonMass,
												"MinProtonMass", 
												ProtonMassStr, 
												MINPROTONMASS,  
												B_FOLLOW_NONE, 
												B_WILL_DRAW | B_NAVIGABLE,
												maxStrWidth,
												pMinLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMinProtonMassUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MinProtonMassGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		MinNumGalaxyGadget = new UInt32Gadget(	uc->MinNumGalaxy,
												"MinNumGalaxy", 
												NumGalaxyStr, 
												MINNUMGALAXY,
												B_FOLLOW_NONE, 
												B_WILL_DRAW | B_NAVIGABLE,
												maxStrWidth,
												pMinLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMinNumGalaxyUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MinNumGalaxyGadget, 
																								pMinLayoutMatrix->itemsList,
																								KIND_INTGADG));
/////////////////////////////////////////////////////////////////
		LayoutMatrix *	pMaxLayoutMatrix = new LayoutMatrix(SAMESIZE, 13, 1, this);//rows,columns
////////////////
		MaxWidthGadget = new UInt32Gadget(	uc->MaxWidth,
											"MaxWidth", 
											maxStr,  
											MAXWIDTH,
											B_FOLLOW_NONE, 
											B_WILL_DRAW | B_NAVIGABLE,
											ftemp,
											pMaxLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMaxWidthUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MaxWidthGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
//////////////////////////////////////////////////////////////////////////////////////
		MaxHeightGadget = new UInt32Gadget(	uc->MaxHeight,
											"MaxHeight", 
											maxStr,  
											MAXHEIGHT,
											B_FOLLOW_NONE, 
											B_WILL_DRAW | B_NAVIGABLE,
											ftemp,
											pMaxLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMaxHeightUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MaxHeightGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
//////////////////////////////////////////////////////////////////////////////////////
		MaxDepthGadget = new UInt32Gadget(	uc->MaxDepth,
											"MaxDepth", 
											maxStr,  
											MAXDEPTH,
											B_FOLLOW_NONE, 
											B_WILL_DRAW | B_NAVIGABLE,
											ftemp,
											pMaxLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMaxDepthUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MaxDepthGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
//////////////////////////////////////////////////////////////////////////////////////
		MaxSofLGadget = new UInt32Gadget(	uc->MaxSofL,
											"MaxSofL", 
											maxStr,  
											MAXSOFL,
											B_FOLLOW_NONE, 
											B_WILL_DRAW | B_NAVIGABLE,
											ftemp,
											pMaxLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMaxSofLUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MaxSofLGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		MaxPropFuelUseGadget = new UInt32Gadget(	uc->MaxPropFuelUse,
													"MaxPropFuelUse", 
													maxStr, 
													MAXPROPFUELUSE,
													B_FOLLOW_NONE, 
													B_WILL_DRAW | B_NAVIGABLE,
													ftemp,
													pMaxLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMaxPropFuelUseUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MaxPropFuelUseGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		MaxPropAccelGadget = new UInt32Gadget(	uc->MaxPropAccel,
												"MaxPropAccel", 
												maxStr, 
												MAXPROPACCEL,
												B_FOLLOW_NONE, 
												B_WILL_DRAW | B_NAVIGABLE,
												ftemp,
												pMaxLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMaxPropAccelUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MaxPropAccelGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		MaxFTLFuelUseGadget = new UInt32Gadget(	uc->MaxFTLFuelUse,
												"MaxFTLFuelUse", 
												maxStr, 
												MAXFTLFUELUSE,
												B_FOLLOW_NONE, 
												B_WILL_DRAW | B_NAVIGABLE,
												ftemp,
												pMaxLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMaxFTLFuelUseUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MaxFTLFuelUseGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		MaxFTLAccelGadget = new UInt32Gadget(	uc->MaxFTLAccel,
												"MaxFTLAccel", 
												maxStr, 
												MAXFTLACCEL,
												B_FOLLOW_NONE, 
												B_WILL_DRAW | B_NAVIGABLE,
												ftemp,
												pMaxLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMaxFTLAccelUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MaxFTLAccelGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
////////////////////////////////////////////////////////////////
		MaxInstFuelUseGadget = new UInt32Gadget(	uc->MaxInstFuelUse,
													"MaxInstFuelUse", 
													maxStr, 
													MAXINSTFUELUSE,
													B_FOLLOW_NONE, 
													B_WILL_DRAW | B_NAVIGABLE,
													ftemp,
													pMaxLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMaxInstFuelUseUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MaxInstFuelUseGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
/////////////////////////////////////////////////////////////////
		MaxElectronMassGadget = new UInt32Gadget(	uc->MaxElectronMass,
													"MaxElectronMass", 
													maxStr, 
													MAXELECTRONMASS,
													B_FOLLOW_NONE, 
													B_WILL_DRAW | B_NAVIGABLE,
													ftemp,
													pMaxLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMaxElectronMassUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MaxElectronMassGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
//////////////////////////////////////////////////////////////////
		MaxNeutronMassGadget = new UInt32Gadget(	uc->MaxNeutronMass,
													"MaxNeutronMass", 
													maxStr, 
													MAXNEUTRONMASS,
													B_FOLLOW_NONE, 
													B_WILL_DRAW | B_NAVIGABLE,
													ftemp,
													pMaxLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMaxNeutronMassUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MaxNeutronMassGadget, 
																								pMaxLayoutMatrix->itemsList,
																								KIND_INTGADG));
/////////////////////////////////////////////////////////////////
		MaxProtonMassGadget = new UInt32Gadget(	uc->MaxProtonMass,
												"MaxProtonMass", 
												maxStr, 
												MAXPROTONMASS,
												B_FOLLOW_NONE, 
												B_WILL_DRAW | B_NAVIGABLE,
												ftemp,
												pMaxLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMaxProtonMassUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MaxProtonMassGadget, 
																										pMaxLayoutMatrix->itemsList,
																										KIND_INTGADG));
////////////////////////////////////////////////////////////////
		MaxNumGalaxyGadget = new UInt32Gadget(	uc->MaxNumGalaxy,
												"MaxNumGalaxy", 
												maxStr, 
												MAXNUMGALAXY,
												B_FOLLOW_NONE, 
												B_WILL_DRAW | B_NAVIGABLE,
												ftemp,
												pMaxLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMaxNumGalaxyUInt32GadgetLayoutMatrixItem(new LayoutMatrixItem(	(void *)MaxNumGalaxyGadget, 
																									pMaxLayoutMatrix->itemsList,
																									KIND_INTGADG));
////////////////////////////////
		uint32 picKind = UNIVERSALCONSTANTSPICKIND;
		#include "bottomLine.source"
		thisDNPtr = dataListGlobal[UNIVERSALCONSTANTS_TYPE]->NextPrevItems(	(void *)universalConstantsCurrent, 
																			&nextDNPtr, 
																			&prevDNPtr, 
																			pBottomButtons);
		if (!prevDNPtr)
		{
			pBottomButtons->prev->SetEnabled(false);
		}
		if (!nextDNPtr)
		{
			pBottomButtons->next->SetEnabled(false);
		}
		if (!prevDNPtr && !nextDNPtr)
		{
			pBottomButtons->list->SetEnabled(false);
		}
		if (!dataListGlobal[UNIVERSALCONSTANTS_TYPE]->list->CountItems()) 
		{
			pBottomButtons->remove->SetEnabled(false);
		}
/////////////////////////////////
		release_sem(calc_sem);
		pNameLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, MATRIXVERTICALOFFSET, calc_sem);
		pMinLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, pNameLayoutMatrix->bottom, calc_sem);
		pMaxLayoutMatrix->Calc(pMinLayoutMatrix->right, pNameLayoutMatrix->bottom, calc_sem);
		pBottomLineLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, pMaxLayoutMatrix->bottom, calc_sem);
	}
	catch (...)
	{
		warning(CaughtUniversalConstantsWindowCTOR);
		release_sem(calc_sem);
		throw;
	}
	try 
	{
		BMenuItem *	menuItem;
		BMenu * APPMenu = new BMenu(AppMenuLable);
		menuItem = new BMenuItem(	AboutMenuLable, 
									new BMessage(ABOUT_UNIVERSALCONSTANTSWINDOW));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	PreferenceMenuLable, 
									new BMessage(PREFSMSG));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	CloseWindow, 
									new BMessage(B_QUIT_REQUESTED));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	QuitMenuLable, 
									new BMessage(QUIT_APP));
		APPMenu->AddItem(menuItem);
		pMenuBar->AddItem(APPMenu);
	}
	catch(...) 
	{
		throw;
	}
	if (myApp->pEditUniverseWindow) 
	{
		if (myApp->pEditUniverseWindow->LockLooper())
		{
			myApp->pEditUniverseWindow->buttons[NUM_DFLT_UNIVERSALCONSTANTS]->SetEnabled(false);
			myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->SetEnabled(false);
			myApp->pEditUniverseWindow->buttons[NUM_LOAD_UNIVERSALCONSTANTS]->SetEnabled(false);
			myApp->pEditUniverseWindow->UnlockLooper();
		}
		else
		{
			warning(FailLockLooper);
		}
	}
	if (!universalConstantsCurrent) 
	{
		if (dataListGlobal[UNIVERSALCONSTANTS_TYPE]->list->CountItems()) 
		{
			universalConstantsCurrent = (UniversalConstants *)((DataNode *)dataListGlobal[UNIVERSALCONSTANTS_TYPE]->list->ItemAt(0))->data;
		}
	}
}//end


EditUniversalConstantsWindow	::	~EditUniversalConstantsWindow() 
{
	if (savePanel)
	{
		delete savePanel;
	}
	if (saveMessenger)
	{
		delete saveMessenger;
	}
	if (loadPanel)
	{
		delete loadPanel;
	}
	if (loadMessenger)
	{
		delete loadMessenger;
	}
	if (MinWidthGadget) 
	{
		MinWidthGadget->RemoveSelf();
		delete MinWidthGadget;
	}
	if (MaxWidthGadget) 
	{
		MaxWidthGadget->RemoveSelf();
		delete MaxWidthGadget;
	}
	if (MinHeightGadget) 
	{
		MinHeightGadget->RemoveSelf();
		delete MinHeightGadget;
	}
	if (MaxHeightGadget) 
	{
		MaxHeightGadget->RemoveSelf();
		delete MaxHeightGadget;
	}
	if (MinDepthGadget) 
	{
		MinDepthGadget->RemoveSelf();
		delete MinDepthGadget;
	}
	if (MaxDepthGadget) 
	{
		MaxDepthGadget->RemoveSelf();
		delete MaxDepthGadget;
	}
	if (MinSofLGadget) 
	{
		MinSofLGadget->RemoveSelf();
		delete MinSofLGadget;
	}
	if (MaxSofLGadget) 
	{
		MaxSofLGadget->RemoveSelf();
		delete MaxSofLGadget;
	}
	if (MinPropFuelUseGadget) 
	{
		MinPropFuelUseGadget->RemoveSelf();
		delete MinPropFuelUseGadget;
	}
	if (MaxPropFuelUseGadget) 
	{
		MaxPropFuelUseGadget->RemoveSelf();
		delete MaxPropFuelUseGadget;
	}
	if (MinPropAccelGadget) 
	{
		MinPropAccelGadget->RemoveSelf();
		delete MinPropAccelGadget;
	}
	if (MaxPropAccelGadget) 
	{
		MaxPropAccelGadget->RemoveSelf();
		delete MaxPropAccelGadget;
	}
	if (MinFTLFuelUseGadget) 
	{
		MinFTLFuelUseGadget->RemoveSelf();
		delete MinFTLFuelUseGadget;
	}
	if (MaxFTLFuelUseGadget) 
	{
		MaxFTLFuelUseGadget->RemoveSelf();
		delete MaxFTLFuelUseGadget;
	}
	if (MinFTLAccelGadget) 
	{
		MinFTLAccelGadget->RemoveSelf();
		delete MinFTLAccelGadget;
	}
	if (MaxFTLAccelGadget) 
	{
		MaxFTLAccelGadget->RemoveSelf();
		delete MaxFTLAccelGadget;
	}
	if (MinInstFuelUseGadget) 
	{
		MinInstFuelUseGadget->RemoveSelf();
		delete MinInstFuelUseGadget;
	}
	if (MaxInstFuelUseGadget) 
	{
		MaxInstFuelUseGadget->RemoveSelf();
		delete MaxInstFuelUseGadget;
	}
	if (MinElectronMassGadget) 
	{
		MinElectronMassGadget->RemoveSelf();
		delete MinElectronMassGadget;
	}
	if (MaxElectronMassGadget) 
	{
		MaxElectronMassGadget->RemoveSelf();
		delete MaxElectronMassGadget;
	}
	if (MinNeutronMassGadget) 
	{
		MinNeutronMassGadget->RemoveSelf();
		delete MinNeutronMassGadget;
	}
	if (MaxNeutronMassGadget) 
	{
		MaxNeutronMassGadget->RemoveSelf();
		delete MaxNeutronMassGadget;
	}
	if (MinProtonMassGadget) 
	{
		MinProtonMassGadget->RemoveSelf();
		delete MinProtonMassGadget;
	}
	if (MaxProtonMassGadget) 
	{
		MaxProtonMassGadget->RemoveSelf();
		delete MaxProtonMassGadget;
	}
	if (MinNumGalaxyGadget) 
	{
		MinNumGalaxyGadget->RemoveSelf();
		delete MinNumGalaxyGadget;
	}
	if (MaxNumGalaxyGadget) 
	{
		MaxNumGalaxyGadget->RemoveSelf();
		delete MaxNumGalaxyGadget;
	}
	if (myApp->pEditUniverseWindow) 
	{
		if (myApp->pEditUniverseWindow->LockLooper())
		{
			myApp->pEditUniverseWindow->buttons[NUM_DFLT_UNIVERSALCONSTANTS]->SetEnabled(true);
			myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->SetEnabled(true);
			myApp->pEditUniverseWindow->buttons[NUM_LOAD_UNIVERSALCONSTANTS]->SetEnabled(true);
			myApp->pEditUniverseWindow->UnlockLooper();
		}
		else
		{
			warning(FailLockLooper);
		}
	}
	if (pBottomButtons)
	{
		delete pBottomButtons;
	}
//	if (GetLVWPointer())
//	{
//		GetLVWPointer()->PostMessage(B_QUIT_REQUESTED);
//	}
	myApp->pEditUniversalConstantsWindow = NULL;
}

void 
EditUniversalConstantsWindow	::	MessageReceived(	BMessage *message) 
{
	bool validate = strcmp(mpNameStrGadget->Text(), "");
	switch (message->what) 
	{
		case LOADFROMPANEL:	
		{
			entry_ref ref;
			int32 numUniversalConstants;
			if (message->FindRef("refs", &ref) >= B_OK) 
			{
				BFile file(&ref, B_READ_ONLY);
				status_t fileStatus;
				if ((fileStatus = file.InitCheck()) == B_NO_ERROR) 
				{
					if (!StripFileHeaderPre(&file)) 
					{
						warning(noLoad);
						return;
					}
					if (!StripFileHeader(	UNIVERSALCONSTANTS_TYPE, 
											&file, 
											&numUniversalConstants)) 
					{
						warning(noLoad);
						return;
					}
					if (!(universalConstants->Load(&file))) 
					{
						warning(noLoad);
					}
					else 
					{
						universalConstantsCurrent = universalConstants;
						mpNameStrGadget->SetText(universalConstantsCurrent->name);
						FillStrGadgets();
						thisDNPtr = dataListGlobal[UNIVERSALCONSTANTS_TYPE]->NextPrevItems(	(void *)universalConstantsCurrent, 
																							&nextDNPtr, 
																							&prevDNPtr, 
																							pBottomButtons);
					}
				}
				else warning(FailFileInitCheck);
			}
			else warning(FailFileFindRef);
		break;
		}
		case BLLOAD:
			if (!loadPanel) 
			{
				try 
				{
					loadMessenger = new BMessenger(this);
				}
				catch (...) 
				{
					warning(FailMemory);
					loadMessenger = NULL;
					return;
				}
				try 
				{
					loadPanel = new BFilePanel(	B_OPEN_PANEL, 
												loadMessenger, 
												NULL, 
												B_FILE_NODE, 
												false, 
												new BMessage(LOADFROMPANEL), 
												NULL, 
												false, 
												true);
					
					BWindow * panelWindow = loadPanel->Window();
					panelWindow->SetTitle(OpenUC);
					loadPanel->Show();
				}
				catch (...) 
				{
					warning(FailMemory);
					loadPanel = NULL;
					return;
				}
			}
			else loadPanel->Show();
		break;
		case SAVEFROMPANEL: 
		{
			if (validate)
			{
				if (ValidateUniversalConstants())
				{
					UpdateUniversalConstants();
					entry_ref ref;
					const char * fileName;
					if (message->FindRef("directory", &ref) >= B_OK) 
					{
						if (message->FindString("name", &fileName) >= B_OK) 
						{
							BFile file;
							BDirectory dir = BDirectory(&ref);
							status_t result = file.SetTo(	&dir, 
															fileName, 
															B_WRITE_ONLY | B_CREATE_FILE | B_ERASE_FILE);
							if (result >= B_OK) 
							{
								if (!PutFileHeaderPre(&file)) 
								{
									return;
								}
								if (!PutFileHeader(UNIVERSALCONSTANTS_TYPE, 1, &file)) 
								{
									return;
								}
								if (!(universalConstants->Save(&file))) 
								{
									warning(nothingToSave[UNIVERSALCONSTANTS_TYPE]);
									return;
								}
								return;
							}
							else 
							{
								warning(FailFileSetTo);
							}
						}
						else 
						{
							warning(FailFileName);
						}
					}
					else 
					{
						warning(FailFileDir);
					}
				}
			}
			else
			{
				warning(NeedNameToKeep);
			}
		break;
		}
		case BLSAVE:
			if (validate)
			{
				if (!savePanel) 
				{
					try 
					{
						saveMessenger = new BMessenger(this);
					}
					catch (...) 
					{
						warning(FailMemory);
						saveMessenger = NULL;
						return;
					}
					try 
					{
						savePanel = new BFilePanel(	B_SAVE_PANEL, 
													saveMessenger, 
													NULL, 
													B_FILE_NODE, 
													false, 
													new BMessage(SAVEFROMPANEL), 
													NULL, 
													false, 
													true);
						savePanel->Show();
					}
					catch (...) 
					{
						warning(FailMemory);
						savePanel = NULL;
						return;
					}
				}
				else 
				{
					savePanel->Show();
				}
			}
			else
			{
				warning(NeedNameToKeep);
			}
		break;
		case MINWIDTH:
		case MINHEIGHT:
		case MINDEPTH:
		case MINSOFL:
		case MINPROPFUELUSE:
		case MINPROPACCEL:
		case MINFTLFUELUSE:
		case MINFTLACCEL:
		case MININSTFUELUSE:
		case MINELECTRONMASS:
		case MINNEUTRONMASS:
		case MINPROTONMASS:
		case MINNUMGALAXY:
		case MAXWIDTH:
		case MAXHEIGHT:
		case MAXDEPTH:
		case MAXSOFL:
		case MAXPROPFUELUSE:
		case MAXPROPACCEL:
		case MAXFTLFUELUSE:
		case MAXFTLACCEL:
		case MAXINSTFUELUSE:
		case MAXELECTRONMASS:
		case MAXNEUTRONMASS:
		case MAXPROTONMASS:
		case MAXNUMGALAXY:
			//debug no need to do anything really, but might want to validate??
		break;
		case PREFSMSG:
		{
			myPrefs->OpenPreferencesPanel();
		break;
		}
		case BLREMOVE:
			dataListGlobal[UNIVERSALCONSTANTS_TYPE]->Remove();
			Quit();
		break;
		case BLLIST:
			try 
			{
				BRect holdRect;
				myPrefs->GetPreferredListViewWindowRect(&holdRect);
				mpListViewWindow = new ListViewWindow(	holdRect,
														lvwts[UNIVERSALCONSTANTS_TYPE],
														"ListViewView",
														"ListViewWindowFrame",
														NULL,
														dataListGlobal[UNIVERSALCONSTANTS_TYPE], 
														mpNameStrGadget->Text(),
														this,
														LISTVIEWSELECTONE);
				if (err == NO_ERR)
				{
					mpListViewWindow->Initialize();
					pBottomButtons->list->SetEnabled(false);
				}
			}
			catch (...) 
			{
				warning(FailListViewWindow);
				myApp->PostMessage(B_QUIT_REQUESTED);
				throw;
			}
		break;
		case BLLISTGOT:
			if (validate) 
			{
				if (UniqueName(dataListGlobal[UNIVERSALCONSTANTS_TYPE], mpNameStrGadget->Text()))
				{
					validate = false;
					if (ValidateUniversalConstants())
					{
						if (AddUniversalConstants()) 
						{
							validate = true;
						}
					}
				}
				else
				{
					if (strcmp(mpNameStrGadget->Text(), universalConstantsCurrent->name))
					{
						validate = false;
						if (ValidateUniversalConstants())
						{
							if (UpdateUniversalConstants()) 
							{
								validate = true;
							}
						}
					}
				}
			}
			else
			{
				validate = true;
			}
			if (validate)
			{
				universalConstantsCurrent = universalConstantsNewCurrent;
				mpNameStrGadget->SetText(universalConstantsCurrent->name);
				FillStrGadgets();
				thisDNPtr = dataListGlobal[UNIVERSALCONSTANTS_TYPE]->NextPrevItems(	(void *)universalConstantsCurrent, 
																					&nextDNPtr, 
																					&prevDNPtr, 
																					pBottomButtons);
			}
			pBottomButtons->list->SetEnabled(true);
		break;
		case BLPREVIOUS:
		{
			if (validate) 
			{
				if (UniqueName(dataListGlobal[UNIVERSALCONSTANTS_TYPE], mpNameStrGadget->Text()))
				{
					validate = false;
					if (ValidateUniversalConstants())
					{
						if (AddUniversalConstants()) 
						{
							validate = true;
						}
					}
				}
				else
				{
					if (strcmp(mpNameStrGadget->Text(), universalConstantsCurrent->name))
					{
						validate = false;
						if (ValidateUniversalConstants())
						{
							if (UpdateUniversalConstants()) 
							{
								validate = true;
							}
						}
					}
				}
			}
			else
			{
				validate = true;
			}
			if (validate)
			{
				UniversalConstants * prevUniversalConstants = (UniversalConstants *)((DataNode *)prevDNPtr)->data;
				universalConstantsCurrent = prevUniversalConstants;
				mpNameStrGadget->SetText(universalConstantsCurrent->name);
				thisDNPtr = dataListGlobal[UNIVERSALCONSTANTS_TYPE]->NextPrevItems(	(void *)universalConstantsCurrent, 
																					&nextDNPtr, 
																					&prevDNPtr, 
																					pBottomButtons);
				FillStrGadgets();
				if (myApp->pEditUniverseWindow->LockLooper())
				{
					string newLabel = editThe[UNIVERSALCONSTANTS_TYPE];
					newLabel += mpNameStrGadget->Text();
					char abuf[256];
					BFont * font = myPrefs->GetPreferredFont();
					bool ts = TruncateString(	newLabel.c_str(),
												&abuf[0],
												myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->Frame().Width(),
												font);
					if (ts)
					{
						newLabel = abuf;
					}
					myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->SetLabel(newLabel.c_str());
					myApp->pEditUniverseWindow->UnlockLooper();
				}
				else
				{
					warning(FailLockLooper);
				}
				if (dataListGlobal[UNIVERSALCONSTANTS_TYPE]->list->CountItems() > 1) 
				{
					pBottomButtons->list->SetEnabled(true);
				}
				else
				{
					pBottomButtons->list->SetEnabled(false);
				}
			}
		break;
		}
		case BLDONE:
			if (validate) 
			{
				if (UniqueName(dataListGlobal[UNIVERSALCONSTANTS_TYPE], mpNameStrGadget->Text()))
				{
					validate = false;
					if (ValidateUniversalConstants())
					{
						if (AddUniversalConstants()) 
						{
							validate = true;
						}
					}
				}
				else
				{
					if (strcmp(mpNameStrGadget->Text(), universalConstantsCurrent->name))
					{
						validate = false;
						warning(WrongName);
						mpNameStrGadget->SetText(universalConstantsCurrent->name);
					}
					else
					{
						validate = false;
						if (ValidateUniversalConstants())
						{
							if (UpdateUniversalConstants())
							{
								validate = true;
							}
						}
					}
				}
				if (validate)
				{
					if (myApp->pEditUniverseWindow->LockLooper())
					{
						string newLabel = editThe[UNIVERSALCONSTANTS_TYPE];
						newLabel += mpNameStrGadget->Text();
						char abuf[256];
						BFont * font = myPrefs->GetPreferredFont();
						bool ts = TruncateString(	newLabel.c_str(),
													&abuf[0],
													myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->Frame().Width(),
													font);
						if (ts)
						{
							newLabel = abuf;
						}
						myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->SetLabel(newLabel.c_str());
						myApp->pEditUniverseWindow->pBottomButtons->save->SetEnabled(true);
						myApp->pEditUniverseWindow->UnlockLooper();
					}
					else
					{
						warning(FailLockLooper);
					}
					if (myApp->pTitleWindow->LockLooper())
					{
						myApp->pTitleWindow->pSaveButton->SetEnabled(true);
						myApp->pTitleWindow->pRealButton->SetEnabled(true);
						myApp->pTitleWindow->UnlockLooper();
					}
					else
					{
						warning(FailLockLooper);
					}
					Quit();
				}
			}
			else
			{
				Quit();
			}
		break;
		case BLNEW:
			if (validate) 
			{
				if (UniqueName(dataListGlobal[UNIVERSALCONSTANTS_TYPE], mpNameStrGadget->Text()))
				{
					if (ValidateUniversalConstants())
					{
						if (AddUniversalConstants()) 
						{
							if( myApp->pEditUniverseWindow->LockLooper())
							{
								string newLabel = editThe[UNIVERSALCONSTANTS_TYPE];
								newLabel += mpNameStrGadget->Text();
								char abuf[256];
								BFont * font = myPrefs->GetPreferredFont();
								bool ts = TruncateString(	newLabel.c_str(),
															&abuf[0],
															myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->Frame().Width(),
															font);
								if (ts)
								{
									newLabel = abuf;
								}
								myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->SetLabel(newLabel.c_str());
								myApp->pEditUniverseWindow->pBottomButtons->save->SetEnabled(true);
								myApp->pEditUniverseWindow->UnlockLooper();
							}
							else
							{
								warning(FailLockLooper);
							}
							if (myApp->pTitleWindow->LockLooper())
							{
								myApp->pTitleWindow->pSaveButton->SetEnabled(true);
								myApp->pTitleWindow->pRealButton->SetEnabled(true);
								myApp->pTitleWindow->UnlockLooper();
							}
							else
							{
								warning(FailLockLooper);
							}
							mpNameStrGadget->SetText("");
							mpNameStrGadget->MakeFocus();
							pBottomButtons->prev->SetEnabled(true);
							if (dataListGlobal[UNIVERSALCONSTANTS_TYPE]->list->CountItems() > 1) 
							{
								pBottomButtons->list->SetEnabled(true);
							}
							else
							{
								pBottomButtons->list->SetEnabled(false);
							}
						}
					}
				}
				else
				{
					if (UpdateUniversalConstants())
					{
						mpNameStrGadget->SetText("");
						mpNameStrGadget->MakeFocus();
						pBottomButtons->prev->SetEnabled(false);
						pBottomButtons->next->SetEnabled(false);
					}
				}
			}
		break;
		case BLADD:
			if (validate) 
			{
				if (UniqueName(dataListGlobal[UNIVERSALCONSTANTS_TYPE], mpNameStrGadget->Text()))
				{
					if (ValidateUniversalConstants())
					{
						if (AddUniversalConstants()) 
						{
							if (myApp->pEditUniverseWindow->LockLooper())
							{
								string newLabel = editThe[UNIVERSALCONSTANTS_TYPE];
								newLabel += mpNameStrGadget->Text();
								char abuf[256];
								BFont * font = myPrefs->GetPreferredFont();
								bool ts = TruncateString(	newLabel.c_str(),
															&abuf[0],
															myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->Frame().Width(),
															font);
								if (ts)
								{
									newLabel = abuf;
								}
								myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->SetLabel(newLabel.c_str());
								myApp->pEditUniverseWindow->pBottomButtons->save->SetEnabled(true);
								myApp->pEditUniverseWindow->UnlockLooper();
							}
							else
							{
								warning(FailLockLooper);
							}
							if (myApp->pTitleWindow->LockLooper())
							{
								myApp->pTitleWindow->pSaveButton->SetEnabled(true);
								myApp->pTitleWindow->pRealButton->SetEnabled(true);
								myApp->pTitleWindow->UnlockLooper();
							}
							else
							{
								warning(FailLockLooper);
							}
							mpNameStrGadget->SetText("");
							mpNameStrGadget->MakeFocus();
							pBottomButtons->prev->SetEnabled(false);
							pBottomButtons->gnu->SetEnabled(false);
							if (dataListGlobal[UNIVERSALCONSTANTS_TYPE]->list->CountItems() > 1) 
							{
								pBottomButtons->list->SetEnabled(true);
							}
							else
							{
								pBottomButtons->list->SetEnabled(false);
							}
						}
					}
				}
				else
				{
					warning(FailNameUnique[UNIVERSALCONSTANTS_TYPE]);
				}
			}
			else 
			{
				warning(everythingNamed);
			}
		break;
		case BLPICTURE:
			warning("debug no pictures yet\n");
		break;
		case BLNEXT:
		{
			if (validate) 
			{
				if (UniqueName(dataListGlobal[UNIVERSALCONSTANTS_TYPE], mpNameStrGadget->Text()))
				{
					validate = false;
					if (ValidateUniversalConstants())
					{
						if (AddUniversalConstants()) 
						{
							validate = true;
						}
					}
				}
				else
				{
					if (strcmp(mpNameStrGadget->Text(), universalConstantsCurrent->name))
					{
						validate = false;
						if (ValidateUniversalConstants())
						{
							if (UpdateUniversalConstants()) 
							{
								validate = true;
							}
						}
					}
				}
			}
			else
			{
				validate = true;
			}
			if (validate)
			{
				UniversalConstants * nextUniversalConstants = (UniversalConstants *)((DataNode *)nextDNPtr)->data;
				universalConstantsCurrent = nextUniversalConstants;
				mpNameStrGadget->SetText(universalConstantsCurrent->name);
				thisDNPtr = dataListGlobal[UNIVERSALCONSTANTS_TYPE]->NextPrevItems(	(void *)universalConstantsCurrent, 
																					&nextDNPtr, 
																					&prevDNPtr, 
																					pBottomButtons);
				FillStrGadgets();
				if (myApp->pEditUniverseWindow->LockLooper())
				{
					string newLabel = editThe[UNIVERSALCONSTANTS_TYPE];
					newLabel += mpNameStrGadget->Text();
					char abuf[256];
					BFont * font = myPrefs->GetPreferredFont();
					bool ts = TruncateString(	newLabel.c_str(),
												&abuf[0],
												myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->Frame().Width(),
												font);
					if (ts)
					{
						newLabel = abuf;
					}
					myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->SetLabel(newLabel.c_str());
					myApp->pEditUniverseWindow->UnlockLooper();
				}
				else
				{
					warning(FailLockLooper);
				}
				if (dataListGlobal[UNIVERSALCONSTANTS_TYPE]->list->CountItems() > 1) 
				{
					pBottomButtons->list->SetEnabled(true);
				}
				else
				{
					pBottomButtons->list->SetEnabled(false);
				}
			}
		break;
		}
		case ABOUT_UNIVERSALCONSTANTSWINDOW:
		{
			string warn = AboutUniversalConstantsWindowMsg1;
			warn += AboutUniversalConstantsWindowMsg2;
			warn += AboutUniversalConstantsWindowMsg3;
			warning(warn.c_str());
		break;
		}
		case QUIT_APP:
			if (Verify(ReallyQuitApp))
			{
				myApp->PostMessage(B_QUIT_REQUESTED);
			}
		break;
		default:
			WindowGuts::MessageReceived(message);
		break;
	}
}//end


bool 
EditUniversalConstantsWindow	::	AddUniversalConstants(	void) 
{
	UniversalConstants * thang;
	try
	{
		thang = new UniversalConstants(	universalConstants, 
										(char *)mpNameStrGadget->Text());
	}
	catch (...)
	{
		warning(FailMemory);
		return false;
	}
	if (err != CREATED)
	{
		delete thang;
		return false;
	}
	return true;
}//end


bool 
EditUniversalConstantsWindow	::	QuitRequested(	void) 
{
	BRect frame = Frame();
	myApp->SetPreferredEditUniversalConstantsWindowRect(frame);
	if (strcmp(mpNameStrGadget->Text(), ""))
	{
		bool validate = false;
		if (UniqueName(dataListGlobal[UNIVERSALCONSTANTS_TYPE], mpNameStrGadget->Text()))
		{
			validate = false;
			if (ValidateUniversalConstants())
			{
				if (AddUniversalConstants()) 
				{
					validate = true;
				}
			}
		}
		else
		{
			if (strcmp(mpNameStrGadget->Text(), universalConstantsCurrent->name))
			{
				validate = false;
				warning(WrongName);
				mpNameStrGadget->SetText(universalConstantsCurrent->name);
			}
			else
			{
				validate = false;
				if (ValidateUniversalConstants())
				{
					if (UpdateUniversalConstants())
					{
						validate = true;
					}
				}
			}
		}
		if (validate)
		{
			if (myApp->pEditUniverseWindow->LockLooper())
			{
				string newLabel = editThe[UNIVERSALCONSTANTS_TYPE];
				newLabel += mpNameStrGadget->Text();
				char abuf[256];
				BFont * font = myPrefs->GetPreferredFont();
				bool ts = TruncateString(	newLabel.c_str(),
											&abuf[0],
											myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->Frame().Width(),
											font);
				if (ts)
				{
					newLabel = abuf;
				}
				myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->SetLabel(newLabel.c_str());
				myApp->pEditUniverseWindow->pBottomButtons->save->SetEnabled(true);
				myApp->pEditUniverseWindow->UnlockLooper();
			}
			else
			{
				warning(FailLockLooper);
			}
			if (myApp->pTitleWindow->LockLooper())
			{
				myApp->pTitleWindow->pSaveButton->SetEnabled(true);
				myApp->pTitleWindow->pRealButton->SetEnabled(true);
				myApp->pTitleWindow->UnlockLooper();
			}
			else
			{
				warning(FailLockLooper);
			}
		}
	}
	return(WindowGuts::QuitRequested());
}


bool 
EditUniversalConstantsWindow	::	UpdateUniversalConstants(	void) 
{
	if (universalConstantsCurrent) 
	{
		if (!universalConstantsCurrent->Copy(universalConstants))
		{
			return false;
		}
		return true;
	}
	return false;
}//end


bool 
EditUniversalConstantsWindow	::	ValidateUniversalConstants(	void) 
{
	uint32	wMin, hMin, dMin, sMin, pMin, fMin, iMin, eMin, nMin, prMin, 
			wMax, hMax, dMax, sMax, pMax, fMax, iMax, eMax, nMax, prMax, 
			paMin, paMax, faMin, faMax, ngMin, ngMax;
	wMin = s2uint32(MinWidthGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univWidtherr);
		return false;
	}
	hMin = s2uint32(MinHeightGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univHeighterr);
		return false;
	}
	dMin = s2uint32(MinDepthGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univDeptherr);
		return false;
	}
	sMin = s2uint32(MinSofLGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univSerr);
		return false;
	}
	pMin = s2uint32(MinPropFuelUseGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univPerr);
		return false;
	}
	fMin = s2uint32(MinFTLFuelUseGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univFerr);
		return false;
	}
	iMin = s2uint32(MinInstFuelUseGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univIerr);
		return false;
	}
	paMin = s2uint32(MinPropAccelGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univPAerr);
		return false;
	}
	faMin = s2uint32(MinFTLAccelGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univFAerr);
		return false;
	}
	eMin = s2uint32(MinElectronMassGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univEerr);
		return false;
	}
	nMin = s2uint32(MinNeutronMassGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univNerr);
		return false;
	}
	prMin = s2uint32(MinProtonMassGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univPRerr);
		return false;
	}
	ngMin = s2uint32(MinNumGalaxyGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univNGerr);
		return false;
	}
	wMax = s2uint32(MaxWidthGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univWidtherr);
		return false;
	}
	hMax = s2uint32(MaxHeightGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univHeighterr);
		return false;
	}
	dMax = s2uint32(MaxDepthGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univDeptherr);
		return false;
	}
	sMax = s2uint32(MaxSofLGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univSerr);
		return false;
	}
	pMax = s2uint32(MaxPropFuelUseGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univPerr);
		return false;
	}
	fMax = s2uint32(MaxFTLFuelUseGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univFerr);
		return false;
	}
	iMax = s2uint32(MaxInstFuelUseGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univIerr);
		return false;
	}
	paMax = s2uint32(MaxPropAccelGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univPAerr);
		return false;
	}
	faMax = s2uint32(MaxFTLAccelGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univFAerr);
		return false;
	}
	eMax = s2uint32(MaxElectronMassGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univEerr);
		return false;
	}
	nMax = s2uint32(MaxNeutronMassGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univNerr);
		return false;
	}
	prMax = s2uint32(MaxProtonMassGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univPRerr);
		return false;
	}
	ngMax = s2uint32(MaxNumGalaxyGadget->Text());
	if (S2UIERR == err) 
	{
		warning(univNGerr);
		return false;
	}
	universalConstants->MinWidth = wMin;
	universalConstants->MinHeight = hMin;
	universalConstants->MinDepth = dMin;
	universalConstants->MinSofL = sMin;
	universalConstants->MinPropFuelUse = pMin;
	universalConstants->MinFTLFuelUse = fMin;
	universalConstants->MinInstFuelUse = iMin;
	universalConstants->MinElectronMass = eMin;
	universalConstants->MinNeutronMass = nMin;
	universalConstants->MinProtonMass = prMin;
	universalConstants->MinPropAccel = paMin;
	universalConstants->MinFTLAccel = faMin;
	universalConstants->MinNumGalaxy = ngMin;
	universalConstants->MaxWidth = wMax;
	universalConstants->MaxHeight = hMax;
	universalConstants->MaxDepth = dMax;
	universalConstants->MaxSofL = sMax;
	universalConstants->MaxPropFuelUse = pMax;
	universalConstants->MaxFTLFuelUse = fMax;
	universalConstants->MaxInstFuelUse = iMax;
	universalConstants->MaxElectronMass = eMax;
	universalConstants->MaxNeutronMass = nMax;
	universalConstants->MaxProtonMass = prMax;
	universalConstants->MaxPropAccel = paMax;
	universalConstants->MaxFTLAccel = faMax;
	universalConstants->MaxNumGalaxy = ngMax;
	universe->MinWidth = wMin;
	universe->MinHeight = hMin;
	universe->MinDepth = dMin;
	universe->MinSofL = sMin;
	universe->MinPropFuelUse = pMin;
	universe->MinFTLFuelUse = fMin;
	universe->MinInstFuelUse = iMin;
	universe->MinElectronMass = eMin;
	universe->MinNeutronMass = nMin;
	universe->MinProtonMass = prMin;
	universe->MinPropAccel = paMin;
	universe->MinFTLAccel = faMin;
	universe->MinNumGalaxy = ngMin;
	universe->MaxWidth = wMax;
	universe->MaxHeight = hMax;
	universe->MaxDepth = dMax;
	universe->MaxSofL = sMax;
	universe->MaxPropFuelUse = pMax;
	universe->MaxFTLFuelUse = fMax;
	universe->MaxInstFuelUse = iMax;
	universe->MaxElectronMass = eMax;
	universe->MaxNeutronMass = nMax;
	universe->MaxProtonMass = prMax;
	universe->MaxPropAccel = paMax;
	universe->MaxFTLAccel = faMax;
	universe->MaxNumGalaxy = ngMax;
	if (universalConstants->name)
	{
		if (strcmp(universalConstants->name, mpNameStrGadget->Text())) 
		{
			if (universalConstants->name) 
			{
				free(universalConstants->name);
			}
			universalConstants->name = (char *)malloc(strlen(mpNameStrGadget->Text()) + 1);
			if (universalConstants->name) 
			{
				strcpy(universalConstants->name, mpNameStrGadget->Text());
			}
			else 
			{
				warning(FailName);
				return false;
			}
		}
	}
	else
	{
		universalConstants->name = (char *)malloc(strlen(mpNameStrGadget->Text()) + 1);
		if (universalConstants->name) 
		{
			strcpy(universalConstants->name, mpNameStrGadget->Text());
		}
		else 
		{
			warning(FailName);
			return false;
		}
	}
	return true;
}//end


void
EditUniversalConstantsWindow	::	FillStrGadgets(	void)
{
	char uInt32GadgetBuf[16];
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MinWidth);
	MinWidthGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MinHeight);
	MinHeightGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MinDepth);
	MinDepthGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MinSofL);
	MinSofLGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MinPropFuelUse);
	MinPropFuelUseGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MinPropAccel);
	MinPropAccelGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MinFTLFuelUse);
	MinFTLFuelUseGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MinFTLAccel);
	MinFTLAccelGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MinInstFuelUse);
	MinInstFuelUseGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MinElectronMass);
	MinElectronMassGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MinNeutronMass);
	MinNeutronMassGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MinProtonMass);
	MinProtonMassGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MinNumGalaxy);
	MinNumGalaxyGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MaxWidth);
	MaxWidthGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MaxHeight);
	MaxHeightGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MaxDepth);
	MaxDepthGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MaxSofL);
	MaxSofLGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MaxPropFuelUse);
	MaxPropFuelUseGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MaxPropAccel);
	MaxPropAccelGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MaxFTLFuelUse);
	MaxFTLFuelUseGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MaxFTLAccel);
	MaxFTLAccelGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MaxInstFuelUse);
	MaxInstFuelUseGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MaxElectronMass);
	MaxElectronMassGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MaxNeutronMass);
	MaxNeutronMassGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MaxProtonMass);
	MaxProtonMassGadget->SetText(uInt32GadgetBuf);
	sprintf(uInt32GadgetBuf, "%u", universalConstantsCurrent->MaxNumGalaxy);
	MaxNumGalaxyGadget->SetText(uInt32GadgetBuf);
}//end
