//editorGalaxy.cpp

#include "windowGuts.h"
#include "myButton.h"
#include "designButtons.h"
#include "editUniverseWindow.h"
#include "bottomLine.h"
#include "editGalaxyWindow.h"
#include "def.h"
#include "bottomLine.h"

void EditUniverseWindow::EditGalaxyList(void) {

float biggestX = 632;
float biggestY = 475;
BRect editWindowRect(40,21, biggestX,biggestY);
editGalaxyWindow = new EditGalaxyWindow(editWindowRect, editThe[GALAXY_TYPE]);
if (!editGalaxyWindow) {
	warning(failEditWindow);
	return;
}
editGalaxyWindow->Lock();

char * prelimName;
char prelimW[UINTSTRLEN];
char prelimH[UINTSTRLEN];
char prelimD[UINTSTRLEN];
int32 mode;
if (galaxyCurrent) {
	prelimName = galaxyCurrent->name;
	SPRTF(prelimW, "%u", galaxyCurrent->width);
	SPRTF(prelimH, "%u", galaxyCurrent->height);
	SPRTF(prelimD, "%u", galaxyCurrent->depth);
	mode = SOI_BLREMOVE;
}
else {
	prelimName = NULL;
	prelimW[0] = NULL;
	prelimH[0] = NULL;
	prelimD[0] = NULL;
	mode = SOI_BLADD;
}

int32 left = 10;
int32 width = 235;
int32 height = 18;
int32 vgap = 23;//height + Vspacing
float divider = 160.0;
int32 top = 24;

BRect nameRect(10,2, 580,18);
BMessage * bmName = new BMessage(SOI_NAMEGALAXY);
if (!bmName) {
	warning(failMemory);
	return;
}
editGalaxyWindow->nameStrGadget = new StringGadget(nameRect, nameGadgetStr, nameOf[GALAXY_TYPE], prelimName, bmName, B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
if (!editGalaxyWindow->nameStrGadget) {
	warning(failStringGadget);
	return;
}
editGalaxyWindow->nameStrGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editGalaxyWindow->nameStrGadget->SetDivider(200.0);
if (mode == SOI_BLADD) editGalaxyWindow->nameStrGadget->makeFocus = true;
editGalaxyWindow->AddChild(editGalaxyWindow->nameStrGadget);
BRect wRect(left,top, width,top + height);
editGalaxyWindow->wIntGadget = new IntGadget(wRect, wGadgetStr, wGalaxy, prelimW, new BMessage(SOI_WGALAXY), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
if (!editGalaxyWindow->wIntGadget) {
	warning(failIntGadget);
	return;
}
editGalaxyWindow->wIntGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editGalaxyWindow->wIntGadget->SetDivider(divider);
editGalaxyWindow->AddChild(editGalaxyWindow->wIntGadget);

top += vgap;
BRect hRect(left,top, width,top + height);
editGalaxyWindow->hIntGadget = new IntGadget(hRect, hGadgetStr, hGalaxy, prelimH, new BMessage(SOI_HGALAXY), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
if (!editGalaxyWindow->hIntGadget) {
	warning(failIntGadget);
	return;
}
editGalaxyWindow->hIntGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editGalaxyWindow->hIntGadget->SetDivider(divider);
editGalaxyWindow->AddChild(editGalaxyWindow->hIntGadget);

top += vgap;
BRect dRect(left,top, width,top + height);
editGalaxyWindow->dIntGadget = new IntGadget(dRect, dGadgetStr, dGalaxy, prelimD, new BMessage(SOI_DGALAXY), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
if (!editGalaxyWindow->dIntGadget) {
	warning(failIntGadget);
	return;
}
editGalaxyWindow->dIntGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editGalaxyWindow->dIntGadget->SetDivider(divider);
editGalaxyWindow->AddChild(editGalaxyWindow->dIntGadget);

bool save = false;
if (dataListGlobal[GALAXY_TYPE]->list->CountItems()) save = true;
editGalaxyWindow->bottom = 405;
BottomLine(GALAXY_TYPE, (EditUniverseWindow * )editGalaxyWindow, editGalaxyWindow->bottom, editGalaxyWindow->bb, mode, save);
editGalaxyWindow->thisDNPtr = dataListGlobal[GALAXY_TYPE]->NextPrevItems((void *)galaxyCurrent, &editGalaxyWindow->nextDNPtr, &editGalaxyWindow->prevDNPtr, editGalaxyWindow->bb);

editGalaxyWindow->Unlock();
editGalaxyWindow->Show();
}//end