//myListView.cpp

#include "Xthings.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "preferences.h"
#include "myroColour.h"
#include "myPreferences.h"
#include "myApp.h"
#include "dataNode.h"
#include "dataList.h"
#include "XmyListView.h"
#include "myListView.h"
#include "layoutMatrix.h"
#include "Xwarning.h"

MyListView	::	~MyListView() 
{
	//left blank
};//end


//ctor
MyListView	::	MyListView(	const char * paramName,
							DataList * pparamDataList,
							uint32 ui32paramSelectMsg,
							uint32 ui32paramInvokeMsg,
							list_view_type ui32paramSelectType,
							LayoutMatrix * lpparamLayoutMatrix) 
				: 
					BListView(	BRect(0,0,32,32), 
								paramName, 
								ui32paramSelectType, 
								B_FOLLOW_LEFT | B_FOLLOW_TOP, 
								B_WILL_DRAW | B_NAVIGABLE | B_FRAME_EVENTS),
					fmWidth(0),
					fmHeight(0)
{
	lpparamLayoutMatrix->AddToChildren((void *)this);
	try
	{
		float temp = 0;
		BView bv(BRect(0, 0, 32, 32), NoShowView, B_FOLLOW_NONE, NULL);
		bv.SetFont(myPrefs->GetPreferredFont());
		font_height fontHeight;
		bv.GetFontHeight(&fontHeight);
		bv.RemoveSelf();
		fmHeight = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
		fmHeight *= pparamDataList->list->CountItems();
		DataNode * node;
		#pragma warn_possunwant off
		for (	int32 i = 0; 
				node = (DataNode *)pparamDataList->list->ItemAt(i); 
				i++) 
		{
		#pragma warn_possunwant reset
			const char * name = node->MyName(pparamDataList->kind);
			BStringItem * bsi = new BStringItem(name);
			AddItem(bsi);
			bsi->SetEnabled(true);
			temp = bv.StringWidth(name);
			if (temp > fmWidth)
			{
				fmWidth = temp;
			}
		}
		temp = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
		temp *= .5;
		fmHeight += temp;
		temp = bv.StringWidth("ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890");
		temp /= 36;
		fmWidth += (temp / 2);
		if (ui32paramSelectMsg)
		{
			SetSelectionMessage(new BMessage(ui32paramSelectMsg));
		}
		if (ui32paramInvokeMsg)
		{
			SetInvocationMessage(new BMessage(ui32paramInvokeMsg));
		}
		rgb_color viewColor;
		myPrefs->GetPreferredMyListViewViewColor(&viewColor);
		SetViewColor(viewColor);
		myPrefs->GetPreferredMyListViewHighColor(&viewColor);
		SetHighColor(viewColor);
		myPrefs->GetPreferredMyListViewLowColor(&viewColor);
		SetLowColor(viewColor);
	}
	catch (...)
	{
		warning(FailMemory);
		throw;
	}
}//end


void 
MyListView	::	AttachedToWindow() 
{
	BListView::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredMyListViewViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
	myPrefs->GetPreferredMyListViewHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredMyListViewLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
}//end


void
MyListView	::	MyGetPreferredSize(	float * fpparamWidth,
									float * fpparamHeight)
{
	*fpparamHeight = fmHeight;
	*fpparamWidth = fmWidth;
}//end