//scrolling fontPref window

#include "DmenuMsg.h"
#include "windowGuts.h"
#include "Xs2f.h"
#include "XlayoutMatrixItem.h"
#include "DlayoutMatrix.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "preferences.h"
#include "myTextView.h"
#include "myListView.h"
#include "myButton.h"
#include "uInt32Gadget.h"
#include "floatGadget.h"
#include "stringGadget.h"
#include "myPictureButton.h"
#include "myStatusBar.h"
#include "myRadioView.h"
#include "myCheckBox.h"
#include "myColorControl.h"
#include "XcolorWell.h"
#include "colorWell.h"
#include "prefPanelWindow.h"
#include "myPreferences.h"
#include "XspecificColorWindow.h"
#include "specificColorWindow.h"
#include "Xwarning.h"
#include "preferences.h"
#include "myroColour.h"
#include "myApp.h"
#include <memory>
#include "titleWindow.h"
#include "dataNode.h"
#include "dataList.h"
#include "constants.h"
#include "universalConstants.h"
#include "universe.h"
#include "scrollView.h"
#include "Xverify.h"

const char * lScrollViewName[NUMSPECIFICWINDOWS] = 
{
	"scBUTTON",
	"scPICTURE",
	"scRADIOVIEW",
	"scCHECKBOX",
	"scSTATUSBAR",
	"scCOLORCONTROL",
	"scTEXTVIEW",
	"scINTGADG",
	"scSTRINGGADG",
	"scCOLORWELL",
	"scSTRINGDRAWER",
	"scLISTVIEW",
	"scFLOATGADG"
};
//the following array is also duplicated in myPreferences.cpp
const char * lNamePrefFrame[NUMSPECIFICWINDOWS] = 
{
	"SPECIFICCOLORBUTTON",
	"SPECIFICCOLORPICTURE",
	"SPECIFICCOLORRADIOVIEW",
	"SPECIFICCOLORCHECKBOX",
	"SPECIFICCOLORSTATUSBAR",
	"SPECIFICCOLORCOLORCONTROL",
	"SPECIFICCOLORTEXTVIEW",
	"SPECIFICCOLORINTGADG",
	"SPECIFICCOLORSTRINGGADG",
	"SPECIFICCOLORCOLORWELL",
	"SPECIFICCOLORSTRINGDRAWER",
	"SPECIFICCOLORLISTVIEW",
	"SPECIFICCOLORFLOATGADG"
};

//ctor
SpecificColorWindow	::	SpecificColorWindow(	BRect paramBound,
												uint32 ui32paramkind)
				: 
				WindowGuts(	paramBound, 
							lvwTitleStr[ui32paramkind], 
							lScrollViewName[ui32paramkind],
							lNamePrefFrame[ui32paramkind]),
				pmViewColorControl(NULL),
				pmHighColorControl(NULL),
				pmLowColorControl(NULL),
				pmViewColorWell(NULL),
				pmHighColorWell(NULL),
				pmLowColorWell(NULL),
				pmBarColorControl(NULL),
				pmBarColorWell(NULL),
				mpBarHeightFloatGadget(NULL),
				kind(ui32paramkind)
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning(FailCreateSemaphore);
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		LayoutMatrix *	pholdTitleLayoutMatrix = new LayoutMatrix(BESTSIZE, 1, 1, this);//rows,columns
/////////////////////////////////////////////////////////////////////////////////////////////
		BFont * pBFont = new BFont(myPrefs->GetPreferredFont());
		float fontSize = pBFont->Size();
		fontSize *= 3;
		if (fontSize > 200)
		{
			fontSize = 200;
		}
		pBFont->SetSize(fontSize);
		pBFont->SetShear(122);
		//will need offset for demo--use a seperate matrix and get it's bottom
		MyStringDrawer * pMyStringDrawer = new MyStringDrawer(	"specificTitleMyStringDrawer", 
																lvwTitleStr[kind], 
																B_FOLLOW_NONE, 
																B_WILL_DRAW,
																pBFont,
																pholdTitleLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMyStringDrawerLMI(new LayoutMatrixItem(	(void *)pMyStringDrawer, 
																				pholdTitleLayoutMatrix->itemsList,
																				KIND_STRINGDRAWER));
/////////////////////////////
		if (!myPrefs->bUseColorControl && !myPrefs->bUseColorWell)
		{
			warning(noCCenabled);
		}
		LayoutMatrix * pholdViewCCLayoutMatrix = NULL;
		LayoutMatrix * pholdHighCCLayoutMatrix = NULL;
		LayoutMatrix * pholdLowCCLayoutMatrix = NULL;
		MyStringDrawer * pMyStringDrawerAXX = NULL;
		LayoutMatrixItem * pMyStringDrawerAXXLMI = NULL;
		LayoutMatrixItem * pColorControlAXXLMI = NULL;
		MyStringDrawer * pMyStringDrawerBXX = NULL;
		LayoutMatrixItem * pMyStringDrawerBXXLMI = NULL;
		LayoutMatrixItem * pColorControlBXXLMI = NULL;
		MyStringDrawer * pMyStringDrawerCXX = NULL;
		LayoutMatrixItem * pMyStringDrawerCXXLMI = NULL;
		LayoutMatrixItem * pColorControlCXXLMI = NULL;
		rgb_color color;//re-use for every setvalue
		if (myPrefs->bUseColorControl)
		{
			pholdViewCCLayoutMatrix = new LayoutMatrix(BESTSIZE, 2, 1, this);//rows,columns
	/////////////////////////////////////////////////////////////////////////////////////
			pMyStringDrawerAXX = new MyStringDrawer(	"MyStringDrawerAXX", 
														ColorWindowHeading2, 
														B_FOLLOW_NONE, 
														B_WILL_DRAW,
														NULL,
														pholdViewCCLayoutMatrix);
			pMyStringDrawerAXXLMI = new  LayoutMatrixItem(	(void *)pMyStringDrawerAXX, 
															pholdViewCCLayoutMatrix->itemsList,
															KIND_STRINGDRAWER);
	////////////////////////////////////////////////////////////////////
			pmViewColorControl = new MyColorControl(	BPoint(1, 1), 
														B_CELLS_8x32,//lots of other options! Make a pref??
														1,
														"ColorControlAXX", 
														COLORCONTROL_VIEW,
														true,
														this,
														pholdViewCCLayoutMatrix);
			switch (kind)
			{
				case SPECIFIC_COLOR_BUTTON:
					myPrefs->GetPreferredMyButtonViewColor(&color);
					pmViewColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_PICTURE:
					myPrefs->GetPreferredMyPictureButtonViewColor(&color);
					pmViewColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_RADIOVIEW:
					myPrefs->GetPreferredMyRadioViewViewColor(&color);
					pmViewColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_CHECKBOX:
					myPrefs->GetPreferredMyCheckBoxViewColor(&color);
					pmViewColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_STATUSBAR:
					myPrefs->GetPreferredMyStatusBarViewColor(&color);
					pmViewColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_COLORCONTROL:
					myPrefs->GetPreferredMyColorControlViewColor(&color);
					pmViewColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_TEXTVIEW:
					myPrefs->GetPreferredMyTextViewViewColor(&color);
					pmViewColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_LISTVIEW:
					myPrefs->GetPreferredMyListViewViewColor(&color);
					pmViewColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_INTGADG:
					myPrefs->GetPreferredUInt32GadgetViewColor(&color);
					pmViewColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_FLOATGADG:
					myPrefs->GetPreferredFloatGadgetViewColor(&color);
					pmViewColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_STRINGGADG:
					myPrefs->GetPreferredStringGadgetViewColor(&color);
					pmViewColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_COLORWELL:
					myPrefs->GetPreferredColorWellViewColor(&color);
					pmViewColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_STRINGDRAWER:
					myPrefs->GetPreferredMyStringDrawerViewColor(&color);
					pmViewColorControl->SetValue(color);
				break;
				default:
					warning(BadSpecColorKindView);
					throw;
				break;
			}
			pColorControlAXXLMI = new  LayoutMatrixItem(	(void *)pmViewColorControl, 
															pholdViewCCLayoutMatrix->itemsList,
															KIND_MYCOLORCONTROL);
	/////////////////////
			pholdHighCCLayoutMatrix = new LayoutMatrix(BESTSIZE, 2, 1, this);//rows,columns
	////////////////////////////////
			pMyStringDrawerBXX = new MyStringDrawer(	"MyStringDrawerBXX", 
														ColorWindowHeading3, 
														B_FOLLOW_NONE, 
														B_WILL_DRAW,
														NULL,
														pholdHighCCLayoutMatrix);
			pMyStringDrawerBXXLMI = new  LayoutMatrixItem(	(void *)pMyStringDrawerBXX, 
															pholdHighCCLayoutMatrix->itemsList,
															KIND_STRINGDRAWER);
	/////////////////////////////////////////////
			pmHighColorControl = new MyColorControl(	BPoint(1, 1), 
														B_CELLS_8x32,
														1,
														"HighColorControlBXX", 
														COLORCONTROL_HIGH,
														true,
														this,
														pholdHighCCLayoutMatrix);
			switch (kind)
			{
				case SPECIFIC_COLOR_BUTTON:
					myPrefs->GetPreferredMyButtonHighColor(&color);
					pmHighColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_PICTURE:
					myPrefs->GetPreferredMyPictureButtonHighColor(&color);
					pmHighColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_RADIOVIEW:
					myPrefs->GetPreferredMyRadioViewHighColor(&color);
					pmHighColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_CHECKBOX:
					myPrefs->GetPreferredMyCheckBoxHighColor(&color);
					pmHighColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_STATUSBAR:
					myPrefs->GetPreferredMyStatusBarHighColor(&color);
					pmHighColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_COLORCONTROL:
					myPrefs->GetPreferredMyColorControlHighColor(&color);
					pmHighColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_TEXTVIEW:
					myPrefs->GetPreferredMyTextViewHighColor(&color);
					pmHighColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_LISTVIEW:
					myPrefs->GetPreferredMyListViewHighColor(&color);
					pmHighColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_INTGADG:
					myPrefs->GetPreferredUInt32GadgetHighColor(&color);
					pmHighColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_FLOATGADG:
					myPrefs->GetPreferredFloatGadgetHighColor(&color);
					pmHighColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_STRINGGADG:
					myPrefs->GetPreferredStringGadgetHighColor(&color);
					pmHighColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_COLORWELL:
					myPrefs->GetPreferredColorWellHighColor(&color);
					pmHighColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_STRINGDRAWER:
					myPrefs->GetPreferredMyStringDrawerHighColor(&color);
					pmHighColorControl->SetValue(color);
				break;
				default:
					warning(BadSpecColorKindHigh);
					throw;
				break;
			}
			pColorControlBXXLMI = new  LayoutMatrixItem(	(void *)pmHighColorControl, 
															pholdHighCCLayoutMatrix->itemsList,
															KIND_MYCOLORCONTROL);
	//////////////////////////////////////////////////////////////
			pholdLowCCLayoutMatrix = new LayoutMatrix(BESTSIZE, 2, 1, this);//rows,columns
	///////////////////////////////////////////////////
			pMyStringDrawerCXX = new MyStringDrawer(	"MyStringDrawerCXX", 
																		ColorWindowHeading4, 
																		B_FOLLOW_NONE, 
																		B_WILL_DRAW,
																		NULL,
																		pholdLowCCLayoutMatrix);
			pMyStringDrawerCXXLMI = new  LayoutMatrixItem(	(void *)pMyStringDrawerCXX, 
															pholdLowCCLayoutMatrix->itemsList,
															KIND_STRINGDRAWER);
	///////////////////////////////////////////////////////////////////
			pmLowColorControl = new MyColorControl(	BPoint(1, 1), 
													B_CELLS_8x32,
													1,
													"LowColorControlCXX", 
													COLORCONTROL_LOW,
													true,
													this,
													pholdLowCCLayoutMatrix);
			switch (kind)
			{
				case SPECIFIC_COLOR_BUTTON:
					myPrefs->GetPreferredMyButtonLowColor(&color);
					pmLowColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_PICTURE:
					myPrefs->GetPreferredMyPictureButtonLowColor(&color);
					pmLowColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_RADIOVIEW:
					myPrefs->GetPreferredMyRadioViewLowColor(&color);
					pmLowColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_CHECKBOX:
					myPrefs->GetPreferredMyCheckBoxLowColor(&color);
					pmLowColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_STATUSBAR:
					myPrefs->GetPreferredMyStatusBarLowColor(&color);
					pmLowColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_COLORCONTROL:
					myPrefs->GetPreferredMyColorControlLowColor(&color);
					pmLowColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_TEXTVIEW:
					myPrefs->GetPreferredMyTextViewLowColor(&color);
					pmLowColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_LISTVIEW:
					myPrefs->GetPreferredMyListViewLowColor(&color);
					pmLowColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_INTGADG:
					myPrefs->GetPreferredUInt32GadgetLowColor(&color);
					pmLowColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_FLOATGADG:
					myPrefs->GetPreferredFloatGadgetLowColor(&color);
					pmLowColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_STRINGGADG:
					myPrefs->GetPreferredStringGadgetLowColor(&color);
					pmLowColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_COLORWELL:
					myPrefs->GetPreferredColorWellLowColor(&color);
					pmLowColorControl->SetValue(color);
				break;
				case SPECIFIC_COLOR_STRINGDRAWER:
					myPrefs->GetPreferredMyStringDrawerLowColor(&color);
					pmLowColorControl->SetValue(color);
				break;
				default:
					warning(BadSpecColorKindLow);
					throw;
				break;
			}                         
			pColorControlCXXLMI = new  LayoutMatrixItem(	(void *)pmLowColorControl, 
															pholdLowCCLayoutMatrix->itemsList,
															KIND_MYCOLORCONTROL);
		}
////////////////////////
		LayoutMatrix * pholdColorWellLayoutMatrix = NULL;
		TextItem * pholdMainViewColorWellText = NULL;
		LayoutMatrixItem * pMainViewLMI = NULL;
		TextItem * pholdMainHighColorWellText = NULL;
		LayoutMatrixItem * pMainHighLMI = NULL;
		TextItem * pholdMainLowColorWellText = NULL;
		LayoutMatrixItem * pMainLowLMI = NULL;
		if (myPrefs->bUseColorWell)
		{
			pholdColorWellLayoutMatrix = new LayoutMatrix(BESTSIZE, 3, 1, this);//rows,columns
	//////////////
			pholdMainViewColorWellText = new TextItem(	ColorWindowHeading5,
														pholdColorWellLayoutMatrix);
			pmViewColorWell = new ColorWell(	"ColorWellViewColorPref", 
												B_FOLLOW_NONE, 
												B_WILL_DRAW,
												VIEW_COLOR,
												pholdMainViewColorWellText,
												pholdColorWellLayoutMatrix);
			pMainViewLMI = new  LayoutMatrixItem(	(void *)pmViewColorWell, 
													pholdColorWellLayoutMatrix->itemsList,
													KIND_COLORWELLGADG);
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			pholdMainHighColorWellText = new TextItem(	ColorWindowHeading6,
														pholdColorWellLayoutMatrix);
			pmHighColorWell = new ColorWell(	"ColorWellHighColorPref", 
												B_FOLLOW_NONE, 
												B_WILL_DRAW,
												HIGH_COLOR,
												pholdMainHighColorWellText,
												pholdColorWellLayoutMatrix);
			pMainHighLMI = new  LayoutMatrixItem(	(void *)pmHighColorWell, 
													pholdColorWellLayoutMatrix->itemsList,
													KIND_COLORWELLGADG);
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			pholdMainLowColorWellText = new TextItem(	ColorWindowHeading7,
														pholdColorWellLayoutMatrix);
			pmLowColorWell = new ColorWell(	"ColorWellLowColorPref", 
											B_FOLLOW_NONE, 
											B_WILL_DRAW,
											LOW_COLOR,
											pholdMainLowColorWellText,
											pholdColorWellLayoutMatrix);
			pMainLowLMI = new  LayoutMatrixItem(	(void *)pmLowColorWell, 
													pholdColorWellLayoutMatrix->itemsList,
													KIND_COLORWELLGADG);
		}
///////////////////////////////////////////////////////////////////////
		LayoutMatrix * pholdDemoLayoutMatrix = new LayoutMatrix(BESTSIZE, 1, 1, this);//rows,columns
//////////////////////////////////
		int32 kindDemo;
		void * pholdDemo;
		switch (kind)
		{
			case SPECIFIC_COLOR_BUTTON:
			{
				MyButton * pholdDemoMyButton = new MyButton(	"demoButton", 
																DemoButtonLable, 
																DEMOBUTTONMSG,
																B_FOLLOW_NONE, 
																B_WILL_DRAW,
																pholdDemoLayoutMatrix);
				kindDemo = KIND_MYBUTTON;
				pholdDemo = (void *)pholdDemoMyButton;
			break;
			}
			case SPECIFIC_COLOR_PICTURE:
			{
				BPicture * pOnPicture;
				BPicture * pOnDisabledPicture;
				BPicture * pOffPicture;
				BPicture * pOffDisabledPicture;
				BWindow bwn(	BRect(0, 0, 32, 32), //manditory for BPicture
								NoShowWindow, 
								B_DOCUMENT_WINDOW, 
									/*B_WILL_ACCEPT_FIRST_CLICK*/0);
				BView bv(BRect(0, 0, 32, 32), NoShowView, B_FOLLOW_NONE, NULL);
				bwn.AddChild(&bv);
				bv.BeginPicture(new BPicture);
				bv.MoveTo(5, 5);
				bv.StrokeRect(BRect(0,0,8,8));
				pOffPicture = bv.EndPicture();
				
				bv.BeginPicture(new BPicture);
				bv.MoveTo(10, 5);
				bv.StrokeRect(BRect(0,0,10,15));
				pOnPicture = bv.EndPicture();
				
				bv.BeginPicture(new BPicture);
				bv.MoveTo(2, 5);
				bv.FillRect(BRect(0,0,22,20));
				pOffDisabledPicture = bv.EndPicture();
				
				bv.BeginPicture(new BPicture);
				bv.MoveTo(1, 5);
				bv.FillRect(BRect(0,0,6,15));
				pOnDisabledPicture = bv.EndPicture();
				bv.RemoveSelf();
				MyPictureButton * pholdDemoMyPictureButton = new MyPictureButton(	BRect(0, 0, 32, 32),
																					"DemoPictureButton", 
																					pOffPicture,
																					pOnPicture,
																					pOffDisabledPicture,
																					pOnDisabledPicture,
																					DEMOPICTUREBUTTONMSG,
																					B_TWO_STATE_BUTTON,//B_ONE_STATE_BUTTON
																					B_FOLLOW_NONE, 
																					B_WILL_DRAW,
																					pholdDemoLayoutMatrix);
				kindDemo = KIND_MYPICTUREBUTTON;
				pholdDemo = (void *)pholdDemoMyPictureButton;
			break;
			}
			case SPECIFIC_COLOR_RADIOVIEW:
			{
				BList * pBList = new BList();
				RadioViewData * pRadioViewDataOne = new RadioViewData();
				pRadioViewDataOne->mLabel = DemoRadio1Lable;
				BMessage * pOneMsg = new BMessage('_one');
				pRadioViewDataOne->pmMsg = pOneMsg;
				pBList->AddItem((void *)pRadioViewDataOne);
				
				RadioViewData * pRadioViewDataTwo = new RadioViewData();
				pRadioViewDataTwo->mLabel = DemoRadio2Lable;
				BMessage * pTwoMsg = new BMessage('_two');
				pRadioViewDataTwo->pmMsg = pTwoMsg;
				pBList->AddItem((void *)pRadioViewDataTwo);
				
				RadioViewData * pRadioViewDataThree = new RadioViewData();
				pRadioViewDataThree->mLabel = DemoRadio3Lable;
				BMessage * pThreeMsg = new BMessage('thre');
				pRadioViewDataThree->pmMsg = pThreeMsg;
				pBList->AddItem((void *)pRadioViewDataThree);
				
				MyRadioView * pholdMyRadioView = new MyRadioView(	"firstRadio",
																	false,//true gives vertical orientation
																	pBList,
																	myPrefs->GetPreferredFont(),
																	pholdDemoLayoutMatrix);
				bool success = pholdMyRadioView->Initialize();
				if (!success)
				{
					warning(DemoRadioFailInit);
					throw;
				}
				kindDemo = KIND_MYRADIOVIEW;
				pholdDemo = (void *)pholdMyRadioView;
			break;
			}
			case SPECIFIC_COLOR_CHECKBOX:
			{
				MyCheckBox * pholdCheckBox = new MyCheckBox(	"checkBox", 
																DemoCheckBoxLable, 
																B_CONTROL_ON,
																'_one',
																B_FOLLOW_NONE, 
																B_WILL_DRAW,
																pholdDemoLayoutMatrix);
				kindDemo = KIND_MYCHECKBOX;
				pholdDemo = (void *)pholdCheckBox;
			break;
			}
			case SPECIFIC_COLOR_STATUSBAR:
			{
				MyStatusBar * pholdStatusBar = new MyStatusBar(	BRect(1, 1, 32, 32), 
																"StatusBarname", 
																DemoSTatusBarLeadLable, 
																DemoSTatusBarTrailLable,
																50,
																25,
																pholdDemoLayoutMatrix);
				kindDemo = KIND_MYSTATUSBAR;
				pholdDemo = (void *)pholdStatusBar;
			break;
			}
			case SPECIFIC_COLOR_COLORCONTROL:
			{
				MyColorControl * pholdColorControl = new MyColorControl(	BPoint(1, 1), 
																			B_CELLS_8x32,
																			1,
																			"ColorControl", 
																			DEMOCOLORCONTROLMSG,
																			true,
																			this,
																			pholdDemoLayoutMatrix);
			
				kindDemo = KIND_MYCOLORCONTROL;
				pholdDemo = (void *)pholdColorControl;
			break;
			}
			case SPECIFIC_COLOR_TEXTVIEW:
			{
				BView bv(BRect(0, 0, 32, 32), NoShowView, B_FOLLOW_NONE, B_WILL_DRAW);
				bv.SetFont(myPrefs->GetPreferredFont());
				font_height	fontHeight;
				bv.GetFontHeight(&fontHeight);
				float stringEntryPixHeight = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
				float stringEntryPixWidth = bv.StringWidth(TextGadgetLable);
				MyTextView * pholdTextView = new MyTextView(	"textView", 
																NULL, 
																stringEntryPixWidth,
																6 * stringEntryPixHeight,//allow 6 lines visible
																pholdDemoLayoutMatrix);
				rgb_color textColor;
				myPrefs->GetPreferredMyTextViewHighColor(&textColor);
				pholdTextView->SetFontAndColor(myPrefs->GetPreferredFont(), B_FONT_ALL, &textColor);
				pholdTextView->SetText(TextGadgetLable);
				kindDemo = KIND_MYTEXTVIEW;
				pholdDemo = (void *)pholdTextView;
			break;
			}
			case SPECIFIC_COLOR_LISTVIEW:
			{
				DataList * dataList = new DataList(UNIVERSE_TYPE);
				Universe * univ1 = new Universe();
				univ1->name =  (char *)malloc(strlen(ListViewSample1) + 1);
				if (!univ1->name)
				{
					throw;
				}
				strcpy(univ1->name, ListViewSample1);
				DataNode * nodeOne = new DataNode(univ1);
				dataList->AddItem(nodeOne);
				Universe * univ2 = new Universe();
				univ2->name =  (char *)malloc(strlen(ListViewSample2) + 1);
				if (!univ2->name)
				{
					throw;
				}
				strcpy(univ2->name, ListViewSample2);
				DataNode * nodeTwo = new DataNode(univ2);
				dataList->AddItem(nodeTwo);
				Universe * univ3 = new Universe();
				univ3->name =  (char *)malloc(strlen(ListViewSample3) + 1);
				if (!univ3->name)
				{
					throw;
				}
				
				strcpy(univ3->name, ListViewSample3);
				DataNode * nodeThree = new DataNode(univ3);
				dataList->AddItem(nodeThree);
				MyListView * mlv = new MyListView(	"mlvTitle",
													dataList,
													'selc',
													'invc',
													B_SINGLE_SELECTION_LIST,
													pholdDemoLayoutMatrix);
				kindDemo = KIND_MYLISTVIEW;
				pholdDemo = (void *)mlv;
			break;
			}
			case SPECIFIC_COLOR_INTGADG:
			{
				UInt32Gadget * pholdUInt32Gadget = new UInt32Gadget(	123,
																		"uInt32Gadget", 
																		UInt32GadgetLable, 
																		DEMOINTGADGMSG,
																		B_FOLLOW_NONE, 
																		B_WILL_DRAW | B_NAVIGABLE,
																		0,
																		pholdDemoLayoutMatrix);
				kindDemo = KIND_INTGADG;
				pholdDemo = (void *)pholdUInt32Gadget;
			break;
			}
			case SPECIFIC_COLOR_FLOATGADG:
			{
				FloatGadget * pholdFloatGadget = new FloatGadget(	(float)1.23,
																	"floatGadget", 
																	FloatGadgetLable, 
																	DEMOFLOATGADGMSG,
																	B_FOLLOW_NONE, 
																	B_WILL_DRAW | B_NAVIGABLE,
																	0,
																	pholdDemoLayoutMatrix);
				kindDemo = KIND_FLOATGADG;
				pholdDemo = (void *)pholdFloatGadget;
			break;
			}
			case SPECIFIC_COLOR_STRINGGADG:
			{
				StringGadget * pholdStringGadget = new StringGadget(	"stringGadgetName", 
																		StringGadgetLable, 
																		NULL, 
																		DEMOSTRINGGADGMSG,
																		B_FOLLOW_NONE, 
																		B_WILL_DRAW | B_NAVIGABLE,
																		0,
																		pholdDemoLayoutMatrix);
				kindDemo = KIND_STRINGGADG;
				pholdDemo = (void *)pholdStringGadget;
			break;
			}
			case SPECIFIC_COLOR_COLORWELL:
			{
				TextItem * pholdText = new TextItem(	DemoRoLable,
														pholdDemoLayoutMatrix);
				ColorWell * pholdColorWell = new ColorWell(	"colorWell", 
															B_FOLLOW_NONE, 
															B_WILL_DRAW,
															NO_COLOR,
															pholdText,
															pholdDemoLayoutMatrix);
				kindDemo = KIND_COLORWELLGADG;
				pholdDemo = (void *)pholdColorWell;
			break;
			}
			case SPECIFIC_COLOR_STRINGDRAWER:
			{
				MyStringDrawer * pholdMyStringDrawer = new MyStringDrawer(	"stringDrawer", 
																			DemoTextItemText, 
																			B_FOLLOW_NONE, 
																			B_WILL_DRAW,
																			NULL,
																			pholdDemoLayoutMatrix);
				kindDemo = KIND_STRINGDRAWER;
				pholdDemo = (void *)pholdMyStringDrawer;
			break;
			}
			default:
				warning(BadSpecItemKind);
				throw;
			break;
		}
		pmDemoItem = pholdDemo;
		auto_ptr<LayoutMatrixItem> apDemoLMI(new LayoutMatrixItem(	(void *)pholdDemo, 
																	pholdDemoLayoutMatrix->itemsList,
																	kindDemo));
/////////////////////
		LayoutMatrix *	pholdBarTitleLayoutMatrix = NULL;
		LayoutMatrix *	pholdBarCCLayoutMatrix = NULL;
		LayoutMatrix * pholdBarCWLayoutMatrix = NULL;
		LayoutMatrix * pholdBarHLayoutMatrix = NULL;
		LayoutMatrixItem * pBarHeadingLMI = NULL;
		LayoutMatrixItem * pBarColorLabelLMI = NULL;
		LayoutMatrixItem * pBarCCLMI = NULL;
		LayoutMatrixItem * pBarCWLMI = NULL;
		LayoutMatrixItem * pBarHeightLMI = NULL;
///////////////////////////
		if (kind == SPECIFIC_COLOR_STATUSBAR)
		{
			pholdBarTitleLayoutMatrix = new LayoutMatrix(BESTSIZE, 1, 1, this);//rows,columns
////////////////////////////////////////////////////////////////
			BFont * pBFontBar = new BFont(myPrefs->GetPreferredFont());
			float fontSize = pBFontBar->Size();
			fontSize *= 3;
			if (fontSize > 200)
			{
				fontSize = 200;
			}
			pBFontBar->SetSize(fontSize);
			pBFontBar->SetShear(122);
			//will need offset for demo--use a seperate matrix and get it's bottom
			MyStringDrawer * pBarMyStringDrawer = new MyStringDrawer(	"specificTitleBarMyStringDrawer", 
																		BarColorTitle, 
																		B_FOLLOW_NONE, 
																		B_WILL_DRAW,
																		pBFontBar,
																		pholdBarTitleLayoutMatrix);
			pBarHeadingLMI = new LayoutMatrixItem(	(void *)pBarMyStringDrawer, 
													pholdBarTitleLayoutMatrix->itemsList,
													KIND_STRINGDRAWER);
//////////////////////////////////////////////////
			pholdBarCCLayoutMatrix = new LayoutMatrix(BESTSIZE, 2, 1, this);//rows,columns
///////////////////////////////////////////////////////////////////////////////////
			MyStringDrawer * pBarMyStringDrawerAXX = new MyStringDrawer(	"BarMyStringDrawerAXX", 
																			BarCCLabel, 
																			B_FOLLOW_NONE, 
																			B_WILL_DRAW,
																			NULL,
																			pholdBarCCLayoutMatrix);
			pBarColorLabelLMI = new LayoutMatrixItem(	(void *)pBarMyStringDrawerAXX, 
														pholdBarCCLayoutMatrix->itemsList,
														KIND_STRINGDRAWER);
////////////////////////////////////////////////////////////////////
			pmBarColorControl = new MyColorControl(	BPoint(1, 1), 
													B_CELLS_8x32,//lots of other options! Make a pref??
													1,
													"barColorControl", 
													BARCOLORCONTROL_VIEW,
													true,
													this,
													pholdBarCCLayoutMatrix);
			myPrefs->GetPreferredMyBarColor(&color);
			pmBarColorControl->SetValue(color);
			pBarCCLMI = new LayoutMatrixItem(	(void *)pmBarColorControl, 
												pholdBarCCLayoutMatrix->itemsList,
												KIND_MYCOLORCONTROL);
//////////////////////////////////////
			pholdBarCWLayoutMatrix = new LayoutMatrix(BESTSIZE, 1, 1, this);//rows,columns
///////////////////////////////////////////
			TextItem * pholdBarMainViewColorWellText = new TextItem(	BarCWLabel,
																		pholdBarCWLayoutMatrix);
			pmBarColorWell = new ColorWell(	"ColorWellViewColorPref", 
												B_FOLLOW_NONE, 
												B_WILL_DRAW,
												BAR_COLOR,
												pholdBarMainViewColorWellText,
												pholdBarCWLayoutMatrix);
			pBarCWLMI = new LayoutMatrixItem(	(void *)pmBarColorWell, 
												pholdBarCWLayoutMatrix->itemsList,
												KIND_COLORWELLGADG);
///////////////////////////////////////////
			pholdBarHLayoutMatrix = new LayoutMatrix(BESTSIZE, 1, 1, this);//rows,columns
//////////////////////////////////////////////////////////////////////////
			mpBarHeightFloatGadget = new FloatGadget(	myPrefs->GetPreferredBarHeight(),
														"BarHeightFloatGadget", 
														EnterBarHeightLable,
														BAR_HEIGHT_STR,
														B_FOLLOW_NONE, 
														B_WILL_DRAW | B_NAVIGABLE,
														0,
														pholdBarHLayoutMatrix);
			pBarHeightLMI = new LayoutMatrixItem(	(void *)mpBarHeightFloatGadget, 
													pholdBarHLayoutMatrix->itemsList,
													KIND_FLOATGADG);
		}
/////////////////////////////////////////////////////////////
		release_sem(calc_sem);
		pholdTitleLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, MATRIXVERTICALOFFSET, calc_sem);
		float bottom = pholdTitleLayoutMatrix->bottom;
		float right = MATRIXHORIZONTALOFFSET;
		if (myPrefs->bUseColorControl)
		{
			pholdViewCCLayoutMatrix->Calc(right, bottom, calc_sem);
			pholdHighCCLayoutMatrix->Calc(pholdViewCCLayoutMatrix->right, bottom, calc_sem);
			pholdLowCCLayoutMatrix->Calc(pholdHighCCLayoutMatrix->right, bottom, calc_sem);
			bottom = pholdLowCCLayoutMatrix->bottom;
			right = pholdLowCCLayoutMatrix->right;
			delete pMyStringDrawerAXXLMI;
			delete pColorControlAXXLMI;
			delete pMyStringDrawerBXXLMI;
			delete pColorControlBXXLMI;
			delete pMyStringDrawerCXXLMI;
			delete pColorControlCXXLMI;
		}
		float cwRight = MATRIXHORIZONTALOFFSET;
		if (myPrefs->bUseColorWell)
		{
			pholdColorWellLayoutMatrix->Calc(cwRight, bottom, calc_sem);
			bottom = pholdColorWellLayoutMatrix->bottom;
			cwRight = pholdColorWellLayoutMatrix->right;
			if (!myPrefs->bUseColorControl)
			{
				right = cwRight;
			}
		}
		pholdDemoLayoutMatrix->Calc(right, pholdTitleLayoutMatrix->bottom, calc_sem);
		if (kind == SPECIFIC_COLOR_STATUSBAR)
		{
			pholdBarTitleLayoutMatrix->Calc(cwRight, bottom, calc_sem);
			if (myPrefs->bUseColorControl)
			{
				pholdBarCCLayoutMatrix->Calc(cwRight, pholdBarTitleLayoutMatrix->bottom, calc_sem);
				bottom = pholdBarCCLayoutMatrix->bottom;
				delete pBarCCLMI;
			}
			if (myPrefs->bUseColorWell)
			{
				pholdBarCWLayoutMatrix->Calc(cwRight,bottom, calc_sem);
				delete pBarCWLMI;
			}
			pholdBarHLayoutMatrix->Calc(cwRight, pholdBarTitleLayoutMatrix->bottom, calc_sem);
			delete pBarColorLabelLMI;
			delete pBarHeadingLMI;
			delete pBarHeightLMI;
			
		}
	}
	catch (...)
	{
		warning(CaughtSpecificColorWindowCTOR);
		release_sem(calc_sem);
		throw;
	}
	try 
	{
		BMenuItem *	menuItem;
		BMenu * APPMenu = new BMenu(AppMenuLable);
		menuItem = new BMenuItem(	AboutMenuLable, 
									new BMessage(ABOUT_SPECIFICCOLORWINDOW));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	CloseWindow, 
									new BMessage(B_QUIT_REQUESTED));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	QuitMenuLable, 
									new BMessage(QUIT_APP));
		APPMenu->AddItem(menuItem);
		pMenuBar->AddItem(APPMenu);
	}
	catch(...) 
	{
		throw;
	}
}//end


//dtor
SpecificColorWindow	::	~SpecificColorWindow() 
{
	if (myPrefs->pPrefPanelWindow)//can get a race if not checked
	{
		myPrefs->pPrefPanelWindow->mpPrefWindows[kind] = NULL;
	}
	if (myPrefs->bPrefChangesMade)
	{
		myApp->pTitleWindow->PostMessage(B_QUIT_REQUESTED);
	}
}//end


bool
SpecificColorWindow	::	QuitRequested(	void) 
{
	BRect frame = Frame();
	if (pmViewColorControl)//if you got one you got 'em all
	{
		rgb_color viewColor(pmViewColorControl->ValueAsColor());
		rgb_color highColor(pmHighColorControl->ValueAsColor());
		rgb_color lowColor(pmLowColorControl->ValueAsColor());
		switch (kind) 
		{
			case SPECIFIC_COLOR_BUTTON:
				myPrefs->SetPreferredMyButtonViewColor(&viewColor);
				myPrefs->SetPreferredMyButtonHighColor(&highColor);
				myPrefs->SetPreferredMyButtonLowColor(&lowColor);
			break;
			case SPECIFIC_COLOR_PICTURE:
				myPrefs->SetPreferredMyPictureButtonViewColor(&viewColor);
				myPrefs->SetPreferredMyPictureButtonHighColor(&highColor);
				myPrefs->SetPreferredMyPictureButtonLowColor(&lowColor);
			break;
			case SPECIFIC_COLOR_RADIOVIEW:
				myPrefs->SetPreferredMyRadioViewViewColor(&viewColor);
				myPrefs->SetPreferredMyRadioViewHighColor(&highColor);
				myPrefs->SetPreferredMyRadioViewLowColor(&lowColor);
			break;
			case SPECIFIC_COLOR_CHECKBOX:
				myPrefs->SetPreferredMyCheckBoxViewColor(&viewColor);
				myPrefs->SetPreferredMyCheckBoxHighColor(&highColor);
				myPrefs->SetPreferredMyCheckBoxLowColor(&lowColor);
			break;
			case SPECIFIC_COLOR_STATUSBAR:
				myPrefs->SetPreferredMyStatusBarViewColor(&viewColor);
				myPrefs->SetPreferredMyStatusBarHighColor(&highColor);
				myPrefs->SetPreferredMyStatusBarLowColor(&lowColor);
			break;
			case SPECIFIC_COLOR_COLORCONTROL:
				myPrefs->SetPreferredMyColorControlViewColor(&viewColor);
				myPrefs->SetPreferredMyColorControlHighColor(&highColor);
				myPrefs->SetPreferredMyColorControlLowColor(&lowColor);
			break;
			case SPECIFIC_COLOR_TEXTVIEW:
				myPrefs->SetPreferredMyTextViewViewColor(&viewColor);
				myPrefs->SetPreferredMyTextViewHighColor(&highColor);
				myPrefs->SetPreferredMyTextViewLowColor(&lowColor);
			break;
			case SPECIFIC_COLOR_LISTVIEW:
				myPrefs->SetPreferredMyListViewViewColor(&viewColor);
				myPrefs->SetPreferredMyListViewHighColor(&highColor);
				myPrefs->SetPreferredMyListViewLowColor(&lowColor);
			break;
			case SPECIFIC_COLOR_INTGADG:
				myPrefs->SetPreferredUInt32GadgetViewColor(&viewColor);
				myPrefs->SetPreferredUInt32GadgetHighColor(&highColor);
				myPrefs->SetPreferredUInt32GadgetLowColor(&lowColor);
			break;
			case SPECIFIC_COLOR_FLOATGADG:
				myPrefs->SetPreferredFloatGadgetViewColor(&viewColor);
				myPrefs->SetPreferredFloatGadgetHighColor(&highColor);
				myPrefs->SetPreferredFloatGadgetLowColor(&lowColor);
			break;
			case SPECIFIC_COLOR_STRINGGADG:
				myPrefs->SetPreferredStringGadgetViewColor(&viewColor);
				myPrefs->SetPreferredStringGadgetHighColor(&highColor);
				myPrefs->SetPreferredStringGadgetLowColor(&lowColor);
			break;
			case SPECIFIC_COLOR_COLORWELL:
				myPrefs->SetPreferredColorWellViewColor(&viewColor);
				myPrefs->SetPreferredColorWellHighColor(&highColor);
				myPrefs->SetPreferredColorWellLowColor(&lowColor);
			break;
			case SPECIFIC_COLOR_STRINGDRAWER:
				myPrefs->SetPreferredMyStringDrawerViewColor(&viewColor);
				myPrefs->SetPreferredMyStringDrawerHighColor(&highColor);
				myPrefs->SetPreferredMyStringDrawerLowColor(&lowColor);
			break;
			default:
				warning(BadSpecKindQR);
				throw;
			break;
		}
	}
	switch (kind) 
	{
		case SPECIFIC_COLOR_BUTTON:
			myPrefs->SetPreferredSpecificColorButtonWindowRect(frame);
		break;
		case SPECIFIC_COLOR_PICTURE:
			myPrefs->SetPreferredSpecificColorPictureButtonWindowRect(frame);
		break;
		case SPECIFIC_COLOR_RADIOVIEW:
			myPrefs->SetPreferredSpecificColorRadioButtonWindowRect(frame);
		break;
		case SPECIFIC_COLOR_CHECKBOX:
			myPrefs->SetPreferredSpecificColorCheckBoxWindowRect(frame);
		break;
		case SPECIFIC_COLOR_STATUSBAR:
		{
			myPrefs->SetPreferredSpecificColorStatusBarWindowRect(frame);
			rgb_color barColor(pmBarColorControl->ValueAsColor());
			myPrefs->SetPreferredMyBarColor(&barColor);
			myPrefs->SetPreferredBarHeight(s2f(mpBarHeightFloatGadget->Text()));
		break;
		}
		case SPECIFIC_COLOR_COLORCONTROL:
			myPrefs->SetPreferredSpecificColorColorControlWindowRect(frame);
		break;
		case SPECIFIC_COLOR_TEXTVIEW:
			myPrefs->SetPreferredSpecificColorTextViewWindowRect(frame);
		break;
		case SPECIFIC_COLOR_LISTVIEW:
			myPrefs->SetPreferredSpecificColorListViewWindowRect(frame);
		break;
		case SPECIFIC_COLOR_INTGADG:
			myPrefs->SetPreferredSpecificColorUInt32GadgetWindowRect(frame);
		break;
		case SPECIFIC_COLOR_FLOATGADG:
			myPrefs->SetPreferredSpecificColorFloatGadgetWindowRect(frame);
		break;
		case SPECIFIC_COLOR_STRINGGADG:
			myPrefs->SetPreferredSpecificColorStringGadgetWindowRect(frame);
		break;
		case SPECIFIC_COLOR_COLORWELL:
			myPrefs->SetPreferredSpecificColorColorWellWindowRect(frame);
		break;
		case SPECIFIC_COLOR_STRINGDRAWER:
			myPrefs->SetPreferredSpecificColorStringDrawerWindowRect(frame);
		break;
		default:
			warning(BadSpecKindQR);
			throw;
		break;
	}
	return(WindowGuts::QuitRequested());
}//end


void
SpecificColorWindow	::	ResetDemo(	void)
{
	myPrefs->bPrefChangesMade = true;
	rgb_color viewColor(pmViewColorControl->ValueAsColor());
	rgb_color highColor(pmHighColorControl->ValueAsColor());
	rgb_color lowColor(pmLowColorControl->ValueAsColor());
	if (LockLooper())
	{
		if (kind == SPECIFIC_COLOR_TEXTVIEW)
		{
			((BTextView *)pmDemoItem)->SetViewColor(viewColor);
			((BTextView *)pmDemoItem)->SetLowColor(lowColor);
			((BTextView *)pmDemoItem)->SetFontAndColor(myPrefs->GetPreferredFont(), B_FONT_ALL, &highColor);
			((BTextView *)pmDemoItem)->Invalidate(((BTextView *)pmDemoItem)->Bounds());
		}
		else if (kind == SPECIFIC_COLOR_STRINGDRAWER)
		{
			rgb_color originalHighColor(baseView->HighColor());
			rgb_color originalLowColor(baseView->LowColor());
			rgb_color originalViewColor(baseView->ViewColor());
			BFont originalFont;
			baseView->GetFont(&originalFont);
			baseView->SetViewColor(viewColor);
			baseView->SetHighColor(highColor);
			baseView->SetLowColor(lowColor);
			TextItem * textItem = ((MyStringDrawer *)pmDemoItem)->GetTextItem();
			baseView->SetFont(((MyStringDrawer *)pmDemoItem)->GetFont());
			baseView->MovePenTo(textItem->left, textItem->top);
			baseView->DrawString(textItem->text);
			baseView->SetHighColor(originalHighColor);
			baseView->SetLowColor(originalLowColor);
			baseView->SetViewColor(originalViewColor);
			baseView->SetFont(&originalFont);
		}
		else if (kind == SPECIFIC_COLOR_STATUSBAR)
		{
			rgb_color barColor(pmBarColorControl->ValueAsColor());
			((BStatusBar *)pmDemoItem)->SetBarColor(barColor);
			((BStatusBar *)pmDemoItem)->SetViewColor(viewColor);
			((BStatusBar *)pmDemoItem)->SetHighColor(highColor);
			((BStatusBar *)pmDemoItem)->SetLowColor(lowColor);
			((BStatusBar *)pmDemoItem)->SetBarHeight(s2f(mpBarHeightFloatGadget->Text()));
			((BStatusBar *)pmDemoItem)->Invalidate(((BView *)pmDemoItem)->Bounds());
		}
		else
		{
			((BView *)pmDemoItem)->SetViewColor(viewColor);
			((BView *)pmDemoItem)->SetHighColor(highColor);
			((BView *)pmDemoItem)->SetLowColor(lowColor);
			((BView *)pmDemoItem)->Invalidate(((BView *)pmDemoItem)->Bounds());
		}
		UnlockLooper();
	}
	else
	{
		warning(FailLockLooper);
	}
}//end


void
SpecificColorWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		case 'selc':
			warning(SelectFromList);
		break;
		case 'invc':
			warning(InvokeFromList);
		break;
		case ABOUT_SPECIFICCOLORWINDOW:	
			warning(AboutSpecColorWindow);
		break;
		case QUIT_APP:
			if (Verify(ReallyQuitApp))
			{
				myApp->PostMessage(B_QUIT_REQUESTED);
			}
		break;
		case roColourDROPPEDMESSAGE: 
		{
    		rgb_color * pRGBColor;
    		rgb_color color;   		
    		int32 numRGBBytes = sizeof(struct rgb_color);
	        if (	pparamMessage->FindData(	"RGBColor",
		       									B_RGB_COLOR_TYPE, 
												(void**)&pRGBColor, 
												&numRGBBytes ) 
					== B_OK)
	        {
	           	color = *pRGBColor;
	            if (pparamMessage->WasDropped()) 
	            {
					int32 colorToChange;
					if (	pparamMessage->FindInt32(	"ColorToChange",
														&colorToChange)
							 == B_OK)
					{
						switch(colorToChange)
						{
							case BAR_COLOR:
								myPrefs->SetPreferredMyBarColor(&color);
								pmBarColorControl->SetValue(color);
							break;
							case VIEW_COLOR:
								switch(kind)
								{
									case SPECIFIC_COLOR_BUTTON:
										myPrefs->SetPreferredMyButtonViewColor(&color);
									break;
									case SPECIFIC_COLOR_PICTURE:
										myPrefs->SetPreferredMyPictureButtonViewColor(&color);
									break;
									case SPECIFIC_COLOR_RADIOVIEW:
										myPrefs->SetPreferredMyRadioViewViewColor(&color);
									break;
									case SPECIFIC_COLOR_CHECKBOX:
										myPrefs->SetPreferredMyCheckBoxViewColor(&color);
									break;
									case SPECIFIC_COLOR_STATUSBAR:
										myPrefs->SetPreferredMyStatusBarViewColor(&color);
									break;
									case SPECIFIC_COLOR_COLORCONTROL:
										myPrefs->SetPreferredMyColorControlViewColor(&color);
									break;
									case SPECIFIC_COLOR_TEXTVIEW:
										myPrefs->SetPreferredMyTextViewViewColor(&color);
									break;
									case SPECIFIC_COLOR_LISTVIEW:
										myPrefs->SetPreferredMyListViewViewColor(&color);
									break;
									case SPECIFIC_COLOR_INTGADG:
										myPrefs->SetPreferredUInt32GadgetViewColor(&color);
									break;
									case SPECIFIC_COLOR_FLOATGADG:
										myPrefs->SetPreferredFloatGadgetViewColor(&color);
									break;
									case SPECIFIC_COLOR_STRINGGADG:
										myPrefs->SetPreferredStringGadgetViewColor(&color);
									break;
									case SPECIFIC_COLOR_COLORWELL:
										myPrefs->SetPreferredColorWellViewColor(&color);
									break;
									case SPECIFIC_COLOR_STRINGDRAWER:
										myPrefs->SetPreferredMyStringDrawerViewColor(&color);
									break;
									default:
										warning(BadSpecKindColorSetView);
										throw;
									break;
								}
								pmViewColorControl->SetValue(color);
							break;
							case HIGH_COLOR:
								switch(kind)
								{
									case SPECIFIC_COLOR_BUTTON:
										myPrefs->SetPreferredMyButtonHighColor(&color);
									break;
									case SPECIFIC_COLOR_PICTURE:
										myPrefs->SetPreferredMyPictureButtonHighColor(&color);
									break;
									case SPECIFIC_COLOR_RADIOVIEW:
										myPrefs->SetPreferredMyRadioViewHighColor(&color);
									break;
									case SPECIFIC_COLOR_CHECKBOX:
										myPrefs->SetPreferredMyCheckBoxHighColor(&color);
									break;
									case SPECIFIC_COLOR_STATUSBAR:
										myPrefs->SetPreferredMyStatusBarHighColor(&color);
									break;
									case SPECIFIC_COLOR_COLORCONTROL:
										myPrefs->SetPreferredMyColorControlHighColor(&color);
									break;
									case SPECIFIC_COLOR_TEXTVIEW:
										myPrefs->SetPreferredMyTextViewHighColor(&color);
									break;
									case SPECIFIC_COLOR_LISTVIEW:
										myPrefs->SetPreferredMyListViewHighColor(&color);
									break;
									case SPECIFIC_COLOR_INTGADG:
										myPrefs->SetPreferredUInt32GadgetHighColor(&color);
									break;
									case SPECIFIC_COLOR_FLOATGADG:
										myPrefs->SetPreferredFloatGadgetHighColor(&color);
									break;
									case SPECIFIC_COLOR_STRINGGADG:
										myPrefs->SetPreferredStringGadgetHighColor(&color);
									break;
									case SPECIFIC_COLOR_COLORWELL:
										myPrefs->SetPreferredColorWellHighColor(&color);
									break;
									case SPECIFIC_COLOR_STRINGDRAWER:
										myPrefs->SetPreferredMyStringDrawerHighColor(&color);
									break;
									default:
										warning(BadSpecKindColorSetHigh);
										throw;
									break;
								}
								pmHighColorControl->SetValue(color);
							break;
							case LOW_COLOR:
								switch(kind)
								{
									case SPECIFIC_COLOR_BUTTON:
										myPrefs->SetPreferredMyButtonLowColor(&color);
									break;
									case SPECIFIC_COLOR_PICTURE:
										myPrefs->SetPreferredMyPictureButtonLowColor(&color);
									break;
									case SPECIFIC_COLOR_RADIOVIEW:
										myPrefs->SetPreferredMyRadioViewLowColor(&color);
									break;
									case SPECIFIC_COLOR_CHECKBOX:
										myPrefs->SetPreferredMyCheckBoxLowColor(&color);
									break;
									case SPECIFIC_COLOR_STATUSBAR:
										myPrefs->SetPreferredMyStatusBarLowColor(&color);
									break;
									case SPECIFIC_COLOR_COLORCONTROL:
										myPrefs->SetPreferredMyColorControlLowColor(&color);
									break;
									case SPECIFIC_COLOR_TEXTVIEW:
										myPrefs->SetPreferredMyTextViewLowColor(&color);
									break;
									case SPECIFIC_COLOR_LISTVIEW:
										myPrefs->SetPreferredMyListViewLowColor(&color);
									break;
									case SPECIFIC_COLOR_INTGADG:
										myPrefs->SetPreferredUInt32GadgetLowColor(&color);
									break;
									case SPECIFIC_COLOR_FLOATGADG:
										myPrefs->SetPreferredFloatGadgetLowColor(&color);
									break;
									case SPECIFIC_COLOR_STRINGGADG:
										myPrefs->SetPreferredStringGadgetLowColor(&color);
									break;
									case SPECIFIC_COLOR_COLORWELL:
										myPrefs->SetPreferredColorWellLowColor(&color);
									break;
									case SPECIFIC_COLOR_STRINGDRAWER:
										myPrefs->SetPreferredMyStringDrawerLowColor(&color);
									break;
									default:
										warning(BadSpecKindColorSetLow);
										throw;
									break;
								}
								pmLowColorControl->SetValue(color);
							break;
							case NO_COLOR:
								warning(DemoRoNo);
							break;
							default:
								warning(RoBadMsg);
							break;
						}
					}
				}
			}
		break;
		}
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
	switch(pparamMessage->what) 
	{
		case COLORCONTROL_VIEW:
		case COLORCONTROL_HIGH:
		case COLORCONTROL_LOW:
		case BARCOLORCONTROL_VIEW:
		case 0x63636f6c://<CR> from color control 
		case 0x62485320://<CR> from bar height
		case roColourDROPPEDMESSAGE:
		case DEMOPICTUREBUTTONMSG:
			ResetDemo();
		break;
	}
}//end
