//blackhole.cpp

#include "Xwarning.h"
#include "Xunique.h"
#include "constants.h"
#include "dobj.h"
#include "def.h"
#include "error.h"
#include "mergeHow.h"
#include "mergeNode.h"
#include "mergeList.h"
#include "XdataNode.h"
#include "XdataList.h"
#include "dataNode.h"
#include "dataList.h"
#include "universalConstants.h"
#include "holeAffects.h"
#include "blackhole.h"

Blackhole	::	Blackhole() 
{
	err = NO_ERR;
}//end


Blackhole	::	Blackhole(	Blackhole * fromItem, 
							const char * n) 
{
	err = NO_ERR;
	name = (char *)malloc(strlen(n) + 1);
	if (name) 
	{
		DataNode * node = new DataNode(this);
		if (node) 
		{
			strcpy(name, n);
			//debug do holeAffects 
			if (!Unique()) 
			{
				err = CREATEDNOTADDED;
				return;
			}
			if (dataListGlobal[BLACKHOLE_TYPE]->AddItem(node)) 
			{
				blackholeCurrent = this;
				err = CREATED;
				return;
			}
			err = NO_ADDITEM;
		}
		err = NO_DATANODE;
	}
	err = NO_NAME;
}//end


Blackhole	::	Blackhole(	Blackhole * fromItem, 
							MergeList * list) 
{
	err = NO_ERR;
	name = (char *)malloc(strlen(fromItem->name) + 1);
	if (name) 
	{
		MergeNode * node = new MergeNode(this, MERGEDNOT);
		if (node) 
		{
			strcpy(name, fromItem->name);
			//debug do holeAffects 
			if (list->AddItem(node)) 
			{
				node->placedAt = list->list->IndexOf(list->list->LastItem());
				err = CREATED;
				return;
			}
			err = NO_ADDITEM;
		}
		err = NO_DATANODE;
	}
	err = NO_NAME;
}//end


Blackhole	::	~Blackhole() 
{
	//left blank
}//end


bool 
Blackhole	::	Unique() 
{
	DataNode * node;
	err = NO_UNIQUE;
	#pragma warn_possunwant off
	for (	int32 i = 0;
			node = (DataNode * )dataListGlobal[BLACKHOLE_TYPE]->list->ItemAt(i);
			i++) 
	{
	#pragma warn_possunwant reset
		if (!strcmp(name, node->MyName(BLACKHOLE_TYPE))) 
		{
			warning(FailCreate[BLACKHOLE_TYPE]);
			warning(FailCreateName);
			return false;
		}
	}
	err = NO_ERR;
	return true;
}//end


bool 
Blackhole	::	Save(	BFile * file) 
{
	if (!BuildConstantsSave(file)) return false;
	if (!HoleAffectsSave(file)) return false;
	//save other stuff
	return true;
}//end


bool 
Blackhole	::	Load(	BFile * file) 
{
	if (!BuildConstantsLoad(file)) 
	{
		return false;
	}
	if (!HoleAffectsLoad(file)) 
	{
		return false;
	}
	//load other stuff
	return true;
}//end


bool 
Blackhole	::	Copy(	Blackhole * fromItem) 
{
	if (name && fromItem->name) 
	{
		if (strcmp(name, fromItem->name)) 
		{
			if (name) 
			{
				free(name);
			}
			name = (char *)malloc(strlen(fromItem->name) + 1);
			if (name) strcpy(name, fromItem->name);
			else 
			{
				err = NO_NAME;
				warning(FailName);
				return false;
			}
		}
	}
	//debug must do object as well
	return true;
}//end
