//methods of the constants class soi 0.1

#include "dobj.h"
#include "Xwarning.h"
#include "Xconstants.h"
#include "constants.h"

BuildConstants	::	BuildConstants() 
				:	object(NULL),
					name(NULL)
{
	//left blank
}//end


BuildConstants	::	~BuildConstants() 
{
	if (object) 
	{
		delete object;
	}
	if (name) 
	{
		free(name);
	}
}//end


bool
BuildConstants	::	BuildConstantsSave(	BFile * file) 
{
	BMessage msg;
	status_t success = msg.AddString("name", name);
	if (success == B_OK)
	{
	//debug got to do object
		msg.Flatten(file);
		return true;
	}
	warning(AddXfailedBuildConstantsSave);
	return false;
}//end


bool
BuildConstants	::	BuildConstantsLoad(	BFile * file)
{
	BMessage msg;
	char * strPtr;
	status_t success = msg.Unflatten(file);
	if (success == B_OK)
	{
		success = msg.FindString("name", &strPtr);
		if (success == B_OK)
		{
			int32 len = strlen(strPtr) + 1;
			name = (char *)malloc(len);
			if (name) 
			{
				strcpy(name, strPtr);
				object = NULL;//debug got to impliment object someday
				return true;
			}
			else
			{
				warning(FailMemory);
			}
		}
		warning(FindXfailedBuildConstantsLoad);
	}
	warning(BMsgFailUnflatten);
	return false;
}//end


SmallConstants	::	SmallConstants()
				:	mass(0),
					volume(0),
					vper(0)
{
	//left blank
}//end


bool
SmallConstants	::	SmallConstantsSave(	BFile * file)
{
	BMessage msg;
	status_t success = msg.AddInt32("mass", (int32)mass);
	if (success == B_OK)
	{
		success = msg.AddInt32("volume", (int32)volume);
		if (success == B_OK)
		{
			success = msg.AddInt32("vper", (int32)vper);
			if (success == B_OK)
			{
				msg.Flatten(file);
				return true;
			}
		}
	}
//	bad:
	warning(BMsgAddXFailSmallConstantsSave);
	return false;
}//end


bool
SmallConstants	::	SmallConstantsLoad(	BFile * file)
{
	BMessage msg;
	status_t success = msg.Unflatten(file);
	if (success == B_OK)
	{
		success = msg.FindInt32("mass", (int32)&mass);
		if (success == B_OK)
		{
			success = msg.FindInt32("volume", (int32)&volume);
			if (success == B_OK)
			{
				success = msg.FindInt32("vper", (int32)&vper);
				if (success == B_OK)
				{
					return true;
				}
			}
		}
		warning(BMsgFindXFailSmallConstantsLoad);
	}
	warning(BMsgFailUnflatten);
	return false;
}//end
