#include <Application.h>
#include "message_labels.h"
#include "TextToolWindow.h"

TextToolWindow::TextToolWindow(share *sh)
 : BWindow(BRect(100, 100, 600, 500), "Text Tool", B_FLOATING_WINDOW, 
 B_NOT_ZOOMABLE | B_NOT_MINIMIZABLE | B_NOT_RESIZABLE | 
 B_WILL_ACCEPT_FIRST_CLICK, B_CURRENT_WORKSPACE)
{
	ThePrefs.texttool_win_open=true;
	shared=sh;
	containerview = new TextToolView(Bounds());
	AddChild(containerview);
	Show();
	Activate();
}

TextToolWindow::~TextToolWindow(void)
{	ThePrefs.texttool_win_open=false;
}

void TextToolWindow::MessageReceived(BMessage *msg)
{	BRect winrect;

	switch(msg->what)
	{
		case RENDER_TEXT:
			shared->currentfont=containerview->fontview->currentfont;
			sprintf(shared->ttstring,(char *)containerview->textedit->Text());
			util.mainWin->PostMessage(new BMessage(RENDER_TEXT));
			break;
		case FONTVIEW_TOGGLE:
			winrect=Bounds();
			// Rectangles are same width - font display is hidden
			if(winrect.IntegerWidth()==500)
			{
				ResizeBy(-379.0,0.0);	
			}
			else
			{	ResizeBy(379,0);
			}
			break;
		default:
			BWindow::MessageReceived(msg);
	}
	
}
/*
bool TextToolWindow::QuitRequested(void)
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
}
*/
