#include "support/MuscleSupport.h"
#include "ShareStrings.h"

namespace beshare {

static int _language = LANGUAGE_ENGLISH;   // Everybody's favorite language!

static const char _englishShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'P',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

static const char * _englishStrings[NUM_STRINGS] = {
   "Anonymous",
   "Unknown",
   " is now connected.",
   " has disconnected.",
   "User #",
   " (a.k.a. ",
   " is now known as ",
   "true",
   "false",
   "<unknown type>",
   "User ",
   " is downloading ",
   "Error writing to file ",
   "An Error Occurred.",
   "Queued (Local machine too busy)",
   "Queued (Remote machine too busy)",
   "Sent: ",
   "Rcvd: ",
   "/sec, ",
   "Awaiting callback...",
   "Connecting...",
   "Download complete",
   "Download aborted",
   "Couldn't connect",
   "Preparing to Upload",
   "Preparing to Download",
   "to",
   "from",
   "Error starting download--no accept port!",
   "Error starting delayed connect!",
   "Error starting delayed connect--no transceiver thread!",
   "Error, couldn't create connect thread! (Try quitting BeShare, then Restarting Networking)",
   "(Sharing %i local files)",
   "Couldn't find 'shared' subdirectory, file sharing disabled!",
   "\0011File Name",
   "\0012User",
   "\0013SessionID",
   "\0014Connection",
   "File",
   "Connect to server",
   "Disconnect",
   "Open Shared Folder",
   "Open Downloads Folder",
   "Clear Chat Log",
   "Reset Layout",
   "About BeShare",
   "Quit",
   "Attributes",
   "Settings",
   "Max Simultaneous Uploads",
   "Max Simultaneous Downloads",
   "No Limit",
   "Upload Bandwidth",
   "Log",
   "Uploads",
   "User Events",
   "Query Changes",
   "Full User Queries",
   "I'm Firewalled",
   "Query:",
   "Start Query",
   "Stop Query",
   "Server:",
   "User Name:",
   "Download Selected Files",
   "Clear Finished/Failed Transfers",
   "Remove Selected",
   "Chat",
   "Name",
   "ID",
   "BeShare is listening on port %u.  Select Connect from the File menu to begin!",
   "Couldn't start file-sharing server thread!  (Try Restarting Networking, then restarting BeShare)",
   "Can't download from user ",
   ", no connection information available.",
   "Can't download files from ",
   ", because both of us are behind firewalls.",
   "File download accept session for ",
   " failed to initialize!",
   "File download session to ",
   "Changed Query to",
   "Started Query",
   "Couldn't start ShareFileTransfer session to serve remote transfer request!  (Try Restarting Networking, then restarting BeShare)",
   "Your name has been changed to ",
   "by",
   "Unknown user ",
   ", message \"",
   "\" not sent.",
   "No target user specified in /msg",
   "Stopped Query",
   "System",
   "Warning",
   "Error",
   "Action",
   "Connect to ",
   " - Connecting to ",
   " - %lu results shown (",
   " - Connected to ",
   "Connection established.",
   "Connecting to server...",
   "You are no longer connected to the MUSCLE server.",
   "Connection to server failed.",
   "English",
   "Spanish",
   "Language %s selected.  Change will take effect after you restart BeShare.",
   "Language", 
   "German",
   "Kind",
   "File Size",
   "Files",
   "Dutch",
   "Examining Files...",
   "Available irc-style commands:",
   "send a private message",
   "change your user name",
   "do something",
   "synonym for /action",
   "clear the chat log",
   "start a new query",
   "stop the current query",
   "connect to a server",
   "disconnect from the server",
   "quit BeShare",
   "show this help text",
   "<name or session id> <text>",
   "<name>",
   "<action>",
   "[queryString]",
   "[serverName]",
   "Portuguese",
   "French",
   "Beep When Mentioned",
   "Max Simultaneous Uploads Per User",
   "Timestamps",
   "AutoClear Finished Downloads",
   "Max Simultaneous Downloads Per User",
   "Italian",
   "Login on Startup",
   "Private Messages",
   "Open Private Chat Window",
   "BeShare Private Chat Window",
   "Chat With:",
   "Error, no user specified!", 
   "Save Preset",
   "Restore Preset",
   "Error, unknown command",
   "Type /help for a list of available commands.",
   " - (%lu-%lu) of %lu results shown (",
   "Display",
   "Info Messages",
   "Warning Messages",
   "Error Messages",
   "Logging Enabled",
   "Logging Disabled",
   "Results Per Page",
   "Switch to Page",
   "specify users to ignore",
   "Ignore pattern set to: ",
   "Ignore pattern removed.",
   "<names or session ids>",
   "Move Up",
   "Move Down",
   "Halt Transfer",
   "Restart Transfer",
   "Open File",
   "Russian",
   "Chat",
   "Current /ignore pattern is: ",
   "Disabled",
   "There are %i transfers in progress, are you sure you want to quit?",
   "Don't Quit",
   "Modification Time",
   "Esperanto",
   "Swedish",
   "ping other clients",
   "Ping returned in %Li milliseconds",
   "Sent ping request to: ",
   "Norwegian",
   "Serbian",
   "away",
   "Auto Away",
   "minutes",
   "tag",
   "change the auto-away tag",
   "Auto-away tag set to: ",
   "Force away state",
   "Open Folder",
   "Watch pattern set to: ",
   "Watch pattern removed.",
   "Current /watch pattern is: ",
   "specify users to watch",
   "Startup commands cleared.",
   "command",
   "add startup command",
   "clear startup commands",
   "Recorded startup command: ",
   "Watch",
   "Server status requested.",
   "%.1fMB used (%.1fMB available)",
   "Server status:",
   "Server version",
   "Local session root",
   "Server memory usage",
   "Request server status",
   "Server uptime",
   "weeks",
   "days",
   "System Uptime",
   "logged in for",
   "File Sharing Enabled",
   "Ban User For",
   "User at IP %s banned for",
   "Hours",
   "Forever",
   "remove all upload bans",
   "Removing %lu upload bans",
   "AutoPriv pattern set to: ",
   "AutoPriv pattern removed.",
   "specify AutoPriv users",
   "Current /autopriv pattern is: ",
   "Unknown data format!",
   "Open Logs Folder",
   "Status",
   "Your status has been changed to: ",
   " is now ",
   "Load",
   "set user status string",
   "Bulgarian",
   "Path",
   "Retain File Paths",
   "Set alias",
   "Removed alias",
   "[name and value]",
   "create an alias",
   "remove an alias",
   "Move to Top",
   "Move to Bottom",
   "set custom window title",
   "Custom window title is now",
   "AutoUpdate Server List",
   "Added server: %s",
   "Removed server: %s",
   "BeShare v%s is now available for download.  You can upgrade at %s",
   "execute shell command",
   "Executing shell command",
   "shell command",
   "idle command set to",
   "set command for when transfers cease",
   "font size in points", 
   "set font size",
   "Font size set to:",
   "Font size reset to default",
};

static const char _spanishShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'E',  // "Bye" to current connection
   'P',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'I',  // Open private chat window
   'F',  // Toggle file logging
   'S',  // File sharing enabled
   'O',  // Logs dir
};

// Submitted by: Phantom (socca@bemail.org)
static const char * _spanishStrings[NUM_STRINGS] = {
   "Anónimo",
   "Desconocido",
   " está conectado.",
   " está desconectado.",
   "Usuario #",
   " (a.k.a. ",
   " es conocido como ",
   "verdadero",
   "falso",
   "<tipo desconocido>",
   "Usuario ",
   " está descargando ",
   "error al escribir el archivo ",
   "se produjo un error.",
   "Queued (maquina local está muy ocupada)",
   "Queued (maquina remota está muy ocupada)",
   "Enviado: ",
   "Recibido: ",
   "/seg, ",
   "Esperando respuesta...",
   "Conectando...",
   "Download completo",
   "Download abortado",
   "no pudo conectar",
   "preparado para upload",
   "preparado para download",
   "a",
   "de",
   "Error al comenzar download--no aceptar puerto!",
   "Error al comenzar la conexión con delay!",
   "Error al comenzar conexión con delay--no transmite hilo!",
   "Error, no se pudo crear conectar hilo!",
   "(Compartiendo %i archivos locales)",
   "No se pudo encontrar el subdirectorio 'shared', compartir archivos desabilitado!",
   "\0011Archivo",
   "\0012Usuario",
   "\0013ID de Sesión",
   "\0014Conexión",
   "Archivo",
   "Conectar al Servidor",
   "Desconectar",
   "Abrir Carpeta Compartida",
   "Abrir Carpeta de Downloads",
   "Limpiar Historial de Chat",
   "Resetear Ventana",
   "Acerca de Beshare",
   "Salir",
   "Atributos",
   "Opciones",
   "Máximo de Uploads Simultáneos",
   "Máximo de Downloads Simultáneos",
   "Sin Límite ",
   "Ancho de Banda Para Upload",
   "Historia",
   "Uploads",
   "Eventos de usuario",
   "Cambios de Query",
   "Búsqueda Completa de Usuario",
   "Tengo Firewall",
   "Búsqueda:",
   "Buscar",
   "Parar",
   "Servidor:",
   "Nombre:",
   "Download archivos elegidos",
   "Limpiar terminados/Transferencias erróneas",
   "Remover elegido",
   "Chat",
   "Nombre",
   "ID",
   "BeShare está escuchando en puerto %u.  Seleccionar Conectar del menu de archivo para comenzar!",
   "No pudo comenzar el hilo de ejecución para compartir archivos!",
   "No se pudo bajar desde el usuario",
   ",no hay información de la conexión.",
   "No puede bajar archivos de ",
   ", porque ustedes dos están detras de un firewall.",
   "Sesión de download aceptada para ",
   " error para iniciar!",
   "Sesión de download para ",
   "Cambiada la búsqueda a",
   "Comenzar búsqueda",
   "No pudo comenzar la sesión transferencia de archivos para servir el pedido remoto de tranferencia!",
   "Tu nombre ha cambiado a ",
   "por",
   "Usuario desconocido ",
   ", mensage \"",
   "\" no enviado.",
   "No hay un usuario designado en /msg",
   "Búsqueda parada",
   "Sistema",
   "Peligro",
   "Error",
   "Acción",
   "Conectar a ",
   " - Conectando a ",
   " - %lu resultados mostrados (",
   " - Conectado a ",
   "Conexión establecida.",
   "Conectando a servidor...",
   "No está conectado al servidor muscle.",
   "Conexión al servidor falló.",
   "Inglés",
   "Castellano",
   "Idioma %s seleccionado. El cambio tomará efecto cuando reinicie BeShare",
   "Idioma",
   "Alemán",
   "Tipo",
   "Tamaño",
   "Archivos",
   "Holandés",
   "Examinando Archivos...",
   "Comandos de irc disponibles:",
   "enviar un mensaje privado",
   "cambia tu nombre de usuario",
   "haz algo",
   "sinónimo para /action",
   "limpiar el historial de chat",
   "comenzar una nueva búsqueda",
   "detener la búsqueda actual",
   "conectar al servidor",
   "desconectar del servidor",
   "salir de BeShare",
   "mostrar este texto de ayuda",
   "<nombre o id de sesión> <texto>",
   "<nombre>",
   "<acción>",
   "[búsqueda]",
   "[servidor]",
   "Portugues",
   "Francés",
   "Emite un Beep Cuando su Nombre es Mencionado",
   "Máximo de Uploads Simultáneos por Usuario",
   "Timestamps",
   "AutoLimpiar Downloads Terminados",
   "Máximo de Downloads Simultáneos por Usuario",
   "Italiano",
   "Conectar al Inicio",
   "Mensaje Privado",
   "Abrir Ventana Privada de Chat",
   "BeShare Ventana Privada de Chat",
   "Chatear Con:",
   "¡Error, usuario no especificado!",
   "Salvar Configuración",
   "Restaurar Configuración",
   "Error, comando desconocido",
   "Pulse /help para una lista de comandos disponibles.",
   " - (%lu-%lu) de %lu resultados mostrados (",
   "Mostrar",
   "Mensajes Informativos",
   "Mensajes de Aviso",
   "Mensajes de Error",
   "Historia Habilitado",
   "Historia Deshabilitado",
   "Resultados Por Página",
   "Mueva a Pagina",
   "especifica usuarios a ignore",
   "Ignore modelo cambiado a: ",
   "Ignore modelo quitado.",
   "<names or session ids>",
   "Levantar",
   "Descargar",
   "Termina Transferencia",
   "Reempieza Transferencia",
   "Abre Archivo",
   "Ruso",
   "Chat",
   "/ignore modelo es: ",
   "Deshabilitado",
   "Hay una transferencia %i en progreso, estás seguro de que querés salir?",
   "Me quedo",
   "Fecha de Modificación",
   "Esperanto",
   "Sueco",
   "ping otro cliente",
   "Ping recibido en %Li milisegundos",
   "Hacer un ping a: ",
   "Noruego",
   "Serbio",
   "ausente",
   "Ausente Automático",
   "minutos",
   "mensaje",
   "cambiar el mensaje del away automático",
   "Mensaje del Away Automático cambiado a: ",
   "Forzar modo ausente",
   "Abrir Carpeta",
   "Patrón de seguimiento modificado a: ",
   "Patrón de seguimiento removido.",
   "El patrón de seguimiento actual es: ",
   "Especificar usuarios a seguir",
   "Comandos de inicio borrados",
   "comando",
   "agregar comando de inicio",
   "limpiar comandos de inicio",
   "Comando de inicio grabado: ",
   "Seguir a",
   "Estado del servidor solicitado",
   "%.1fMB usado (%.1fMB disponible)",
   "Estado del servidor",
   "Version del servidor",
   "Root de la sesión local",
   "Memoria usada por el servidor",
   "Solicitar estado del servidor",
   "Tiempo en línea del servidor",
   "semanas",
   "días",
   "Tiempo conectado",
   "Conectado por",
   "Compartir archivos activado",
   "Prohibir usuario por",
   "Usuario en IP %s está prohibido por",
   "Horas",
   "Siempre",
   "borrar todas las prohibiciones",
   "Borrando %lu prohibiciones de descarga",
   "Patrón AutoPriv establecido como:",
   "Patrón AutoPriv removido",
   "especificar usuarios de AutoPriv",
   "Patrón /autopriv actual es",
   "¡Formato desconocido!",
   "Abrir carpeta de registros",
   "Estado",
   "Tu estado ha sido cambiado a: ",
   " esta ahora ",
   "Cargar",
   "modifica el estado del usuario",
   "Bulgaro",
   "Directorio",
   "Retener directorio",
   "Establecer Alias",
   "Alias removido",
   "[nombre y valor]",
   "crear un alias",
   "remover alias",
   "Mover arriba",
   "Mover abajo",
   "establecer titulo de ventana",
   "El titulo de la ventana es",
   "AutoActualizar Lista de Servers",
   "Servidor agregado: %s",
   "Servidor removido: %s",
   "La version v%s de BeShare está disponible para descargar. Puedes actualizarla a %s",
   "execute shell command",
   "Executing shell command",
   "shell command",
   "idle command set to",
   "set command for when transfers cease",
   "font size in points", 
   "set font size",
   "Font size set to:",
   "Font size reset to default",
};

static const char _germanShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'T',  // "Bye" to current connection
   'F',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'Z',  // Reset Layout
   'Q',  // Quit
   'K',  // Full user Queries
   'M',  // Beep When Mentioned
   'P',  // Open private chat window
   'G',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

// Submitted by:  hoshy (beat.rupp@gmx.net)
static const char * _germanStrings[NUM_STRINGS] = {
   "anonym",
   "unbekannt",
   " ist jetzt verbunden.",
   " hat die Verbindung getrennt.",
   "Benutzer #",
   " (alias ",
   " heißt jetzt ",
   "wahr",
   "falsch",
   "<unbekannter Typ>",
   "Benutzer ",
   " lädt herunter ",
   "Fehler beim Schreiben der Datei ",
   "Es trat ein Fehler auf.",
   "In Warteschlange (Lokaler Rechner ist überlastet)",
   "In Warteschlange (Entfernter Rechner ist überlastet)",
   "Gesendet: ",
   "Empfangen: ",
   "/Sek., ",
   "Erwarte Rückruf...",
   "Verbinde...",
   "Download beendet",
   "Download abgebrochen",
   "Konnte nicht verbinden",
   "Bereite Upload vor",
   "Bereite Download vor",
   "an",
   "von",
   "Fehler beim Starten des Downloads--keine gültigen Ports!",
   "Fehler beim Starten einer wartenden Verbindung!",
   "Fehler beim Starten einer wartenden Verbindung - kein Übermittlungs-Thread vorhanden!",
   "Fehler: konnte keinen Verbindungs-Thread erstellen! (Versuchen Sie, BeShare zu beenden und danach das Netzwerk neuzustarten)",
   "(Es sind %i lokale Dateien freigegeben)",
   "Konnte Ordner 'shared' nicht finden. Dateifreigabe deaktiviert!",
   "\0011Dateiname",
   "\0012Benutzer",
   "\0013SitzungsID",
   "\0014Verbindung",
   "Datei",
   "Verbinden mit Server",
   "Verbindung trennen",
   "Freigegebenen Ordner öffnen",
   "Downloads-Ordner öffnen",
   "Chat-Aufzeichnung löschen",
   "Ansicht zurücksetzen",
   "Über BeShare",
   "Beenden",
   "Attribute",
   "Einstellungen",
   "Max. Gleichzeitige Uploads",
   "Max. Gleichzeitige Downloads",
   "Keine Beschränkung",
   "Upload-Bandbreite",
   "Aufzeichnung",
   "Uploads",
   "Benutzerereignisse",
   "Änderungen abfragen",
   "Vollständige Benutzerabfragen",
   "Ich bin hinter einer Firewall",
   "Abfrage:",
   "Starte Abfrage",
   "Stoppe Abfrage",
   "Server:",
   "Benutzername:",
   "Markierte Dateien herunterladen",
   "Beendete/fehlerhafte Übertragungen löschen",
   "Markierte Dateien entfernen",
   "Chat",
   "Name",
   "ID",
   "BeShare lauscht auf Port %u.  Wählen Sie Verbinden im Menu Datei, um loszulegen!",
   "Server für die Dateifreigabe konnte nicht gestartet werden!",
   "Kann nicht herunterladen von Benutzer ",
   ", keine Informationen zur Verbindung sind vorhanden.",
   "Kann keine Dateien herunterladen von ",
   ", weil wir beide hinter einer Firewall sind.",
   "Sitzung für eingehenden Dateidownload von",
   " initialisieren schlug fehl!",
   "Sitzung für Dateidownload an ",
   "Abfrage geändert in",
   "Abfrage gestartet",
   "Download-Sitzung für anfragenden, entfernten Rechner konnte nicht gestartet werden!",
   "Ihr Name wurde geändert auf ",
   "von",
   "Unbekannter Benutzer ",
   ", Mitteilung \"",
   "\" nicht gesendet.",
   "Kein Zielbenutzer in /msg angegeben",
   "Abfrage gestoppt",
   "System",
   "Warnung",
   "Fehler",
   "Aktion",
   "Verbinden mit ",	//?
   " - Verbinde mit ",
   " - %lu Resultate angezeigt (",
   " - Verbunden mit ",
   "Verbindung hergestellt.",
   "Verbinde mit Server...",
   "Sie sind nicht mehr mit dem MUSCLE-Server verbunden.",
   "Verbindung zum Server schlug fehl.",
   "Englisch",
   "Spanisch",
   "Sprache %s ausgewählt.  Sie müssen BeShare neu starten, damit die Änderungen wirksam werden.",
   "Sprache",
   "Deutsch",
   "Art",
   "Dateigröße",
   "Dateien",
   "Holländisch",
   "Überprüfe Dateien",
   "Vorhandene IRC-Kommandos:",
   "eine private Nachricht senden",
   "ändern Sie Ihren Benutzernamen",
   "machen Sie etwas",
   "Synonym für /action",
   "Chat-Aufzeichnung löschen",
   "neue Abfrage starten",
   "aktuelle Abfrage stoppen",
   "verbinde mit Server",
   "Verbindung trennen",
   "BeShare beenden",
   "diesen Hilfetext anzeigen",
   "<Name oder SitzungsID> <Text>",
   "<Name>",
   "<Aktion>",
   "[AbfrageString]",
   "[ServerName]",
   "Portugiesisch",
   "Französisch",
   "Piepston Ausgeben, wenn Sie Angesprochen Werden",
   "Max. Gleichzeitige Uploads pro Benutzer",
   "Zeitstempel",
   "Beendete Downloads automatisch löschen",
   "Max. Gleichzeitige Downloads pro Benutzer",
   "Italienisch",
   "Bei Programmstart automatisch einloggen",
   "Private Nachrichten",
   "Privates Chat-Fenster öffnen",
   "Privates BeShare Chat-Fenster",
   "Chatten mit:",
   "Fehler: kein Benutzer angegeben!",
   "Standard-Einstellung speichern",
   "Standard-Einstellung wiederherstellen",
   "Fehler: unbekannter Befehl",
   "Geben Sie /help ein, um eine Liste von verfügbaren Befehlen anzuzeigen.",
   " - (%lu-%lu) von %lu Resultaten angezeigt (",
   "Anzeige",
   "Informationsmeldungen",
   "Warnungsmeldungen",
   "Fehlermeldungen",
   "Protokollierung Ein",
   "Protokollierung Aus",
   "Resultate pro Seite", 
   "Wechsle zu Seite", 
   "Geben Sie zu ignorierende Benutzer an", 
   "Muster zur Ignorierung gesetzt auf: ", 
   "Muster zur Ignorierung entfernt.", 
   "<Namen oder Sitzungs-IDs>", 
   "Nach oben", 
   "Nach unten", 
   "Transfer stoppen", 
   "Transfer neustarten", 
   "Datei öffnen", 
   "Russisch",
   "Chat",
   "Aktuelles /ignore-Muster ist: ",
   "Aus",
   "Es sind noch %i Übertragungen im Gang. Sind Sie sicher, dass Sie BeShare beenden wollen?",
   "Nicht beenden",
   "Geändert",
   "Esperanto",
   "Schwedisch",
   "andere Rechner 'pingen'",
   "Ping antwortete in %Li Millisekunden",
   "Ping gesendet an: ",
   "Norwegisch",
   "Serbisch",
   "abwesend",
   "Automatische Abwesenheit",
   "Minuten",
   "tag",
   "Text der automatischen Abwesenheitsschaltung ändern",
   "Text der automatischen Abwesenheitsschaltung ist: ",
   "Abwesenheit erzwingen",
   "öffne Ordner",
   "Beobachtungs-Muster gesetzt auf: ",
   "Beobachtungs-Muster entfernt.",
   "Aktuelles Beobachtungs-Muster ist: ",
   "Zu beobachtende Benutzer angeben",
   "Startbefehle gelöscht.",
   "Befehl",
   "Startbefehl hinzufügen",
   "Startbefehle löschen",
   "Aufgezeichneter Startbefehl: ",
   "Beobachten",
   "Server-Status angefordert",
   "%.1MB belegt (%.1fMB frei)",
   "Server-Status:",
   "Server-Version",
   "Lokales Wurzelverzeichnis",
   "Belegter Speicher des Servers",
   "Server-Status anfordern",
   "Server-Uptime",
   "Wochen",
   "Tage",
   "System-Uptime",
   "Online seit",
   "Dateifreigabe eingeschaltet",
   "Benutzer ausschließen für",
   "Benutzer mit IP %s ist ausgeschlossen für",
   "Stunden",
   "Für immer",
   "entferne alle Upload-Ausschlüsse",
   "Entferne %lu Upload-Ausschlüsse",
   "AutoPriv-Muster gesetzt auf: ",
   "AutoPriv-Muster entfernt.",
   "AutoPriv-Benutzer bestimmen",
   "Aktuelles /autopriv-Muster ist: ",
   "Unbekanntes Datenformat!",
   "Log-Ordner öffnen",
   "Status",
   "Ihr Status wurde geändert auf: ",
   " ist jetzt ",
   "Auslastung",
   "Benutzerstatus setzen",
   "Bulgarisch",
   "Pfad",
   "Dateipfade beibehalten",
   "Setze Alias",
   "Alias entfernt",
   "[Name und Wert]",
   "Alias erstellen",
   "Alias antfernen",
   "An erste Stelle",
   "An letzte Stelle",
   "eigene Fensterüberschrift setzen",
   "eigene Fensterüberschrift ist",
   "Serverliste automatisch updaten",
   "Server %s hinzugefügt",
   "Server %s entfernt",
   "BeShare v%s ist jetzt erhältlich zum Download. Upgraden Sie auf %s",
   "Shell-Befehl ausführen",
   "Shell-Befehl wird ausgeführt",
   "Shell-Befehl",
   "Ruhebefehl gesetzt auf",
   "Befehl setzen für beendete Downloads",
   "Schriftgrsse in Punkten",
   "Schriftgrsse setzen",
   "Schriftgrsse gesetzt auf:",
   "Schriftgrsse auf Standard zurckgesetzt",
};

static const char _dutchShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'G',  // Shared dir
   'I',  // Download dir
   'L',  // clear Log
   'H',  // Reset Layout
   'Q',  // Quit
   'Z',  // Full user Queries
   'M',  // Beep When Mentioned
   'P',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

// Submitted by Zathros/Ted Leeuwesteijn Ted@nds.nl, 3rdrock@bart.nl
static const char * _dutchStrings[NUM_STRINGS] = {
   "Anoniem",
   "onbekend",
   " is nu verbonden.",
   " heeft verbroken.",
   "gebruiker #",
   " (o.b.a ",
   " heeft nu de naam ",
   "waar",
   "onecht",
   "<onbekende soort>",
   "Gebruiker ",
   " is aan het binnenhalen ",
   "Fout tijdens schrijf operatie ",
   "Er is een fout opgetreden.",
   "Pauze (Lokale machine heeft het te druk)",
   "Pauze (Andere machine heeft het te druk)",
   "Zend: ",
   "Ontvangen: ",
   "/sec, ",
   "Wacht op terugbel bevestiging...",
   "Verbinden...",
   "Binnenhalen klaar",
   "Binnenhalen geannuleerd",
   "Kon niet verbinden",
   "Opmaken voor sturen",
   "Opmaken voor binnenhalen",
   "naar",
   "van",
   "Fout bij het binnenhalen bestand--geen acceptatie poort!",
   "Fout bij vertraagde verbinding!",
   "Fout bij vertraagde verbinding--geen transceiver draad!",
   "Fout, kan geen verbindings draad vinden!",
   "(Delen van %i lokale bestanden)",
   "Kan geen 'gedeelde' bestanden vinden in de shared folder, Delen niet geactiveerd!",
   "\0011Bestands Naam",
   "\0012Gebruiker",
   "\0013SessieNr",
   "\0014Verbinding",
   "Bestand",
   "Verbinden met server",
   "Verbreken",
   "Open Gedeelde Folder",
   "Open Inkomende Folder",
   "Maak Chat Log Schoon",
   "Herstel Venster",
   "Over BeShare",
   "Einde",
   "Attributen",
   "Instellingen",
   "Max Simultane Uploads",
   "Max Simultane Downloads",
   "Onbegrensd",
   "Uitgaande Bandbreedte",
   "Log",
   "Inkomend",
   "Gebruikers Gebeurtenissen",
   "Veranderde Zoekopdracht",
   "Volledige Gebruiker Zoekopdrachten",
   "Ik Ben Afgeschermd",
   "Zoek:",
   "Start Zoek",
   "Stop Zoek",
   "Server:",
   "Gebruikers Naam:",
   "Haal geselecteerde bestanden op",
   "Maak beeindigde/mislukte Transmissies schoon",
   "Verwijder Selectie",
   "Praat",
   "Naam",
   "Nr",
   "BeShare luistert op poort %i. Selecteer verbinden in het bestands menu om te beginnen!",
   "Kan geen BestandsDelingServerDraad vinden!",
   "Kan niet binnenhalen van de gebruiker ", 
   ", geen verbindings informatie beschikbaar.",
   "Kan niet binnenhalen van ",
   ", omdat wij beiden achter een firewall zitten.",
   "Bestand binnenhalen acceptatie voor ",
   " fout in initialisatie!",
   "Bestands verzoek sessie naar",
   "Zoek opdracht veranderd in",
   "Zoek opdracht gestart",
   "Kan geen GedeeldeBestandsOverdracht sessie starten voor extern overdracht verzoek!",
   "Je naam is veranderd in ",
   "door",
   "Onbekende gebruiker ",
   ", bericht \"",
   "\" niet verzonden.",
   "Geen gebruikersnaam geselecteerd in /msg",
   "Zoek opdracht gestopt",
   "Systeem",
   "Waarschuwing",
   "fout",
   "Aktie",
   "Verbind met ",
   " - Verbinden met ",
   " - toont %lu resultaten (",
   " - Verbonden met ",
   "Verbinding opgebouwd.",
   "Verbinden met server...",
   "U bent niet langer verbonden met de MUSCLE server.",
   "Verbinding met server is mislukt.",
   "Engels",
   "Spaans",
   "Taal %s geselekteerd. De veranderingen vinden plaats na het herstarten van BeShare.",
   "Taal", 
   "Duits",
   "Soort",
   "Bestands Grootte",
   "Aantal",
   "Nederlands",
   "Onderzoekt bestanden",
   "Beschikbare irc-stijl commandos:",
   "zend een prive bericht",
   "verander je gebruikersnaam",
   "Doe iets",
   "synoniem voor /action",
   "maak praat venster schoon",
   "start een nieuwe zoek aktie",
   "stop de huidige zoekaktie",
   "verbind met een server",
   "verbreek met de huidige server",
   "einde BeShare",
   "geeft deze helptekst weer",
   "<naam of sessie_Nr> <Tekst>",
   "<eigennaam>",
   "<aktie>",
   "[zoekregel]",
   "[servernaam]",
   "Portugees",
   "Frans",
   "Geef Geluid Wanneer u Genoemd Word",
   "Max Simultane Uploads per Gebruiker",
   "Toon Tijd",
   "AutoBeeindigde Downloads Schoon",
   "Max Simultane Downloads per Gebruiker",
   "Italians",
   "Verbind bij Starten",
   "Prive Berichten",
   "Open Prive Venster",
   "BeShare Prive Venster",
   "Praat Met:",
   "Fout, Geen Gebruiker Geselecteerd",
   "Bewaar Instelling",
   "Herstel Instelling",
   "Fout, onbekende opdracht",
   "Gebruik /help voor een lijst van beschikbare opdrachten.",
   " - (%lu-%lu) van %lu toont resultaten (",
   "Toon",
   "Berichten Info",
   "Alarm Berichten",
   "Fout Berichten",
   "Logboek Aan",
   "Logboek Uit",
   "Resultaten Per Pagina",
   "Ga naar Pagina", 
   "selecteer de te negeren gebruikers",
   "Negeer patroon staat op: ", 
   "Negeer patroon verwijderd.", 
   "<namen of sessie nummers>", 
   "Omhoog",
   "Omlaag", 
   "Stop Binnenhalen",
   "Herstart Binnenhalen", 
   "Open Bestand", 
   "Russe",
   "Praat",
   "Huidige /ignore patroon is:",
   "Uitgeschakeld",
   "Er zijn %i transacties gaande, weet u zeker dat u wilt stoppen?",
   "Niet Stoppen",
   "Veranderd",
   "Esperanto",
   "Zweeds",
   "ping andere partij",
   "Ping antwoord in %Li Milliseconden",
   "Zend ping verzoek naar: ",
   "Noors",
   "Servisch",
   "weg",
   "Automatisch Weg",
   "minuten",
   "etiket",
   "verander het atomatisch-weg etiket",
   "Automatisch-weg etiket ingesteld op: ",
   "Forceer weg status.",
   "Open Map",
   "kijk patroon gezet op:",
   "Kijk patroon verwijderd.",
   "Huidige /kijk patroon is: ",
   "specifeer gebruikers om te kijken",
   "Opstart commando's opgeschoond.",
   "commando",
   "voeg opstart commando toe",
   "maak opstart commando's schoon",
   "Opgenomen opstart commando: ",
   "Kijk",
   "Server status verzocht.",
   "%. 1fMB gebruikt (%. 1fMB beschikbaar)",
   "Server status:",
   "Server Versie",
   "Lokale sessie root",
   "Server geheugen gebruik",
   "Verzoek server status",
   "Server leeftijd",
   "weken",
   "dagen",
   "Systeem Leeftijd",
   "ingelogd voor",
   "Delen Bestanden Aktief",
   "Weiger Gebruiker Voor",
   "Gebruiker op IP %s is geweigerd voor",
   "Uren",
   "Permanent",
   "Verwijder alle uitgaande weigeringen",
   "Verwijder %lu uitgaande weigeringen",
   "AutoPriv patroon gezet op: ",
   "Autopriv patroon verwijderd",
   "Specificeer Autopriv Gebruikers",
   "Huidige /autopriv patroon is :",
   "Gegevens formaat onbekend!",
   "Open Logboek Map",
   "Status",
   "Uw status is veranderd naar: ",
   " is nu ",
   "Bezetting",
   "Stel gebruikers gegevens regel in",
   "bulgaars",
   "locatie",
   "behoud bestands locaties",
   "Stel alias in",
   "verwijderede alias",
   "Naam en waarde",
   "creeer een alias",
   "Verwijder een alias",
   "Verplaats naar Top",
   "Verplaats naar onderaan",
   " Stel een andere verster titel in",
   "andere venster titel is nu",
   "Automatisch bijwerken van server lijst",
   "Toegevoegde server: %s",
   "verwijderde server: %s",
   "BeShare v%s is nu verkrijgbaar, u kunt opwaarderen op %s",
   "voer shell opdracht uit",
   "shell opdracht uitgevoerd",
   "shell opdracht",
   "idle opdracht ingesteld op",
   "zet op overleden download opdrachten",
   "lettergrootte in punten",
   "lettergrootte instellen",
   "lettergrootte ingesteld op:",
   "lettergrootte op standaard",
};

static const char _portugueseShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'P',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

// Submitted by: BGA (bga@din.uem.br)
static const char * _portugueseStrings[NUM_STRINGS] = {
   "Anônimo", 
   "Desconhecido", 
   " conectou-se.", 
   " desconectou-se.", 
   "Usuário #", 
   " (t.c.c ", 
   " agora é conhecido por ", 
   "verdadeiro", 
   "falso", 
   "<tipo desconhecido>", 
   "Usuário ", 
   " está transferindo ", 
   "Erro ao escrever no arquivo ", 
   "Um Erro Ocorreu.", 
   "Empilhado (Máquina local muito ocupada)", 
   "Empilhado (Máquina remota muito ocupada)", 
   "Enviado: ", 
   "Recebido: ", 
   "/seg, ", 
   "Esperando retorno...", 
   "Conectando...", 
   "Transferência completa", 
   "Transferência abortada", 
   "Impossivel conectar", 
   "Preparando Transferência", 
   "Preparando Transferência", 
   "para", 
   "de", 
   "Erro ao iniciar transferência--porta accept inexistente!", 
   "Erro ao iniciar conexão adiada!", 
   "Erro ao iniciar conexão adiada--thread transceiver inexistente!", 
   "Erro, impossivel criar thread de conexão!", 
   "(Compartilhando %i arquivos locais)", 
   "Impossivel encontrar subdiretório 'shared', compartilhamento de arquivos desabilitado!", 
   "\0011Nome do Arquivo", 
   "\0012Usuário", 
   "\0013ID de Sessão", 
   "\0014Conexão", 
   "Arquivo", 
   "Conectar ao servidor", 
   "Desconectar", 
   "Abrir Diretório Shared", 
   "Abrir Diretório Downloads", 
   "Apagar Histórico de Chat", 
   "Resetar Layout", 
   "Sobre BeShare", 
   "Sair", 
   "Atributos", 
   "Configurações", 
   "Max de Uploads Simultâneos", 
   "Max de Downloads Simultâneos", 
   "Sem Limite", 
   "Banda de Transferência (Upload)", 
   "Histórico", 
   "Transferências (Uploads)", 
   "Eventos de Usuários", 
   "Mudanças de Pesquisa", 
   "Pesquisas Completas por Usuários", 
   "Estou Atrás de um Firewall", 
   "Pesquisa:", 
   "Iniciar Pesquisa", 
   "Parar Pesquisa", 
   "Servidor:", 
   "Nome de Usuário:", 
   "Transferir Arquivos Selecionados", 
   "Limpar Transferências Completas/Falhas", 
   "Remover Selecionados", 
   "Conversação", 
   "Nome", 
   "ID",                                              
   "BeShare está escutando na porta %u.  Selecione Conectar no menu Arquivo para iniciar!",  
   "Impossivel iniciar thread do servidor de compartilhamento de arquivos!", 
   "impossível transferir do usuário ", 
   ", informação sobre conexão não disponível.", 
   "Impossível transferir arquivos de ", 
   ", porque ambos estamos atrás de firewalls.", 
   "Sessão de aceitação de transferência de arquivo para ", 
   " falhou durante a inicialização!", 
   "Sessão de transferência de arquivo para ", 
   "Pesquisa Mudada para", 
   "Pesquisa Iniciada", 
   "Impossível iniciar sessão de Tranferência de Arquivo para servir requisição remota de transferência!", 
   "Seu nome foi mudado para ", 
   "por", 
   "Usuário desconhecido ", 
   ", mensagem \"", 
   "\" não enviada.", 
   "Nenhum usuário destino especificado no /msg", 
   "Pesquisa Interrompida", 
   "Sistema", 
   "Aviso", 
   "Erro", 
   "Ação", 
   "Conectar em ", 
   " - Conectando em ", 
   " - %lu resultados mostrados (", 
   " - Conectado a ", 
   "Conexão estabelecida.", 
   "Conectando ao servidor...", 
   "Você não está mais conectado ao servidor MUSCLE.", 
   "Conexão ao servidor falhou.", 
   "Inglês", 
   "Espanhol", 
   "Lingua %s selecionada.  A mudança se tornará efetiva após você reiniciar o BeShare.",  
   "Lingua", 
   "Alemão", 
   "Tipo", 
   "Tamanho do Arquivo", 
   "Arquivos", 
   "Holandês", 
   "Examinando Arquivos...", 
   "Comandos estilo irc disponíveis:", 
   "envia uma mensagem privada", 
   "muda seu nome de usuário", 
   "faz alguma coisa", 
   "sinônimo para /action", 
   "limpa o histórico de chat", 
   "inicia uma nova pesquisa", 
   "finaliza a pesquisa atual", 
   "conecta a um servidor", 
   "desconecta de um servidor", 
   "sai do BeShare", 
   "mostra esse texto de ajuda", 
   "<nome ou id de sessão> <texto>", 
   "<nome>", 
   "<ação>", 
   "[stringDeBusca]", 
   "[nomeDoServidor]",
   "Português",
   "Francés",
   "Emitir um Bip Quando Seu Nome for Mencionado",
   "Max de Uploads Simultâneos por Usuário",
   "Timestamps",
   "AutoLimpar Downloads Completos",
   "Max de Downloads Simultâneos por Usuário",
   "Italiano",
   "Conectar ao Iniciar",
   "Mensagens Privadas",
   "Abrir Janela de Conversação Privada",
   "Janela de Conversação Privada do BeShare",
   "Conversar com:",
   "Erro, nenhum usuário especificado!",
   "Salvar Configuração",
   "Restaurar Configuração",
   "Erro, comando desconhecido",
   "Digite /help para obter uma lista dos comandos disponíveis.",
   " - (%lu-%lu) dos %lu resultados mostrados (",
   "Mostrar",
   "Mensagens Informativas",
   "Mensagens de Aviso",
   "Mensagens de Erro",
   "Log Habilitado",
   "Log Desabilitado",
   "Resultados Por Página",
   "Mudar para Página",
   "especifique usuários a ignorar",
   "Padrão a ignorar configurado para: ",
   "Padrão a ignorar removido.",
   "<nomes ou ids de sessão> ",
   "Mover Para Cima",
   "Mover Para Baixo",
   "Interromper Transfer",
   "Reiniciar Transfer",
   "Abrir Arquivo",
   "Ruso",
   "Conversação", 
   "O padrão /ignore é: ",
   "Desabilitado",
   "Existem %i transferências em progresso, tem certeza de que você quer mesmo sair?",
   "Não Sair",
   "Data de Modificação",
   "Esperanto",
   "Sueco",
   "envia ping para outros clientes",
   "Ping retornou em %Li milisegundos",
   "Requisição de ping enviada para: ",
   "Norueguês",
   "Sérvio",
   "ausente",
   "Ausente Automaticamente",
   "minutos",
   "tag",
   "Alterar a tag de ausência automática",
   "Tag de ausência automática alterada para: ",
   "Forçar ausência",
   "Abrir Diretório",
   "Padrão de observação setado para: ",
   "Padrão de observação removido.",
   "Padrão de /watch atual é: ",
   "especifica usuários a observar",
   "Comandos de inicialização apagados.",
   "comando",
   "adiciona comando de inicialização",
   "apaga comandos de inicialização ",
   "Comando de inicialização gravado:",
   "Observar",
   "Status do servidor requerido.",
   "%.1fMB usados (%.1fMB disponíveis)",
   "Status do servidor:",
   "Versão do servidor",
   "Raiz da sessão local",
   "Uso de memória do servidor",
   "Requisita status do servidor",
   "Uptime do servidor",
   "semanas",
   "dias",
   "Uptime do Sistema",
   "conectado para",
   "Compartilhamento de Arquivos Habilitado",
   "Banir Usuário Por",
   "Usuário no IP %s banido por",
   "Horas",
   "Para Sempre",
   "Remover todos os banidos para upload",
   "Removendo %lu banidos para upload",
   "Padrão de AutoPriv setado para: ",
   "Padrão de AutoPriv removido.",
   "especifica usuários AutoPriv",
   "Padrão AutoPriv atual é: ",
   "Formato de dados desconhecido!",
   "Abrir Pasta de Logs",
   "Status",
   "Seu status foi mudado para: ",
   " agora está ",
   "Carga",
   "seta o texto de status do usuário",
   "Búlgaro",
   "Diretório",
   "Manter Diretórios",
   "Alias configurado",
   "Alias removido",
   "[nome e valor]",
   "cria um alias",
   "remove um alias",
   "Mover para o Topo",
   "Mover para o Fundo",
   "configura título da janela",
   "Título da janela agora é",
   "Atualização Automática da Lista de Servidores",
   "Adicionado servidor: %s",
   "Removido servidor: %s",
   "BeShare v%s está disponivel para download. Você pode atualizar em %s",
   "executa um comando shell",
   "Executando comando shell",
   "comando shell",
   "Comando ocioso setado para",
   "configura comando a ser executado quando as transferências encerram",
   "tamanho da fonte em pontos",
   "configurar tamanho de fonte",
   "Tamanho de fonte configurado para:",
   "Tamanho de fonte reconfigurado para padro",
}; 

static const char _frenchShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'P',  // Shared dir
   'T',  // Download dir
   'E',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'I',  // Open private chat window
   'F',  // Toggle file logging
   'S',  // File sharing enabled
   'O',  // Logs dir
};

/* French translation by Dider Bertrand (didix@mail.be) */
static const char * _frenchStrings[NUM_STRINGS] = {
   "Anonyme",
   "Inconnu",
   " connecté.",
   " déconnecté.",
   "Utilisateur #",
   " (alias ",
   " maintenant connu comme ",
   "vrai",
   "faux",
   "<type inconnu>",
   "Utilisateur ",
   " en téléchargement ",
   "Erreur d'écriture de fichier ",
   "Une erreur s'est produite.",
   "En attente (Machine locale trop occupée)",
   "En attente (Machine distante trop occupée)",
   "Envoyé: ",
   "Reçu: ",
   "/sec, ",
   "En attente d'une réponse...",
   "Connexion...",
   "Téléchargement terminé",
   "Téléchargement abandonné",
   "Connexion impossible",
   "Préparation à l'envoie",
   "Préparation au téléchargement",
   "à",
   "de",
   "Erreur en commençant le téléchargement--pas d'acceptation du port!",
   "Erreur à l'établissement de la connexion retardée!",
   "Erreur à l'établissement de la connexion retardée--pas de thread transmetteur!",
   "Erreur, création de thread connecteur impossible!",
   "(Partage de %i fichiers locaux)",
   "Dossier 'Shared' introuvable, fichiers partagés indisponibles!",
   "\0011Nom du Fichier",
   "\0012Utilisateur",
   "\0013N° de Session",
   "\0014Connexion",
   "Fichier",
   "Connecter au serveur",
   "Déconnecter",
   "Ouvrir le Dossier Partagé",
   "Ouvrir le Dossier des Téléchargements",
   "Effacer l'historique des Discussions",
   "Restaurer la Fenêtre",
   "A Propos de BeShare",
   "Quitter",
   "Attributs",
   "Configuration",
   "Max. d'envois Simultanés",
   "Max. de Téléchargements Simultanés",
   "Illimité",
   "Type de Connexion",
   "Historique",
   "Envois",
   "Evénements Utilisateur",
   "Changements de Recherche",
   "Tout Rechercher chez l'utilisateur",
   "Je Suis Protégé par un Firewall",
   "Requête:",
   "Démarrer Requête",
   "Arrêter Requête",
   "Serveur:",
   "Nom d'utilisateur:",
   "Télécharger les fichiers sélectionnés",
   "Effacer les transferts terminés/abandonnés",
   "Effacer la sélection",
   "Discussion",
   "Nom",
   "N°",
   "BeShare utilise le port %u.  Sélectionnez Connecter du menu Fichier pour commencer!",
   "Thread du serveur d'échange de fichiers impossible à lancer!",
   "Téléchargement impossible depuis l'utilisateur ",
   ", aucune information de connexion disponible.",
   "Téléchargement de fichiers impossible depuis ",
   ", parce que nous sommes derrière des Firewalls.",
   "Acceptation de session de téléchargement de fichier pour",
   " initialisation ratée!",
   "Session de téléchargement de fichier à ",
   "Requête changée en",
   "Requête démarrée",
   "Session PartageFichierTransfert impossible à commencer pour répondre à une requête de transfert distante!",
   "Votre nom a été changé en ",
   "par",
   "Utilisateur inconnu : ",
   "; le message \"",
   "\" n'a pas été envoyé.",
   "Pas de destinataire spécifié dans /msg",
   "Requête arrêtée",
   "Système",
   "Avertissement",
   "Erreur",
   "Action",
   "Connecter à ",
   " - Connexion à ",
   " - %lu résultats affichés (",
   " - Connecté à ",
   "Connexion établie.",
   "Connexion au serveur...",
   "Vous n'êtes plus connecté au serveur MUSCLE.",
   "Connexion au serveur ratée.",
   "Anglais",
   "Espagnol",
   "Langue %s sélectionnée.  Le changement prendra effet après avoir redémarré BeShare.",
   "Langue",
   "Allemand",
   "Type",
   "Taille du Fichier",
   "Fichiers",
   "Néerlandais",
   "Contrôle des fichiers...",
   "Commandes du type irc disponibles:",
   "envoyer un message privé",
   "changer votre nom d'utilisateur",
   "faire quelque chose",
   "synonyme pour /action",
   "effacer l'historique de discussion",
   "démarrer une nouvelle recherche",
   "arrêter la recherche actuelle",
   "connecter à un serveur",
   "déconnecter du serveur",
   "quitter BeShare",
   "afficher ce texte d'aide",
   "<nom ou n° de session> <texte>",
   "<nom>",
   "<action>",
   "[Chaîne de recherche]",
   "[Nom du serveur]",
   "Portugais",
   "Français",
   "Faire un Bip une Fois Mentionné",
   "Max. d'envois Simultanés par Utilisateur",
   "Horodateurs",
   "AutoEffacer les Transferts Terminés",
   "Max. de Téléchargements Simultanés par Utilisateur",
   "Italien",
   "Connexion au Lancement",
   "Messages Privés",
   "Ouvrir une Fenêtre de Discussion Privée",
   "Fenêtre Privée de Discussion de BeShare",
   "Discussion avec:",
   "Erreur, Aucun Utilisateur Spécifié!",
   "Enregistrer la Configuration",
   "Restaurer la Configuration",
   "Erreur, commande inconnue",
   "Tapez /help pour obtenir la liste des commandes disponibles.",
   " - (%lu-%lu) des %lu résultats affichés (",
   "Affichage",
   "Messages d'Information",
   "Messages d'Avertissement",
   "Messages d'Erreur",
   "Historique Disponible",
   "Historique Indisponible",
   "Résultats Par Page", 
   "Changer pour la Page", 
   "spécifier les utilisateursa ignorer",
   "Ignorer la formule: ", 
   "Ignorer la formule supprimée.", 
   "<noms ou numéros de session>", 
   "Monter", 
   "Descendre", 
   "Interrompre le Téléchargement", 
   "Recommencer le Téléchargement", 
   "Ouvrir un Fichier", 
   "Russe",
   "Discussion",
   "Modèle /ignore actuel: ",
   "Indisponible",
   "Il y a %i transferts en cours, êtes vous sur de vouloir quitter?",
   "Ne pas Quitter",
   "Date de Modification",
   "Espéranto",
   "Suédois",
   "ping autres utilisateurs",
   "Ping renvoyé en %Li millisecondes", 
   "Envoyer une requête ping à: ", 
   "Norvégien",
   "Serbe",
   "parti",
   "Partir Automatiquement",
   "minutes",
   "tag",
   "changer le tag de départ automatique",
   "Tag de départ automatique mis à: ",
   "Force l'état 'parti'",
   "Ouvrir le Dossier",  
   "Modèle de surveillance mis à",
   "Modèle de surveillance supprimé.",
   "Modèle /watch actuel: ",
   "spécifier les utilisateur à surveiller",
   "Commandes de lancement annulées.",
   "commande",
   "ajouter une commnde au lancement",
   "annuler les commandes de lancement",
   "Commandes de lancement enregistrées: ",
   "Surveiller",
   "Etat du serveur demandé.",
   "%.1fMo utilisés (%.1fMo disponibles)",
   "Etat du serveur:",
   "Version du serveur:",
   "Root de la session locale",
   "Usage mémoire du serveur",
   "Demande l'état du serveur",
   "Uptime du serveur",
   "semaines",
   "jours",
   "Uptime du système",
   "connecté depuis",
   "Partage de Fichiers Disponible",
   "Bannir l'Utilisateur Pour",
   "L'utilisateur de l'IP %s est banni pour",
   "Heures",
   "Pour toujours",
   "supprimer toutes les interdictions d'envoi",
   "Supprime %lu interdictions d'envoi",
   "Modèle AutoPriv mis à: ",
   "Modèle AutoPriv supprimé.",
   "spécifier les utilisateurs AutoPriv",
   "Modèle /autopriv actuel: ",
   "Format de donnée inconnu!",
   "Ouvrir le dossier des historiques",
   "Etat",
   "Votre état a été changé en: ",
   " est maintenant ",
   "Transfert",
   "établi la phrase d'état de l'utilisateur",
   "Bulgare",
   "Chemin",
   "Garder les Chemins des Fichiers",
   "Alias mis à",
   "Alias supprimé",
   "[nom et valeur]",
   "créer un alias",
   "supprimer un alias",
   "Déplacer en Haut",
   "Déplacer en Bas",
   "établi un titre de fenêtre personnalisé", 
   "Le titre de fenêtre personnalisé est maintenant",
   "AutoMAJ de la Liste des Serveurs",
   "Serveur ajout: %s",
   "Serveur supprim: %s",
   "BeShare v%s est maintenant disponible.  Vous pouvez le tlcharger sur %s",
   "exécute une commande shell",
   "Exécution de la commande shell",
   "commande shell",
   "commande d'inactivité mise à",
   "commande quand les transfers cessent",
   "taille de police en points",
   "changer la taille de la police",
   "Taille de police mise :",
   "Taille de police par dfaut",
};

// DA@Y2K: Added Italian localisation.
static const char _italianShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'I',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

// Submitted by Dario Accornero <bexoft@bexoft.com>
static const char * _italianStrings[NUM_STRINGS] = {
   "Anonimo",
   "Ignoto",
   " è ora connesso.",
   " si è disconnesso.",
   "Utente #",
   " (ossia ",
   " è ora noto come ",
   "vero",
   "falso",
   "<tipo ingnoto>",
   "Utente ",
   " sta scaricando ",
   "Errore nella scrittura del file ",
   "Si è verificato un errore.",
   "In coda (Macchina locale sovraccarica)",
   "In coda (Macchina remota sovraccarica)",
   "Inv.: ",
   "Ric.: ",
   "/sec, ",
   "In attesa di risposta...",
   "Collegamento...",
   "Scaricamento completo",
   "Scaricamento interrotto",
   "Impossibile connettersi",
   "Preparazione al caricamento",
   "Preparazione allo scaricamento",
   "a",
   "da",
   "Errore nell'iniziare lo scaricamento--nessuna porta accettata!",
   "Errore nell'iniziare la connessione procrastinata!",
   "Errore nell'iniziare la connessione procrastinata--nessun thread di ricezione!",
   "Errore, impossibile creare thread di connessione! (Prova ad uscire da BeShare, e poi a far ripartire la rete)",
   "(Sto condividendo %i files locali)",
   "Impossibile trova la cartella 'shared', condivisione disabilitata!",
   "\0011Nome File",
   "\0012Utente",
   "\0013ID Sessione",
   "\0014Connessione",
   "File",
   "Collegati al server",
   "Disconnetti",
   "Apri Cartella Condivisa",
   "Apri Cartella Scaricamento",
   "Cancella il Chat Log",
   "Ripristina Impostazioni Finestra",
   "Informazioni su BeShare",
   "Esci",
   "Attributi",
   "Impostazioni",
   "Max Caricamenti Simultanei",
   "Max Scaricamenti Simultanei",
   "Nessun Limite",
   "Velocità di Caricamento",
   "Log",
   "Caricamenti",
   "Eventi Utente",
   "Cambiamenti della Ricerca",
   "Ricerche Utente Complete",
   "Sono Dietro un Firewall",
   "Ricerca:",
   "Inizia ricerca",
   "Termina ricerca",
   "Server:",
   "Nome utente:",
   "Scarica files selezionati",
   "Elimina trasferimenti completi/errati",
   "Rimuovi selezione",
   "Chat",
   "Nome",
   "ID",
   "BeShare sta ascoltando sulla porta %u.  Scegli Collegati dal menu File per iniziare!",
   "Impossibile iniziare thread di condivisione server!  (Prova a far ripartire la rete, poi a rilanciare BeShare)",
   "Impossibile scaricare dall'utente ",
   ", nessuna informazione disponibile sulla connessione.",
   "Impossibile scaricare files da ",
   ", perché siamo entrambi dietro un firewall.",
   "Sessione di accettazione dello scaricamento per ",
   " non è riuscita a partire!",
   "Sessione scaricamento file su ",
   "Ricerca cambiata in",
   "Ricerca attivata",
   "Impossibile iniziare sessione ShareFileTransfer per rispondere a richiesta di trasferimento remoto!  (Prova a far ripartire la rete, poi a rilanciare BeShare)",
   "Il tuo nome e' stato cambiato in ",
   "di",
   "Utente ignoto ",
   ", messaggio \"",
   "\" non inviato.",
   "Nessun utente specificato in /msg",
   "Ricerca interrotta",
   "Sistema",
   "Attenzione",
   "Errore",
   "Azione",
   "Collegati a ",
   " - Collegamento a ",
   " - %lu risultati mostrati (",
   " - Connesso a ",
   "Connessione stabilita.",
   "Collegamento al server...",
   "Non sei più connesso al server MUSCLE.",
   "Connessione al server fallita.",
   "Inglese",
   "Spagnolo",
   "Lingua %s selezionata.  La modifica avrà effetto quando rilancerai BeShare.",
   "Lingua", 
   "Tedesco",
   "Tipo",
   "Dimensione File",
   "Files",
   "Olandese",
   "Sto esaminando i files...",
   "Comandi tipo IRC disponibili:",
   "invia un messaggio privato",
   "cambia il tuo nome utente",
   "fai qualcosa (azione)",
   "sinonimo per /action",
   "cancella il chat log",
   "inizia una nuova ricerca",
   "interrompi la ricerca corrente",
   "collegati al server",
   "disconnettiti dal server",
   "esci da BeShare",
   "mostra questo testo d'aiuto",
   "<nome o id sessione> <testo>",
   "<nome>",
   "<azione>",
   "[stringaRicerca]",
   "[nomeServer]",
   "Portoghese",
   "Francese",
   "Suona Quando Menzionato",
   "Max Caricamenti Simultanei per Utente",
   "Mostra Tempi",
   "Elimina Automaticamente Scaricamenti Completati",
   "Max Scaricamenti Simultanei per Utente",
   "Italiano",
   "Collegati al Lancio",
   "Messaggi Privati",
   "Apri Finestra Privata di Chat",
   "BeShare Finestra Privata di Chat",
   "Chatta Con:",
   "Errore, nessun utente specificato!",
   "Salva Impostazioni",
   "Ripristina Impostazioni",
   "Errore, comando ignoto",
   "Scrivi /help per la lista dei comandi disponibili.",
   " - (%lu-%lu) dei %lu risultati mostrati (",
   "Visualizza",
   "Messaggi Informativi",
   "Messaggi d'Avvertimento",
   "Messaggi d'Errore",
   "Log Abilitato",
   "Log Disabilitato",
   "Risultati per Pagina", 
   "Passa alla Pagina", 
   "specifica utenti da ignorare", 
   "Ignora pattern impostato su: ", 
   "Ignora pattern rimosso.", 
   "<nomi o ID sessioni>", 
   "Muovi Su", 
   "Muovi Giù",
   "Interrompi Scaricamento", 
   "Ricomincia Scaricamento", 
   "Apri File", 
   "Russa",
   "Chat",
   "Corrente /ignore pattern è: ",
   "Disabilitato",
   "Ci sono %i trasferimenti in corso, siete sicuri di voler uscire?",
   "Non Uscire",
   "Modificato il",
   "Esperanto",
   "Svedese",
   "Fai un ping su altri clients",
   "Il ping è ritornato in %Li millisecondi",
   "Manda una richiesta di ping a: ", 
   "Norvegese",
   "Serbo",
   "via",
   "Allontanati Automaticamente",
   "minuti",
   "tag",
   "Cambia il tag di auto-allontanamento",
   "Tag di auto-allontanamento impostato come: ",
   "Forza auto allontanamento",
   "Apri Cartella",
   "Pattern di osservazione impostato su: ",
   "Pattern di osservazione eliminato.",
   "Pattern di osservazione corrente: ",
   "specifica utenti da osservare",
   "Comandi di lancio rimossi.",
   "comando",
   "aggiungi comando di lancio",
   "elimina comandi di lancio",
   "Comando di lancio registrato: ",
   "Osserva",
   "Richiesto stato del server.",
   "%.1fMB usati (%.1fMB disponibili)",
   "Stato del server:",
   "Versione del server",
   "Root della sessione locale",
   "Utilizzo memoria del server",
   "Richiedi stato del server",
   "Tempo online del server",
   "settimane",
   "giorni",
   "Tempo online del sistema",
   "connesso da",
   "Condivisione files attiva",
   "Blocca utente per",
   "Utente con indirizzo IP %s bloccato per",
   "Ore",
   "Sempre",
   "elimina tutti i blocchi per upload",
   "Sto rimuovendo %lu blocchi per upload",
   "Pattern AutoPriv impostato su: ",
   "Pattern AutoPriv rimosso.",
   "specifica utenti AutoPriv",
   "Pattern /autopriv corrente: ",
   "Formato dati ignoto!",
   "Apri Cartella Log",
   "Stato",
   "Il tuo stato è stato cambiato in: ", 
   " è ora ",                     
   "Carico",
   "assegna stringa per stato utente",
   "Bulgarian",
   "Path",
   "Retain File Paths",
   "Set alias",
   "Removed alias",
   "[name and value]",
   "create an alias",
   "remove an alias",
   "Move to Top",
   "Move to Bottom",
   "set custom window title",
   "Custom window title is now",
   "AutoUpdate Server List",
   "Added server: %s",
   "Removed server: %s",
   "BeShare v%s is now available for download.  You can upgrade at %s",
   "execute shell command",
   "Executing shell command",
   "shell command",
   "idle command set to",
   "set command for when transfers cease",
   "font size in points", 
   "set font size",
   "Font size set to:",
   "Font size reset to default",
};

static const char _russianShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'I',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

// Russian translation by Oleg "2sheds" Kourapov <2sheds@newmail.ru>
static const char * _russianStrings[NUM_STRINGS] = {
   "Анонимный",
   "Неизвестный",
   " подключился.",
   " отключился.",
   "Юзер №",
   " (a.k.a. ",
   " сменил имя на ",
   "true",
   "false",
   "<неизвестный тип>",
   "Юзер ",
   " скачивает ",
   "Ошибка при записи файла ",
   "Произошла ошибка.",
   "Отложено (Локальная машина занята)",
   "Отложено (Удаленная машина занята)",
   "Отпр: ",
   "Прин: ",
   "/сек, ",
   "Ждем ответ...",
   "Соединяемся...",
   "Скачивание завершено",
   "Скачивание отменено",
   "Невозможно соединиться",
   "Подготовка к закачиванию",
   "Подготовка к скачиванию",
   "в",
   "из",
   "Не удается открыть порт!",
   "Не удается начать отложенное соединение!",
   "Не удается начать отложенное соединение--нет передающего потока!",
   "Ошибка, не удается присоединиться! (Закройте BeShare и нажмите Restart Networkiing в настройках сети)",
   "(Доступно %i локальных файлов)",
   "Не удается найти папку 'shared', разделение доступа невозможно!",
   "\0011Имя файла",
   "\0012Юзер",
   "\0013№ юзера",
   "\0014Соединение",
   "Файл",
   "Присоединиться",
   "Отсоединиться",
   "Открыть папку 'Shared'",
   "Открыть папку 'Downloads'",
   "Очистить окно разговоров",
   "Вернуть исходный вид",
   "О программе...",
   "Выйти",
   "Атрибуты",
   "Настройки",
   "Макс. число закачиваний",
   "Макс. число скачиваний",
   "Без ограничений",
   "Вид соединения",
   "Записывать",
   "Закачивания",
   "Локальные события",
   "Изменения запроса",
   "Показывать все файлы юзера",
   "Я за файрволом",
   "Искать:",
   "Начать поиск",
   "Остановить",
   "Сервер:",
   "Имя юзера:",
   "Скачать выбранные файлы",
   "Убрать законченные/прерванные скачивания",
   "Остановить выбранное",
   "Разговоры",
   "Имя",
   "№",
   "BeShare следит за портом %i.  Выберите Присоединиться в меню Файл!",
   "Couldn't start file-sharing server thread!  (Try Restarting Networking, then restarting BeShare)", //*
   "Не удается скачать от ",
   ", нет данных о соединении.",
   "Не удается скачать файлы от ",
   ", потому что оба клиента за файрволами.",
   "Не удается инициализировать соединение с ",
   ", возможно он находится за файрволом",
   "Не удается получить ответ от ",
   "Запрос изменен на ",
   "Запрос подан",
   "Couldn't start ShareFileTransfer session to serve remote transfer request!  (Try Restarting Networking, then restarting BeShare)", // *
   "Ваше имя было изменено на ",
   "по",
   "Неизвестный юзер ",
   ", сообщение \"",
   "\" не было послано.",
   "После /msg должен быть указан юзер",
   "Запрос отменен",
   "Система",
   "Внимание!",
   "Ошибка",
   "Действие",
   "Соединиться с ",
   " - Соединяемся с ",
   " - %lu вариантов показано (",
   " - Соединились с ",
   "Установлено соединение.",
   "Соединяемся с сервером...",
   "Вы не подключены к серверу MUSCLE.",
   "Не удалось соединиться с сервером.",
   "Английский [En]",
   "Испанский [Es]",
   "Выбран %s язык.  Перезагрузите BeShare, чтобы изменения вступили в силу.",
   "Язык интерфейса", 
   "Немецкий [Ge]",
   "Тип",
   "Размер",
   "Файлы",
   "Датский [De]",
   "Просматриваю файлы...",
   "Поддерживаемые IRC-команды:",
   "послать сообщение лично",
   "сменить имя",
   "сделать что-нибудь",
   "синоним команды /action",
   "стереть записанные разговоры",
   "подать новый запрос",
   "остановить запрос",
   "подсоединиться к серверу",
   "отсоединиться от сервера",
   "выйти из BeShare",
   "показать подсказку",
   "<имя или №> <текст>",
   "<имя>",
   "<действие>",
   "[запрос]",
   "[сервер]",
   "Португальский [Po]",
   "Французский [Fr]",
   "Подавать сигнал при упоминании имени",
   "Макс. число закачиваний для одного юзера",
   "Проставлять время",
   "Автоматически убирать скачанные файлы",
   "Макс. число скачиваний у одного юзера",
   "Итальянский [It]",
   "Подключаться при запуске",
   "Личные сообщения",
   "открыть окно для личного разговора",
   "Окно личного разговора",
   "Поговорить с",
   "Не указан юзер!",
   "Сохранить",
   "Восстановить",
   "Неизвестная команда ",
   "Наберите /help, чтобы увидеть список команд.",
   " - показано (%lu-%lu) вариантов из %lu (",
   "Показывать",
   "Информационные",
   "Предупреждения",
   "Ошибки",
   "Запись включена",
   "Запись выключена",
   "Количество результатов на страницу",
   "Открыть страницу",
   "игнорировать юзеров",
   "Маска команды /ignore: ",
   "Маска команды /ignore удалена.",
   "<имена или №№>",
   "Вверх",
   "Вниз",
   "Отменить скачивание",
   "Начать скачивание заново",
   "Открыть файл",
   "Русский [Ru]",
   "Сказать",
   "Текущая маска команды /ignore: ",
   "нет маски",
   "Скачивается %i файл(ов), вы уверены, что хотите выйти?",
   "Остаться",
   "Изменен",
   "Эсперанто",
   "Шведский [Se]",
   "послать пакет",
   "Пакет вернулся через %Li милисекунд",
   "Пакет отправлен: ",
   "Норвежский",
   "Сербский",
   "вышел",
   "Режим \" Вышел\" через",
   "минут",
   "метка",
   "изменить метку \"Вышел\"",
   "Метка режима \"Вышел\": ",
   "включить режим \"Вышел\"",
   "Open Folder",
   "Watch pattern set to: ",
   "Watch pattern removed.",
   "Current /watch pattern is: ",
   "specify users to watch",
   "Startup commands cleared.",
   "command",
   "add startup command",
   "clear startup commands",
   "Recorded startup command: ",
   "Watch",
   "Server status requested.",
   "%.1fMB used (%.1fMB available)",
   "Server status:",
   "Server version",
   "Local session root",
   "Server memory usage",
   "Request server status",
   "Server uptime",
   "weeks",
   "days",
   "System Uptime",
   "logged in for",
   "File Sharing Enabled",
   "Ban User For",
   "User at IP %s banned for",
   "Hours",
   "Forever",
   "remove all upload bans",
   "Removing %lu upload bans",
   "AutoPriv pattern set to: ",
   "AutoPriv pattern removed.",
   "specify AutoPriv users",
   "Current /autopriv pattern is: ",
   "Unknown data format!",
   "Open Logs Folder",
   "Status",
   "Your status has been changed to: ",
   " is now ",
   "Load",
   "set user status string",
   "Bulgarian",
   "Path",
   "Retain File Paths",
   "Set alias",
   "Removed alias",
   "[name and value]",
   "create an alias",
   "remove an alias",
   "Move to Top",
   "Move to Bottom",
   "set custom window title",
   "Custom window title is now",
   "AutoUpdate Server List",
   "Added server: %s",
   "Removed server: %s",
   "BeShare v%s is now available for download.  You can upgrade at %s",
   "execute shell command",
   "Executing shell command",
   "shell command",
   "idle command set to",
   "set command for when transfers cease",
   "font size in points", 
   "set font size",
   "Font size set to:",
   "Font size reset to default",
};

static const char _esperantoShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'P',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

static const char * _esperantoStrings[NUM_STRINGS] = {
   "Anonima",
   "Nekonata",
   " nun estas konektita.",
   " malkonektis.",
   "Uzanto #",
   " (alinome ",
   " nun estas konata kiel ",
   "vere",
   "malvere",
   "<nekonata tipo>",
   "Uzanto ",
   " elŝutas ",
   "Eraro je skribo al dosiero ",
   "Okazis Eraro.",
   "Envicigita (Loka komputilo tro okupita)",
   "Envicigita (Fora komputilo tro okupita)",
   "Sendita: ",
   "Ricevita: ",
   "/sek, ",
   "Atendas revokon...",
   "Konektas...",
   "Elŝuto finita",
   "Elŝuto abortigita",
   "Ne eblis konekti",
   "Preparas Alŝuti",
   "Preparas Elŝuti",
   "al",
   "de",
   "Eraro je starto de elŝuto--neniu akcepta pordo!",
   "Eraro je starto de prokrastita konekto!",
   "Eraro je starto de prokrastita konekto--neniu ricevsenda fadeno!",
   "Eraro, ne eblis krei konektan fadenon! (Provu eliru BeShare-on, poste Restartigu la Retumadon)",
   "(Disponigas %i lokajn dosierojn)",
   "Ne eblis trovi la dosierujon 'shared', dosier-disponigado malebligita!",
   "\0011Dosiernomo",
   "\0012Uzanto",
   "\0013Sesia ID",
   "\0014Konekto",
   "Arkivo",
   "Konektu al servilo",
   "Malkonektu",
   "Malfermu La Disponigan Dosierujon",
   "Malfermu La Elŝutan Dosierujon",
   "Malplenigu La Babilan Protokolon",
   "Reŝarĝu La Aranĝon",
   "Pri BeShare",
   "Eliru",
   "Atributoj",
   "Preferoj",
   "Supra Limo de Samtempaj Alŝutoj",
   "Supra Limo de Samtempaj Elŝutoj",
   "Neniu Limo",
   "Alŝuta Bendlarĝo",
   "Protokolu",
   "Alŝutojn",
   "Uzant-Eventojn",
   "Serĉo-Ŝanĝojn",
   "Plenaj Uzant-Serĉoj",
   "Mi estas malantaŭ Fajroŝirmilo",
   "Serĉu:",
   "Komencu Serĉi",
   "Ĉesu Serĉi",
   "Servilo:",
   "Uzantonomo:",
   "Elŝutu Elektitajn Dosierojn",
   "Forigu Finitajn/Malsukcesajn Transigojn",
   "Forigu Elektitan",
   "Babiladon",
   "Nomo",
   "ID",
   "BeShare aŭskultas ĉe la pordo %u.  Elektu Konektu en la Arkivo-menuo por komenci!",
   "Ne eblis startigi la dosier-disponigan fadenon!  (Provu Restartigu la Retumadon, poste restartigu BeShare-on)",
   "Ne eblas elŝuti de uzanto ",
   ", neniu konekta informo haveblas.",
   "Ne eblas elŝuti dosierojn de ",
   ", ĉar ni ambaŭ estas malantaŭ fajroŝirmiloj.",
   "Dosierelŝuta akceptsesio al ",
   " malsukcesis iniciatiĝi!",
   "Dosierelŝuta sesio al ",
   "Ŝanĝis Serĉo al",
   "Komencis Serĉi",
   "Ne eblis startigi ShareFileTransfer-sesion por servi la foran transigpeton!  (Try Restarting Networking, then restarting BeShare)",
   "Via nomo estas ŝanĝita al ",
   "de",
   "Nekonata uzanto ",
   ", mesaĝo \"",
   "\" ne sendita.",
   "Ricevonta uzanto ne specifita en /msg",
   "Ĉesis Serĉi",
   "Sistemo",
   "Averto",
   "Eraro",
   "Ago",
   "Konektu al ",
   " - Konektas al ",
   " - %lu rezultoj montritaj (",
   " - Konektita al ",
   "Konekto establita.",
   "Konektas al servilo...",
   "Vi ne plu estas konektita al la MUSCLE-servilo.",
   "Konekto al la servilo malsukcesis.",
   "Angla",
   "Hispana",
   "La lingvo %s estis elektita.  La ŝanĝo efikos post restartigo de BeShare.",
   "Lingvo", 
   "Germana",
   "Tipo",
   "Grandeco",
   "Dosieroj",
   "Nederlanda",
   "Ekzamenas la Dosierojn...",
   "Disponeblaj irc-stilaj komandoj:",
   "sendas privatan mesaĝon",
   "ŝanĝas vian uzantonomon",
   "faru ion",
   "sinonimo de /action",
   "malplenigas la babilan protokolon",
   "startigas novan serĉon",
   "haltigas la nunan serĉon",
   "konektas al servilo",
   "malkonektas de la servilo",
   "eliru BeShare-on",
   "montras la jenan helptekston",
   "<nomo aŭ sesia id> <teksto>",
   "<nomo>",
   "<ago>",
   "[serĉTeksto]",
   "[servilNomo]",
   "Portugala",
   "Franca",
   "Sonu Kiam Menciita",
   "Supra Limo de Samtempaj Alŝutoj por Ĉiu Uzanto",
   "Tempomarkojn",
   "Forigu Finitajn Elŝutojn Aŭtomate",
   "Supra Limo de Samtempaj Elŝutoj por Ĉiu Uzanto",
   "Itala",
   "Konektu je la Programstarto",
   "Privatajn Mesaĝojn",
   "Malfermu Privatan Babilfenestron",
   "BeShare Private Chat Window",
   "Babilu Kun:",
   "Eraro, uzanto ne specifita!", 
   "Ŝparu Preferojn",
   "Reŝarĝu Preferojn",
   "Eraro, nekonata komando",
   "Skribu /help por listo de disponeblaj komandoj.",
   " - (%lu-%lu) el %lu rezultoj montritaj (",
   "Montru",
   "Informajn Mesaĝojn",
   "Alertajn Mesaĝojn",
   "Erarajn Mesaĝojn",
   "Protokolo Aktivita",
   "Protokolo Neaktivita",
   "Rezultoj sur Ĉiu Paĝo",
   "Ŝanĝu al Paĝo",
   "specifu uzantojn por ignori",
   "Ignorfiltro ŝanĝita al: ",
   "Ignorfiltro forigita.",
   "<nomoj aŭ sesiaj id-oj>",
   "Movu Supren",
   "Movu Malsupren",
   "Haltigu Elŝuton",
   "Restartigu Elŝuton",
   "Malfermu Dosieron",
   "Rusa",
   "Babilu", 
   "Nuna /ignore-filtro estas: ",
   "Neaktivita",
   "Estas %i aktiva(j) transigo(j), ĉu vi vere volas eliri?",
   "Ne Eliru",            // Don't Quit
   "Laste Ŝanĝita",   // Time of the last change
   "Esperanto",   
   "Sveda",               // Swedish
   "pingas aliajn klientojn", 
   "La pingo revenis post %Li milisekundoj.", 
   "Pingo-peto sendita al: ", 
   "Norvega",
   "Serba",
   "for",
   "Aŭtomate For",
   "minutoj",
   "mesaĝo",
   "ŝanĝas la aŭtomata-for-mesaĝo",
   "Aŭtomata-for-mesaĝo ŝanĝita al: ",
   "Devige enŝaltas for-staton",
   "Malfermu La Dosierujon",   
   "Observa filtro ŝanĝita al: ",
   "Observa filtro forigita.",
   "Aktuala observa filtro estas: ",
   "precizigu observotajn uzantojn",
   "Start-ordonoj nuligitaj.",
   "ordono",
   "aldonu start-ordonon",
   "nuligu start-ordonojn",
   "Registrita start-ordono: ",
   "Observu",
   "Servila stato postulita.",
   "%.1fMB uzataj (%.1fMB disponeblaj)",
   "Servila stato:",
   "Servilo versio",
   "Radiko de la loka komputilo",
   "Servila uzo de memoro",
   "Postulu la servilan staton",
   "Tempodaŭro ekde la servila ŝaltiĝo",
   "semajnojn",
   "tagojn",
   "Tempodaŭro ekde la sistema ŝaltiĝo",
   "konektita",
   "Dosierdisponado Aktiva",
   "Malpermesu Uzanton Dum",
   "Uzanto kun IP %s malpermesita dum",
   "Horoj",
   "Eterne",
   "forigu ĉiujn alŝut-malpermesojn",
   "Forigas %lu alŝut-malpermesojn",
   "AutoPriv-filtro ŝanĝita al: ",
   "AutoPriv-filtro forigita.",
   "precizigu AutoPriv-uzantojn",
   "Nuna /autopriv-filtro estas: ",
   "Nekonata datum-formato!",
   "Malfermu la Protokol-dosierujon",
   "Stato",
   "Via stato ŝanĝiĝis al: ",
   " nun estas ",
   "Ŝarĝo",
   "ŝanĝas la stato-tekston de la uzanto",
   "Bulgara",
   "Pado",
   "Konservu Dosierajn Padojn",
   "Ŝanĝis alinomon",
   "Forigis alinomon",
   "[nomo kaj valoro]",
   "kreas alinomon",
   "forigas alinomon",
   "Movu al la Supro",
   "Movu al la Malsupro",
   "ŝanĝu la fenestro-titolon",
   "La fenestrotitolo nun estas",
   "Aŭtomate Ĝisdatigi La Servil-liston",
   "Aldonis la servilon",
   "Forigis la servilon",
   "BeShare v%s nun elŝuteblas. Vi povas ĝisdatigi ĉe %s",
   "execute shell command",
   "Executing shell command",
   "shell command",
   "idle command set to",
   "set command for when transfers cease",
   "font size in points", 
   "set font size",
   "Font size set to:",
   "Font size reset to default",
};


static const char _swedishShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'K',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'A',  // Quit
   'U',  // Full user Queries
   'O',  // Beep When Mentioned
   'P',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'G',  // Logs dir
};

static const char * _swedishStrings[NUM_STRINGS] = {
   "Anonym",
   "Okänd",
   " är nu ansluten.",
   " har kopplat ner.",
   "Användare #",
   " (alias ",
   " heter nu ",
   "sant",
   "falskt",
   "<okänd typ>",
   "Användare ",
   " laddar ner ",
   "Fel vid skrivning till fil ",
   "Ett Fel Uppstod.",
   "Köad (Egna datorn för upptagen)",
   "Köad (Andra sidan för upptagen)",
   "Sänt: ",
   "Mottagit: ",
   "/sek, ",
   "Väntar på återupprigning...",
   "Ansluter...",
   "Nerladdning slutförd",
   "Nerladdning avbruten",
   "Kunde inte ansluta",
   "Förbereder Uppladdning",
   "Förbereder Nerladdning",
   "till",
   "från",
   "Fel vid start av nerladdning--ingen mottagarport!",
   "Fel vid start av fördröjd anslutning!",
   "Fel vid start av fördröjd anslutning--ingen transceivertråd!",
   "Fel, kunde inte skapa anslutningstråd! (Försök med att avsluta BeShare, och Starta om Nätverket)",
   "(Delar med sig av %i lokala filer)",
   "Kunde inte hitta underkatalogen 'shared', fildelning avstängd!",
   "\0011Filnamn",
   "\0012Användare",
   "\0013SessionsID",
   "\0014Anslutning",
   "Arkiv",
   "Anslut till server",
   "Koppla ner",
   "Öppna Katalogen med Delade Filer",
   "Öppna Katalogen med Nerladdade Filer",
   "Rensa Chatt-Loggen",
   "Nollställ Layouten",
   "Om BeShare",
   "Avsluta",
   "Attribut",
   "Inställningar",
   "Max Samtidiga Uppladdningar",
   "Max Samtidiga Nerladdningar",
   "Obegränsat",
   "Uppladdningsbandbredd",
   "Logg",
   "Uppladdningar",
   "Användarhändelser",
   "Sökändringar",
   "Fullständiga Användarsökningar",
   "Jag är bakom en Brandvägg",
   "Sök:",
   "Starta Sökning",
   "Stoppa Sökning",
   "Server:",
   "Användarnamn:",
   "Ladda Ner Valda Filer",
   "Rensa Avslutade/Avbrutna Överföringar",
   "Ta Bort Markerad",
   "Chatt",
   "Namn",
   "ID",
   "BeShare lyssnar på port %u. Välj Anslut i Arkiv-menyn för att börja!",
   "Kunde inte starta servertråden för fildelning! (Försök med att Starta om Nätverket, och sedan starta om BeShare)",
   "Kan inte ladda ner från användare ",
   ", ingen anslutningsinformation tillgänglig.",
   "Kan inte ladda ner filer från ",
   ", eftersom vi båda är bakom brandväggar.",
   "Filnerladdnings-mottagnings-sessionen för ",
   " kunde inte initialiseras!",
   "Filnerladdnings-session till ",
   "Ändrade Sökning till",
   "Startade Sökning",
   "Kunde inte starta ShareFileTransfer-session för att betjäna andra sidans överföringsbegäran!  (Försök med att Starta om Nätverket, och sedan starta om BeShare)",
   "Ditt namn har ändrats till ",
   "av",
   "Okänd användare ",
   ", meddelande \"",
   "\" sändes ej.",
   "Ingen mottagande användare angavs i /msg",
   "Stoppade Sökning",
   "System",
   "Varning",
   "Fel",
   "Händelse",
   "Anslut till ",
   " - Ansluter till ",
   " - %lu resultat visade (",
   " - Ansluten till ",
   "Anslutning etablerad.",
   "Ansluter till server...",
   "Du är inte längre ansluten till MUSCLE-servern.",
   "Anslutning till server misslyckades.",
   "Engelska",
   "Spanska",
   "Språk %s valt.  Ändringarna kommer att ta effekt efter att du startat om BeShare.",
   "Språk", 
   "Tyska",
   "Typ",
   "Filstorlek",
   "Filer",
   "Holländska",
   "Undersöker Filer...",
   "Tillgängliga irc-typskommandon:",
   "sänd ett privat meddelande",
   "ändra ditt användarnamn",
   "gör någonting",
   "synonym till /action",
   "rensa chatt-loggen",
   "starta en ny sökning",
   "stoppa nuvarande sökning",
   "anslut till en server",
   "koppla ner från servern",
   "avsluta BeShare",
   "visa den här hjälptexten",
   "<namn eller sessions-id> <text>",
   "<namn>",
   "<händelse>",
   "[sökSträng]",
   "[serverNamn]",
   "Portugisiska",
   "Franska",
   "Pip När Omnämnd",
   "Max Samtidiga Uppladdningar Per Användare",
   "Tidstämplar",
   "AutoRensa Färdiga Nerladdningar",
   "Max Samtidiga Nerladdningar Per Användare",
   "Italienska",
   "Logga in vid Uppstart",
   "Privata Meddelanden",
   "Öppna Privat Chatt-Fönster",
   "BeShare Privat Chatt-Fönster",
   "Chatta Med:",
   "Fel, ingen användare angiven!", 
   "Spara Inställningar",
   "Återställ Inställningar",
   "Fel, okänt kommando",
   "Skriv /help för en lista med tillgängliga kommandon.",
   " - (%lu-%lu) av %lu resultat visade (",
   "Visa",
   "Infomeddelanden",
   "Varningsmeddelanden",
   "Felmeddelanden",
   "Loggning Aktiverad",
   "Loggning Avaktiverad",
   "Resultat Per Sida",
   "Byt till Sida",
   "ange användare att ignorera",
   "Ignoreringsmönster satt till: ",
   "Ignoreringsmönster borttaget.",
   "<namn eller sessions-id:n>",
   "Flytta Upp",
   "Flytta Ner",
   "Stanna Nerladdning",
   "Fortsätt Nerladdning",
   "Öppna Fil",
   "Ryska",
   "Chatta",
   "Nuvarande /ignore-mönster är: ",
   "Avaktiverad",
   "Det finns %i pågående överföringar, är det säkert att du vill avsluta?",
   "Avsluta Inte",      // Don't Quit
   "Senaste Ändring", // Last Change
   "Esperanto",
   "Svenska",	
   "pingar andra klienter",
   "Pingen återvände efter %Li millisekunder.",
   "Ping-förfrågan sänd till: ",
   "Norska",
   "Serbiska",
   "borta",
   "Automatiskt Borta",
   "minuter",
   "meddelande",
   "ändrar auto-borta-meddelandet",
   "Auto-borta-meddelandet satt till: ",
   "Påtvingar borta-läge",
   "Öppna Filer",
   "Iaktagningsmönster satt till: ",
   "Iaktagningsmönster borttaget.",
   "Nuvarande iaktagningsmönster är: ",
   "ange användare som ska iaktagas",
   "Start-kommandon rensade.",
   "kommando",
   "lägg till start-kommando",
   "rensa start-kommandon",
   "Inspelat start-kommando: ",
   "Observera",
   "Serverstatus begärd.",
   "%.1fMB använda (%.1fMB tillgängliga)",
   "Serverstatus:",
   "Serverversion",
   "Egna datorns rot",
   "Serverns minnesanvändning",
   "Begär serverstatus",
   "Serverns uppetid",
   "veckor",
   "dagar",
   "Systemets Uppetid",
   "inloggad",
   "Fildelning Aktiverad",
   "Banna Användare För",
   "Användare med IP %s bannad för",
   "Timmar",
   "Evigt",
   "ta bort alla uppladdnings-banningar",
   "Tar bort %lu uppladdnings-banningar",
   "AutoPriv-mönster satt till: ",
   "AutoPriv-mönster borttaget.",
   "ange AutoPriv-användare",
   "Nuvarande /autopriv-mönster är: ",
   "Okänt dataformat!",
   "Öppna Logg-katalogen",
   "Status",
   "Din status har ändrats till: ",
   " är nu ",
   "Belastning",
   "sätt användarens status-text",
   "Bulgariska",
   "Sökväg",
   "Bevara Fil-sökvägar",
   "Satte alias",
   "Tog bort alias",
   "[namn och värde]",
   "skapa ett alias",
   "ta bort ett alias",
   "Flytta Överst",
   "Flytta Nederst",
   "sätt egen fönstertitel",
   "Fönstertiteln är nu",
   "Uppdatera Serverlistan Automatiskt",
   "Lade till server",
   "Tog bort server",
   "BeShare v%s finns nu för nerladdning. Du kan uppgradera på %s",
   "execute shell command",
   "Executing shell command",
   "shell command",
   "idle command set to",
   "set command for when transfers cease",
   "font size in points", 
   "set font size",
   "Font size set to:",
   "Font size reset to default",
};

static const char _norwegianShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'P',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

static const char * _norwegianStrings[NUM_STRINGS] = {
   "Anonym",
   "Ukjent",
   " er no tilkopla.",
   " har kopla frå.",
   "Brukar #",
   " (kjend som ",
   " er no kjend som ",
   "sann",
   "usann",
   "<ukjend type>",
   "Brukar ",
   " lastar ned ",
   "Feil ved filskriving ",
   "Det vart ein feil.",
   "I kø (maskina di er oppteken)",
   "I kø (vertsmaskina er oppteken)",
   "Sendt: ",
   "Motteke: ",
   "/sek, ",
   "Ventar på svar...",
   "Koplar til...",
   "Nedlasting ferdig",
   "Nedlasting avbrote",
   "Kunne ikkje kopla til",
   "Gjer klar til å senda",
   "Gjer klar til å lasta ned",
   "til",
   "frå",
   "Kan ikkje lasta ned--ingen mottakarport!",
   "Kan ikkje starta forseinka tilkopling!",
   "Kan ikkje starta forseinka tilkopling--ingen overføringstråd!",
   "Feil, kan ikkje laga tilkoplingstråd! (Prøv å avslutta BeShare og starta Netverkstenester på nytt)",
   "(Deler %i filer på maskina di)",
   "Kan ikkje finna 'shared'-mappa, fildeling er avslegen!",
   "\0011Filnamn",
   "\0012Brukar",
   "\0013Brukarnummer",
   "\0014Tilkopling",
   "Fil",
   "Kopla til tenar",
   "Kopla frå",
   "Opna Shared-mappa",
   "Opna Downloads-mappa",
   "Slett pratelogg",
   "Start omatt oppsett",
   "Om BeShare",
   "Avslutt",
   "Eigenskapar",
   "Innstillingar",
   "Flest opplastingar samstundes",
   "Flest nedlastingar samstundes",
   "Ikkje nokor grense",
   "Opplastingsbandbreidd",
   "Logg",
   "Opplastingar",
   "Brukarhendingar",
   "Endringar i førespurnader",
   "Fulle brukarførespurnader",
   "Eg er bak ein brannmur",
   "Førespurnad:",
   "Finn!",
   "Stogg førespurnad",
   "Tenar:",
   "Brukarnamn:",
   "Last ned desse filene",
   "Slett ferdige/feilslegne nedlastingar",
   "Slett utvalde",
   "Prat",
   "Namn",
   "Nummer",
   "BeShare lyttar på port %u.  Vel Kopla til frå Fil-menyen for å byrja!",
   "Kan ikkje starta tenartråd for fildeling!  (Prøv å starta Netverkstenester på nytt, så BeShare)",
   "Kan ikkje lasta ned frå brukar ",
   ", det finst ikkje opplysningar om tilkoplinga.",
   "Kan ikkje lasta ned filer frå ",
   ", fordi me er bak brannmurar båe to.",
   "Godkjenninga av filnedlasting for ",
   " vart feil",
   "Filnedlasting for ",
   "Endra førespurnad til",
   "Starta førespurnad",
   "Kan ikkje starta ShareFileTransfer-omgang for å svara på førespurnad frå ein annan brukar!  (Prøv å starta Netverkstenester på nytt, så BeShare)",
   "Namnet ditt er endra til ",
   "av",
   "Ukjend brukar ",
   ", melding \"",
   "\" ikkje sendt.",
   "Ingen målbrukar gjeven i /msg",
   "Stogga førespurnad",
   "System",
   "Åtvaring",
   "Feil",
   "Handling",
   "Kopla til ",
   " - Koplar til ",
   " - %lu resultat synte (",
   " - Kopla til ",
   "Har sett opp tilkopling.",
   "Koplar til tenar...",
   "Du er ikkje lenger kopla til MUSCLE-tenaren.",
   "Greidde ikkje å kopla til tenar.",
   "Engelsk",
   "Spansk",
   "Språket %s er valt.  Endringane vil synast når du startar BeShare på nytt att.",
   "Språk", 
   "Tysk",
   "Type",
   "Storleik",
   "Filer",
   "Nederlandsk",
   "Undersøkjer filer...",
   "Kommandoar i irc-stil som finst:",
   "send ei privat melding",
   "endra brukarnamnet ditt",
   "gjer noko",
   "synonym for /action",
   "slett prateloggen",
   "start ein ny førespurnad",
   "stogg den aktive førespurnaden",
   "kopla til ein tenar",
   "kopla frå tenaren",
   "avslutt BeShare",
   "syn meg denne hjelpeteksten",
   "<namn eller brukarnummer> <tekst>",
   "<namn>",
   "<handling>",
   "[søkjeStreng]",
   "[tenarNamn]",
   "Portugisisk",
   "Fransk",
   "Pip når nemnd",
   "Flest samstundes opplastingar for kvar brukar",
   "Tidsstempel",
   "AutoSlett ferdige nedlastingar",
   "Flest samstundes nedlastingar for kvar brukar",
   "Italiensk",
   "Logg inn ved oppstart",
   "Private meldingar",
   "Opna privat praterute",
   "BeShare privat praterute",
   "Prat med:",
   "Feil, du har ikkje valt brukar!", 
   "Lagra innstilling",
   "Hent fram att innstilling",
   "Feil, ukjend kommando",
   "Skriv /help for eit oversyn over mogelege kommandoar.",
   " - (%lu-%lu) av %lu synte resultat (",
   "Syn",
   "Info-meldingar",
   "Åtvaringar",
   "Feilmeldingar",
   "Logging på",
   "Logging av",
   "Resultat for kvar side",
   "Byt til side",
   "sjå bort frå brukarar",
   "Oversjå-filteret er sett til: ",
   "Ta bort oversjå-filter.",
   "<namn eller brukarnummer>",
   "Flytt opp",
   "Flytt ned",
   "Stogg nedlasting",
   "Start nedlasting på nytt",
   "Opna fil",
   "Russisk",
   "Prat",
   "Noverande /ignore-mønster er: ",
   "Avslegen",
   "Der er %i overføringar no, er du viss på at du vil avslutta?",
   "Ikkje avslutt",      // Don't Quit
   "Siste endring", // Last Change
   "Esperanto",
   "Svensk",
   "ping andre brukarar",
   "Ping kom att på %Li millisekund",
   "Sent ping-førespurnad til: ",
   "Norsk (nynorsk)",
   "Serbisk",
   "borte",
   "Autovarsling om fråver",
   "minutt",
   "melding",
   "endrar meldinga som kjem opp automatisk når du er borte",
   "Meldinga som kjem opp når du er borte er no: ",
   "Bruk fråversmelding uansett",
   "Opna mappa",
   "Fylgjefilteret er sett til: ",
   "Fylgjefilteret er fjerna.",
   "Fylgjefilteret /watch er no: ",
   "Skriv inn kva brukarar du vil fylgja med",
   "Oppstartskommandoane er sletta.",
   "kommando",
   "legg til ein oppstartskommando",
   "slett oppstartskommandoane",
   "Har lagt til oppstartskommando: ",
   "Fylg med",
   "Spør etter tenarstatus.",
   "%.1fMB  brukt (%.1fMB tilgjengeleg)",
   "Tenarstatus:",
   "Tenarversjon",
   "Tenar-rota åt klienten din denne omgangen",
   "Minnebruk hjå tenaren",
   "Spør etter tenarstatus",
   "Tenaren har vore i drift",
   "veker",
   "dagar",
   "Maskina di har vore i drift",
   "Du har vore logga på i",
   "Fildeling på",
   "Steng ute brukar i",
   "Brukaren med IP %s er stengt ute i",
   "Timar",
   "For alltid",
   "fjern alle opplastingsstengsel",
   "Fjernar %lu opplastingsstengsel",
   "AutoPriv-mønsteret er sett til: ",
   "Har fjerna AutoPriv-mønsteret.",
   "oppgje AutoPriv-brukarar",
   "Det noverande /autopriv-mønsteret er: ",
   "Ukjent dataformat!",
   "Opna loggmappa",
   "Status",
   "Statusen din erendra til: ",
   " er ",
   "Last",
   "endrar brukarstatusen",
   "Bulgarsk",
   "Filplassering",
   "Bruk filplasseringane",
   "Bruk alias",
   "Fjerna alias",
   "[namn og verdi]",
   "lag eit alias",
   "fjern eit alias",
   "Flytt øvst",
   "Flytt nedst",
   "Gje vindauget ein eigen tittel",
   "Vindaugstittelen er no",
   "Auto-oppdater tenarlista",
   "Har lagt til tenar: %s",
   "Har fjerna tenar: %s",
   "No kan du få BeShare v%s. Du kan laste han ned frå %s.",
   "utfør skall-kommando",
   "Utfører skall-kommando",
   "skall-kommando",
   "ledig-kommandoen er sett til",
   "set kommandoar til bruk når overføringane er avslutta (ledig-kommandoar)",
   "skriftstorleik i punkt",
   "set skriftstorleik",
   "Skriftstorleiken er no:",
   "Har sett skrifta til vanleg storleik",
};

static const char _serbianShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'P',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

static const char * _serbianStrings[NUM_STRINGS] = {
   "Anoniman",
   "Nepoznat",
   " je konektovan.",
   " nije konektovan.",
   "Korisnik #",
   " (a.k.a. ",
   " se sad zove ",
   "tacno",
   "netacno",
   "<nepoznat tip>",
   "Korisnik ",
   " preuzima datoteku ",
   "Greska pri snimanju datoteke ",
   "Desila se greska.",
   "Ceka (lokalni racunar je zauzet)",
   "Ceka (udaljeni racunar je zauzet)",
   "Poslato: ",
   "Primljeno: ",
   "/sek, ",
   "Ceka odgovor...",
   "Povezivanje...",
   "Preuzimanje gotovo",
   "Preuzimanje prekinuto",
   "Povezivanje neuspesno",
   "Pripremanje slanja",
   "Pripremanje preuzimanja",
   "ka",
   "od",
   "Greska pri preuzimanju-nije prihvacen port!",
   "Greska pri odlozenoj konekciji!",
   "Greska pri odlozenoj konekciji--no transceiver thread!",
   "Greska, nije se mogla uspostaviti konekcija! (Ugasite BeShare i restartujte Networking)",
   "(Delim %i lokalnih datoteka)",
   "Ne mogu da nadjem 'deljeni' poddirektorijum, deljenje datoteka onemoguceno!",
   "\0011Ime datoteke",
   "\0012Korisnik",
   "\0013Broj sesije",
   "\0014Konekcija",
   "Datoteka",
   "Povezi se na server",
   "Prekini vezu",
   "Otvori direktorijum sa deljenim datotekama",
   "Otvori Download direktorijum",
   "Obrisi Chat Log",
   "Resetuj interfejs",
   "O BeShare-u",
   "Izadji",
   "Atributi",
   "Podesavanja",
   "Maksimum simultanih slanja",
   "Maksimum simultanih preuzimanja",
   "Bez ogranicenja",
   "Brzina konekcije",
   "Log",
   "Slanja",
   "Korisnicki dogadjaji",
   "Promene upita",
   "Puni korisnicki upiti",
   "Ja sam iza firewall-a",
   "Upit:",
   "Pokreni upit",
   "Zaustavi upit",
   "Server:",
   "Korisnicko ime:",
   "Preuzmi izabrane datoteke",
   "Izbrisi zavrsene/neuspesne transfere",
   "Izbrisi izabrano",
   "Razgovor",
   "Ime",
   "ID",
   "BeShare slusa na portu %u.  Izaberi Connect iz Datoteka menija da pocnes!",
   "Nije se mogao pokrenuti ile-sharing server thread!  (Restartujte Networking i pokrenite BeShare!)",
   "Nije moguce preuzeti datoteku od korisnika ",
   ", bez informacije o konekciji.",
   "Nemoguce preuzeti od ",
   ", zato sto smo obojica iza firewall-a.",
   "Preuzimanje datoteke prihvaceno od ",
   " neuspesna inicijalizacija!",
   "Sesija preuzimanja od ",
   "Promenjen upit u",
   "Pokrenut upit",
   "Nije pokrenuta ShareFileTransfer sesija da bi se zadovoljio zahtev! (Restartuj Networking,a potom restartuj BeShare)",
   "Vase ime je promenjeno u ",
   "od",
   "Nepoznat korisnik ",
   ", poruka \"",
   "\" nije poslata.",
   "Nije odredjen ciljni korisnik u /msg",
   "Zaustavljen sistem",
   "Sistem",
   "Upozorenje",
   "Greska",
   "Akcija",
   "Povezi se sa ",
   " - Povezi se sa ",
   " - %lu reultati prikazani (",
   " - Povezi se sa ",
   "Uspostavljena veza.",
   "Povezivanje na server...",
   "Niste vise povezani na MUSCLE server.",
   "Beuspesno povezivanje na server.",
   "Engleski",
   "Spanski",
   "Jezik %s izabran. Promena ce se prikazati po ponovnom pokretanju BeShare-a.",
   "Jezik", 
   "Nemacki",
   "Tip",
   "Velicina datoteke",
   "Datoteke",
   "Holandski",
   "Ispitujem datoteke...",
   "Raspolozive irc-olike komande:",
   "posalji privatnu poruku",
   "promeni svoje korisnicko ime",
   "uradi nsto",
   "sinonim za /akciju",
   "izbrisi chat log",
   "pokreni novi upit",
   "zaustavi upit",
   "povezi se na server",
   "prekini vezu sa serverom",
   "izadji iz BeShare-a",
   "prikazi tekst pomoci",
   "<ime ili id sesije> <tekst>",
   "<ime>",
   "<akcija>",
   "[queryString]",
   "[imeservera]",
   "Portugalski",
   "Francuski",
   "Upozori zvukom kad si pomenut",
   "Maksimum istovremenih slanja po korisniku",
   "Vreme",
   "Automatski izbrisi zavrsene preuzete datoteke",
   "Maksimum istovremenih preuzimanja po korisniku",
   "Italijanski",
   "Povezi se automatski",
   "Privatne poruke",
   "Optvori prozor za privatni razgovor",
   "BeShare prozor za privatni razgovor",
   "razgovor sa:",
   "Greska, nije definisan korisnik!", 
   "Snimi sablon",
   "Ponovo ucitaj sablon",
   "Greska, nepoznata komanda",
   "Ukucaj /help za listu raspolozivih komandi.",
   " - (%lu-%lu) od %lu rezultata (",
   "Prikazi",
   "Informativne poruke",
   "Poruke upozorenja",
   "Poruke o greskama",
   "Povezivanje omoguceno",
   "Povezivanje onemoguceno",
   "Resuzultati po stranici",
   "Prebaci se na stranicu",
   "odredi korisnike za ignorisanje",
   "Lista za ignorisanje podesena na: ",
   "Lista za ignorisanje izbrisana.",
   "<imena ili id sesija>",
   "Pomeri gore",
   "Pomeri dole",
   "Zaustavi preuzimanje",
   "Ponovno pokreni preuzimanje",
   "Otvori datoteku",
   "Ruski",
   "Razgovor",
   "Trenutna /lista ignorisanja: ",
   "Onemogucen",
   "Trenutno je u toku %i transfera, da li ste sigurni da hocete da izadjete?",
   "Ne izadji",
   "Vreme promene",
   "Esperanto",
   "Svedski",
   "ping-uj ostale klijente",
   "Ping se vratio za %Li milisekundi",
   "Posalji ping zahtev ka: ",
   "Norveski",
   "Srpski",
   "away",
   "Auto Away",
   "minutes",
   "tag",
   "change the auto-away tag",
   "Auto-away tag set to: ",
   "Force away state",
   "Otvori Direktorijum",   
   "Watch pattern set to: ",
   "Watch pattern removed.",
   "Current /watch pattern is: ",
   "specify users to watch",
   "Startup commands cleared.",
   "command",
   "add startup command",
   "clear startup commands",
   "Recorded startup command: ",
   "Watch",
   "Server status requested.",
   "%.1fMB used (%.1fMB available)",
   "Server status:",
   "Server version",
   "Local session root",
   "Server memory usage",
   "Request server status",
   "Server uptime",
   "weeks",
   "days",
   "System Uptime",
   "logged in for",
   "File Sharing Enabled",
   "Ban User For",
   "User at IP %s banned for",
   "Hours",
   "Forever",
   "remove all upload bans",
   "Removing %lu upload bans",
   "AutoPriv pattern set to: ",
   "AutoPriv pattern removed.",
   "specify AutoPriv users",
   "Current /autopriv pattern is: ",
   "Unknown data format!",
   "Open Logs Folder",
   "Status",
   "Your status has been changed to: ",
   " is now ",
   "Load",
   "set user status string",
   "Bulgarian",
   "Path",
   "Retain File Paths",
   "Set alias",
   "Removed alias",
   "[name and value]",
   "create an alias",
   "remove an alias",
   "Move to Top",
   "Move to Bottom",
   "set custom window title",
   "Custom window title is now",
   "AutoUpdate Server List",
   "Added server: %s",
   "Removed server: %s",
   "BeShare v%s is now available for download.  You can upgrade at %s",
   "execute shell command",
   "Executing shell command",
   "shell command",
   "idle command set to",
   "set command for when transfers cease",
   "font size in points", 
   "set font size",
   "Font size set to:",
   "Font size reset to default",
};

static const char _bulgarianShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'P',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

// Bulgarian translation by Zlatko Zlatinov <zlati74@rambler.bg>
static const char * _bulgarianStrings[NUM_STRINGS] = {
   "Анонимен",
   "Неизвестен",
   " се включи.",
   " беше отстранен ( disconnected).",
   "Клиент № ",
   " (известен като ",
   " си промени името на ",
   "истина",
   "лъжа",
   "<неизвестен тип (значение)>",
   "Клиент ",
   " се сваля ",
   "Грешка при запис на файла ",
   "Грешка",
   "На опашката (локалната машина е заета в момента)",
   "На опашката (отдалечената машина е заета в момента)",
   "Изпратени: ",
   "Приети: ",
   "/сек., ",
   "Чакам отговор...",
   "Connect...",
   "Свалянето завърши",
   "Свалянето е прекъснато",
   "Връзката е невъзможна",
   "Подготовка за upload",
   "Подготовка за download",
   "в",
   "от",
   "Не мога да започна свалянето - няма отворен порт!",
   "Не мога да продължа - отложена връзка (delayed)!",
   "Не мога да продължа, отложена връзка (delayed)- няма изходен поток!",
   "Грешка, не може да се създаде нишка! (Затворете BeShare и натиснете Restart Networkiing в мрежовите настройки)",
   "(Достъпни са %i локални файла)",
   "Не мога да намеря папка Shared, забранени са локалните файлове!",
   "\0011Име на файла",
   "\0012Клиент",
   "\0013№ на сесията",
   "\0014Тип на връзката",
   "Файл",
   "Connect ",
   "Disconnect",
   "Отвори папка Shared",
   "Отвори папка Downloads",
   "Изчисти чат прозореца",
   "Върни настройките по подразбиране",
   "Информация за програмата",
   "Изход",
   "Атрибути",
   "Настройки",
   "Макс. число за upload",
   "Макс. число за download",
   "Без ограничения",
   "Скорост на връзката",
   "Записи",
   "Upload",
   "Локални събития",
   "Изменения на заявката",
   "Показване на всички клиентски файлове",
   "Зад защитна стена съм (firewall)",
   "Заявка:",
   "Започни търсене",
   "Спри",
   "Сървър:",
   "Име на клиента:",
   "Свали избраните файлове",
   "Автом. изтрий завършилите /неуспелите",
   "Изтрий селектираните",
   "Разговори (чат)",
   "Име",
   "№",
   "BeShare следи порт %i.  Изберете Connect в менюто Файл!",
   "Не мога да стартирам file-sharing server thread!  (Опитай Restarting Networking, след това стартирай BeShare)", //*
   "Не мога да сваля файла от клиент ",
   ", няма информация за връзка.",
   "Не мога да сваля файловете от ",
   ", защото и двата клиента са зад защитна стена.",
   "Не може да се инициализира връзка с",
   ", възможно е той да е със защитна стена",
   "Не мога да получа отговор от ",
   "Заявката е изменена на ",
   "Заявката е стартирана",
   "Couldn't start ShareFileTransfer session to serve remote transfer request!  (Try Restarting Networking, then restarting BeShare)", // *
   "Вашето име бе променено на ",
   "от",
   "Неизвестен клиент ",
   ", съобщение \"",
   "\" не беше изпратено.",
   "След /msg задължително трябва да е указан клиент",
   "Търсенето е спряно",
   "Система",
   "Внимание!",
   "Грешка",
   "Действие",
   "Connect to ",
   " - Връзваме се със ",
   " - %lu вариант(a) са показани (",
   " - Връзка с ",
   "Установена е връзка.",
   "Връзваме се със сървър...",
   "Вие вече не сте включен към MUSCLE сървър.",
   "Не успяхте да се свържете със сървър.",
   "Английски [En]",
   "Испански [Es]",
   "Избран е %s език.  Промяната ще настъпи след рестартиране на BeShare.",
   "Език", 
   "Немски [Ge]",
   "Значение",
   "Размер",
   "Файла(a)",
   "Датски [De]",
   "Преглед на файловете...",
   "Поддръжани IRC-команди:",
   "изпрати лично съобщение",
   "смени името на клиента",
   "направи нещо",
   "синоним на команда /action",
   "изтрий записаните разговори",
   "стартирай нова заявка",
   "спри текущата заявка",
   "свържи се със сървър",
   "disconnect от сървър",
   "изход от BeShare",
   "покажи списъка с команди",
   "<име или клиентски №> <текст>",
   "<име>",
   "<действие>",
   "[заявка]",
   "[сървър]",
   "Португалски [Po]",
   "Френски [Fr]",
   "Подай сигнал при споменаване на името",
   "Макс. число upload-и за клиент",
   "Покажи времето",
   "Автоматично изтрий завършилите",
   "Макс. число download-и за клиент",
   "Италиански [It]",
   "Логин при стартиране",
   "Лични съобщения",
   "Oтвори прозорец за чат",
   "BeShare чат прозорец",
   "Поговори с ",
   "Грешка, не е указан клиент!",
   "Съхрани",
   "Въстанови",
   "Неизвестна команда ",
   "Напишете /help, за да видите списъка с валидни команди.",
   " - показани са (%lu-%lu) варианта от %lu (",
   "Покажи",
   "Информационни съобщения",
   "Предупреждения",
   "Грешки",
   "Записите са включени",
   "Записите са деактивирани",
   "Количество резултати на страница",
   "Прехвърли се на страница",
   "игнорирай клиент",
   "Маска на команда /ignore: ",
   "Маска на команда /ignore е изтрита.",
   "<имена или №>",
   "Нагоре",
   "Надолу",
   "Отмени трансфера",
   "Рестартирай трансфера",
   "Отвори файл",
   "Руски [Ru]",
   "Чат",
   "Текущата маска на команда /ignore е: ",
   "деактивиран",
   "Дърпат се %i файл(а), уверени ли сте, че искате да напуснете програмата?",
   "Не",
   "Променен",
   "Есперанто",
   "Шведски [Se]",
   "пинг на другите клиенти",
   "Пакета се връща за %Li милисекунди",
   "Изпрати пинг до: ",
   "Норвежки",
   "Сръбски",
   "излязъл",
   "Режим \" Изход\" след",
   "минути",
   "отметка",
   "промени отметка \"Изход\"",
   "Отметка режим \"Изход\": ",
   "изключи режим \"Изход\"",
   "Отвори папка",
   "Watch pattern set to: ",
   "Watch pattern removed.",
   "Current /watch pattern is: ",
   "клиент(и) за наблюдение",
   "Стартовите команди са изтрити.",
   "команда",
   "добави команда при стартиране",
   "изтрий стартиращите команди",
   "показва информация за състоянието (статуса) на сървъра: ",
   "Наблюдавай",
   "Запитване за текущия статус на сървъра.",
   "%.1fMB използвани (%.1fMB достъпни)",
   "Статус на сървъра:",
   "Версия на сървъра",
   "Local session root",
   "Използвана памет от сървъра",
   "запитване за състоянието на сървъра",
   "Server uptime",
   "седмици",
   "дни",
   "System Uptime",
   "logged in for",
   "Разреши достъпа до локални файлове",
   "Ban User For",
   "User at IP %s banned for",
   "Часове",
   "Завинаги",
   "изтрий всички забрани за upload",
   "Removing %lu upload bans",
   "AutoPriv pattern set to: ",
   "AutoPriv pattern removed.",
   "specify AutoPriv users",
   "Current /autopriv pattern is: ",
   "Неизвестен формат на данните!",
   "Отвори папка Log",
   "Статус",
   "Вашият статус беше променен на: ",
   " сега се подвизава под името ",
   "Зареден в %",
   "задай клиентски статус",
   "Български [Bg]",
   "Път",
   "Запомни пътищата",
   "Псевдоним",
   "Изтрий псевдоним",
   "[име и стойност]",
   "създай псевдоним",
   "изтрий псевдоним",
   "Премести най-отпред",
   "Премести най-отзад",
   "задай различно заглавие на прозореца",
   "Прозореца сега се казва",
   "Aвтоматично обнови листа на сървърите",
   "Добавен е сървър: %s",
   "Изтрит е сървър: %s",
   "BeShare v%s е достъпна за сваляне.  Можете да свалите версия %s",
   "execute shell command",
   "Executing shell command",
   "shell command",
   "idle command set to",
   "set command for when transfers cease",
   "font size in points", 
   "set font size",
   "Font size set to:",
   "Font size reset to default",
};

int GetLanguage()
{
   return _language;
}

void SetLanguage(int wl)
{
   if ((wl >= 0)&&(wl < NUM_LANGUAGES)) _language = wl;
}

const char * GetLanguageName(int wl)
{
   switch(wl)
   {
      case LANGUAGE_ENGLISH:    return str(STR_ENGLISH);
      case LANGUAGE_SPANISH:    return str(STR_SPANISH);
      case LANGUAGE_GERMAN:     return str(STR_GERMAN);
      case LANGUAGE_DUTCH:      return str(STR_DUTCH);
      case LANGUAGE_PORTUGUESE: return str(STR_PORTUGUESE);
      case LANGUAGE_FRENCH:     return str(STR_FRENCH);
      case LANGUAGE_ITALIAN:    return str(STR_ITALIAN);
      case LANGUAGE_RUSSIAN:    return str(STR_RUSSIAN);
      case LANGUAGE_SWEDISH:    return str(STR_SWEDISH);
      case LANGUAGE_ESPERANTO:  return str(STR_ESPERANTO);
      case LANGUAGE_NORWEGIAN:  return str(STR_NORWEGIAN);
      case LANGUAGE_SERBIAN:    return str(STR_SERBIAN);
      case LANGUAGE_BULGARIAN:  return str(STR_BULGARIAN);
      case LANGUAGE_MALKOVITCH: return "Malkovich";
      default:  MASSERT(false, "Bad language token!"); return 0;
   }
}

const char * str(int ws)
{
   const char ** base = NULL;
   switch(_language)
   {
      case LANGUAGE_ENGLISH:    base = _englishStrings;    break;
      case LANGUAGE_SPANISH:    base = _spanishStrings;    break;
      case LANGUAGE_GERMAN:     base = _germanStrings;     break;
      case LANGUAGE_DUTCH:      base = _dutchStrings;      break;
      case LANGUAGE_PORTUGUESE: base = _portugueseStrings; break;
      case LANGUAGE_FRENCH:     base = _frenchStrings;     break;
      case LANGUAGE_ITALIAN:    base = _italianStrings;    break;
      case LANGUAGE_RUSSIAN:    base = _russianStrings;    break;
      case LANGUAGE_SWEDISH:    base = _swedishStrings;    break;
      case LANGUAGE_ESPERANTO:  base = _esperantoStrings;  break;
      case LANGUAGE_NORWEGIAN:  base = _norwegianStrings;  break;
      case LANGUAGE_SERBIAN:    base = _serbianStrings;    break;
      case LANGUAGE_BULGARIAN:  base = _bulgarianStrings;  break;
      case LANGUAGE_MALKOVITCH: 
      {
         switch(ws)
         {
            case STR_FILE_NAME_KEY:  return "\0011Malkovich";  // gotta make sure these are 
            case STR_USER_KEY:       return "\0012Malkovich";  // prefixed correctly, even
            case STR_SESSIONID_KEY:  return "\0013Malkovich";  // inside Malkovich-land
            case STR_CONNECTION_KEY: return "\0014Malkovich";
            default:                 return "Malkovich";
         }
      }
      break;
   }
   return ((base)&&(ws >= 0)&&(ws < NUM_STRINGS)) ? base[ws] : NULL;
}

char shortcut(int sc)
{
   const char * base = NULL;
   switch(_language)
   {
      case LANGUAGE_ENGLISH:    base = _englishShortcuts;    break;
      case LANGUAGE_SPANISH:    base = _spanishShortcuts;    break;
      case LANGUAGE_GERMAN:     base = _germanShortcuts;     break;
      case LANGUAGE_DUTCH:      base = _dutchShortcuts;      break;
      case LANGUAGE_PORTUGUESE: base = _portugueseShortcuts; break;
      case LANGUAGE_FRENCH:     base = _frenchShortcuts;     break;
      case LANGUAGE_ITALIAN:    base = _italianShortcuts;    break;
      case LANGUAGE_RUSSIAN:    base = _russianShortcuts;    break;
      case LANGUAGE_SWEDISH:    base = _swedishShortcuts;    break;
      case LANGUAGE_ESPERANTO:  base = _esperantoShortcuts;  break;
      case LANGUAGE_NORWEGIAN:  base = _norwegianShortcuts;  break;
      case LANGUAGE_SERBIAN:    base = _serbianShortcuts;    break;
      case LANGUAGE_BULGARIAN:  base = _bulgarianShortcuts;  break;
      case LANGUAGE_MALKOVITCH: return 'M';
   }
   return ((base)&&(sc >= 0)&&(sc < NUM_SHORTCUTS)) ? base[sc] : 0;
}


};  // end namespace beshare
