#include <stdio.h>
#include "ShareUtils.h"

namespace beshare {

void
GetByteSizeString(int64 v, char * buf)
{
   // special hack to give file sizes in kilobytes, etc. for readability
        if (v > (1024LL*1024LL*1024LL*1024LL)) sprintf(buf, "%.2fTB", ((double)v)/(1024LL*1024LL*1024LL*1024LL));
   else if (v > (1024LL*1024LL*1024LL)) sprintf(buf, "%.2fGB", ((double)v)/(1024LL*1024LL*1024LL));
   else if (v > (1024LL*1024LL)) sprintf(buf, "%.2fMB", ((double)v)/(1024LL*1024LL));
   else if (v > (1024LL*10LL)) sprintf(buf, "%lliKB", v/1024LL);
   else sprintf(buf, "%lli bytes", v);
}

void 
GetTimeString(time_t when, char * buf)
{
   struct tm * now = localtime(&when);
   sprintf(buf, "%02i/%02i/%04i %02i:%02i:%02i", now->tm_mon+1, now->tm_mday, now->tm_year+1900, now->tm_hour, now->tm_min, now->tm_sec);
}

};  // end namespace beshare
