#ifndef CLAMP_FRONTEND_H
#define CLAMP_FRONTEND_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <AppKit.h>
#include <Claes/Thread.h>
#include "FrontEnd_Messages.h"
#include "CLAmp_Signature.h"

#define SPEEDPROMILLE_FROM_PROMILLE(Pm) ((Pm)< 500 ? 500+(Pm) : (Pm)*2)
#define PROMILLE_FROM_SPEEDPROMILLE(Pm) ((Pm)<1000 ? (Pm)-500 : (Pm)/2)

// This class is used by CLAmp_FrontEnd and should not be used by you...
class CLAFE_Receiver : public BLooper {
public:
	CLAFE_Receiver();
	~CLAFE_Receiver();
	bool InitCheck() { return (InitOkay); }
	void MessageReceived (BMessage *msg);
	bool NewInfoAvailable() { return (NewInfo); }
	void GetInfo(struct FrontEndInfo *info) { if (Lock()) { memcpy (info, &CLAmp_Info, sizeof(CLAmp_Info)); NewInfo= false; Unlock(); } }
	void SendMsg(long Command) { BMessage Msg(Command); SendMsg(&Msg); }
	void SendMsg(BMessage *msg);
	void SetAutoStart(bool Yes) { AutoStart= Yes; }
	void StartCLAmp();
private:
	Bool Lock()						{ return (B_NO_ERROR==acquire_sem(DataSemaphore)); }
	bool LockTimed(long microSec)	{ return (B_NO_ERROR==acquire_sem_etc(DataSemaphore, 1, B_TIMEOUT, microSec)); }
	bool IsNotLocked()				{ int32 Cnt; return (B_OK==get_sem_count(DataSemaphore,&Cnt) && Cnt<=0); }
	void Unlock()					{ release_sem(DataSemaphore); }

 	BMessenger CL_Amp;
	struct FrontEndInfo CLAmp_Info;
	sem_id DataSemaphore;
	bool NewInfo, MessengerOk, InitOkay, AutoStart;
};


class CLAmp_FrontEnd : public CLThread {
public:
	CLAmp_FrontEnd(bool AutoUpdateInfo=false, bigtime_t Interval= 100*1000);
	~CLAmp_FrontEnd();
	bool InitCheck() { return (InitOkay); }
	void StartRunning(bool AutoStart=true, long priority=B_DISPLAY_PRIORITY) { ourMailbox->SetAutoStart(AutoStart); Go("CL-Amp FrontEnd", (Priority=priority)); }
	void StopRunning() { CLThread::SetAbort(); if (DataSemaphore>=0) delete_sem(DataSemaphore); DataSemaphore=-1; CLThread::Abort(); }
	int32 Main();
	void SetHandler(BHandler *h) { theHandler= h; }

	// Your controlling routines! With them you can tell CL-Amp what to do...
	void PlayThis(const char *String, bool Fade=false)  { BMessage Msg(M_PLAY_THIS); Msg.AddString(CL_AMP_THIS_NAME, String); Msg.AddBool(CL_AMP_FADING, Fade); ourMailbox->SendMsg(&Msg);  }
	void PressPrevButton(bool Fade=false)	{ BMessage Msg(M_BUTTON_PREV);  Msg.AddBool(CL_AMP_FADING, Fade); ourMailbox->SendMsg(&Msg);  }
	void PressPlayButton(bool Fade=false)	{ BMessage Msg(M_BUTTON_PLAY);  Msg.AddBool(CL_AMP_FADING, Fade); ourMailbox->SendMsg(&Msg);  }
	void PressPauseButton(bool Fade=false)	{ BMessage Msg(M_BUTTON_PAUSE); Msg.AddBool(CL_AMP_FADING, Fade); ourMailbox->SendMsg(&Msg); }
	void PressStopButton(bool Fade=false)	{ BMessage Msg(M_BUTTON_STOP);  Msg.AddBool(CL_AMP_FADING, Fade); ourMailbox->SendMsg(&Msg);  }
	void PressNextButton(bool Fade=false)	{ BMessage Msg(M_BUTTON_NEXT);  Msg.AddBool(CL_AMP_FADING, Fade); ourMailbox->SendMsg(&Msg);  }
	void PressCloseButton(bool Fade=false)	{ BMessage Msg(M_BUTTON_CLOSE); Msg.AddBool(CL_AMP_FADING, Fade); ourMailbox->SendMsg(&Msg); }
	void SetVolume(short Volume)			{ BMessage Msg(M_SET_VOLUME);  Msg.AddInt16(CL_AMP_VOLUME,  Volume);  ourMailbox->SendMsg(&Msg);  }
	void SetSpeed(short Speed, bool RealPercent=true)	{ int16 TheSpeed= RealPercent?PROMILLE_FROM_SPEEDPROMILLE(Speed):Speed; BMessage Msg(M_SET_SPEED);   Msg.AddInt16(CL_AMP_SPEED, TheSpeed);   ourMailbox->SendMsg(&Msg);  }
	void SetPanning(short Panning)			{ BMessage Msg(M_SET_PANNING); Msg.AddInt16(CL_AMP_PANNING, Panning); ourMailbox->SendMsg(&Msg);  }

	// These are the routines that give you information about the current status of CL-Amp. They are only
	// refreshed when Refresh() is called so call that routine before you check things!
	bool Refresh()	{ bool Refreshed=false; if (ourMailbox->NewInfoAvailable()) Refreshed=true, ourMailbox->GetInfo(&CLAmp_Info); if (!AutoUpdateInfo) SendInfoRequest(); return (Refreshed); }
	bool Playing()	{ return (CLAmp_Info.Playing);	} 
	bool Paused()	{ return (CLAmp_Info.Paused);	}
	bool Fading()	{ return (CLAmp_Info.Fading);	}
	long Position()	{ return (CLAmp_Info.Position);	}
	long CurrTime()	{ return (CLAmp_Info.CurrTime);	}
	long TotTime()	{ return (CLAmp_Info.TotTime);	}
	long Frequency(){ return (CLAmp_Info.Frequency);}
	long BitRate()	{ return (CLAmp_Info.BitRate);	}
	bool Stereo()	{ return (CLAmp_Info.Stereo);	}
	long Volume()	{ return (CLAmp_Info.Volume);	}
	long Speed(bool RealPercent=true)	{ return (RealPercent?SPEEDPROMILLE_FROM_PROMILLE(CLAmp_Info.Speed):CLAmp_Info.Speed);	}
	long Panning()	{ return (CLAmp_Info.Panning);	} // Not currently used by CL-Amp
	const char *Title()	{ return (CLAmp_Info.SongTitle);	}
private:
	Bool Lock()						{ return (B_NO_ERROR==acquire_sem(DataSemaphore)); }
	bool LockTimed(long microSec)	{ return (B_NO_ERROR==acquire_sem_etc(DataSemaphore, 1, B_TIMEOUT, microSec)); }
	bool IsNotLocked()				{ int32 Cnt; return (B_OK==get_sem_count(DataSemaphore,&Cnt) && Cnt<=0); }
	void Unlock()					{ release_sem(DataSemaphore); }
	void SendInfoRequest()  { ourMailbox->SendMsg(CL_AMP_FRONTEND_INFO); }

	CLAFE_Receiver *ourMailbox;
	BHandler *theHandler;
	sem_id DataSemaphore;
	bigtime_t Interval;
	long Priority;
	struct FrontEndInfo CLAmp_Info;
	bool AutoUpdateInfo;
	bool InitOkay;
};

#endif
