
#ifndef CLAMP_VISUALIZATION_PLUGIN_H
#define CLAMP_VISUALIZATION_PLUGIN_H

#include <AppKit.h>
#include <StorageKit.h>
#include <interface/View.h>

#ifndef CLAMP_PLUGIN_MSGS_H
 #include "Plugin_Messages.h"
#endif

#include "VisualizationPlugin_InfoStruct.h"

// The following is for the GetFlags() return value
#define VISPLUG_NEED_AUDIO_DATA		0x0001	// The plugin need a constantly updated info about the audio stream (CL-Amp will call Render())

// NOT supported, yet!
#define VISPLUG_NEED_MAIN_BMP		0x0010	// The plugin need a constantly updated bitmap of the CL-Amp window (CL-Amp will call Draw())
#define VISPLUG_UPDATES_MAIN_BMP	0x0020	// The plugin is changing the bitmap... (CL-Amp will use the Bitmap as it is after Draw() is called)


// The class description of the object that will be returned when CL-Amp ask the AddOn (Plugin) for its object...
class VisualizationPlugin {
public:
// Used by CL-Amp. Don't bother about these functions!
	VisualizationPlugin(char *label, char *desc) { CLAmpHandler=NULL; Label= label; Description= desc; Active= false; }
	virtual ~VisualizationPlugin() { }
	void SetHandler(BView *handler) { CLAmpHandler= handler; }
	void Activate(bool On) { if (Active!=On) { if ((Active=On)) Active= Init(); else Cleanup(); } }
	bool IsActive() { return Active; }

// =================================================================
// Here comes the functions you have to provide in your plugin code!

	virtual bool Init()=0;
	virtual void Cleanup()=0;
	virtual bool About(bool Question)=0;
	virtual bool Prefs(bool Question)=0;
	virtual unsigned long GetFlags()=0;
	// SongInfo() is not yet implemented but it will come in next version.
	virtual void SongInfo(struct SongInfoStruct *info)=0;
	// Render() is called everytime CL-Amp is adding data to the audio stream (if Init() returns VISPLUG_NEED_AUDIO_DATA)
	virtual bool Render(const struct VisAudioInfoStruct *info)=0;
	
	
	// Draw() is called everytime CL-Amp is updating it's display (if Init() returns VISPLUG_NEED_MAIN_BMP)
	// ATTENTION: The following Draw() is NOT working right now!!!
	// It's is a future project. Forget it right now!
	virtual bool Draw(struct VisGUIInfoStruct *info) { return(false); };

// End of the functions you have to provide in your plugin code!
// =================================================================

// Help functions you can call to get data from the InputPlugin class itself
	const char *GetLabel() { return Label; }
	const char *GetDescription() { return Description; }
	BHandler *GetCLAmpHandler() { return CLAmpHandler; }
	void SendToCLAmp(BMessage *msg) { BLooper *l; if (CLAmpHandler && (l=CLAmpHandler->Looper())) { l->PostMessage (msg, CLAmpHandler); } }
	void SendToCLAmp_ChangedFile(const char *FileName) { BMessage Msg(CLAMP_MSG_CHANGED); BLooper *l; if (CLAmpHandler && (l=CLAmpHandler->Looper())) { Msg.AddString(CLAMP_CHANGED_LABEL, FileName); l->PostMessage (&Msg, CLAmpHandler); } }
	void SendToCLAmp_AddFile(const char *FileName) { BMessage Msg(CLAMP_MSG_ADD); BLooper *l; if (CLAmpHandler && (l=CLAmpHandler->Looper())) { Msg.AddString(CLAMP_ADD_LABEL, FileName); l->PostMessage (&Msg, CLAmpHandler); } }
	void SendToCLAmp_DelFile(const char *FileName) { BMessage Msg(CLAMP_MSG_DEL); BLooper *l; if (CLAmpHandler && (l=CLAmpHandler->Looper())) { Msg.AddString(CLAMP_DEL_LABEL, FileName); l->PostMessage (&Msg, CLAmpHandler); } }
	void SendToCLAmp_Deactivate() { BMessage Msg(CLAMP_MSG_DEACTIVATE); Msg.AddPointer(CLAMP_OBJECT_LABEL, this); SendToCLAmp (&Msg); }
private:
	char *Label, *Description;
	BView *CLAmpHandler;
	bool Active;
};

#define CURRENT_VISUALIZATION_PLUGIN_VERSION  1
#define VISUALIZATION_PLUGIN_VERSION_MASK	0x0fff

#endif
