#ifndef CLAMP_VISUALIZATION_PLUGIN_INFO_H
#define CLAMP_VISUALIZATION_PLUGIN_INFO_H

#define MAX_VISPLUG_TITLE_LEN 100

#define SPECTRUMDATA_LEN	76
#define WAVEFORMDATA_LEN	1024

struct VisAudioInfoStruct {
// Audio stream info
	int Frequency;	// sample rate (filled in by calling app)
	int Channels;	// number of channels (filled in...)
	int LatencyTime;	// Latency in ms from call of RenderFrame to actual drawing
						// ATTENTION: Not used in CL-Amp (at least not yet :)
	int DelayTime;		// Delay between calls in ms
						// ATTENTION: Not used in CL-Amp (at least not yet :)
	int SpectrumChannels;
	int WaveFormChannels;
	const unsigned char *SpectrumData;
	const short *WaveFormData;
};

struct SongInfoStruct {
// Current song info
	char Title[MAX_VISPLUG_TITLE_LEN];
	long CurrTime, TotTime; // milliSeconds!
	long Position; // (Promille! => 0=start, and 1000=end of file)
	long Frequency, BitRate;
	short Volume, Speed, Panning; // Panning is not used in CL-Amp (at least, not yet!)
	bool Stereo;
	
// Play mode
	bool Playing, Paused; // Sound is coming when you have Playing and NOT Paused! (Playing && !Paused)
	bool Fading; // True when CL-Amp is fading or crossfading
};

/*struct VisGUIInfoStruct {
// CL-Amp's main bitmap
	BBitmap *DispBmp;
	BRect VisArea;
	long Width, Height;
	bool ShadeMode;
};*/

#endif
