#include "PrefsPanel/ViEdView_L0S0.h"
#include "Preferences.h"


ViEdView_L0S0::ViEdView_L0S0(BRect frame, const char *name, uint32 resizingMode, uint32 flags) :
	BView(frame, name, resizingMode, flags)
{
}

ViEdView_L0S0::~ViEdView_L0S0()
{
}

void ViEdView_L0S0::SetGainSliderLabel()
{
	char Label[100];
	sprintf (Label, "Gain (%ld%%)", ThePrefs.GainPercent());
	GainSlider->SetLabel(Label);
}

void ViEdView_L0S0::AttachedToWindow()
{
	BRect R= Bounds();
	R.top+= 5;
	R.left+= 5;
	R.bottom= 50 + R.top;
	R.right-= 5;
	GainSlider= new BSlider(R, "", "", new BMessage(M_SLIDER_GAIN), 1, 500);
	GainSlider->SetLimitLabels("1%", "500%");
	GainSlider->SetHashMarks(B_HASH_MARKS_BOTTOM);
	GainSlider->SetHashMarkCount(6);
	GainSlider->SetValue(ThePrefs.GainPercent());
	SetGainSliderLabel();
	AddChild(GainSlider);
	GainSlider->SetTarget(this);
}

void ViEdView_L0S0::UpdateControls()
{
}

void ViEdView_L0S0::MessageReceived(BMessage *message)
{
	switch ( message->what ) {
		case M_SLIDER_GAIN:
			ThePrefs.SetGainPercent(GainSlider->Value());
			SetGainSliderLabel();
			break;
		case B_SIMPLE_DATA:
			break;
   		default:
			BView::MessageReceived(message);
			break;
	}
}
