/*
 * Copyright (C) 1999 Daisuke Sato
 * Author : D.Sato <satozzz@cadvision.com>
 *
 * There are no warranties of any kind for this program. If you use this
 * program, you do so at your own risk. The authors are not responsible for any
 * damages  that might result from using this program.
 */
#include "CRcWindow.h" 
#include "convflg.h"


CRcWindow::CRcWindow( BRect frame ) 
    :BWindow( frame, PGMNAME, B_TITLED_WINDOW, B_NOT_RESIZABLE | B_NOT_ZOOMABLE |B_DRAW_ON_CHILDREN) 
{ 
    BRect viewFrame = Bounds() ; 
    
    view = new CRcView( viewFrame ) ; 
    AddChild( view ) ; 
} 


bool CRcWindow::QuitRequested() 
{ 
    be_app->PostMessage( B_QUIT_REQUESTED ) ; 
    return true ; 
} 


void CRcWindow::MessageReceived( BMessage* msg ) 
{ 
    switch ( msg->what ){ 
        case MSG_OPEN_PRESSED :
            view->openpanel() ;	
            break ;
        case MSG_SAVE_PRESSED :
            view->savepanel() ;	
            break ;
        case MSG_EXEC_PRESSED :
            view->convertCR() ;
            view->resetSaveFname() ;
            break ;
        case MSG_QUIT_PRESSED :
            QuitRequested() ; // exit
            break ;
        case MSG_B2W_PRESSED : 
            view->setConvflg( BE_TO_WIN ) ;
            break ; 
        case MSG_B2M_PRESSED : 
            view->setConvflg( BE_TO_MAC ) ;
            break ; 
        case MSG_W2B_PRESSED : 
            view->setConvflg( WIN_TO_BE ) ;
            break ; 
        case MSG_M2B_PRESSED : 
            view->setConvflg( MAC_TO_BE ) ;
            break ; 
        case MSG_INTEXT_KEYIN :
            break ;
        case MSG_OUTEXT_KEYIN :
            break ;
        case B_SIMPLE_DATA :    //Get open file name
            view->getOpenfname( msg ) ;
            break ;
        case B_SAVE_REQUESTED : //Get save file name
            view->getSavefname( msg ) ;
            break ;
        default: 
            inherited::MessageReceived( msg ) ;
            break ; 
    } 
} 
/*
 * End.
 */