/*
 * Copyright (C) 1999 Daisuke Sato
 * Author : D.Sato <satozzz@cadvision.com>
 *
 * There are no warranties of any kind for this program. If you use this
 * program, you do so at your own risk. The authors are not responsible for any
 * damages  that might result from using this program.
 */
#include "convCR.h"

convCR::convCR( entry_ref *openref, 
                entry_ref *saveref, 
                char      *savename ) 
       :fileUtil( openref, saveref, savename ) 
{
}


convCR::convCR():fileUtil()
{
}


convCR::~convCR()
{
}


char *convCR::readSorceFile( entry_ref *openref )
{
    retmsg = openread( openref ) ;
    if( retmsg != NULL ) return retmsg ;
    return NULL ;
}


char *convCR::createSaveFile( entry_ref *saveref, char *savename )
{
    retmsg = savecreate( saveref, savename ) ;
    if( retmsg != NULL ) return retmsg ;
    return NULL ;
}


char *convCR::getPofSrc( int *len )
{
    retmsg = filebuff( len ) ;
    return retmsg ;
}


int convCR::crCode()
{
    static int row ;
    
    retmsg = filebuff( &row ) ;
    stretc = new strEtc( retmsg, row ) ;
    
    crcount = stretc->strcount( WIN_CR ) ;
    if( crcount > 0 ){
        row = WIN_TO_BE ;
        goto RETURN ;
    }
    crcount = stretc->strcount( MAC_CR ) ;
    if( crcount > 0 ){
        row = MAC_TO_BE ;
        goto RETURN ;
    }
    row = BE_TO_WIN ;
    
    RETURN :
    delete stretc ;
    return row ;
}


void convCR::convert( int convflg )
{
    register int    c ;
    char  *cr ;
    str_fetch_t    get_next ;
    register char *ret_charTok ;

    buff = ( char * )filebuff( &buflen ) ;
    stretc = new strEtc( buff, buflen ) ;

    //
    c = 0 ;
    get_next = STR_FETCH_INIT ;
    cr = _Crcode( convflg ) ; 
    while( ( ret_charTok = ( char * )stretc->charTok( SEEK_CHAR, get_next ) ) ){
        get_next = STR_FETCH_NEXT ;
        if( ( *ret_charTok == ( char )NULL ) && convflg == WIN_TO_BE ){
            if( ( c ^= 1 ) ) continue ;
        }
        else{
            c = 0 ;
        }
        savewrite( ret_charTok ) ; 
        savewrite( cr  ) ;
    }
    delete stretc ;    
}


char *convCR::_Crcode( int convflg )
{
    switch( convflg ){
        case BE_TO_WIN :
            return WIN_CR ;
        case BE_TO_MAC :
            return MAC_CR ;
        default :
            return BE_CR ;
    }
}
/*
 * End.
 */