/*
 * Chron
 * Copyright Jonathan Booth, Oct 13, 1996
 *
 * Last Update: Oct 13, 1996
 *
 * A rewrite of the X-windows clock 'Chron', except prettier.
 */

#ifndef CLOCK_H
#define CLOCK_H

#include <View.h>

class Clock : public BView
{
public:
	Clock(BRect Area, color_space Mode);
	~Clock();
	virtual void AttachedToWindow();
	virtual void DetachedFromWindow();
	virtual void Draw(BRect updateRect);
	virtual void UpdateImage();
	virtual void ChangeSec();
	virtual void Pulse();
private:
	BPicture *Face;		// The face of the clock
	BBitmap *HandBit;	// Bitmap to speed updates
	BView *HandImg;		// Drawing image
	BPoint Center;		// center of the fig
	float LenX,LenY;	// half of a side
	bool SecStat;		// Are we displaying the seconds
	bool RedrawFace;	// Do we need to redraw the face?
	int OldSec;			// Last second we updated
};

#endif