///////////////////////////////////////////
//
// file:  App.cpp
//
// Copyright 1998 Johnny Be Good! Software
//
//                John R. Ashmun
//                jrashmun@halcyon.com
//
///////////////////////////////////////////

#include "App.h"

Application::Application( )
   : BApplication( "application/x-vnd.JBG-Claris_to_BeMail" )
{
   scriptref = 0;
   buffer = 0;
   buffer2 = 0;
   enclosure = 0;
   final_boundary = 0;
   from = 0;
   mime_version = 0;
   name = 0;
   nargs = 0;
   reply_to = 0;
   sent = 0;
   subject = 0;
   to = 0;
   header_length = 0;
   content_length = 0;
   message_time = 0;
   entry_list = new BList;
   open_panel = 0;
   save_panel = 0;
   dirs_only_filter = new DirRefFilter;
}

Application::~Application( )
{
   if( open_panel )
      delete open_panel;

   if( save_panel )
      delete save_panel;

   delete dirs_only_filter;

   entry_list->MakeEmpty( );
   delete entry_list;
}


void Application::RefsReceived( BMessage* msg )
{
   // Pete Goodeve's comments from his xicon application:
   //
   // A double-click, or drag&drop, on a script icon invokes the
   // app, and supplies a refs-received message to this function.
   // This has to handle some quirks of startup from the (PR)
   // tracker:
   //
   // Under drag&drop, *two* messages will arrive!  The second
   // is redundant and must be ignored. (Actually it will only
   // be seen under debugging (:-))
   //
   // Under drag&drop, the arguments come in as 'refs' and the
   // script is in entry "_item_to_launch_"; if the script
   // is just clicked on, it is presented as (the only) 'refs'
   // item.
   //
   // It has proved impossible to avoid traversing a link (if
   // this is what any of the icons concerned are): whether
   // the 'traverse' argument to SetTo is TRUE or FALSE, the
   // resulting BEntry always refers to the resolved path!

#define CLARIS_INCOMING_MAIL "application/x-MacOS-FCIM"
#define CLARIS_OUTGOING_MAIL "application/x-MacOS-FCOM"

   char        date_time_file_name_string[32];
   char        type_of_selected_file[255];
   char*       enclosure_buffer = 0;
   char*       encoded_enclosure_buffer = 0;
   char        unique_name[255];
   uint32      enttype;
   int         j = 0;
   int         k = 0;
   status_t    status = B_OK;
   ssize_t     encoded_enclosure_size = 0;
   off_t       enclosure_file_size = 0;
   struct stat st;
   entry_ref   ref;
   entry_ref*  ref_list_item = 0;
   BPath       enclosure_path;
   BPath       initial_directory;
   BPath       save_path;
   BEntry      ent;
   BEntry      save_ent;
   BNode*      in_node = 0;
   BNodeInfo*  in_info = 0;
   BNodeInfo*  out_info = 0;
   BFile*      enclosure_file = 0;
   BFile*      out_file = 0;

//printf( "RefsReceived( )\n" );
//msg->PrintToStream( );

   scriptref = new entry_ref;

   if( open_panel )
      open_panel->Hide( );

   // First we assume Drag & Drop (so "...launch" is supplied):
   if( msg->FindRef( "_item_to_launch_", scriptref ) == B_OK )
   {
//printf( "...launch is supplied\n" );
      ent.SetTo( scriptref ); // need this a mo' for the name

      // then get arguments
      msg->GetInfo( "refs", &enttype, &nargs );
//printf( "nargs == %d\n", nargs );
      if( nargs )
      { // there had better be...!
         for( j = 0; j < nargs && msg->FindRef( "refs", j, &ref ) == B_OK; j++)
         {
            ref_list_item = new entry_ref( ref );
            in_node = new BNode( ref_list_item );
            in_info = new BNodeInfo( in_node );
            in_info->GetType( type_of_selected_file );
            if( !strcmp( type_of_selected_file, CLARIS_INCOMING_MAIL )
                || !strcmp( type_of_selected_file, CLARIS_OUTGOING_MAIL ) )
               entry_list->AddItem( ref_list_item );
            else
               delete ref_list_item;

            delete in_info;
            delete in_node;
         }

         if( !entry_list->IsEmpty( ) )
         {
//printf( "Saved entries -- readying save_panel\n" );
            save_panel = new BFilePanel( B_OPEN_PANEL, 0, 0, B_DIRECTORY_NODE );
            save_panel->Window( )->SetTitle( "Choose Destination Directory" );
            save_panel->SetRefFilter( dirs_only_filter );
            initial_directory.SetTo( "/" );
            initial_directory.Append( "boot" );
            initial_directory.Append( "home" );
            initial_directory.Append( "mail" );
            save_panel->SetPanelDirectory( initial_directory.Path( ) );
            save_panel->SetHideWhenDone( false );
            save_panel->Show( );
//printf( "Supposed to have just done save_panel->Show( )\n" );
         }
      }
   }

   // if we don't have a script yet, look for icon-click:
   if( ent.SetTo( scriptref ) != B_OK )
   {
//printf( "looking for icon-click\n" );
      msg->FindRef( "refs", scriptref ); // assume we can only get one(!)
      if( ent.SetTo( scriptref ) != B_OK )
         Quit( ); // can't go any further

      ent.GetStat( &st );
      if( S_ISDIR( st.st_mode ) )
      {
//         printf( "It's a directory\n" );

         save_panel->Hide( );

//printf( "RefsReceived got save directory\n" );
         msg->FindRef( "directory", scriptref ); // assume we can only get one(!)
         if( save_ent.SetTo( scriptref ) != B_OK )
            Quit( ); // can't go any further

         save_ent.GetPath( &save_path );
//printf( "Save directory is %s\n", save_path.Path( ) );

         for( j = 0; j < entry_list->CountItems( ); j++ )
         {
            ref_list_item = (entry_ref*)entry_list->ItemAt( j );
            ent.SetTo( ref_list_item );
            process_entry( ent );

            if( !name )
            {
               name = new char[1];
               name[0] = '\0';
            }

            for( k = 0; k < strlen( name ); k++ )
            {
               if( name[k] == '/' )
                  name[k] = '\\';
            }

            strcpy( unique_name, name );

            message_time = parsedate( sent, -1 );
            time_to_date_time_file_name_string( date_time_file_name_string,
                                                message_time );
            strcat( unique_name, date_time_file_name_string );

try_open:
            save_path.Append( unique_name );
//printf( "MessageReceived path is %s\n", path.Path( ) );

//printf( "Saving %s\n", save_path.Path( ) );
            out_file = new BFile( save_path.Path( ),
                                  B_CREATE_FILE | B_FAIL_IF_EXISTS | B_WRITE_ONLY );
            status = out_file->InitCheck( );
            if( status != B_OK )
            {
//               printf( "Couldn't create file %s\n", save_path.Path( ) );
               increment_file_name_version( unique_name );
               save_path.GetParent( &save_path );
               goto try_open;
            }
            save_path.GetParent( &save_path );

//printf( "strlen( buffer2 ) == %d\n", strlen( buffer2 ) );
//printf( "Writing %Ld bytes from buffer2\n", file_size );
            out_file->Write( buffer2, file_size );

//printf( "Writing Name:  %s\n", name );
            out_file->WriteAttr( B_MAIL_ATTR_NAME, B_STRING_TYPE, 0,
                                 name, strlen( name ) + 1 );
            delete [] name;
            name = 0;

            if( enclosure )
            {
               enclosure_path.SetTo( "/S900" );
               enclosure_path.Append( "Internet Connection Kit" );
               enclosure_path.Append( "Internet Applications" );
               enclosure_path.Append( "Claris Emailer Folder" );
               enclosure_path.Append( "Downloads" );
               enclosure_path.Append( enclosure );
//printf( "enclosure path is %s\n", enclosure_path.Path( ) );
               enclosure_file = new BFile( enclosure_path.Path( ), B_READ_ONLY );
               enclosure_file->GetSize( &enclosure_file_size );
               enclosure_buffer = new char[enclosure_file_size];

               enclosure_file->Read( enclosure_buffer, enclosure_file_size );
               delete enclosure_file;

               encoded_enclosure_buffer = new char[4 * enclosure_file_size];
               encoded_enclosure_size = encode_base64( encoded_enclosure_buffer,
                                                       enclosure_buffer,
                                                       enclosure_file_size );
               out_file->Write( encoded_enclosure_buffer, encoded_enclosure_size );

               content_length += encoded_enclosure_size;

               if( final_boundary )
               {
                  out_file->Write( final_boundary, strlen( final_boundary ) );

                  content_length = content_length + strlen( final_boundary );

                  delete [] final_boundary;
                  final_boundary = 0;
               }

               delete [] enclosure_buffer;
               delete [] encoded_enclosure_buffer;
               delete [] enclosure;
               enclosure = 0;
            }

            out_info = new BNodeInfo( out_file );

            out_info->SetType( "text/x-email" );

            delete out_info;

//printf( "Writing when == %d\n", message_time );
            status = out_file->WriteAttr( B_MAIL_ATTR_WHEN, B_TIME_TYPE, 0,
                                          &message_time, sizeof( message_time ) );

            if( subject )
            {
//printf( "Writing Subject:  %s\n", subject );
               out_file->WriteAttr( B_MAIL_ATTR_SUBJECT, B_STRING_TYPE, 0,
                                    subject, strlen( subject ) + 1 );
               delete [] subject;
               subject = 0;
            }

            if( sent )
            {
//printf( "Sent:  %s\n", sent );
               delete [] sent;
               sent = 0;
            }

            if( from )
            {
//printf( "Writing From:  %s\n", from );
               out_file->WriteAttr( B_MAIL_ATTR_FROM, B_STRING_TYPE, 0,
                                    from, strlen( from ) + 1 );
               delete [] from;
               from = 0;
            }

            if( to )
            {
//printf( "Writing To:  %s\n", to );
               out_file->WriteAttr( B_MAIL_ATTR_TO, B_STRING_TYPE, 0,
                                    to, strlen( to ) + 1 );
               delete [] to;
               to = 0;
            }

            if( reply_to )
            {
//printf( "Writing Reply-To:  %s\n", reply_to );
               out_file->WriteAttr( B_MAIL_ATTR_REPLY, B_STRING_TYPE, 0,
                                    reply_to, strlen( reply_to ) + 1 );
               delete [] reply_to;
               reply_to = 0;
            }

            if( priority )
            {
//printf( "Writing Priority:  %s\n", priority );
               out_file->WriteAttr( B_MAIL_ATTR_PRIORITY, B_STRING_TYPE, 0,
                                    priority, strlen( priority ) + 1 );
               delete [] priority;
               priority = 0;
            }

            if( mime_version )
            {
//printf( "Writing Mime-Version:  %s\n", mime_version );
               out_file->WriteAttr( B_MAIL_ATTR_MIME, B_STRING_TYPE, 0,
                                    mime_version, strlen( mime_version ) + 1 );
               delete [] mime_version;
               mime_version = 0;
            }

            out_file->WriteAttr( B_MAIL_ATTR_STATUS, B_STRING_TYPE, 0,
                                 "Read", strlen( "Read" ) + 1 );

            out_file->WriteAttr( B_MAIL_ATTR_HEADER, B_INT32_TYPE, 0,
                                 &header_length, sizeof( header_length ) );

            out_file->WriteAttr( B_MAIL_ATTR_CONTENT, B_INT32_TYPE, 0,
                                 &content_length, sizeof( content_length ) );

            delete out_file;

            delete [] buffer2;
            buffer2 = 0;
         }
      }
      else
      {
//printf( "It's not a directory\n" );
         msg->GetInfo( "refs", &enttype, &nargs );
//printf( "nargs == %d\n", nargs );
         if( nargs )
         { // there had better be...!
            for( j = 0; j < nargs && msg->FindRef( "refs", j, &ref ) == B_OK; j++)
            {
               ref_list_item = new entry_ref( ref );
               in_node = new BNode( ref_list_item );
               in_info = new BNodeInfo( in_node );
               in_info->GetType( type_of_selected_file );
               if( !strcmp( type_of_selected_file, CLARIS_INCOMING_MAIL )
                   || !strcmp( type_of_selected_file, CLARIS_OUTGOING_MAIL ) )
                  entry_list->AddItem( ref_list_item );
               else
                  delete ref_list_item;

               delete in_info;
               delete in_node;
            }
         }

         if( !entry_list->IsEmpty( ) )
         {
            save_panel = new BFilePanel( B_OPEN_PANEL, 0, 0, B_DIRECTORY_NODE );
            save_panel->Window( )->SetTitle( "Choose Destination Directory" );
            save_panel->SetRefFilter( dirs_only_filter );
            initial_directory.SetTo( "/" );
            initial_directory.Append( "boot" );
            initial_directory.Append( "home" );
            initial_directory.Append( "mail" );
            save_panel->SetPanelDirectory( initial_directory.Path( ) );
            save_panel->SetHideWhenDone( false );
            save_panel->Show( );
         }
      }
   }
}

void Application::ReadyToRun( )
{
   BPath initial_directory;

   if( !save_panel )
   {
      open_panel = new BFilePanel;
      open_panel->SetHideWhenDone( false );
      open_panel->Window( )
         ->SetTitle( "Choose Claris E-Mail Message To Convert to BeMail File" );

      initial_directory.SetTo( "/" );
      initial_directory.Append( "S900" );
      initial_directory.Append( "Internet Connection Kit" );
      initial_directory.Append( "Internet Applications" );
      initial_directory.Append( "Claris Emailer Folder" );
      initial_directory.Append( "Claris Emailer Files" );
      initial_directory.Append( "Filing Cabinet" );
      initial_directory.Append( "Personal Folders" );
      open_panel->SetPanelDirectory( initial_directory.Path( ) );
      open_panel->Show( );
   }
}


void Application::MessageReceived( BMessage* msg )
{
   BFilePanel* source = 0;

//printf( "MessageReceived\n" );
//msg->PrintToStream( );

   switch( msg->what )
   {
      case B_CANCEL:
         msg->FindPointer( "source", &source );

         if( entry_list->IsEmpty( ) || source == save_panel )
         {
            be_app->PostMessage( B_QUIT_REQUESTED );
         }
         break;

      default:
         BApplication::MessageReceived( msg );
         break;
   }
}
