//
// ParentKeyFilter.cpp
//
// Message filter that sends key events to a view's parent
//

#include "ParentKeyFilter.h"

ParentKeyFilter::ParentKeyFilter(BView* forView)
	: BMessageFilter(B_KEY_DOWN)
{
	mView = forView;
}

filter_result ParentKeyFilter::Filter(BMessage* message, BHandler**)
{
	const char* bytes = NULL;
	
	if (message->FindString("bytes", &bytes) || !mView->Parent())
		return B_DISPATCH_MESSAGE;

	// if key is space, enter, line feed, or tab
	//	
	if ((bytes[0] == ' ') || (bytes[0] == 10) || (bytes[0] == 13) || 
		(bytes[0] == 9))
		return B_DISPATCH_MESSAGE;
	
	mView->Window()->PostMessage(message, mView->Parent());
	return B_SKIP_MESSAGE;
}
