//--------------------------------------------------------------------
//	
//	DrumCircleData.h
//
//	Written by: Steffen Yount
//	
//	Copyright 1999 Steffen Yount All Rights Reserved.
//	
//--------------------------------------------------------------------

#ifndef _DrumCircleData_h
#define _DrumCircleData_h

#include <SupportDefs.h>
#include <Archivable.h>

class BMessage;

//====================================================================
//	CLASS: DrumCircleData

class DrumCircleData: public BArchivable
{

	//----------------------------------------------------------------
	//	Virtual member function overrides

public:
	DrumCircleData(const BMessage * dcdmessage);
	DrumCircleData(uint16 measure_length = 12, uint16 drum_count = 16);
	~DrumCircleData();
	virtual status_t Archive(BMessage *archive, bool deep = true) const;
	static BArchivable * Instantiate(BMessage *archive);


	//----------------------------------------------------------------
	//	Member functions

void Rename(const char * newname);
void Setto(const DrumCircleData &);
void Move(uint16 from, uint16 to);

	//----------------------------------------------------------------
	//	Member variables

//using (const &) 's to ensure data will not break

private:	
	uint16		p_drumcount;
	uint16		p_measurelen;
	uint16 *	p_drums;
	uint16 *	p_velocity;
	float *		p_duration;
	bool **		p_rythm;					
	uint16 *	p_changelust;
	uint16 *	p_hitlust;
	uint16 *	p_channel;
	bool *		p_on;
	char *		p_name;

public:
	const uint16 			&drumcount;
	const uint16 			&measurelen;
	uint16 * const		&drums;
	uint16 * const		&velocity;
	float * const		&duration;
	bool *const *const	&rythm;		
	uint16 * const		&changelust;
 	uint16 * const		&hitlust;
 	uint16 * const		&channel;
 	bool * const		&on;
 	const char * const	&name;
		
};




#endif