
#ifndef _PROPGADGET
#define _PROPGADGET
#include "layout.h"

class PropGadget : public MView
{
	private:	float	hprop;
				float	hval;
				float	vprop;
				float	vval;
				bool	vertical;
				bool	horizontal;
				void	(*callback)(PropGadget*,void*);
				void	*callbackarg;
				
	public:		PropGadget(float,float ,float, float, BBitmap* =NULL,
					 void (*func)(PropGadget*, void*)=NULL,
					 void *arg=NULL);
				BBitmap*	Pknob;
				BRect lastknobrect;


				virtual	void	Draw(BRect);
				virtual void	MouseDown(BPoint);
				void			SetValue(float,float);
				inline float	Hval() {return hval;}
				inline float	Vval() {return 1.0-vval;}

				virtual	minimax	layoutprefs();
				virtual BRect	layout(BRect rect);
				virtual void	DrawContainer(BRect);
				virtual void	DrawKnob(BRect);
};


#define M_PROP_PROP		0
#define M_PROP_FIXED	1

#endif