//
// base-classes for a simple layout engine
//
// derived classes should implement a layoutprefs() function that returns information
// about minimum and maximum size of the object, and a layout() function that displays
// the object at the given size and position.
//

#include "layout.h"

minimax::minimax(int minx,int miny,int maxx,int maxy,float wght)
{
	mini.Set(minx,miny);
	maxi.Set(maxx,maxy);
	weight=wght;
	if(mini.x>maxi.x) maxi.x=mini.x;
	if(mini.y>maxi.y) maxi.y=mini.y;
};
minimax::minimax(BPoint min,BPoint max,float wght)
{
	mini=min;
	maxi=max;
	weight=wght;
	if(mini.x>maxi.x) maxi.x=mini.x;
	if(mini.y>maxi.y) maxi.y=mini.y;
};

// --------------------------------------------------------------------------------
// ------------ base class --------------------------------------------------------
MView::MView()
		: BView(BRect(0,0,1,1),"",0,0) //B_WILL_DRAW)
{
	SetViewColor(200,200,200);
//	SetLowColor(216,216,216);
//	SetViewColor(B_TRANSPARENT_32_BIT);
};

minimax MView::layoutprefs()
{
	if(!Parent()&&Window())
	{
		BRect cursize;

//		Window()->SetSizeLimits(mpm.mini.x+12,mpm.maxi.x+12,mpm.mini.y+31,mpm.maxi.y+31);
		Window()->SetSizeLimits(mpm.mini.x-1,mpm.maxi.x-1,mpm.mini.y-1,mpm.maxi.y-1);
		SetResizingMode(B_FOLLOW_ALL);
		SetFlags(B_WILL_DRAW|B_FRAME_EVENTS);
		
		cursize=Window()->Bounds();
		cursize.OffsetTo(0,0);
		cursize=(cursize|BRect(0,0,mpm.mini.x,mpm.mini.y))&BRect(0,0,mpm.maxi.x,mpm.maxi.y);
		Window()->ResizeTo(cursize.Width()-1,cursize.Height()-1);
		ResizeTo(cursize.Width(),cursize.Height());
	}

	//printf("minimum: %f\n",mpm.mini.y);
	return mpm;
};
void MView::FrameResized(float width, float height)
{
	// Don't use Bounds() for size here, use Window()->Bounds() instead.
	// Otherwise a subtle error may occur: the window can be resized between
	// the time the views Bounds() are determined, and the time the view size
	// is set in layout().
	// The view and window will then have different sizes, and the view will
	// try to keep this difference (B_FOLLOW_ALL).

	if(Bounds()!=lastsize)
	{
		lastsize=Bounds();
		layout(Window()->Bounds());
	}
}



