/*
 *  panprop.cpp - Panning slider
 *
 *  SIDPlayer (C) 1996 Christian Bauer
 *  Stereo support by Marco Nelissen
 */

#include "panprop.h"


panprop::panprop(float ihprop,float ihval,float ivprop,float ivval, 
					BBitmap *kr, void (*func)(panprop*,void*), void *arg )
	: PropGadget(ihprop, ihval, ivprop, ivval, kr,  (void (*)(PropGadget*,void*))func,  arg )
{
}

void panprop::DrawContainer(BRect rec)
{
	BRect back=Bounds();
	int y;
	int width;

	inherited::DrawContainer(rec);
	SetHighColor(50,50,50);
	y=(back.top+back.bottom)/2+1;
	width=back.Width()-rec.Width();
	SetPenSize(2);
	StrokeLine(BPoint(back.left+rec.Width()/2,y),BPoint(back.right-rec.Width()/2,y));
	SetPenSize(1);

	for(float f=0;f<=1;f=f+0.25)
	{
		StrokeLine(BPoint(width*f+rec.Width()/2,y-3),BPoint(width*f+rec.Width()/2,y+2));
	}
}

